/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.annotations.AnnotationSession;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ASecondaryCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import org.dom4j.Element;

public class AnnotateCommand
extends ASecondaryCommand {
    String m_contextId = null;
    String m_text = null;
    String m_layoutElementId = null;
    String m_secondaryId = null;
    String m_parameterValues = null;
    String m_sliderDetails = null;
    String m_filterDetails = null;

    @Override
    protected void doAsyncRESTOutput(Conversation conversation, MessageContext messageContext) throws CCSAuthenticationException, CCSGeneralException {
        this.m_conversation = conversation;
        String string = (String)conversation.getProperty("filter");
        Filter[] filterArray = string != null ? new Filter[]{new Filter(CCSFormatter.decodeName(string), "OBJECT_ID")} : (Filter[])conversation.getProperty("filters");
        Integer n = (Integer)this.m_conversation.getProperty("rowLimit");
        String string2 = (String)this.m_conversation.getProperty("format");
        CCSFormatter cCSFormatter = this.m_session.getFormatLoader().getFormatter(string2, this.m_provider);
        this.m_provider.retrieveDrillOutput(conversation);
        CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider, filterArray, n, cCSFormatter);
        Constants.Compatibility compatibility = (Constants.Compatibility)((Object)conversation.getProperty("downgrade"));
        if (compatibility != null) {
            cCSDataResult.setDowngrade(compatibility);
        }
        this.m_session.getResponder().setData(cCSDataResult);
    }

    @Override
    protected Conversation doRESTAsync(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.m_conversation.setProperty("sourceID", this.m_sourceID);
        this.m_conversation.setProperty("contextId", this.m_contextId);
        this.m_conversation.setProperty("layoutElementId", this.m_layoutElementId);
        this.m_conversation.setProperty("text", this.m_text);
        this.m_conversation.setProperty("initialize", "annotation");
        this.m_conversation.setProperty("operation", "annotoutput");
        this.m_conversation.setProperty("status", "working");
        return this.m_conversation;
    }

    @Override
    protected void doRestSync(MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        Conversation conversation = this.m_session.recoverConversation(this.m_sourceID);
        String string = "storeID(\"" + this.m_provider.getStoreID() + "\")";
        AnnotationSession annotationSession = new AnnotationSession(string, this.m_secondaryId, (String)conversation.getProperty("versionPath"), Conversation.deserializeAsyncRequest(conversation, "primary"), conversation.getHeader());
        String string2 = annotationSession.addAnnotation(this.m_contextId, this.m_text, this.m_layoutElementId, this.m_parameterValues, this.m_sliderDetails, this.m_filterDetails);
        this.m_session.setResponseAsString(string2);
    }

    @Override
    protected void extractRESTOptions(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
        this.m_secondaryId = bIBusEnvelope.getFormValue("secondaryId");
        this.m_text = bIBusEnvelope.getFormValue("text");
        this.m_contextId = bIBusEnvelope.getFormValue("contextId");
        this.m_layoutElementId = bIBusEnvelope.getFormValue("layoutElementId");
        if (this.m_layoutElementId == null) {
            this.m_layoutElementId = "empty";
        }
        this.m_parameterValues = bIBusEnvelope.getFormValue("parameterValues");
        this.m_sliderDetails = bIBusEnvelope.getFormValue("sliderDetails");
        this.m_filterDetails = bIBusEnvelope.getFormValue("filterDetails");
    }

    @Override
    protected void initialize() {
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            this.m_sourceID = SoapParms.getContainedStringParm(element, "session", "conversationID", null, false);
            this.m_contextId = SoapParms.getStringParm(element, "contextID", false);
            this.m_layoutElementId = SoapParms.getStringParm(element, "layoutElementId", false);
            this.m_text = SoapParms.getStringParm(element, "text", false);
            Conversation conversation = this.m_session.recoverConversation(this.m_sourceID);
            if (conversation == null) {
                throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{this.m_sourceID}, 404);
            }
            this.m_provider = this.m_session.getProviderFromConversation(conversation);
            if (this.m_layoutElementId == null) {
                this.m_layoutElementId = "empty";
            }
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }

    protected CCSDataResult processRequest(Element element, Element element2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        Conversation conversation = this.m_provider.beginDrill(this.m_contextId, this.m_sourceID, this.m_text);
        conversation.setProperty("command", this.getClass().getName());
        CCSDataResult cCSDataResult = this.createResponse(element2, conversation, null);
        return cCSDataResult;
    }

    @Override
    protected CCSDataResult createResponse(Element element, Conversation conversation, String string) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        String string2 = (String)conversation.getProperty("status");
        element.add(this.generateSession(conversation, string));
        if ("complete".equals(string2)) {
            // empty if block
        }
        return null;
    }
}

