/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ASecondaryCommand;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class BackCommand
extends ASecondaryCommand {
    PromptValue[] m_prompts = null;

    @Override
    protected void doAsyncRESTOutput(Conversation conversation, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException {
        ParameterValue[] parameterValueArray = (ParameterValue[])conversation.getProperty("prompts");
        this.m_prompts = PromptValue.toPrompValueArray(parameterValueArray);
        Element element = this.m_provider.promptBack(conversation, this.m_prompts);
        this.m_session.setResponseAsString(element.asXML());
    }

    @Override
    protected Conversation doRESTAsync(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.m_conversation.setProperty("status", "complete");
        this.m_conversation.setProperty("prompts", PromptValue.toPValueArray(this.m_prompts));
        return this.m_conversation;
    }

    @Override
    protected void doRestSync(MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
    }

    @Override
    protected void extractRESTOptions(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
        Element element = DocumentHelper.createElement((String)"promptAnswers");
        Utilities.processSimplifiedRESTParameters(bIBusEnvelope, element);
        this.m_prompts = SoapParms.getPromptParms(element, "promptValues", true);
    }

    @Override
    protected CCSDataResult createResponse(Element element, Conversation conversation, String string) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        String string2 = (String)conversation.getProperty("status");
        if ("complete".equals(string2)) {
            Element element2 = element.addElement(new QName("output", this.m_session.getResponseNamespace()));
            Element element3 = element2.addElement(new QName("LDXOutput", this.m_session.getResponseNamespace()));
            ParameterValue[] parameterValueArray = (ParameterValue[])conversation.getProperty("prompts");
            this.m_prompts = PromptValue.toPrompValueArray(parameterValueArray);
            Element element4 = this.m_provider.promptBack(conversation, this.m_prompts);
            element4.detach();
            element3.add(element4);
        }
        element.elements().add(0, this.generateSession(conversation, string));
        return null;
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            this.m_sourceID = SoapParms.extractSourceID(element);
            this.m_conversation = this.m_session.recoverConversation(this.m_sourceID);
            if (this.m_conversation == null) {
                throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{this.m_sourceID}, 404);
            }
            this.m_prompts = SoapParms.getPromptParms(element, "promptValues", true);
            this.m_conversation.setProperty("prompts", PromptValue.toPValueArray(this.m_prompts));
            this.m_provider = this.m_session.getProviderFromConversation(this.m_conversation);
            Element element2 = DocumentHelper.createElement((QName)new QName("GetOutputResponse", this.m_session.getResponseNamespace()));
            this.m_conversation.setProperty("command", this.getClass().getName());
            this.m_conversation.setProperty("status", "complete");
            this.createResponse(element2, this.m_conversation, this.m_sourceID);
            this.m_session.setSOAPResponse(element2, null);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }
}

