/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ACommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class CancelCommand
extends ACommand {
    @Override
    protected void initialize() {
    }

    @Override
    public void performRestAction(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        try {
            Conversation conversation = this.m_session.recoverConversation(string);
            if (conversation == null) {
                throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{string}, 404);
            }
            ContentProvider contentProvider = this.m_session.getProviderFromConversation(conversation);
            Element element = this.endConversation(string, conversation, contentProvider);
            this.m_session.setResponseAsString(element.asXML());
        }
        catch (CCSException cCSException) {
            this.m_session.handleRESTCCSException(cCSException, messageContext);
        }
    }

    private Element endConversation(String string, Conversation conversation, ContentProvider contentProvider) throws CCSGeneralException {
        contentProvider.cancelConversation(conversation);
        contentProvider.releaseConversation(conversation);
        this.m_session.deleteConversation(string);
        Element element = DocumentHelper.createElement((QName)new QName("ReleaseResponse", this.m_session.getResponseNamespace()));
        return element;
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            String string = SoapParms.getContainedStringParm(element, "session", "conversationID", null, false);
            Conversation conversation = this.m_session.recoverConversation(string);
            if (conversation == null) {
                throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{string}, 404);
            }
            ContentProvider contentProvider = this.m_session.getProviderFromConversation(conversation);
            Element element2 = this.endConversation(string, conversation, contentProvider);
            this.m_session.setSOAPResponse(element2);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }
}

