/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ACommand;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class CognosURLCommand
extends ACommand {
    private PromptValue[] m_promptValues = null;
    private boolean m_useRelativeURL = false;
    private boolean m_useGatewayURI = false;

    @Override
    public void performRestAction(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        try {
            Element element;
            String string2;
            String string3 = bIBusEnvelope.getFormValue("useRelativeURL");
            if (!Utilities.isNullOrEmpty(string3)) {
                if (string3.equalsIgnoreCase("y") || string3.equalsIgnoreCase("yes") || string3.equals("1")) {
                    string3 = "true";
                }
                this.m_useRelativeURL = Boolean.parseBoolean(string3);
            }
            if (!Utilities.isNullOrEmpty(string2 = bIBusEnvelope.getFormValue("useGatewayURI"))) {
                if (string2.equalsIgnoreCase("y") || string2.equalsIgnoreCase("yes") || string2.equals("1")) {
                    string2 = "true";
                }
                this.m_useGatewayURI = Boolean.parseBoolean(string2);
            }
            this.m_provider = this.m_session.getProviderFromID(string);
            String string4 = bIBusEnvelope.getFormValue("xmlData");
            if (null != string4) {
                element = this.extractXMLFormData(string4);
                Element element2 = element.getRootElement();
                Utilities.processSimplifiedRESTParameters(bIBusEnvelope, element2);
                this.m_promptValues = SoapParms.getPromptParms(element2, "promptValues", true);
            }
            element = this.getURL();
            this.m_session.setResponseAsString(element.asXML());
        }
        catch (CCSException cCSException) {
            this.m_session.handleRESTCCSException(cCSException, messageContext);
        }
    }

    private Element getURL() throws CCSGeneralException, CCSAuthenticationException {
        String string;
        Element element = DocumentHelper.createElement((QName)new QName("GetCognosURLResponse", this.m_session.getResponseNamespace()));
        String string2 = this.m_session.getGatewayURL(this.m_useRelativeURL, this.m_useGatewayURI);
        String string3 = this.m_provider.getViewerURL(string2);
        PromptValue[] promptValueArray = this.m_promptValues;
        if (null != promptValueArray && !Utilities.isNullOrEmpty(string = CognosURLCommand.urlParametersSuffix(promptValueArray))) {
            string3 = string3 + string;
        }
        string = element.addElement(new QName("url", this.m_session.getResponseNamespace()));
        string.setText(string3);
        return element;
    }

    public static String urlParametersSuffix(PromptValue[] promptValueArray) {
        String string = new String();
        if (null != promptValueArray && promptValueArray.length > 0) {
            string = string + "&run.prompt=false";
            for (PromptValue promptValue : promptValueArray) {
                String string2 = promptValue.toSelValue();
                if (null == string2 || string2.length() <= 0) continue;
                string = string + "&" + string2;
            }
        }
        return string;
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            this.m_useGatewayURI = SoapParms.getBooleanParm(element, "useGatewayURI", false, true);
            this.m_useRelativeURL = SoapParms.getBooleanParm(element, "useRelativeURL", false, true);
            String string = this.m_session.extractSourceIDFromPath(messageContext);
            if (string == null) {
                string = SoapParms.extractSourceID(element);
            }
            this.m_promptValues = SoapParms.getPromptParms(element, "promptValues", true);
            this.m_provider = this.m_session.getProviderFromID(string);
            Element element2 = this.getURL();
            this.m_session.setSOAPResponse(element2);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }
}

