/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.AAsyncCommand;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class CollectPromptsCommand
extends AAsyncCommand {
    private PromptValue[] m_promptValues;

    @Override
    protected CCSDataResult createResponse(Element element, Conversation conversation, String string) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        try {
            String string2 = (String)conversation.getProperty("status");
            if ("complete".equals(string2)) {
                Element element2 = element.addElement(new QName("output", this.m_session.getResponseNamespace()));
                Element element3 = element2.addElement(new QName("LDXOutput", this.m_session.getResponseNamespace()));
                Element element4 = this.m_provider.collectPrompts(conversation);
                element4.detach();
                element3.add(element4);
            }
            element.elements().add(0, this.generateSession(conversation, string));
            return null;
        }
        catch (Exception exception) {
            throw new CCSGeneralException();
        }
    }

    @Override
    protected void doAsyncRESTOutput(Conversation conversation, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException {
        Element element = this.m_provider.collectPrompts(conversation);
        this.m_session.setResponseAsString(element.asXML());
    }

    @Override
    protected Conversation doRESTAsync(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        Conversation conversation = new Conversation(new BiBusHeader());
        conversation.setProperty("command", this.getClass().getName());
        conversation.setProperty("searchPath", this.m_sourceID);
        conversation.setProperty("promptValues", PromptValue.toPValueArray(this.m_promptValues));
        conversation.setProperty("status", "complete");
        if (this.getSession().getRequestVersion() != Constants.RequestVersion.V3) {
            conversation.setProperty("downgrade", (Object)Constants.Compatibility.C10_1);
        }
        return conversation;
    }

    @Override
    protected void doRestSync(MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    @Override
    protected void extractRESTOptions(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
        String string = bIBusEnvelope.getFormValue("xmlData");
        Element element = null != string ? this.extractXMLFormData(string).getRootElement() : DocumentHelper.createElement((String)"promptAnswers");
        Utilities.processSimplifiedRESTParameters(bIBusEnvelope, element);
        this.m_promptValues = SoapParms.getPromptParms(element, "promptValues", true);
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            this.m_sourceID = SoapParms.extractSourceID(element);
            this.m_provider = this.m_session.getProviderFromID(this.m_sourceID);
            Element element2 = DocumentHelper.createElement((QName)new QName("GetOutputResponse", this.m_session.getResponseNamespace()));
            Conversation conversation = new Conversation(new BiBusHeader());
            conversation.setProperty("command", this.getClass().getName());
            conversation.setProperty("searchPath", this.m_sourceID);
            conversation.setProperty("status", "complete");
            if (this.getSession().getRequestVersion() != Constants.RequestVersion.V3) {
                conversation.setProperty("downgrade", (Object)Constants.Compatibility.C10_1);
            }
            this.createResponse(element2, conversation, null);
            this.m_session.setSOAPResponse(element2, null);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }
}

