/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.command.ACommand;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class CommandMap {
    private static CommandMap m_singleton = null;
    private Hashtable<String, String> m_map = null;
    private Hashtable<String, Hashtable<String, String>> m_extensionMaps;

    private CommandMap() {
        this.initializeMap();
    }

    public static synchronized CommandMap getInstance() {
        if (m_singleton == null) {
            m_singleton = new CommandMap();
        }
        return m_singleton;
    }

    protected void initializeMap() {
        this.m_map = new Hashtable();
        this.m_extensionMaps = new Hashtable();
        this.populateRESTCommands();
        this.populateSOAPCommands();
        this.populateSimplifiedSOAPCommands();
        this.buildExtensionMaps();
    }

    private void buildExtensionMaps() {
        try {
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read(ConfigMgr.getInstance().getFileStream("/plugin/plugins.xml"));
            XPath xPath = document.createXPath("/plugin:plugins/plugin:definition");
            SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
            simpleNamespaceContext.addNamespace("plugin", "http://www.ibm.com/xmlns/intern/cognos/rdsplugindef/201011");
            xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
            List list = xPath.selectNodes((Object)document);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.buildExtensionMap(((Element)iterator.next()).getTextTrim());
            }
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    protected void buildExtensionMap(String string) {
        try {
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read(ConfigMgr.getInstance().getFileStream(string));
            SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
            simpleNamespaceContext.addNamespace("plugin", "http://www.ibm.com/xmlns/intern/cognos/rdsplugin/201011");
            this.createCommandMap(document, simpleNamespaceContext, "/plugin:commands/plugin:RESTPath", "/plugin:commands/plugin:restCommands/plugin:command");
            this.createCommandMap(document, simpleNamespaceContext, "/plugin:commands/plugin:SOAPAction", "/plugin:commands/plugin:soapCommands/plugin:command");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createCommandMap(Document document, SimpleNamespaceContext simpleNamespaceContext, String string, String string2) {
        XPath xPath = document.createXPath(string);
        xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
        Element element = (Element)xPath.selectSingleNode((Object)document);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.m_extensionMaps.put(element.getTextTrim(), hashtable);
        xPath = document.createXPath(string2);
        xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
        List list = xPath.selectNodes((Object)document);
        if (list.size() > 0) {
            this.processExtensionCommands(hashtable, list);
        }
    }

    private void processExtensionCommands(Hashtable<String, String> hashtable, List list) {
        for (Element element : list) {
            Element element2 = element.element("name");
            Element element3 = element.element("handler");
            hashtable.put(element2.getTextTrim(), element3.getTextTrim());
        }
    }

    private void populateRESTCommands() {
        this.m_map.put("output", "com.cognos.ccs.service.command.ReportOutputCommand");
        this.m_map.put("atom", "com.cognos.ccs.service.command.AtomFeedCommand");
        this.m_map.put("atom_ds", "com.cognos.ccs.service.command.AtomFeedCommand_DS");
        this.m_map.put("atom_flat", "com.cognos.ccs.service.command.AtomFeedCommand_DS");
        this.m_map.put("sessionoutput", "com.cognos.ccs.service.command.SessionOutputCommand");
        this.m_map.put("bibus.xsd", "com.cognos.ccs.service.command.FileCommand");
        this.m_map.put("rdsschema1.xsd", "com.cognos.ccs.service.command.FileCommand");
        this.m_map.put("rdsschema2.xsd", "com.cognos.ccs.service.command.FileCommand");
        this.m_map.put("rdsschema3.xsd", "com.cognos.ccs.service.command.FileCommand");
        this.m_map.put("layoutdataxml.xsd", "com.cognos.ccs.service.command.FileCommand");
        this.m_map.put("layoutdataxmlv2.xsd", "com.cognos.ccs.service.command.FileCommand");
        this.m_map.put("layoutdataxmlv3.xsd", "com.cognos.ccs.service.command.FileCommand");
        this.m_map.put("wsil", "com.cognos.ccs.service.command.WSILCommand");
        this.m_map.put("wsdl", "com.cognos.ccs.service.command.WSDLCommand");
        this.m_map.put("promptpage", "com.cognos.ccs.service.command.PromptPageCommand");
        this.m_map.put("promptanswers", "com.cognos.ccs.service.command.PromptAnswerCommand");
        this.m_map.put("promptdescription", "com.cognos.ccs.service.command.PromptDescriptionCommand");
        this.m_map.put("release", "com.cognos.ccs.service.command.CancelCommand");
        this.m_map.put("treepromptnode", "com.cognos.ccs.service.command.TreePromptNodeCommand");
        this.m_map.put("reportinfo", "com.cognos.ccs.service.command.ReportInfoCommand");
        this.m_map.put("drilloutput", "com.cognos.ccs.service.command.DrillOutputCommand");
        this.m_map.put("drill", "com.cognos.ccs.service.command.DrillOutputCommand");
        this.m_map.put("cognosurl", "com.cognos.ccs.service.command.CognosURLCommand");
        this.m_map.put("annotations", "com.cognos.ccs.service.command.AnnotationsCommand");
        this.m_map.put("annotate", "com.cognos.ccs.service.command.AnnotateCommand");
        this.m_map.put("forward", "com.cognos.ccs.service.command.ForwardCommand");
        this.m_map.put("reprompt", "com.cognos.ccs.service.command.ForwardCommand");
        this.m_map.put("finish", "com.cognos.ccs.service.command.ForwardCommand");
        this.m_map.put("back", "com.cognos.ccs.service.command.BackCommand");
        this.m_map.put("next", "com.cognos.ccs.service.command.PageNavigationCommand");
        this.m_map.put("previous", "com.cognos.ccs.service.command.PageNavigationCommand");
        this.m_map.put("last", "com.cognos.ccs.service.command.PageNavigationCommand");
        this.m_map.put("first", "com.cognos.ccs.service.command.PageNavigationCommand");
        this.m_map.put("savestate", "com.cognos.ccs.service.command.SavedStateCommand");
        this.m_map.put("reportprompts", "com.cognos.ccs.service.command.CollectPromptsCommand");
        this.m_map.put("reportdata", "com.cognos.ccs.service.command.ReportOutputCommand");
        this.m_map.put("pagedreportdata", "com.cognos.ccs.service.command.PagedReportDataCommand");
        this.m_map.put("inboxfeed", "com.cognos.ccs.service.command.InboxFeedCommand");
        this.m_map.put("provideroutput", "com.cognos.ccs.service.command.ProviderOutputCommand");
        this.m_map.put("outputformat", "com.cognos.ccs.service.command.OutputFormatCommand");
        this.m_map.put("outputformats", "com.cognos.ccs.service.command.OutputFormatsCommand");
        this.m_map.put("apiversion", "com.cognos.ccs.service.command.APIVersionCommand");
        this.m_map.put("collectprompts", "com.cognos.ccs.service.command.CollectPromptsCommand");
        this.m_map.put("content", "com.cognos.ccs.service.command.PagedReportDataCommand");
    }

    private void populateSOAPCommands() {
        this.m_map.put("gettreepromptnoderequest", "com.cognos.ccs.service.command.TreePromptNodeCommand");
        this.m_map.put("gettreenodevalueparam", "com.cognos.ccs.service.command.TreePromptNodeCommand");
        this.m_map.put("getpromptdescriptionrequest", "com.cognos.ccs.service.command.PromptDescriptionCommand");
        this.m_map.put("getpromptpagerequest", "com.cognos.ccs.service.command.PromptPageCommand");
        this.m_map.put("getpromptanswersrequest", "com.cognos.ccs.service.command.PromptAnswerCommand");
        this.m_map.put("releaserequest", "com.cognos.ccs.service.command.CancelCommand");
        this.m_map.put("getcognosurlrequest", "com.cognos.ccs.service.command.CognosURLCommand");
        this.m_map.put("getreportcontentrequest", "com.cognos.ccs.service.command.ReportOutputCommand");
        this.m_map.put("getreportdatarequest", "com.cognos.ccs.service.command.ReportOutputCommand");
        this.m_map.put("getpagedreportdatarequest", "com.cognos.ccs.service.command.PagedReportDataCommand");
        this.m_map.put("getreportinfoparam", "com.cognos.ccs.service.command.ReportInfoCommand");
        this.m_map.put("getreportformattedrequest", "com.cognos.ccs.service.command.FormattedOutputCommand");
        this.m_map.put("getoutputrequest", "com.cognos.ccs.service.command.SessionOutputCommand");
        this.m_map.put("drillrequest", "com.cognos.ccs.service.command.DrillOutputCommand");
        this.m_map.put("getreportpromptsrequest", "com.cognos.ccs.service.command.CollectPromptsCommand");
        this.m_map.put("forwardrequest", "com.cognos.ccs.service.command.ForwardCommand");
        this.m_map.put("finishrequest", "com.cognos.ccs.service.command.ForwardCommand");
        this.m_map.put("repromptrequest", "com.cognos.ccs.service.command.ForwardCommand");
        this.m_map.put("backrequest", "com.cognos.ccs.service.command.BackCommand");
        this.m_map.put("nextrequest", "com.cognos.ccs.service.command.PageNavigationCommand");
        this.m_map.put("lastrequest", "com.cognos.ccs.service.command.PageNavigationCommand");
        this.m_map.put("previousrequest", "com.cognos.ccs.service.command.PageNavigationCommand");
        this.m_map.put("firstrequest", "com.cognos.ccs.service.command.PageNavigationCommand");
        this.m_map.put("getreportinforequest", "com.cognos.ccs.service.command.ReportInfoCommand");
        this.m_map.put("getoutputformatrequest", "com.cognos.ccs.service.command.OutputFormatCommand");
        this.m_map.put("getoutputformatsrequest", "com.cognos.ccs.service.command.OutputFormatsCommand");
    }

    private void populateSimplifiedSOAPCommands() {
        this.m_map.put("get", "com.cognos.ccs.service.command.SimplifiedOutputCommand");
        this.m_map.put("drill_simple", "com.cognos.ccs.service.command.SimplifiedDrillOutputCommand");
    }

    public ACommand getCommand(String string) {
        try {
            String string2 = this.m_map.get(string.toLowerCase());
            if (null == string2) {
                return null;
            }
            Class<?> clazz = Class.forName(string2);
            return (ACommand)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public ACommand getExtensionCommand(String string, String string2) {
        try {
            Hashtable<String, String> hashtable;
            if (string.endsWith(".high")) {
                string = string.substring(0, string.length() - 5);
            }
            if (null == (hashtable = this.m_extensionMaps.get(string))) {
                return null;
            }
            String string3 = hashtable.get(string2.toLowerCase());
            if (null == string3) {
                return null;
            }
            Class<?> clazz = Class.forName(string3);
            return (ACommand)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public static boolean IsExtensionRequest(String string) {
        if (string == null) {
            return false;
        }
        if (string.endsWith(".high")) {
            string = string.substring(0, string.length() - 5);
        }
        return CommandMap.getInstance().m_extensionMaps.containsKey(string);
    }
}

