/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.FormatLoader;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ASecondaryCommand;
import com.cognos.ccs.transports.XMLTransport;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.ArrayList;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class DrillOutputCommand
extends ASecondaryCommand {
    String m_direction = null;
    String m_contextId = null;
    boolean m_embedImages = false;

    @Override
    protected void doAsyncRESTOutput(Conversation conversation, MessageContext messageContext) throws CCSAuthenticationException, CCSGeneralException {
        Object object;
        Object object2;
        this.m_conversation = conversation;
        String string = (String)conversation.getProperty("filter");
        Filter[] filterArray = string != null ? new Filter[]{new Filter(CCSFormatter.decodeName(string), "OBJECT_ID")} : (Filter[])conversation.getProperty("filters");
        Integer n = (Integer)this.m_conversation.getProperty("rowLimit");
        String string2 = (String)this.m_conversation.getProperty("format");
        FormatLoader formatLoader = this.m_session.getFormatLoader();
        CCSFormatter cCSFormatter = formatLoader.getFormatter(string2, this.m_provider);
        if (cCSFormatter != null) {
            object2 = (Integer)this.m_conversation.getProperty("width");
            object = (Integer)this.m_conversation.getProperty("height");
            cCSFormatter.setWidth((Integer)object2);
            cCSFormatter.setHeight((int)object);
            cCSFormatter.setWebcontentRoot(this.m_session.getWebcontentRoot());
            cCSFormatter.setGatewayURI(this.m_session.getAbsoluteGatewayURL());
            cCSFormatter.setConversation(this.m_conversation);
        }
        this.m_provider.retrieveDrillOutput(conversation);
        ((XMLTransport)this.m_session.getTransport()).setContentType(formatLoader.getContentType(string2));
        object2 = new CCSDataResult(this.m_session.getTransport(), this.m_provider, filterArray, n, cCSFormatter, this.getAppenderList(this.m_conversation));
        object = (Constants.Compatibility)((Object)conversation.getProperty("downgrade"));
        if (object != null) {
            ((CCSDataResult)object2).setDowngrade((Constants.Compatibility)((Object)object));
        }
        ((CCSDataResult)object2).setSecondaryCommands((ArrayList)this.m_conversation.getProperty("SECONDARY_COMMANDS"));
        this.m_session.getResponder().setData((CCSDataResult)object2);
    }

    @Override
    protected Conversation doRESTAsync(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.m_conversation.setProperty("sourceID", this.m_sourceID);
        this.m_conversation.setProperty("context", this.m_contextId);
        this.m_conversation.setProperty("direction", this.m_direction);
        this.m_conversation.setProperty("initialize", "drill");
        this.m_conversation.setProperty("operation", "drilloutput");
        this.m_conversation.setProperty("status", "working");
        this.m_conversation.embedImagesUpdate(this.m_embedImages, this.getSession(), messageContext);
        return this.m_conversation;
    }

    @Override
    protected void doRestSync(MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        Object object;
        Object object2;
        String string = (String)this.m_conversation.getProperty("filter");
        Filter[] filterArray = string != null ? new Filter[]{new Filter(CCSFormatter.decodeName(string), "OBJECT_ID")} : (Filter[])this.m_conversation.getProperty("filters");
        Integer n = (Integer)this.m_conversation.getProperty("rowLimit");
        String string2 = (String)this.m_conversation.getProperty("format");
        FormatLoader formatLoader = this.m_session.getFormatLoader();
        CCSFormatter cCSFormatter = formatLoader.getFormatter(string2, this.m_provider);
        if (cCSFormatter != null) {
            object2 = (Integer)this.m_conversation.getProperty("width");
            object = (Integer)this.m_conversation.getProperty("height");
            cCSFormatter.setWidth((Integer)object2);
            cCSFormatter.setHeight((int)object);
            cCSFormatter.setWebcontentRoot(this.m_session.getWebcontentRoot());
            cCSFormatter.setGatewayURI(this.m_session.getAbsoluteGatewayURL());
        }
        this.m_provider.drill(this.m_contextId, this.m_sourceID, this.m_direction);
        ((XMLTransport)this.m_session.getTransport()).setContentType(formatLoader.getContentType(string2));
        object2 = new CCSDataResult(this.m_session.getTransport(), this.m_provider, filterArray, n, cCSFormatter, this.getAppenderList(this.m_conversation));
        object = (Constants.Compatibility)((Object)this.m_conversation.getProperty("downgrade"));
        if (object != null) {
            ((CCSDataResult)object2).setDowngrade((Constants.Compatibility)((Object)object));
        }
        this.m_session.getResponder().setData((CCSDataResult)object2);
    }

    @Override
    protected void extractRESTOptions(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
        this.m_direction = bIBusEnvelope.getFormValue("direction");
        this.m_contextId = bIBusEnvelope.getFormValue("contextId");
        String string = bIBusEnvelope.getFormValue("embedImages");
        if (!Utilities.isNullOrEmpty(string)) {
            this.m_embedImages = Utilities.parseXMLBoolean(string);
        }
    }

    @Override
    protected void initialize() {
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            this.m_sourceID = SoapParms.getContainedStringParm(element, "session", "conversationID", null, false);
            this.m_contextId = SoapParms.getStringParm(element, "contextID", false);
            this.m_direction = SoapParms.getStringParm(element, "direction", false);
            Conversation conversation = this.m_session.recoverConversation(this.m_sourceID);
            if (conversation == null) {
                throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{this.m_sourceID}, 404);
            }
            this.m_provider = this.m_session.getProviderFromConversation(conversation);
            Element element2 = DocumentHelper.createElement((QName)new QName("GetOutputResponse", this.m_session.getResponseNamespace()));
            CCSDataResult cCSDataResult = this.processRequest(element, element2);
            this.m_session.setSOAPResponse(element2, cCSDataResult);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }

    protected CCSDataResult processRequest(Element element, Element element2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        Conversation conversation = this.m_provider.beginDrill(this.m_contextId, this.m_sourceID, this.m_direction);
        conversation.setProperty("command", this.getClass().getName());
        CCSDataResult cCSDataResult = this.createResponse(element2, conversation, null);
        return cCSDataResult;
    }

    @Override
    protected CCSDataResult createResponse(Element element, Conversation conversation, String string) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        String string2 = (String)conversation.getProperty("status");
        element.add(this.generateSession(conversation, string));
        if ("complete".equals(string2)) {
            Filter[] filterArray;
            Element element2 = element.addElement(new QName("output", this.m_session.getResponseNamespace()));
            Element element3 = element2.addElement(new QName("ContentOutput", this.m_session.getResponseNamespace()));
            String string3 = (String)conversation.getProperty("format");
            CCSFormatter cCSFormatter = this.m_session.getFormatLoader().getFormatter(string3, this.m_provider);
            if (cCSFormatter != null) {
                filterArray = (Filter[])conversation.getProperty("width");
                Integer n = (Integer)conversation.getProperty("height");
                cCSFormatter.setWidth(filterArray.intValue());
                cCSFormatter.setHeight(n);
                cCSFormatter.setWebcontentRoot(this.m_session.getWebcontentRoot());
                cCSFormatter.setGatewayURI(this.m_session.getAbsoluteGatewayURL());
            }
            filterArray = (Filter[])conversation.getProperty("filters");
            int n = 0;
            String string4 = (String)conversation.getProperty("rowLimit");
            if (string4 != null) {
                n = Integer.parseInt(string4);
            }
            this.m_provider.retrieveDrillOutput(conversation);
            element3.addElement("ccsdatamarker");
            CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider, filterArray, n, cCSFormatter, this.getAppenderList(this.m_conversation));
            Constants.Compatibility compatibility = (Constants.Compatibility)((Object)conversation.getProperty("downgrade"));
            if (compatibility != null) {
                cCSDataResult.setDowngrade(compatibility);
            }
            cCSDataResult.setSecondaryCommands((ArrayList)conversation.getProperty("SECONDARY_COMMANDS"));
            return cCSDataResult;
        }
        return null;
    }
}

