/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.content.SearchPromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.FormatLoader;
import com.cognos.ccs.formats.dataset.DatasetHandler;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ASecondaryCommand;
import com.cognos.ccs.transports.XMLTransport;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ForwardCommand
extends ASecondaryCommand {
    PromptValue[] m_prompts = null;
    SearchPromptValue m_search = null;
    private String m_format;

    @Override
    protected void doAsyncRESTOutput(Conversation conversation, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException {
        Element element = (Element)conversation.getProperty("ANSWERS_DOC");
        if (element != null) {
            this.m_session.setResponseAsString(element.asXML());
        } else {
            ParameterValue[] parameterValueArray = (ParameterValue[])conversation.getProperty("prompts");
            this.m_prompts = PromptValue.toPrompValueArray(parameterValueArray);
            String string = (String)conversation.getProperty("primary.operation");
            if ("run".equalsIgnoreCase(string)) {
                this.m_provider.runForward(conversation, this.m_prompts);
                FormatLoader formatLoader = new FormatLoader();
                CCSFormatter cCSFormatter = formatLoader.getFormatter((String)conversation.getProperty("format"), this.m_provider);
                if (cCSFormatter != null) {
                    cCSFormatter.setWebcontentRoot(this.m_session.getWebcontentRoot());
                    cCSFormatter.setGatewayURI(this.m_session.getAbsoluteGatewayURL());
                    cCSFormatter.setConversation(conversation);
                }
                Integer n = (Integer)conversation.getProperty("rowLimit");
                CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider, null, n, cCSFormatter, this.getAppenderList(conversation));
                cCSDataResult.setSecondaryCommands((ArrayList)conversation.getProperty("SECONDARY_COMMANDS"));
                Constants.Compatibility compatibility = (Constants.Compatibility)((Object)conversation.getProperty("downgrade"));
                if (compatibility != null) {
                    cCSDataResult.setDowngrade(compatibility);
                }
                if (cCSFormatter instanceof DatasetHandler) {
                    cCSDataResult.setConversation(this.m_session.getConnect(), conversation);
                }
                if (cCSFormatter != null) {
                    Integer n2 = (Integer)conversation.getProperty("width");
                    Integer n3 = (Integer)conversation.getProperty("height");
                    cCSFormatter.setWidth(n2);
                    cCSFormatter.setHeight(n3);
                    ((XMLTransport)this.m_session.getTransport()).setContentType(formatLoader.getContentType((String)conversation.getProperty("format")));
                }
                this.m_session.getResponder().setData(cCSDataResult);
            } else {
                Element element2 = this.m_provider.promptForward(conversation, this.m_prompts);
                this.m_session.setResponseAsString(element2.asXML());
            }
            conversation.removeProperty("search");
            conversation.removeProperty("reprompt");
        }
    }

    @Override
    protected Conversation doRESTAsync(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        String string = (String)messageContext.getProperty("path_info");
        if (string.indexOf("/reprompt") != -1) {
            this.m_conversation.setProperty("reprompt", "true");
        } else if (string.indexOf("/finish") != -1) {
            this.m_conversation.setProperty("finish", "true");
        } else {
            this.m_conversation.removeProperty("reprompt");
        }
        this.m_conversation.setProperty("status", "complete");
        this.m_conversation.setProperty("prompts", PromptValue.toPValueArray(this.m_prompts));
        this.m_conversation.setProperty("search", this.m_search);
        if (this.m_format != null) {
            this.m_conversation.setProperty("format", this.m_format);
        }
        return this.m_conversation;
    }

    @Override
    protected void doRestSync(MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        throw new CCSGeneralException("NOT_SUPPORTED", 400);
    }

    @Override
    protected void extractRESTOptions(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
        String string = bIBusEnvelope.getFormValue("xmlData");
        Element element = null;
        if (string != null) {
            Document document = this.extractXMLFormData(string);
            element = document.getRootElement();
            Element element2 = element.element("searchPValue");
            if (element2 != null) {
                this.m_search = new SearchPromptValue();
                this.m_search.parseXML(element2);
            }
        } else {
            element = DocumentHelper.createElement((String)"promptAnswers");
            Utilities.processSimplifiedRESTParameters(bIBusEnvelope, element);
            this.m_search = SearchPromptValue.parseFormFields(bIBusEnvelope);
        }
        this.m_prompts = SoapParms.getPromptParms(element, "promptValues", true);
        this.m_format = bIBusEnvelope.getFormValue("fmt");
    }

    @Override
    protected CCSDataResult createResponse(Element element, Conversation conversation, String string) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        try {
            String string2 = (String)conversation.getProperty("status");
            if ("complete".equals(string2)) {
                Element element2 = element.addElement(new QName("output", this.m_session.getResponseNamespace()));
                Element element3 = null;
                Element element4 = (Element)conversation.getProperty("ANSWERS_DOC");
                if (element4 != null) {
                    element4.detach();
                    element4.setQName(new QName("PromptAnswerOutput", this.m_session.getResponseNamespace()));
                    element2.add(element4);
                } else {
                    Element element5 = this.m_provider.promptForward(conversation, this.m_prompts);
                    element5.detach();
                    if (element5.getName().equals("promptAnswers")) {
                        element5.setQName(new QName("PromptAnswerOutput", this.m_session.getResponseNamespace()));
                        element2.add(element5);
                    } else {
                        element3 = element2.addElement(new QName("LDXOutput", this.m_session.getResponseNamespace()));
                        element3.add(element5);
                    }
                }
                conversation.removeProperty("search");
            }
            element.elements().add(0, this.generateSession(conversation, string));
            return null;
        }
        catch (CCSGeneralException cCSGeneralException) {
            throw cCSGeneralException;
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            throw cCSAuthenticationException;
        }
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            this.m_sourceID = SoapParms.extractSourceID(element);
            this.m_conversation = this.m_session.recoverConversation(this.m_sourceID);
            if (this.m_conversation == null) {
                throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{this.m_sourceID}, 404);
            }
            if (element.getName().equals("RepromptRequest")) {
                this.m_conversation.setProperty("reprompt", "true");
            } else {
                this.m_conversation.removeProperty("reprompt");
            }
            this.m_search = SoapParms.getSearchValue(element, "searchValue", true);
            this.m_prompts = SoapParms.getPromptParms(element, "promptValues", true);
            this.m_conversation.setProperty("prompts", PromptValue.toPValueArray(this.m_prompts));
            this.m_provider = this.m_session.getProviderFromConversation(this.m_conversation);
            Element element2 = DocumentHelper.createElement((QName)new QName("GetOutputResponse", this.m_session.getResponseNamespace()));
            this.m_conversation.setProperty("command", this.getClass().getName());
            this.m_conversation.setProperty("search", this.m_search);
            if (this.m_format != null) {
                this.m_conversation.setProperty("format", this.m_format);
            }
            this.m_conversation.setProperty("status", "complete");
            this.createResponse(element2, this.m_conversation, this.m_sourceID);
            this.m_session.setSOAPResponse(element2, null);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }
}

