/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.content.DashboardContentProvider;
import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.AAsyncCommand;
import com.cognos.ccs.transports.XMLTransport;
import com.cognos.ccs.utility.OutputFormatEnums;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.util.HashSet;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class OutputFormatCommand
extends AAsyncCommand {
    protected String m_versionType;
    protected String m_versionName;
    protected String m_versionPath;
    protected String m_burstKey;
    protected String m_burstID;
    protected PromptValue[] m_promptValues;
    protected boolean m_isPaged;
    protected boolean m_showPrompts = true;
    protected int m_rowLimit;
    protected boolean m_saveOutput;
    private String m_outputFormat;
    private String m_viewerStateData;
    private Filter[] m_filters;
    private HashSet<String> m_capabilities;

    @Override
    protected void doAsyncRESTOutput(Conversation conversation, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.m_provider.retrieveDataOutput(conversation);
        if (conversation.getProperty("saveOutput").equals(Boolean.TRUE)) {
            this.m_provider.saveDataContent(conversation);
        }
        this.m_outputFormat = (String)conversation.getProperty("PROVIDER_OUTPUT_FORMAT");
        String string = this.m_provider.getReportOutputContentType(this.m_outputFormat);
        XMLTransport xMLTransport = (XMLTransport)this.m_session.getTransport();
        xMLTransport.setContentType(string);
        CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider);
        cCSDataResult.setConversation(this.m_session.getConnect(), conversation);
        this.m_session.getResponder().setData(cCSDataResult);
    }

    @Override
    protected Conversation doRESTAsync(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        String string = (String)messageContext.getProperty("path_info");
        this.m_outputFormat = this.getFormat(string);
        boolean bl = this.canRetriveFormat(this.m_outputFormat);
        if (!bl) {
            throw new CCSGeneralException("REQUEST_ERROR", 403);
        }
        if (this.m_provider instanceof DashboardContentProvider) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        Conversation conversation = this.startReport(this.m_outputFormat);
        conversation.setProperty("pathInfo", string);
        conversation.setProperty("rowLimit", new Integer(this.m_rowLimit));
        conversation.setProperty("xpath", bIBusEnvelope.getFormValue("xpath"));
        conversation.setProperty("saveOutput", new Boolean(this.m_saveOutput));
        conversation.setProperty("filters", this.m_filters);
        return conversation;
    }

    @Override
    protected void doRestSync(MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        boolean bl;
        String string = (String)messageContext.getProperty("path_info");
        this.m_outputFormat = this.getFormat(string);
        Conversation conversation = new Conversation(this.m_provider.getBiBusHeader());
        conversation.setProperty("filters", this.m_filters);
        conversation.setProperty("PROVIDER_OUTPUT_FORMAT", this.m_outputFormat);
        if (!Utilities.isNullOrEmpty(this.m_viewerStateData)) {
            conversation.setProperty("viewerStateData", this.m_viewerStateData);
        }
        if (!(bl = this.canRetriveFormat(this.m_outputFormat))) {
            throw new CCSGeneralException("REQUEST_ERROR", 403);
        }
        if ((conversation = this.m_provider.retrieveDataContent(this.m_versionType, this.m_versionPath, this.m_versionName, this.m_burstKey, this.m_burstID, this.m_promptValues, this.m_isPaged, this.m_showPrompts, conversation, false, false, this.m_saveOutput)) == null) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        conversation.setProperty("saveOutput", new Boolean(this.m_saveOutput));
        if (conversation.getProperty("saveOutput").equals(Boolean.TRUE)) {
            this.m_provider.saveDataContent(conversation);
        }
        conversation.setProperty("filters", this.m_filters);
        conversation.setProperty("pathInfo", string);
        String string2 = this.m_provider.getReportOutputContentType(this.m_outputFormat);
        XMLTransport xMLTransport = (XMLTransport)this.m_session.getTransport();
        xMLTransport.setContentType(string2);
        CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider);
        cCSDataResult.setConversation(this.m_session.getConnect(), conversation);
        this.m_session.getResponder().setData(cCSDataResult);
        this.m_provider.releaseConversation(conversation);
    }

    private boolean canRetriveFormat(String string) {
        if (OutputFormatEnums.formatCSV.equalsName(string)) {
            return this.m_capabilities.contains(OutputFormatEnums.capabilityCanGenerateCSVOutput.toString());
        }
        if (OutputFormatEnums.formatPDF.equalsName(string)) {
            return this.m_capabilities.contains(OutputFormatEnums.capabilityCanGeneratePDFOutput.toString());
        }
        if (OutputFormatEnums.formatSpreadsheetML.equalsName(string) || OutputFormatEnums.formatXLWA.equalsName(string) || OutputFormatEnums.formatXlsxData.equalsName(string) || OutputFormatEnums.formatXLS.equalsName(string)) {
            return this.m_capabilities.contains(OutputFormatEnums.capabilityCanGenerateXLSOutput.toString());
        }
        if (OutputFormatEnums.formatXML.equalsName(string)) {
            return this.m_capabilities.contains(OutputFormatEnums.capabilityCanGenerateXMLOutput.toString());
        }
        return true;
    }

    @Override
    protected void extractRESTOptions(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
        this.storeCapabilities(bIBusEnvelope);
        this.extractCommonOptions(bIBusEnvelope);
    }

    private void storeCapabilities(BIBusEnvelope bIBusEnvelope) {
        this.m_capabilities = Utilities.getCapabilityValues(bIBusEnvelope);
    }

    @Override
    protected CCSDataResult createResponse(Element element, Conversation conversation, String string) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        String string2 = (String)conversation.getProperty("PROVIDER_OUTPUT_FORMAT");
        String string3 = this.m_provider.getReportOutputContentType(string2);
        XMLTransport xMLTransport = (XMLTransport)this.m_session.getTransport();
        xMLTransport.setContentType(string3);
        CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider);
        cCSDataResult.setConversation(this.m_session.getConnect(), conversation);
        return cCSDataResult;
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            this.extractSOAPParms(element);
            this.m_provider = this.m_session.getProviderFromID(this.m_sourceID);
            if (this.m_provider instanceof DashboardContentProvider) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            this.m_capabilities = this.m_provider.getUserCapabilities();
            boolean bl = this.canRetriveFormat(this.m_outputFormat);
            if (!bl) {
                throw new CCSGeneralException("REQUEST_ERROR", 403);
            }
            Element element2 = this.outputFormatURL();
            this.m_session.setSOAPResponse(element2);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }

    private Element outputFormatURL() throws CCSGeneralException, CCSAuthenticationException {
        Element element = DocumentHelper.createElement((QName)new QName("GetOutputFormatResponse", this.m_session.getResponseNamespace()));
        Element element2 = element.addElement(new QName("outputFormatURL", this.m_session.getResponseNamespace()));
        element2.setText(this.generateOuptutFormatURL());
        if (this.m_promptValues != null && this.m_promptValues.length > 0) {
            Namespace namespace = this.m_session.getResponseNamespace();
            Element element3 = DocumentHelper.createElement((QName)new QName("promptAnswers", namespace));
            for (int i = 0; i < this.m_promptValues.length; ++i) {
                element3.add(this.m_promptValues[i].toXML(namespace, false));
            }
            Element element4 = element.addElement(new QName("xmlData", namespace));
            element4.setText(element3.asXML());
        }
        return element;
    }

    protected String generateOuptutFormatURL() throws CCSAuthenticationException, CCSGeneralException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_session.getAbsoluteGatewayURL());
        stringBuffer.append("/rds/outputformat/report/");
        stringBuffer.append(this.m_provider.getStoreID());
        stringBuffer.append("/");
        stringBuffer.append(this.m_outputFormat);
        StringBuffer stringBuffer2 = new StringBuffer();
        if (!Utilities.isNullOrEmpty(this.m_versionType)) {
            stringBuffer2.append("version=");
            stringBuffer2.append(this.m_versionType);
            stringBuffer2.append("&");
        }
        if (!Utilities.isNullOrEmpty(this.m_versionName)) {
            stringBuffer2.append("versionID=");
            stringBuffer2.append(this.m_versionName);
            stringBuffer2.append("&");
        }
        if (!Utilities.isNullOrEmpty(this.m_versionPath)) {
            stringBuffer2.append("versionPath=");
            stringBuffer2.append(this.m_versionPath);
            stringBuffer2.append("&");
        }
        if (this.m_saveOutput) {
            stringBuffer2.append("saveOutput=true&");
        }
        if (!Utilities.isNullOrEmpty(this.m_burstID)) {
            stringBuffer2.append("burstID=");
            stringBuffer2.append(this.m_burstID);
            stringBuffer2.append("&");
        }
        if (!Utilities.isNullOrEmpty(this.m_burstKey)) {
            stringBuffer2.append("burstKey=");
            stringBuffer2.append(this.m_burstKey);
            stringBuffer2.append("&");
        }
        if (!Utilities.isNullOrEmpty(this.m_viewerStateData)) {
            stringBuffer2.append("viewerStateData=");
            stringBuffer2.append(Utilities.IRIEncode(this.m_viewerStateData, true));
            stringBuffer2.append("&");
        }
        if (this.m_filters != null && this.m_filters.length == 1) {
            stringBuffer2.append("selection=");
            stringBuffer2.append(CCSFormatter.encodeName(this.m_filters[0].getFilterValue()));
            stringBuffer2.append("&");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("?");
            stringBuffer.append(stringBuffer2.substring(0, stringBuffer2.length() - 1));
        }
        return stringBuffer.toString();
    }

    protected void extractSOAPParms(Element element) throws CCSGeneralException {
        String string;
        this.m_sourceID = SoapParms.extractSourceID(element);
        this.m_filters = SoapParms.getFilterParm(element, "filters", true);
        this.m_promptValues = SoapParms.getPromptParms(element, "promptValues", true);
        this.m_versionType = SoapParms.getContainedStringParm(element, "version", "versionType", null, true);
        this.m_versionName = SoapParms.getContainedStringParm(element, "version", "versionName", null, true);
        this.m_versionPath = SoapParms.getContainedStringParm(element, "version", "searchPath", null, true);
        this.m_burstKey = SoapParms.getContainedStringParm(element, "burstInfo", "burstKey", null, true);
        this.m_burstID = SoapParms.getContainedStringParm(element, "burstInfo", "burstId", null, true);
        this.m_rowLimit = SoapParms.getIntParm(element, "rowLimit", 0, Integer.MAX_VALUE, true);
        this.m_saveOutput = SoapParms.getBooleanParm(element, "saveOutput", false, true);
        this.m_outputFormat = SoapParms.getStringParm(element, "outputFormatName", false);
        this.m_viewerStateData = SoapParms.getStringParm(element, "viewerStateData", true);
        if (Integer.MIN_VALUE == this.m_rowLimit) {
            this.m_rowLimit = 0;
        }
        if ((string = SoapParms.getStringParm(element, "prompt", null, true)) != null && (string.equalsIgnoreCase("false") || string.equals("0"))) {
            this.m_showPrompts = false;
        }
    }

    protected Conversation startReport(String string) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        Conversation conversation = new Conversation(this.m_provider.getBiBusHeader());
        conversation.setProperty("PROVIDER_OUTPUT_FORMAT", string);
        if (!Utilities.isNullOrEmpty(this.m_viewerStateData)) {
            conversation.setProperty("viewerStateData", this.m_viewerStateData);
        }
        if ((conversation = this.m_provider.beginRetrieveData(this.m_versionType, this.m_versionPath, this.m_versionName, this.m_burstKey, this.m_burstID, this.m_promptValues, this.m_isPaged, this.m_showPrompts, conversation, this.m_saveOutput)) != null) {
            conversation.setProperty("operation", "output");
        }
        return conversation;
    }

    protected void extractCommonOptions(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
        String string;
        String string2;
        this.m_versionType = bIBusEnvelope.getFormValue("version");
        this.m_versionName = bIBusEnvelope.getFormValue("versionID");
        this.m_versionPath = bIBusEnvelope.getFormValue("versionPath");
        this.m_saveOutput = false;
        if (bIBusEnvelope.getFormValue("saveOutput") != null) {
            this.m_saveOutput = Utilities.parseXMLBoolean(bIBusEnvelope.getFormValue("saveOutput"));
        }
        this.m_burstID = bIBusEnvelope.getFormValue("burstID");
        this.m_burstKey = bIBusEnvelope.getFormValue("burstKey");
        String string3 = bIBusEnvelope.getFormValue("xmlData");
        Element element = null != string3 ? this.extractXMLFormData(string3).getRootElement() : DocumentHelper.createElement((String)"promptAnswers");
        Utilities.processSimplifiedRESTParameters(bIBusEnvelope, element);
        this.m_promptValues = SoapParms.getPromptParms(element, "promptValues", true);
        String string4 = bIBusEnvelope.getFormValue("rowLimit");
        if (string4 != null) {
            this.m_rowLimit = Integer.parseInt(string4);
        }
        if (!Utilities.isNullOrEmpty(string2 = bIBusEnvelope.getFormValue("viewerStateData"))) {
            this.m_viewerStateData = string2;
        }
        if (!Utilities.isNullOrEmpty(string = bIBusEnvelope.getFormValue("selection"))) {
            this.m_filters = this.extractFilters(string);
            if (this.m_filters != null && this.m_filters.length > 1) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
        }
    }

    protected String getFormat(String string) throws CCSGeneralException {
        String[] stringArray = string.split("/");
        if (stringArray.length < 6) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        String string2 = stringArray[3];
        if (string2.equals("storeID") || string2.equals("report") || string2.equals("conversationID")) {
            return stringArray[5];
        }
        if (string2.equals("searchPath") || string2.equals("path")) {
            return stringArray[stringArray.length - 1];
        }
        throw new CCSGeneralException("REQUEST_ERROR", 400);
    }

    @Override
    public String getSavedOutputStoreID(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) throws CCSGeneralException, CCSAuthenticationException {
        this.extractRESTOptions(bIBusEnvelope);
        this.m_provider = this.m_session.getProviderFromID(string);
        return this.m_provider.getSavedOutputStoreID("HTML", this.m_burstID, this.m_burstKey);
    }
}

