/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ACommand;
import com.cognos.ccs.transports.XMLTransport;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Arrays;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class OutputFormatsCommand
extends ACommand {
    private final String JSON_FMT = "json";
    private final String XML_FMT = "xml";
    private final String CSV_FMT = "csv";
    private final String JSON_CONTENT_TYPE = "application/json";
    private final String CSV_CONTENT_TYPE = "text/csv";
    private final String PATH_INFO = "path_info";
    private final String XSD_RESPONSE_NAME = "GetOutputFormatsResponse";
    private final String ROOT_ELEM_NAME = "supportedFormats";
    private final String XML_RESPONSE_ELEMENT = "outputFormatName";
    private String[] m_supportedFormatsArray;

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            String string = this.m_session.extractSourceIDFromPath(messageContext);
            if (string == null) {
                string = SoapParms.extractSourceID(element);
            }
            this.m_provider = this.m_session.getProviderFromID(string);
            this.m_supportedFormatsArray = this.m_provider.getSupportedOutputFormats();
            Element element2 = this.getSupportedFormatsAsXML(this.m_supportedFormatsArray);
            this.m_session.setSOAPResponse(element2);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }

    @Override
    public void performRestAction(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        try {
            String string2 = (String)messageContext.getProperty("path_info");
            String string3 = this.getFromat(string2);
            string3 = Utilities.isNullOrEmpty(string3) ? "xml" : string3.toLowerCase();
            this.m_provider = this.m_session.getProviderFromID(string);
            this.m_supportedFormatsArray = this.m_provider.getSupportedOutputFormats();
            if ("json".equalsIgnoreCase(string3)) {
                this.formatJSONResponse(this.m_supportedFormatsArray);
            } else if ("csv".equalsIgnoreCase(string3)) {
                this.formatCSVResponse(this.m_supportedFormatsArray);
            } else {
                this.formatXMLResponse(this.m_supportedFormatsArray);
            }
        }
        catch (CCSException cCSException) {
            this.m_session.handleRESTCCSException(cCSException, messageContext);
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("ERROR", iOException, 500);
            this.m_session.generateRESTErrorBlock(cCSGeneralException, messageContext);
        }
    }

    private void formatXMLResponse(String[] stringArray) {
        Element element = this.getSupportedFormatsAsXML(stringArray);
        this.m_session.setResponseAsString(element.asXML());
    }

    private Element getSupportedFormatsAsXML(String[] stringArray) {
        Namespace namespace = this.m_session.getResponseNamespace();
        Element element = DocumentHelper.createElement((QName)new QName("GetOutputFormatsResponse", namespace));
        Element element2 = element.addElement(new QName("supportedFormats", namespace));
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                Element element3 = element2.addElement(new QName("outputFormatName", namespace));
                element3.setText(stringArray[i]);
            }
        }
        return element;
    }

    private void formatCSVResponse(String[] stringArray) {
        XMLTransport xMLTransport = (XMLTransport)this.m_session.getTransport();
        xMLTransport.setContentType("text/csv");
        String string = Arrays.toString(stringArray);
        string = string.length() < 3 ? "" : string.substring(1, string.length() - 1);
        this.m_session.setResponseAsString(string);
    }

    private void formatJSONResponse(String[] stringArray) throws IOException {
        JSONArray jSONArray = new JSONArray();
        jSONArray.addAll(Arrays.asList(stringArray));
        XMLTransport xMLTransport = (XMLTransport)this.m_session.getTransport();
        xMLTransport.setContentType("application/json");
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"supportedFormats", (Object)jSONArray);
        this.m_session.setResponseAsString(jSONObject.serialize());
    }

    protected String getFromat(String string) throws CCSGeneralException {
        String[] stringArray = string.split("/");
        if (stringArray.length < 6) {
            if (stringArray.length == 5) {
                return "xml";
            }
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        String string2 = stringArray[3];
        if (string2.equals("storeID") || string2.equals("report") || string2.equals("conversationID")) {
            return stringArray[5];
        }
        if (string2.equals("searchPath") || string2.equals("path")) {
            return stringArray[stringArray.length - 1];
        }
        throw new CCSGeneralException("REQUEST_ERROR", 400);
    }
}

