/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.FormatLoader;
import com.cognos.ccs.formats.annotatedhtml.AnnotatedHTMLHandler;
import com.cognos.ccs.formats.dataset.DatasetHandler;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ASecondaryCommand;
import com.cognos.ccs.transports.XMLTransport;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.ArrayList;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class PageNavigationCommand
extends ASecondaryCommand {
    @Override
    protected void doAsyncRESTOutput(Conversation conversation, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.m_provider.retrieveDataOutput(conversation);
        FormatLoader formatLoader = new FormatLoader();
        CCSFormatter cCSFormatter = formatLoader.getFormatter((String)conversation.getProperty("format"), this.m_provider);
        if (cCSFormatter != null) {
            cCSFormatter.setWebcontentRoot(this.m_session.getWebcontentRoot());
            cCSFormatter.setGatewayURI(this.m_session.getAbsoluteGatewayURL());
            cCSFormatter.setConversation(conversation);
        }
        Integer n = (Integer)conversation.getProperty("rowLimit");
        if (conversation.getProperty("annotations").equals(Boolean.TRUE)) {
            cCSFormatter = new AnnotatedHTMLHandler(this.m_provider, conversation);
        }
        CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider, null, n, cCSFormatter, this.getAppenderList(conversation));
        cCSDataResult.setSecondaryCommands((ArrayList)conversation.getProperty("SECONDARY_COMMANDS"));
        Constants.Compatibility compatibility = (Constants.Compatibility)((Object)conversation.getProperty("downgrade"));
        if (compatibility != null) {
            cCSDataResult.setDowngrade(compatibility);
        }
        if (cCSFormatter instanceof DatasetHandler) {
            cCSDataResult.setConversation(this.m_session.getConnect(), conversation);
        }
        if (cCSFormatter != null) {
            Integer n2 = (Integer)conversation.getProperty("width");
            Integer n3 = (Integer)conversation.getProperty("height");
            cCSFormatter.setWidth(n2);
            cCSFormatter.setHeight(n3);
            ((XMLTransport)this.m_session.getTransport()).setContentType(formatLoader.getContentType((String)conversation.getProperty("format")));
        }
        this.m_session.getResponder().setData(cCSDataResult);
    }

    @Override
    protected Conversation doRESTAsync(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        Conversation conversation = null;
        String string = (String)messageContext.getProperty("path_info");
        if (string.endsWith("/next")) {
            conversation = this.m_provider.nextPage(this.m_conversation);
        } else if (string.endsWith("/previous")) {
            conversation = this.m_provider.previousPage(this.m_conversation);
        } else if (string.endsWith("/first")) {
            conversation = this.m_provider.firstPage(this.m_conversation);
        } else if (string.endsWith("/last")) {
            conversation = this.m_provider.lastPage(this.m_conversation);
        } else {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        return conversation;
    }

    @Override
    protected void doRestSync(MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    @Override
    protected void extractRESTOptions(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            Element element2 = DocumentHelper.createElement((QName)new QName("GetOutputResponse", this.m_session.getResponseNamespace()));
            CCSDataResult cCSDataResult = this.processRequest(element, element2);
            this.m_session.setSOAPResponse(element2, cCSDataResult);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }

    protected CCSDataResult processRequest(Element element, Element element2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.m_sourceID = SoapParms.extractSourceID(element);
        this.m_conversation = this.m_session.recoverConversation(this.m_sourceID);
        if (this.m_conversation == null) {
            throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{this.m_sourceID}, 404);
        }
        this.m_provider = this.m_session.getProviderFromConversation(this.m_conversation);
        if (element.getName().equals("NextRequest")) {
            this.m_conversation = this.m_provider.nextPage(this.m_conversation);
        } else if (element.getName().equals("PreviousRequest")) {
            this.m_conversation = this.m_provider.previousPage(this.m_conversation);
        } else if (element.getName().equals("LastRequest")) {
            this.m_conversation = this.m_provider.lastPage(this.m_conversation);
        } else if (element.getName().equals("FirstRequest")) {
            this.m_conversation = this.m_provider.firstPage(this.m_conversation);
        }
        this.m_conversation.setProperty("command", this.getClass().getName());
        return this.createResponse(element2, this.m_conversation, this.m_sourceID);
    }

    @Override
    protected CCSDataResult createResponse(Element element, Conversation conversation, String string) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        String string2 = (String)conversation.getProperty("status");
        element.add(this.generateSession(conversation, string));
        if ("complete".equals(string2)) {
            Filter[] filterArray;
            Constants.Compatibility compatibility = (Constants.Compatibility)((Object)conversation.getProperty("downgrade"));
            Element element2 = element.addElement(new QName("output", this.m_session.getResponseNamespace()));
            Element element3 = null;
            String string3 = (String)conversation.getProperty("format");
            element3 = string3 != null ? element2.addElement(new QName("FormatOutput", this.m_session.getResponseNamespace())) : (compatibility != null && compatibility == Constants.Compatibility.C8_4_OEM ? element2.addElement(new QName("ContentOutput", this.m_session.getResponseNamespace())) : element2.addElement(new QName("LDXOutput", this.m_session.getResponseNamespace())));
            CCSFormatter cCSFormatter = this.m_session.getFormatLoader().getFormatter(string3, this.m_provider);
            if (cCSFormatter != null) {
                filterArray = (Filter[])conversation.getProperty("width");
                Integer n = (Integer)conversation.getProperty("height");
                cCSFormatter.setWidth(filterArray.intValue());
                cCSFormatter.setHeight(n);
                cCSFormatter.setWebcontentRoot(this.m_session.getWebcontentRoot());
                cCSFormatter.setGatewayURI(this.m_session.getAbsoluteGatewayURL());
                cCSFormatter.setConversation(conversation);
            }
            filterArray = (Filter[])conversation.getProperty("filters");
            this.m_provider.retrieveDataOutput(conversation);
            if (conversation.getProperty("saveOutput").equals(Boolean.TRUE)) {
                this.m_provider.saveDataContent(conversation);
            }
            int n = 0;
            Integer n2 = (Integer)conversation.getProperty("rowLimit");
            if (null != n2) {
                n = n2;
            }
            if (null != cCSFormatter || string3 != null && string3.equalsIgnoreCase("layoutDataXML")) {
                element3.addElement("ccscdatamarker");
            } else {
                element3.addElement("ccsdatamarker");
            }
            CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider, filterArray, n, cCSFormatter, this.getAppenderList(conversation));
            if (compatibility != null) {
                cCSDataResult.setDowngrade(compatibility);
            }
            if (cCSFormatter instanceof DatasetHandler) {
                cCSDataResult.setConversation(this.m_session.getConnect(), conversation);
            }
            cCSDataResult.setSecondaryCommands((ArrayList)conversation.getProperty("SECONDARY_COMMANDS"));
            return cCSDataResult;
        }
        return null;
    }
}

