/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.cache.ConversationCache;
import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.content.SearchPromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ACommand;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class PromptDescriptionCommand
extends ACommand {
    private static final String CONVERSATION_ID_TAG = "conversationID";

    @Override
    protected void initialize() {
    }

    @Override
    public void performRestAction(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        try {
            if (null == string) {
                throw new CCSGeneralException("REQUEST_ERROR", 400);
            }
            Document document = this.extractXMLFormData(bIBusEnvelope.getFormValue("xmlData"));
            Element element = null;
            boolean bl = false;
            String string2 = bIBusEnvelope.getFormValue("reprompt");
            if (!Utilities.isNullOrEmpty(string2) && string2.equalsIgnoreCase("true")) {
                bl = true;
            }
            if (null != document) {
                element = document.getRootElement();
            }
            Element element2 = DocumentHelper.createElement((QName)new QName("GetPromptDescriptionResponse", this.m_session.getResponseNamespace()));
            this.describePrompts(string, element, element2, bl);
            this.m_session.setResponseAsString(element2.asXML());
        }
        catch (CCSException cCSException) {
            this.m_session.handleRESTCCSException(cCSException, messageContext);
        }
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            String string = SoapParms.extractSourceID(element);
            Element element2 = DocumentHelper.createElement((QName)new QName("GetPromptDescriptionResponse", this.m_session.getResponseNamespace()));
            boolean bl = SoapParms.getBooleanParm(element, "reprompt", false, true);
            this.describePrompts(string, element, element2, bl);
            this.m_session.setSOAPResponse(element2);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }

    public void describePrompts(String string, Element element, Element element2, boolean bl) throws CCSGeneralException, CCSAuthenticationException {
        try {
            Element element3;
            Object object;
            ConversationCache conversationCache;
            String string2 = null;
            PromptValue[] promptValueArray = null;
            Cognos8Connector cognos8Connector = this.m_session.getConnect();
            ContentProvider contentProvider = this.m_session.getProviderFromID(string);
            SearchPromptValue searchPromptValue = null;
            if (element != null) {
                conversationCache = element.element(CONVERSATION_ID_TAG);
                if (conversationCache != null) {
                    string2 = conversationCache.getText();
                }
                object = element.elements("promptValues");
                promptValueArray = new PromptValue[object.size()];
                for (int i = 0; i < object.size(); ++i) {
                    promptValueArray[i] = PromptValue.parsePromptValue((Element)object.get(i), Constants.NamespaceVersion.V1);
                }
                element3 = element.element("searchPValue");
                if (element3 != null) {
                    searchPromptValue = new SearchPromptValue();
                    searchPromptValue.parseXML(element3);
                }
            }
            conversationCache = cognos8Connector.conversationCache();
            object = null;
            if (null != string2) {
                object = conversationCache.getConversation(string2);
            }
            if ((object = contentProvider.retrievePromptDescription(promptValueArray, searchPromptValue, (Conversation)object, bl)) != null) {
                if (string2 == null) {
                    string2 = conversationCache.addConversation((Conversation)object);
                } else {
                    conversationCache.updateConversation(string2, (Conversation)object);
                }
            } else if (string2 != null) {
                conversationCache.deleteConversation(string2);
                string2 = null;
            }
            element3 = contentProvider.getInputStreams();
            if (null != element3 && ((Element)element3).length > 0) {
                SAXReader sAXReader = new SAXReader();
                Document document = sAXReader.read(new InputSource((InputStream)element3[0]));
                Element element4 = document.getRootElement();
                element4.detach();
                element2.add(element4);
                if (null != string2) {
                    Element element5 = element2.addElement(new QName(CONVERSATION_ID_TAG, this.m_session.getResponseNamespace()));
                    element5.setText(string2);
                }
            }
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException();
        }
    }
}

