/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.CommandSession;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ACommand;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class PromptPageCommand
extends ACommand {
    private static final String PROMPT_ID_TAG = "promptID";
    private static final String URL_TAG = "url";
    private boolean m_useRelativeURL = false;
    private boolean m_useGatewayURI = false;

    @Override
    protected void initialize() {
    }

    @Override
    public void performRestAction(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        try {
            String string2;
            String string3 = bIBusEnvelope.getFormValue("useGatewayURI");
            if (!Utilities.isNullOrEmpty(string3)) {
                if (string3.equalsIgnoreCase("y") || string3.equalsIgnoreCase("yes") || string3.equals("1")) {
                    string3 = "true";
                }
                this.m_useGatewayURI = Boolean.parseBoolean(string3);
            }
            if (!Utilities.isNullOrEmpty(string2 = bIBusEnvelope.getFormValue("useRelativeURL"))) {
                if (string2.equalsIgnoreCase("y") || string2.equalsIgnoreCase("yes") || string2.equals("1")) {
                    string2 = "true";
                }
                this.m_useRelativeURL = Boolean.parseBoolean(string2);
            }
            Element element = DocumentHelper.createElement((QName)new QName("GetPromptPageResponse", this.m_session.getResponseNamespace()));
            this.m_provider = this.m_session.getProviderFromID(string);
            Element element2 = DocumentHelper.createElement((String)"promptAnswers");
            Utilities.processSimplifiedRESTParameters(bIBusEnvelope, element2);
            PromptValue[] promptValueArray = SoapParms.getPromptParms(element2, "promptValues", true);
            this.collectPrompts(element, this.m_session, promptValueArray);
            this.m_session.setResponseAsString(element.asXML());
        }
        catch (CCSException cCSException) {
            this.m_session.handleRESTCCSException(cCSException, messageContext);
        }
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            this.m_useGatewayURI = SoapParms.getBooleanParm(element, "useGatewayURI", false, true);
            this.m_useRelativeURL = SoapParms.getBooleanParm(element, "useRelativeURL", false, true);
            String string = this.m_session.extractSourceIDFromPath(messageContext);
            if (string == null) {
                string = SoapParms.extractSourceID(element);
            }
            this.m_provider = this.m_session.getProviderFromID(string);
            Element element2 = DocumentHelper.createElement((QName)new QName("GetPromptPageResponse", this.m_session.getResponseNamespace()));
            PromptValue[] promptValueArray = SoapParms.getPromptParms(element, "promptValues", true);
            this.collectPrompts(element2, this.m_session, promptValueArray);
            this.m_session.setSOAPResponse(element2);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }

    protected void collectPrompts(Element element, CommandSession commandSession, PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        String string = commandSession.getGatewayURL(this.m_useRelativeURL, this.m_useGatewayURI);
        ContentProvider.PromptStruct promptStruct = this.m_provider.getPromptPage(string, promptValueArray);
        Namespace namespace = commandSession.getResponseNamespace();
        Element element2 = element.addElement(new QName(PROMPT_ID_TAG, namespace));
        element2.setText(promptStruct.getID());
        Element element3 = element.addElement(new QName(URL_TAG, namespace));
        element3.setText(promptStruct.getURL());
    }
}

