/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.AAsyncCommand;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ReportInfoCommand
extends AAsyncCommand {
    private PromptValue[] m_promptValues;
    private boolean m_useRelativeURL = false;
    private boolean m_useGatewayURI = false;
    private boolean m_embedImages = false;

    @Override
    protected Conversation doRESTAsync(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.beginAction();
    }

    @Override
    protected void doAsyncRESTOutput(Conversation conversation, MessageContext messageContext) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        this.endAction(conversation);
    }

    @Override
    protected void doRestSync(MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        Conversation conversation = this.beginAction();
        while (!conversation.getProperty("status").equals("complete")) {
            conversation = this.m_provider.checkDataStatus(conversation);
        }
        this.endAction(conversation);
        this.m_provider.releaseConversation(conversation);
    }

    private Conversation beginAction() throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        Conversation conversation = this.m_provider.beginRetrieveMeta(this.m_promptValues, this.m_useRelativeURL, this.m_useGatewayURI);
        conversation.setProperty("command", this.getClass().getName());
        conversation.setProperty("operation", "reportinfo");
        conversation.setProperty("GENERATE_RELATIVE_URL", this.m_useRelativeURL);
        conversation.setProperty("useGatewayURI", this.m_useGatewayURI);
        conversation.setProperty("embedImages", this.m_embedImages);
        return conversation;
    }

    private CCSDataResult endAction(Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        conversation.setProperty("ReportInfoLegacyCall", false);
        this.m_provider.retrieveMetaOutput(conversation);
        CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider);
        this.m_session.getResponder().setData(cCSDataResult);
        return cCSDataResult;
    }

    @Override
    protected void extractRESTOptions(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
        String string;
        String string2;
        String string3;
        String string4 = bIBusEnvelope.getFormValue("xmlData");
        if (null != string4) {
            this.m_promptValues = SoapParms.getPromptParms(this.extractXMLFormData(string4).getRootElement(), "promptValues", true);
        }
        if (!Utilities.isNullOrEmpty(string3 = bIBusEnvelope.getFormValue("useRelativeURL"))) {
            if (string3.equalsIgnoreCase("y") || string3.equalsIgnoreCase("yes") || string3.equals("1")) {
                string3 = "true";
            }
            this.m_useRelativeURL = Boolean.parseBoolean(string3);
        }
        if (!Utilities.isNullOrEmpty(string2 = bIBusEnvelope.getFormValue("useGatewayURI"))) {
            if (string2.equalsIgnoreCase("y") || string2.equalsIgnoreCase("yes") || string2.equals("1")) {
                string2 = "true";
            }
            this.m_useGatewayURI = Boolean.parseBoolean(string2);
        }
        if (!Utilities.isNullOrEmpty(string = bIBusEnvelope.getFormValue("embedImages"))) {
            if (string.equalsIgnoreCase("y") || string.equalsIgnoreCase("yes") || string.equals("1")) {
                string = "true";
            }
            this.m_embedImages = Boolean.parseBoolean(string);
        }
    }

    @Override
    protected void initialize() {
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            Element element2 = DocumentHelper.createElement((QName)new QName("GetOutputResponse", this.m_session.getResponseNamespace()));
            CCSDataResult cCSDataResult = this.processRequest(element, element2);
            this.m_session.setSOAPResponse(element2, cCSDataResult);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }

    protected CCSDataResult processRequest(Element element, Element element2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.m_sourceID = SoapParms.extractSourceID(element);
        PromptValue[] promptValueArray = SoapParms.getPromptParms(element, "promptValues", true);
        this.m_useRelativeURL = SoapParms.getBooleanParm(element, "generateRelativeUrl", false, true);
        this.m_useGatewayURI = SoapParms.getBooleanParm(element, "useGatewayURI", false, true);
        this.m_embedImages = SoapParms.getBooleanParm(element, "embedImages", false, true);
        this.m_promptValues = promptValueArray;
        this.m_provider = this.m_session.getProviderFromID(this.m_sourceID);
        Conversation conversation = this.beginAction();
        return this.createResponse(element2, conversation, null);
    }

    @Override
    protected CCSDataResult createResponse(Element element, Conversation conversation, String string) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        String string2 = (String)conversation.getProperty("status");
        element.add(this.generateSession(conversation, string));
        if ("complete".equals(string2)) {
            Element element2 = element.addElement(new QName("output", this.m_session.getResponseNamespace()));
            Element element3 = element2.addElement(new QName("ReportInfoOutput", this.m_session.getResponseNamespace()));
            conversation.setProperty("ReportInfoLegacyCall", false);
            this.m_provider.retrieveMetaOutput(conversation);
            element3.addElement("ccsdatamarker");
            CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider);
            cCSDataResult.setConversation(this.m_session.getConnect(), conversation);
            return cCSDataResult;
        }
        return null;
    }
}

