/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.filter.ContextFilter;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.FormatLoader;
import com.cognos.ccs.formats.dashboardimage.DashboardImageHandler;
import com.cognos.ccs.formats.image.ImageHandler;
import com.cognos.ccs.fsm.LdxHandler;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.ManagedAttachment;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.AAsyncCommand;
import com.cognos.ccs.transports.XMLTransport;
import com.cognos.ccs.utility.RandomGUID;
import com.cognos.ccs.utility.RandomNumber;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.ArrayList;
import org.apache.commons.httpclient.Cookie;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ReportOutputCommand
extends AAsyncCommand {
    private static final String PARAM_INLINE_STYLES = "inlineStyles";
    private static final String PARAM_CSS_SUFFIX = "cssSuffix";
    private static final String PARAM_VAL_HTMLFRAGMENT = "HTMLFragment";
    private static final String PARAM_VAL_HTML = "HTML";
    private static final String PARAM_VAL_CSV = "CSV";
    private static final String SIMPLE_FMT = "Simple";
    protected String m_versionType;
    protected String m_versionName;
    protected String m_versionPath;
    protected String m_burstKey;
    protected String m_burstID;
    CCSFormatter m_formatter;
    protected PromptValue[] m_promptValues;
    protected boolean m_isPaged;
    protected boolean m_showPrompts = true;
    protected int m_rowLimit;
    protected Filter[] m_Filters;
    protected boolean m_saveOutput;
    protected int m_width;
    protected int m_height;
    String m_fmt;
    protected boolean m_annotations;
    protected boolean m_drillUrls;
    protected boolean m_drillThroughUrls;
    protected boolean m_includeLayout = false;
    protected boolean m_excludePage = false;
    protected boolean m_includePageBreaks = false;
    private boolean m_embedImages = false;
    private boolean m_useRelativeURL = false;
    private boolean m_useGatewayURI = false;
    private String m_viewerStateData = "";
    private boolean m_inlineCssStyles = true;
    private String m_cssSuffix = "";

    @Override
    protected Conversation doRESTAsync(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        String string = (String)messageContext.getProperty("path_info");
        Constants.Compatibility compatibility = Constants.Compatibility.C10_1;
        if (string.indexOf("/rds/output") != -1 || SIMPLE_FMT.equals(this.m_fmt)) {
            if (this.getSession().getRequestVersion() == Constants.RequestVersion.V3) {
                throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
            }
            compatibility = Constants.Compatibility.C8_4_OEM;
        } else if (this.getSession().getRequestVersion() == Constants.RequestVersion.V3) {
            compatibility = Constants.Compatibility.C10_3;
        } else if (!this.m_includeLayout) {
            compatibility = Constants.Compatibility.C8_4_1;
        }
        this.m_provider.setDowngrade(compatibility);
        Conversation conversation = this.startReport();
        conversation.setProperty("pathInfo", string);
        conversation.setProperty("filter", bIBusEnvelope.getFormValue("selection"));
        conversation.setProperty("filters", this.m_Filters);
        conversation.setProperty("format", this.m_fmt);
        if (PARAM_VAL_HTMLFRAGMENT.equalsIgnoreCase(this.m_fmt)) {
            conversation.setProperty(PARAM_INLINE_STYLES, this.m_inlineCssStyles);
        } else if (PARAM_VAL_CSV.equalsIgnoreCase(this.m_fmt)) {
            conversation.setProperty("PROVIDER_OUTPUT_FORMAT", this.m_fmt);
        }
        if (PARAM_VAL_HTMLFRAGMENT.equalsIgnoreCase(this.m_fmt) || PARAM_VAL_HTML.equalsIgnoreCase(this.m_fmt)) {
            conversation.setProperty(PARAM_CSS_SUFFIX, this.m_cssSuffix);
        }
        conversation.setProperty("annotations", new Boolean(this.m_annotations));
        conversation.setProperty("drillurls", new Boolean(this.m_drillUrls));
        conversation.setProperty("drillthroughurls", new Boolean(this.m_drillThroughUrls));
        conversation.setProperty("rowLimit", new Integer(this.m_rowLimit));
        conversation.setProperty("xpath", bIBusEnvelope.getFormValue("xpath"));
        conversation.setProperty("saveOutput", new Boolean(this.m_saveOutput));
        conversation.setProperty("width", new Integer(this.m_width));
        conversation.setProperty("height", new Integer(this.m_height));
        conversation.setProperty("excludePage", this.m_excludePage);
        conversation.setProperty("includePageBreaks", new Boolean(this.m_includePageBreaks));
        if (!Utilities.isNullOrEmpty(this.m_viewerStateData)) {
            conversation.setProperty("viewerStateData", this.m_viewerStateData);
        }
        conversation.embedImagesUpdate(this.m_embedImages, this.getSession(), messageContext);
        if (compatibility != Constants.Compatibility.C10_3) {
            conversation.setProperty("downgrade", (Object)compatibility);
        }
        conversation.setProperty("GENERATE_RELATIVE_URL", this.m_useRelativeURL);
        conversation.setProperty("useGatewayURI", this.m_useGatewayURI);
        conversation.setProperty(PARAM_CSS_SUFFIX, this.m_cssSuffix);
        return conversation;
    }

    @Override
    protected void extractRESTOptions(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
        this.extractCommonOptions(bIBusEnvelope);
        String string = bIBusEnvelope.getFormValue("paged");
        if (string != null && (string.equalsIgnoreCase("true") || string.equals("1"))) {
            this.m_isPaged = true;
        }
    }

    protected void extractCommonOptions(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        this.m_versionType = bIBusEnvelope.getFormValue("version");
        this.m_versionName = bIBusEnvelope.getFormValue("versionID");
        this.m_versionPath = bIBusEnvelope.getFormValue("versionPath");
        this.m_saveOutput = false;
        if (bIBusEnvelope.getFormValue("saveOutput") != null) {
            this.m_saveOutput = Utilities.parseXMLBoolean(bIBusEnvelope.getFormValue("saveOutput"));
        }
        String string8 = bIBusEnvelope.getFormValue("width");
        String string9 = bIBusEnvelope.getFormValue("height");
        if (string8 != null) {
            this.m_width = Integer.parseInt(string8);
        }
        if (string9 != null) {
            this.m_height = Integer.parseInt(string9);
        }
        this.m_fmt = bIBusEnvelope.getFormValue("fmt");
        if (PARAM_VAL_HTMLFRAGMENT.equalsIgnoreCase(this.m_fmt)) {
            this.m_inlineCssStyles = Utilities.parseOptionalXMLBoolean(bIBusEnvelope.getFormValue(PARAM_INLINE_STYLES), true);
        }
        if (PARAM_VAL_HTMLFRAGMENT.equalsIgnoreCase(this.m_fmt) || PARAM_VAL_HTML.equalsIgnoreCase(this.m_fmt)) {
            this.setSuffix(bIBusEnvelope);
        }
        this.m_annotations = false;
        if (bIBusEnvelope.getFormValue("annot") != null) {
            this.m_annotations = Utilities.parseXMLBoolean(bIBusEnvelope.getFormValue("annot"));
        }
        this.m_drillUrls = false;
        if (bIBusEnvelope.getFormValue("drillurls") != null) {
            this.m_drillUrls = Utilities.parseXMLBoolean(bIBusEnvelope.getFormValue("drillurls"));
        }
        this.m_drillThroughUrls = false;
        if (bIBusEnvelope.getFormValue("drillthroughurls") != null) {
            this.m_drillThroughUrls = Utilities.parseXMLBoolean(bIBusEnvelope.getFormValue("drillthroughurls"));
        }
        this.m_burstID = bIBusEnvelope.getFormValue("burstID");
        this.m_burstKey = bIBusEnvelope.getFormValue("burstKey");
        String string10 = bIBusEnvelope.getFormValue("xmlData");
        Element element = null != string10 ? this.extractXMLFormData(string10).getRootElement() : DocumentHelper.createElement((String)"promptAnswers");
        Utilities.processSimplifiedRESTParameters(bIBusEnvelope, element);
        this.m_promptValues = SoapParms.getPromptParms(element, "promptValues", true);
        String string11 = bIBusEnvelope.getFormValue("selection");
        String string12 = bIBusEnvelope.getFormValue("xpath");
        if (string12 != null) {
            string11 = "<filters><filter>XPATH<filterType>XPATH</filterType><filterValue>" + string12 + "</filterValue></filter></filters>";
        }
        if (string11 != null) {
            this.m_Filters = this.extractFilters(string11);
        }
        if ((string7 = bIBusEnvelope.getFormValue("rowLimit")) != null) {
            this.m_rowLimit = Integer.parseInt(string7);
        }
        if ((string6 = bIBusEnvelope.getFormValue("prompt")) != null && (string6.equalsIgnoreCase("false") || string6.equals("0"))) {
            this.m_showPrompts = false;
        }
        if (!Utilities.isNullOrEmpty(string5 = bIBusEnvelope.getFormValue("useRelativeURL"))) {
            if (string5.equalsIgnoreCase("y") || string5.equalsIgnoreCase("yes") || string5.equals("1")) {
                string5 = "true";
            }
            this.m_useRelativeURL = Boolean.parseBoolean(string5);
        }
        if (!Utilities.isNullOrEmpty(string4 = bIBusEnvelope.getFormValue("useGatewayURI"))) {
            if (string4.equalsIgnoreCase("y") || string4.equalsIgnoreCase("yes") || string4.equals("1")) {
                string4 = "true";
            }
            this.m_useGatewayURI = Boolean.parseBoolean(string4);
        }
        if (!Utilities.isNullOrEmpty(string3 = bIBusEnvelope.getFormValue("viewerStateData"))) {
            this.m_viewerStateData = string3;
        }
        this.m_excludePage = Utilities.parseOptionalXMLBoolean(bIBusEnvelope.getFormValue("excludePage"), false);
        String string13 = bIBusEnvelope.getFormValue("includePageBreaks");
        if (string13 != null && (string13.equalsIgnoreCase("true") || string13.equals("1"))) {
            this.m_includePageBreaks = true;
        }
        if (!Utilities.isNullOrEmpty(string2 = bIBusEnvelope.getFormValue("includeLayout"))) {
            this.m_includeLayout = Utilities.parseXMLBoolean(string2);
        }
        if (!Utilities.isNullOrEmpty(string = bIBusEnvelope.getFormValue("embedImages"))) {
            this.m_embedImages = Utilities.parseXMLBoolean(string);
        }
    }

    @Override
    protected void doRestSync(MessageContext messageContext) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        Object object;
        Object object2;
        Object object3;
        Conversation conversation = new Conversation(this.m_provider.getBiBusHeader());
        conversation.setProperty("filters", this.m_Filters);
        conversation.setProperty("includePageBreaks", new Boolean(this.m_includePageBreaks));
        if (!Utilities.isNullOrEmpty(this.m_viewerStateData)) {
            conversation.setProperty("viewerStateData", this.m_viewerStateData);
        }
        if (PARAM_VAL_HTMLFRAGMENT.equalsIgnoreCase(this.m_fmt)) {
            conversation.setProperty(PARAM_INLINE_STYLES, this.m_inlineCssStyles);
        } else if (PARAM_VAL_CSV.equalsIgnoreCase(this.m_fmt)) {
            conversation.setProperty("PROVIDER_OUTPUT_FORMAT", this.m_fmt);
        }
        if (PARAM_VAL_HTMLFRAGMENT.equalsIgnoreCase(this.m_fmt) || PARAM_VAL_HTML.equalsIgnoreCase(this.m_fmt)) {
            conversation.setProperty(PARAM_CSS_SUFFIX, this.m_cssSuffix);
        }
        conversation.setProperty("rowLimit", new Integer(this.m_rowLimit));
        conversation = this.m_provider.retrieveDataContent(this.m_versionType, this.m_versionPath, this.m_versionName, this.m_burstKey, this.m_burstID, this.m_promptValues, this.m_isPaged, this.m_showPrompts, conversation, this.m_useRelativeURL, this.m_useGatewayURI, this.m_saveOutput);
        conversation.setProperty("saveOutput", new Boolean(this.m_saveOutput));
        conversation.setProperty("width", new Integer(this.m_width));
        conversation.setProperty("height", new Integer(this.m_height));
        if (conversation.getProperty("saveOutput").equals(Boolean.TRUE)) {
            this.m_provider.saveDataContent(conversation);
        }
        String string = (String)messageContext.getProperty("path_info");
        Constants.Compatibility compatibility = Constants.Compatibility.C10_1;
        if (string.indexOf("/rds/output") != -1 || SIMPLE_FMT.equals(this.m_fmt)) {
            if (this.getSession().getRequestVersion() == Constants.RequestVersion.V3) {
                throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
            }
            compatibility = Constants.Compatibility.C8_4_OEM;
        } else if (this.getSession().getRequestVersion() == Constants.RequestVersion.V3) {
            compatibility = Constants.Compatibility.C10_3;
        } else if (!this.m_includeLayout) {
            compatibility = Constants.Compatibility.C8_4_1;
        }
        conversation.setProperty("pathInfo", string);
        conversation.setProperty("annotations", new Boolean(this.m_annotations));
        conversation.setProperty("drillthroughurls", new Boolean(this.m_drillThroughUrls));
        conversation.embedImagesUpdate(this.m_embedImages, this.getSession(), messageContext);
        conversation.setProperty("GENERATE_RELATIVE_URL", this.m_useRelativeURL);
        conversation.setProperty("useGatewayURI", this.m_useGatewayURI);
        FormatLoader formatLoader = new FormatLoader();
        CCSFormatter cCSFormatter = formatLoader.getFormatter(this.m_fmt, this.m_provider);
        if (cCSFormatter != null) {
            if (PARAM_VAL_HTMLFRAGMENT.equalsIgnoreCase(this.m_fmt) || PARAM_VAL_HTML.equalsIgnoreCase(this.m_fmt)) {
                cCSFormatter.setCssSuffix(this.m_cssSuffix);
            }
            cCSFormatter.setWebcontentRoot(this.m_session.getWebcontentRoot());
            object3 = this.m_session.getGatewayURL(this.m_useRelativeURL, this.m_useGatewayURI);
            cCSFormatter.setGatewayURI((String)object3);
            cCSFormatter.setConversation(conversation);
            object2 = cCSFormatter.getPreProcessor();
            if (object2 != null) {
                ((LdxHandler)object2).setConversation(conversation);
            }
            if (cCSFormatter instanceof ImageHandler || cCSFormatter instanceof DashboardImageHandler) {
                object = this.getSession().getCookies();
                conversation.setProperty("cookies", object);
            }
            cCSFormatter.setRequestVersion(this.getSession().getRequestVersion());
            cCSFormatter.setProductLocale(this.getSession().getUserJavaLocale());
            cCSFormatter.setIsAccessibilityFeaturesEnabled(this.getSession().getIsAccessibilityFeaturesEnabled());
        }
        object3 = new CCSDataResult(this.m_session.getTransport(), this.m_provider, this.m_Filters, this.m_rowLimit, cCSFormatter, this.getAppenderList(conversation));
        if (PARAM_VAL_CSV.equalsIgnoreCase(this.m_fmt)) {
            this.handleCSV((CCSDataResult)object3);
            ((XMLTransport)this.m_session.getTransport()).setContentType("text/plain; charset=utf-8");
        }
        if (compatibility != Constants.Compatibility.C10_3) {
            ((CCSDataResult)object3).setDowngrade(compatibility);
        }
        this.setUpgradeForSavedOutput((CCSDataResult)object3, conversation);
        ((CCSDataResult)object3).setConversation(this.m_session.getConnect(), conversation);
        if (cCSFormatter != null) {
            object2 = (Integer)conversation.getProperty("width");
            object = (Integer)conversation.getProperty("height");
            cCSFormatter.setWidth((Integer)object2);
            cCSFormatter.setHeight((Integer)object);
            ((XMLTransport)this.m_session.getTransport()).setContentType(formatLoader.getContentType(this.m_fmt));
        }
        this.m_session.getResponder().setData((CCSDataResult)object3);
        this.m_provider.releaseConversation(conversation);
    }

    private void setUpgradeForSavedOutput(CCSDataResult cCSDataResult, Conversation conversation) {
        if ("true".equals((String)conversation.getProperty("versioned")) && this.getSession().getRequestVersion() == Constants.RequestVersion.V3) {
            cCSDataResult.setUpgrade(Constants.Compatibility.C10_3);
        }
    }

    protected Conversation startReport() throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        Conversation conversation = this.m_provider.beginRetrieveData(this.m_versionType, this.m_versionPath, this.m_versionName, this.m_burstKey, this.m_burstID, this.m_promptValues, this.m_isPaged, this.m_showPrompts, null, this.m_saveOutput);
        conversation.setProperty("operation", "output");
        return conversation;
    }

    @Override
    protected void doAsyncRESTOutput(Conversation conversation, MessageContext messageContext) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        Cookie[] cookieArray;
        Object object;
        String string;
        FormatLoader formatLoader;
        CCSFormatter cCSFormatter;
        if (conversation.getProperty("GENERATE_RELATIVE_URL") != null) {
            this.m_useRelativeURL = Boolean.parseBoolean(conversation.getProperty("GENERATE_RELATIVE_URL").toString());
        }
        conversation.setProperty("GENERATE_RELATIVE_URL", this.m_useRelativeURL);
        if (conversation.getProperty("useGatewayURI") != null) {
            this.m_useGatewayURI = Boolean.parseBoolean(conversation.getProperty("useGatewayURI").toString());
        }
        conversation.setProperty("useGatewayURI", this.m_useGatewayURI);
        this.m_provider.retrieveDataOutput(conversation);
        if (conversation.getProperty("saveOutput").equals(Boolean.TRUE)) {
            this.m_provider.saveDataContent(conversation);
        }
        if ((cCSFormatter = (formatLoader = new FormatLoader()).getFormatter(string = (String)conversation.getProperty("format"), this.m_provider)) != null) {
            if (PARAM_VAL_HTMLFRAGMENT.equalsIgnoreCase(string) || PARAM_VAL_HTML.equalsIgnoreCase(string)) {
                cCSFormatter.setCssSuffix((String)conversation.getProperty(PARAM_CSS_SUFFIX));
            }
            cCSFormatter.setWebcontentRoot(this.m_session.getWebcontentRoot());
            cCSFormatter.setConversation(conversation);
            object = cCSFormatter.getPreProcessor();
            if (object != null) {
                ((LdxHandler)object).setConversation(conversation);
            }
            if (cCSFormatter instanceof ImageHandler || cCSFormatter instanceof DashboardImageHandler) {
                cookieArray = this.getSession().getCookies();
                conversation.setProperty("cookies", cookieArray);
            }
            cCSFormatter.setRequestVersion(this.getSession().getRequestVersion());
            cCSFormatter.setProductLocale(this.getSession().getUserJavaLocale());
            cCSFormatter.setIsAccessibilityFeaturesEnabled(this.getSession().getIsAccessibilityFeaturesEnabled());
        }
        object = (String)conversation.getProperty("filter");
        cookieArray = (Cookie[])conversation.getProperty("xpath");
        if (cookieArray != null) {
            object = "<filters><filter>XPATH<filterType>XPATH</filterType><filterValue>" + (String)cookieArray + "</filterValue></filter></filters>";
        }
        if (object != null) {
            this.m_Filters = this.extractFilters((String)object);
        }
        Integer n = (Integer)conversation.getProperty("rowLimit");
        CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider, this.m_Filters, n, cCSFormatter, this.getAppenderList(conversation));
        if (PARAM_VAL_CSV.equalsIgnoreCase(string)) {
            this.handleCSV(cCSDataResult);
            ((XMLTransport)this.m_session.getTransport()).setContentType("text/plain; charset=utf-8");
        }
        cCSDataResult.setSecondaryCommands((ArrayList)conversation.getProperty("SECONDARY_COMMANDS"));
        Constants.Compatibility compatibility = (Constants.Compatibility)((Object)conversation.getProperty("downgrade"));
        if (compatibility != null) {
            cCSDataResult.setDowngrade(compatibility);
        }
        this.setUpgradeForSavedOutput(cCSDataResult, conversation);
        cCSDataResult.setConversation(this.m_session.getConnect(), conversation);
        if (cCSFormatter != null) {
            Integer n2 = (Integer)conversation.getProperty("width");
            Integer n3 = (Integer)conversation.getProperty("height");
            cCSFormatter.setWidth(n2);
            cCSFormatter.setHeight(n3);
            cCSFormatter.setWebcontentRoot(this.m_session.getWebcontentRoot());
            String string2 = this.m_session.getGatewayURL(this.m_useRelativeURL, this.m_useGatewayURI);
            cCSFormatter.setGatewayURI(string2);
            ((XMLTransport)this.m_session.getTransport()).setContentType(formatLoader.getContentType((String)conversation.getProperty("format")));
        }
        this.m_session.getResponder().setData(cCSDataResult);
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            this.extractSOAPParms(element);
            this.m_provider = this.m_session.getProviderFromID(this.m_sourceID);
            Element element2 = DocumentHelper.createElement((QName)new QName("GetOutputResponse", this.m_session.getResponseNamespace()));
            CCSDataResult cCSDataResult = this.processRequest(element, element2);
            this.m_session.setSOAPResponse(element2, cCSDataResult);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }

    protected void extractSOAPParms(Element element) throws CCSGeneralException {
        this.extractCommonParms(element);
        String string = SoapParms.getStringParm(element, "paged", null, true);
        if (string != null && (string.equalsIgnoreCase("true") || string.equals("1"))) {
            this.m_isPaged = true;
        }
        this.m_includeLayout = SoapParms.getBooleanParm(element, "includeLayout", false, true);
    }

    protected void extractCommonParms(Element element) throws CCSGeneralException {
        String string;
        this.m_sourceID = SoapParms.extractSourceID(element);
        this.m_Filters = SoapParms.getFilterParm(element, "filters", true);
        this.m_promptValues = SoapParms.getPromptParms(element, "promptValues", true);
        this.m_versionType = SoapParms.getContainedStringParm(element, "version", "versionType", null, true);
        this.m_versionName = SoapParms.getContainedStringParm(element, "version", "versionName", null, true);
        this.m_versionPath = SoapParms.getContainedStringParm(element, "version", "searchPath", null, true);
        this.m_burstKey = SoapParms.getContainedStringParm(element, "burstInfo", "burstKey", null, true);
        this.m_burstID = SoapParms.getContainedStringParm(element, "burstInfo", "burstId", null, true);
        this.m_rowLimit = SoapParms.getIntParm(element, "rowLimit", 0, Integer.MAX_VALUE, true);
        this.m_width = SoapParms.getIntParm(element, "width", 0, Integer.MAX_VALUE, true);
        this.m_height = SoapParms.getIntParm(element, "height", 0, Integer.MAX_VALUE, true);
        this.m_fmt = SoapParms.getStringParm(element, "format", true);
        this.m_inlineCssStyles = SoapParms.getBooleanParm(element, PARAM_INLINE_STYLES, true, true);
        if (PARAM_VAL_HTMLFRAGMENT.equalsIgnoreCase(this.m_fmt) || PARAM_VAL_HTML.equalsIgnoreCase(this.m_fmt)) {
            this.setSuffix(element);
        }
        this.m_saveOutput = SoapParms.getBooleanParm(element, "saveOutput", false, true);
        if (Integer.MIN_VALUE == this.m_rowLimit) {
            this.m_rowLimit = 0;
        }
        if (Integer.MIN_VALUE == this.m_width) {
            this.m_width = 0;
        }
        if (Integer.MIN_VALUE == this.m_height) {
            this.m_height = 0;
        }
        if ((string = SoapParms.getStringParm(element, "prompt", null, true)) != null && (string.equalsIgnoreCase("false") || string.equals("0"))) {
            this.m_showPrompts = false;
        }
        this.m_excludePage = SoapParms.getBooleanParm(element, "excludePage", false, true);
        this.m_includePageBreaks = SoapParms.getBooleanParm(element, "includePageBreaks", false, true);
        this.m_useRelativeURL = SoapParms.getBooleanParm(element, "useRelativeURL", false, true);
        this.m_useGatewayURI = SoapParms.getBooleanParm(element, "useGatewayURI", false, true);
        this.m_viewerStateData = SoapParms.getStringParm(element, "viewerStateData", true);
        this.m_embedImages = SoapParms.getBooleanParm(element, "embedImages", false, true);
    }

    protected CCSDataResult processRequest(Element element, Element element2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        Constants.Compatibility compatibility = Constants.Compatibility.C10_1;
        if (element.getName().equals("GetReportContentRequest") || SIMPLE_FMT.equals(this.m_fmt)) {
            if (this.getSession().getRequestVersion() == Constants.RequestVersion.V3) {
                throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
            }
            compatibility = Constants.Compatibility.C8_4_OEM;
        } else if (this.getSession().getRequestVersion() == Constants.RequestVersion.V3) {
            compatibility = Constants.Compatibility.C10_3;
        } else if (!this.m_includeLayout) {
            compatibility = Constants.Compatibility.C8_4_1;
        }
        if (compatibility != Constants.Compatibility.C10_3) {
            this.m_provider.setDowngrade(compatibility);
        }
        Conversation conversation = this.startReport();
        if (compatibility != Constants.Compatibility.C10_3) {
            conversation.setProperty("downgrade", (Object)compatibility);
        }
        conversation.setProperty("filters", this.m_Filters);
        conversation.setProperty("format", this.m_fmt);
        if (PARAM_VAL_HTMLFRAGMENT.equalsIgnoreCase(this.m_fmt)) {
            conversation.setProperty(PARAM_INLINE_STYLES, this.m_inlineCssStyles);
        } else if (PARAM_VAL_CSV.equalsIgnoreCase(this.m_fmt)) {
            conversation.setProperty("PROVIDER_OUTPUT_FORMAT", this.m_fmt);
        }
        if (PARAM_VAL_HTMLFRAGMENT.equalsIgnoreCase(this.m_fmt) || PARAM_VAL_HTML.equalsIgnoreCase(this.m_fmt)) {
            conversation.setProperty(PARAM_CSS_SUFFIX, this.m_cssSuffix);
        }
        conversation.setProperty("command", this.getClass().getName());
        conversation.setProperty("saveOutput", new Boolean(this.m_saveOutput));
        conversation.setProperty("width", new Integer(this.m_width));
        conversation.setProperty("height", new Integer(this.m_height));
        conversation.setProperty("rowLimit", new Integer(this.m_rowLimit));
        conversation.setProperty("excludePage", this.m_excludePage);
        conversation.setProperty("includePageBreaks", new Boolean(this.m_includePageBreaks));
        conversation.setProperty("GENERATE_RELATIVE_URL", this.m_useRelativeURL);
        conversation.setProperty("useGatewayURI", this.m_useGatewayURI);
        if (!Utilities.isNullOrEmpty(this.m_viewerStateData)) {
            conversation.setProperty("viewerStateData", this.m_viewerStateData);
        }
        conversation.embedImagesUpdate(this.m_embedImages, this.getSession(), null);
        CCSDataResult cCSDataResult = this.createResponse(element2, conversation, null);
        if (conversation.getProperty("SECONDARY_COMMANDS") != null) {
            cCSDataResult.setSecondaryCommands((ArrayList)conversation.getProperty("SECONDARY_COMMANDS"));
        }
        return cCSDataResult;
    }

    @Override
    protected CCSDataResult createResponse(Element element, Conversation conversation, String string) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        String string2 = (String)conversation.getProperty("status");
        this.m_useRelativeURL = Utilities.parseOptionalObjectBoolean(conversation.getProperty("GENERATE_RELATIVE_URL"), false);
        this.m_useGatewayURI = Utilities.parseOptionalObjectBoolean(conversation.getProperty("useGatewayURI"), false);
        element.add(this.generateSession(conversation, string));
        if ("complete".equals(string2)) {
            Object object;
            Integer n;
            Constants.Compatibility compatibility = (Constants.Compatibility)((Object)conversation.getProperty("downgrade"));
            Element element2 = element.addElement(new QName("output", this.m_session.getResponseNamespace()));
            Element element3 = null;
            String string3 = (String)conversation.getProperty("format");
            this.m_formatter = this.m_session.getFormatLoader().getFormatter(string3, this.m_provider);
            if (this.m_formatter != null) {
                if (PARAM_VAL_HTMLFRAGMENT.equalsIgnoreCase(string3) || PARAM_VAL_HTML.equalsIgnoreCase(string3)) {
                    this.m_formatter.setCssSuffix((String)conversation.getProperty(PARAM_CSS_SUFFIX));
                }
                n = (Integer)conversation.getProperty("width");
                object = (Integer)conversation.getProperty("height");
                this.m_formatter.setWidth(n);
                this.m_formatter.setHeight((Integer)object);
                this.m_formatter.setWebcontentRoot(this.m_session.getWebcontentRoot());
                String string4 = this.m_session.getGatewayURL(this.m_useRelativeURL, this.m_useGatewayURI);
                this.m_formatter.setGatewayURI(string4);
                CCSFormatter cCSFormatter = this.m_formatter.getPreProcessor();
                if (cCSFormatter != null) {
                    cCSFormatter.setConversation(conversation);
                }
                if (this.m_formatter instanceof ImageHandler || this.m_formatter instanceof DashboardImageHandler) {
                    Cookie[] cookieArray = this.getSession().getCookies();
                    conversation.setProperty("cookies", cookieArray);
                }
                element3 = element2.addElement(new QName("FormatOutput", this.m_session.getResponseNamespace()));
                this.m_formatter.setRequestVersion(this.getSession().getRequestVersion());
                this.m_formatter.setProductLocale(this.getSession().getUserJavaLocale());
                this.m_formatter.setIsAccessibilityFeaturesEnabled(this.getSession().getIsAccessibilityFeaturesEnabled());
            } else {
                element3 = string3 != null ? element2.addElement(new QName("FormatOutput", this.m_session.getResponseNamespace())) : (compatibility != null && compatibility == Constants.Compatibility.C8_4_OEM ? element2.addElement(new QName("ContentOutput", this.m_session.getResponseNamespace())) : element2.addElement(new QName("LDXOutput", this.m_session.getResponseNamespace())));
            }
            this.m_Filters = (Filter[])conversation.getProperty("filters");
            if (this.m_Filters != null && this.m_Filters.length > 0 && this.m_Filters[0].getFilterType().equals("CONTEXT_SPEC")) {
                ((ContextFilter)this.m_Filters[0]).setConverstion(conversation, this.m_session.getConnect());
            }
            this.m_provider.retrieveDataOutput(conversation);
            if (conversation.getProperty("saveOutput").equals(Boolean.TRUE)) {
                this.m_provider.saveDataContent(conversation);
            }
            n = (Integer)conversation.getProperty("rowLimit");
            if (null != string3) {
                element3.addElement("ccscdatamarker");
            } else {
                element3.addElement("ccsdatamarker");
            }
            object = new CCSDataResult(this.m_session.getTransport(), this.m_provider, this.m_Filters, n, this.m_formatter, this.getAppenderList(conversation));
            if (PARAM_VAL_CSV.equalsIgnoreCase(string3)) {
                this.handleCSV((CCSDataResult)object);
            }
            if (compatibility != null) {
                ((CCSDataResult)object).setDowngrade(compatibility);
            }
            this.setUpgradeForSavedOutput((CCSDataResult)object, conversation);
            ((CCSDataResult)object).setConversation(this.m_session.getConnect(), conversation);
            return object;
        }
        return null;
    }

    private void setSuffix(BIBusEnvelope bIBusEnvelope) {
        String string = bIBusEnvelope.getFormValue(PARAM_CSS_SUFFIX);
        this.setSuffix(string);
    }

    private void setSuffix(Element element) throws CCSGeneralException {
        String string = SoapParms.getStringParm(element, PARAM_CSS_SUFFIX, null, true);
        this.setSuffix(string);
    }

    private void setSuffix(String string) {
        if (ConfigMgr.getInstance().generateUniqueCssStyleNames()) {
            this.m_cssSuffix = this.generateSuffix();
        }
        if (!Utilities.isNullOrEmpty(string) && Utilities.isXPathStringSafe(string)) {
            this.m_cssSuffix = string;
        }
    }

    private String generateSuffix() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("_");
        int n = 0;
        if (n == 0) {
            int n2 = RandomNumber.getInt();
            if (n2 < 0) {
                stringBuilder.append("_");
                n2 *= -1;
            }
            stringBuilder.append(Integer.toString(n2));
        } else if (n == 1) {
            long l = RandomNumber.getLong();
            if (l < 0L) {
                stringBuilder.append("_");
                l *= -1L;
            }
            stringBuilder.append(Long.toString(l));
        } else if (n == 2) {
            String string = new RandomGUID().toString();
            stringBuilder.append(Integer.toString(string.hashCode()));
        } else {
            stringBuilder.append(new RandomGUID().toString());
        }
        return stringBuilder.toString();
    }

    private void handleCSV(CCSDataResult cCSDataResult) {
        cCSDataResult.setIsCSV();
        ManagedAttachment managedAttachment = this.m_provider.getAttachment();
        if (managedAttachment != null) {
            String string = managedAttachment.getCharsetFromContentType();
            cCSDataResult.setCharset(string);
        }
    }
}

