/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.AAsyncCommand;
import com.cognos.ccs.service.command.ACommand;
import com.cognos.ccs.service.command.CommandMap;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class SessionOutputCommand
extends ACommand {
    private static final String COMPLETE = "complete";
    private static final String STATUS_KEY = "status";

    @Override
    protected void initialize() {
    }

    @Override
    public void performRestAction(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        try {
            ACommand aCommand = this.getSecondaryCommand(messageContext);
            if (aCommand != null) {
                aCommand.performRestAction(bIBusEnvelope, messageContext, string);
                return;
            }
            Conversation conversation = this.m_session.recoverConversation(string);
            if (conversation == null) {
                throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{string}, 404);
            }
            String string2 = this.getConversationStatus(conversation);
            if (!COMPLETE.equalsIgnoreCase(string2)) {
                conversation = this.checkStatus(conversation);
            }
            string2 = this.getConversationStatus(conversation);
            String string3 = (String)conversation.getProperty("command");
            Class<?> clazz = Class.forName(string3);
            AAsyncCommand aAsyncCommand = (AAsyncCommand)clazz.newInstance();
            aAsyncCommand.setSession(this.m_session);
            String string4 = bIBusEnvelope.getFormValue("selection");
            String string5 = bIBusEnvelope.getFormValue("fmt");
            String string6 = bIBusEnvelope.getFormValue("xpath");
            if (string4 != null) {
                conversation.setProperty("filter", string4);
            }
            if (string5 != null) {
                conversation.setProperty("format", string5);
            }
            if (string6 != null) {
                conversation.setProperty("xpath", string6);
            }
            if (COMPLETE.equalsIgnoreCase(string2)) {
                aAsyncCommand.retrieveRESTSessionOutput(conversation, this.m_session, messageContext);
            } else {
                aAsyncCommand.createReciept(messageContext, conversation, string);
            }
            this.m_session.updateConversation(conversation, string);
        }
        catch (CCSException cCSException) {
            this.m_session.handleRESTCCSException(cCSException, messageContext);
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("TRANS_ERROR", exception, 500);
            this.m_session.generateRESTErrorBlock(cCSGeneralException, messageContext);
        }
    }

    private String getConversationStatus(Conversation conversation) {
        String string = (String)conversation.getProperty(STATUS_KEY);
        return string;
    }

    public ACommand getSecondaryCommand(MessageContext messageContext) {
        String string = (String)messageContext.getProperty("path_info");
        String[] stringArray = string.split("/");
        if (stringArray.length > 0) {
            String string2 = stringArray[stringArray.length - 1];
            ACommand aCommand = CommandMap.getInstance().getCommand(string2);
            if (null == aCommand) {
                return null;
            }
            aCommand.setSession(this.m_session);
            return aCommand;
        }
        return null;
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            Element element2 = element.element("session");
            String string = SoapParms.getStringParm(element2, "conversationID", false);
            Conversation conversation = this.m_session.recoverConversation(string);
            if (conversation == null) {
                throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{string}, 404);
            }
            this.m_provider = this.m_session.getProviderFromConversation(conversation);
            String string2 = (String)conversation.getProperty("command");
            Class<?> clazz = Class.forName(string2);
            AAsyncCommand aAsyncCommand = (AAsyncCommand)clazz.newInstance();
            aAsyncCommand.setSession(this.m_session);
            aAsyncCommand.m_provider = this.m_provider;
            Element element3 = DocumentHelper.createElement((QName)new QName("GetOutputResponse", this.m_session.getResponseNamespace()));
            CCSDataResult cCSDataResult = aAsyncCommand.processSession(element3, element2);
            this.m_session.setSOAPResponse(element3, cCSDataResult);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("REQUEST_ERROR", exception, 500);
            this.m_session.generateSOAPFault(messageContext, cCSGeneralException);
        }
    }

    public Conversation checkStatus(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        ContentProvider contentProvider = this.m_session.getProviderFromConversation(conversation);
        return contentProvider.checkDataStatus(conversation);
    }

    @Override
    public String getSavedOutputStoreID(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) throws CCSGeneralException, CCSAuthenticationException {
        ContentProvider contentProvider;
        Conversation conversation = this.m_session.recoverConversation(string);
        if (conversation != null && (contentProvider = this.m_session.getProviderFromConversation(conversation)) != null) {
            String string2 = (String)conversation.getProperty("PROVIDER_OUTPUT_FORMAT");
            String string3 = (String)conversation.getProperty("burstID");
            String string4 = (String)conversation.getProperty("burstKey");
            return contentProvider.getSavedOutputStoreID(string2, string3, string4);
        }
        return null;
    }
}

