/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.DrillOutputCommand;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.ArrayList;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class SimplifiedDrillOutputCommand
extends DrillOutputCommand {
    protected static final String Simple_Format = "Simple";

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            this.m_provider = this.m_session.getProviderFromPath(messageContext);
            String string = element.getName();
            string = string.substring(0, string.length() - 7);
            Element element2 = DocumentHelper.createElement((QName)new QName(string + "Response", this.m_session.getResponseNamespace()));
            Element element3 = element.element("session");
            String string2 = SoapParms.getStringParm(element3, "status", false);
            CCSDataResult cCSDataResult = null;
            cCSDataResult = !string2.equals("complete") ? this.processSession(element2, element3) : this.processNewRequest(element, string, element2);
            this.m_session.setSOAPResponse(element2, cCSDataResult);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }

    public CCSDataResult processNewRequest(Element element, String string, Element element2) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        this.m_contextId = SoapParms.getStringParm(element, "contextID", false);
        this.m_direction = SoapParms.getStringParm(element, "direction", false);
        String string2 = SoapParms.getContainedStringParm(element, "session", "conversationID", null, false);
        this.m_conversation = this.m_provider.beginDrill(this.m_contextId, string2, this.m_direction);
        return this.createResponse(element2, this.m_conversation, null);
    }

    @Override
    protected CCSDataResult createResponse(Element element, Conversation conversation, String string) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        String string2 = (String)conversation.getProperty("status");
        element.add(this.generateSession(conversation, string));
        if ("complete".equals(string2)) {
            Object object;
            String string3;
            String string4 = (String)conversation.getProperty("format");
            Filter[] filterArray = null;
            CCSFormatter cCSFormatter = this.m_session.getFormatLoader().getFormatter(string4, this.m_provider);
            if (cCSFormatter != null) {
                cCSFormatter.setSOAPEncode(true);
                cCSFormatter.setWebcontentRoot(this.m_session.getWebcontentRoot());
                cCSFormatter.setGatewayURI(this.m_session.getAbsoluteGatewayURL());
            }
            filterArray = (string3 = (String)conversation.getProperty("filter")) != null ? new Filter[]{new Filter(CCSFormatter.decodeName(string3), "OBJECT_ID")} : (Filter[])conversation.getProperty("filters");
            this.m_provider.retrieveDrillOutput(conversation);
            if (!Simple_Format.equals(string4)) {
                object = element.addElement(new QName("results", this.m_session.getResponseNamespace()));
                object.addElement("ccscdatamarker");
            } else {
                element.addElement("ccsdatamarker");
            }
            object = new CCSDataResult(this.m_session.getTransport(), this.m_provider, filterArray, 0, cCSFormatter, this.getAppenderList(this.m_conversation));
            Constants.Compatibility compatibility = (Constants.Compatibility)((Object)conversation.getProperty("downgrade"));
            if (compatibility != null) {
                ((CCSDataResult)object).setDowngrade(compatibility);
            }
            ((CCSDataResult)object).setSecondaryCommands((ArrayList)conversation.getProperty("SECONDARY_COMMANDS"));
            return object;
        }
        return null;
    }
}

