/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ReportOutputCommand;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class SimplifiedOutputCommand
extends ReportOutputCommand {
    protected static final String Simple_Format = "Simple";
    protected static final String LDX_Format = "LDX";
    CCSFormatter m_formatter;

    @Override
    protected void initialize() {
        this.m_asyncType = 0;
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            this.m_provider = this.m_session.getProviderFromPath(messageContext);
            String string = (String)messageContext.getProperty("path_info");
            String string2 = element.getName();
            string2 = string2.substring(0, string2.length() - 7);
            Namespace namespace = this.m_session.getResponseNamespace();
            Element element2 = DocumentHelper.createElement((QName)new QName(string2 + "Response", namespace));
            Element element3 = element.element("session");
            CCSDataResult cCSDataResult = null;
            cCSDataResult = element3 != null ? this.processSession(element2, element3) : this.processNewRequest(element, string2, element2, string);
            this.m_session.setSOAPResponse(element2, cCSDataResult);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }

    private CCSDataResult processNewRequest(Element element, String string, Element element2, String string2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        String string3;
        String string4 = null;
        boolean bl = false;
        if (string2.toLowerCase().startsWith("/rds/ldx/")) {
            string3 = LDX_Format;
            bl = true;
        } else {
            string3 = Simple_Format;
        }
        this.m_versionType = SoapParms.getContainedStringParm(element, "version", "versionType", null, true);
        this.m_versionName = SoapParms.getContainedStringParm(element, "version", "versionID", null, true);
        this.m_versionPath = SoapParms.getContainedStringParm(element, "version", "searchPath", null, true);
        this.m_burstKey = SoapParms.getContainedStringParm(element, "burstInfo", "burstKey", null, true);
        this.m_burstID = SoapParms.getContainedStringParm(element, "burstInfo", "burstId", null, true);
        this.processSimplifiedParameters(element);
        if (!string.equalsIgnoreCase("GetReport")) {
            if (string.equalsIgnoreCase("GetFormattedReport")) {
                string3 = SoapParms.getStringParm(element, "format", false);
            } else if (string.toLowerCase().startsWith("getformatted_")) {
                string4 = string.substring(13, string.length());
                string3 = SoapParms.getStringParm(element, "format", false);
            } else {
                string4 = string.substring(4, string.length());
            }
        }
        this.setupCommand(string4, string3);
        Conversation conversation = this.startReport();
        conversation.setProperty("filter", string4);
        conversation.setProperty("format", string3);
        conversation.setProperty("generic", new Boolean(bl));
        CCSDataResult cCSDataResult = this.createResponse(element2, conversation, null);
        return cCSDataResult;
    }

    private void processSimplifiedParameters(Element element) throws CCSGeneralException {
        Element element2 = element.element("promptAnswers");
        if (element2 != null) {
            List list = element2.elements();
            for (Element element3 : list) {
                String string = element3.getName();
                if (string.equals("extension") || string.equals("promptValues")) continue;
                String string2 = element3.getText();
                Element element4 = element2.addElement("promptValues");
                Element element5 = element4.addElement("name");
                element5.setText(CCSFormatter.decodeName(string));
                Element element6 = element4.addElement("values");
                Element element7 = element6.addElement("item");
                Element element8 = element7.addElement("SimplePValue");
                Element element9 = element8.addElement("inclusive");
                element9.setText("1");
                Element element10 = element8.addElement("useValue");
                element10.setText(string2);
            }
            this.m_promptValues = SoapParms.getPromptParms(element2, "promptValues", true);
        }
    }

    @Override
    protected CCSDataResult createResponse(Element element, Conversation conversation, String string) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        String string2 = (String)conversation.getProperty("status");
        element.add(this.generateSession(conversation, string));
        if ("complete".equals(string2)) {
            Object object;
            String string3;
            boolean bl = false;
            Boolean bl2 = (Boolean)conversation.getProperty("generic");
            if (bl2 != null) {
                bl = bl2;
            }
            String string4 = (String)conversation.getProperty("format");
            CCSFormatter cCSFormatter = this.m_session.getFormatLoader().getFormatter(string4, this.m_provider);
            if (cCSFormatter != null) {
                cCSFormatter.setSOAPEncode(true);
                cCSFormatter.setWebcontentRoot(this.m_session.getWebcontentRoot());
                cCSFormatter.setGatewayURI(this.m_session.getAbsoluteGatewayURL());
            }
            if ((string3 = (String)conversation.getProperty("filter")) != null) {
                this.m_Filters = new Filter[]{new Filter(CCSFormatter.decodeName(string3), "OBJECT_ID")};
            }
            this.m_provider.retrieveDataOutput(conversation);
            if (!Simple_Format.equals(string4)) {
                object = element.addElement(new QName("results", this.m_session.getResponseNamespace()));
                if (bl) {
                    object.addElement("ccsdatamarker");
                } else {
                    object.addElement("ccscdatamarker");
                }
            } else {
                element.addElement("ccsdatamarker");
            }
            object = new CCSDataResult(this.m_session.getTransport(), this.m_provider, this.m_Filters, this.m_rowLimit, cCSFormatter, this.getAppenderList(conversation));
            ((CCSDataResult)object).setDowngrade(Constants.Compatibility.C8_4_OEM);
            String string5 = "http://developer.cognos.com/schemas/raas/" + CCSFormatter.encodeNameForTag(this.m_provider.getReportName());
            ((CCSDataResult)object).setSimpleNamespace(string5);
            return object;
        }
        return null;
    }

    public void setupCommand(String string, String string2) throws CCSAuthenticationException, CCSGeneralException {
        if (string != null) {
            this.m_Filters = new Filter[]{new Filter(string, "OBJECT_ID")};
        }
        if (string2 != null) {
            this.m_formatter = this.m_session.getFormatLoader().getFormatter(string2, this.m_provider);
        }
    }
}

