/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.service.command.ACommand;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class TreePromptNodeCommand
extends ACommand {
    String m_sourceID = null;

    @Override
    protected void initialize() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void performRestAction(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        try {
            Conversation conversation;
            this.m_sourceID = string;
            Document document = this.extractXMLFormData(bIBusEnvelope.getFormValue("xmlData"));
            PromptValue promptValue = null;
            if (document == null) {
                Element element = DocumentHelper.createElement((String)"xmlData");
                Utilities.processSimplifiedRESTParameters(bIBusEnvelope, element);
                if (element.elements().size() <= 0) throw new CCSGeneralException("REQUEST_ERROR", 400);
                promptValue = PromptValue.parsePromptValue((Element)element.elements().get(0), Constants.NamespaceVersion.V1);
            } else {
                promptValue = PromptValue.parsePromptValue(document.getRootElement(), Constants.NamespaceVersion.V1);
            }
            if ((conversation = this.m_session.recoverConversation(string)) == null) {
                throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{string}, 404);
            }
            this.getTreeNode(conversation, promptValue);
            CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider);
            this.m_session.getResponder().setData(cCSDataResult);
            return;
        }
        catch (CCSException cCSException) {
            this.m_session.handleRESTCCSException(cCSException, messageContext);
        }
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        try {
            String string = SoapParms.getStringParm(element, "conversationID", null, true);
            if (null == string) {
                string = SoapParms.getContainedStringParm(element, "session", "conversationID", null, false);
            }
            this.m_sourceID = string;
            Conversation conversation = this.m_session.recoverConversation(this.m_sourceID);
            if (conversation == null) {
                throw new CCSGeneralException("INVALID_CONVERSATION", new String[]{this.m_sourceID}, 404);
            }
            PromptValue promptValue = SoapParms.getPromptParms(element, "nodeValue", false)[0];
            this.getTreeNode(conversation, promptValue);
            CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider);
            this.m_session.getResponder().setData(cCSDataResult);
            Element element2 = DocumentHelper.createElement((QName)new QName("GetTreePromptNodeResponse", this.m_session.getResponseNamespace()));
            element2.addElement("ccsdatamarker");
            this.m_session.setSOAPResponse(element2);
        }
        catch (CCSException cCSException) {
            this.m_session.handleSOAPCCSException(messageContext, cCSException);
        }
    }

    public void getTreeNode(Conversation conversation, PromptValue promptValue) throws CCSGeneralException, CCSAuthenticationException {
        this.m_provider = this.m_session.getProviderFromConversation(conversation);
        conversation = this.m_provider.retrieveTreePromptNode(conversation, new PromptValue[]{promptValue});
        this.m_session.updateConversation(conversation, this.m_sourceID);
    }
}

