/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.service.command;

import com.cognos.ccs.content.Cognos8ContentProvider;
import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.service.CCSDataResult;
import com.cognos.ccs.service.Transform;
import com.cognos.ccs.service.command.ACommand;
import com.cognos.ccs.utility.Utilities;
import com.cognos.ccs.wsdl.GenericSpecTransformer;
import com.cognos.ccs.wsdl.SpecTransformer;
import com.cognos.ccs.wsdl.SpecValidator;
import com.cognos.ccs.wsdl.WSDLTransform;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class WSDLCommand
extends ACommand {
    protected static Transform Spec2WSDL;
    protected static Transform Spec2WSDL2;
    protected static Transform Prompts2WSDL;
    protected static Document LDXTypes;
    Constants.Compatibility compatibility = Constants.Compatibility.C10_1;

    @Override
    protected void initialize() {
    }

    @Override
    public void performRestAction(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, String string) {
        try {
            if (this.getSession().getRequestVersion() == Constants.RequestVersion.V3) {
                this.compatibility = Constants.Compatibility.C10_3;
            }
            String string2 = this.generateWSDL(string);
            this.m_session.setResponseAsString(string2);
        }
        catch (CCSException cCSException) {
            this.m_session.handleRESTCCSException(cCSException, messageContext);
        }
    }

    @Override
    public void performSoapAction(Element element, MessageContext messageContext) {
        throw new RuntimeException("NOT_IMPLEMENTED");
    }

    private String generateWSDL(String string) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        try {
            if (string == null) {
                return this.getStaticWSDL(this.m_session.getAbsoluteGatewayURL());
            }
            this.m_provider = ContentProvider.getProvider(string, this.m_session.getConnect(), this.m_session.getCookies(), this.m_session);
            SpecValidator specValidator = new SpecValidator();
            if (this.m_provider instanceof Cognos8ContentProvider) {
                ((Cognos8ContentProvider)this.m_provider).setWSDLValidator(specValidator);
            }
            this.m_provider.retrieveMetaContent(null, false, false, false);
            String string2 = "LDX";
            if (specValidator.isValid()) {
                string2 = "Simple";
            }
            String string3 = this.m_session.getAbsoluteGatewayURL() + "/rds/" + string2 + "/" + Utilities.IRIEncode(string, true);
            String string4 = CCSFormatter.encodeNameForTag(this.m_provider.getReportName());
            CCSDataResult cCSDataResult = new CCSDataResult(this.m_session.getTransport(), this.m_provider);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cCSDataResult.writeResultToStream(byteArrayOutputStream);
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read((Reader)new StringReader(byteArrayOutputStream.toString()));
            WSDLTransform wSDLTransform = new WSDLTransform(document, string3, string4);
            SpecTransformer specTransformer = string2.equals("LDX") ? new GenericSpecTransformer(wSDLTransform) : new SpecTransformer(wSDLTransform);
            specTransformer.transform(document.getRootElement());
            return wSDLTransform.getResult().asXML();
        }
        catch (Exception exception) {
            throw new CCSGeneralException("WSDL_ERROR", 500);
        }
    }

    private String getStaticWSDL(String string) throws UnsupportedEncodingException, IOException {
        String string2 = this.compatibility == Constants.Compatibility.C10_3 ? "/wsdl/rdsV3.wsdl" : "/wsdl/rds8.5.wsdl";
        String string3 = Utilities.readFile(string2);
        string3 = string3.replaceAll("\\@RDS_ENDPOINT\\@", string);
        return string3;
    }
}

