/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.utility;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;

public class LogUtilities {
    private static final HashSet<Class<?>> WRAPPER_TYPES = LogUtilities.getWrapperTypes();

    public static String objectAsXML(Object object) {
        try {
            String string = "";
            Class<?> clazz = object.getClass();
            String string2 = LogUtilities.removeInvalidChars(clazz.getName());
            string = string + "<" + string2 + ">\n";
            if (LogUtilities.canObjectBeSerialized(object)) {
                String string3 = object.toString();
                if (clazz.isArray()) {
                    string3 = LogUtilities.arrayAsString(object);
                }
                string = string + "<![CDATA[" + string3 + "]]>\n";
            } else {
                Field[] fieldArray;
                for (Field field : fieldArray = clazz.getDeclaredFields()) {
                    string = string + LogUtilities.memberAsXML(object, field);
                }
            }
            string = string + "</" + string2 + ">\n";
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return object.toString();
        }
    }

    protected static String memberAsXML(Object object, Field field) {
        String string = "";
        String string2 = LogUtilities.removeInvalidChars(field.getName());
        Class<?> clazz = field.getType();
        string = "<" + string2 + " type=\"" + clazz + "\">\n";
        field.setAccessible(true);
        try {
            Object object2 = field.get(object);
            if (object2 != null) {
                Method method = LogUtilities.getAsXmlMethod(object2);
                if (method != null) {
                    String string3 = LogUtilities.invokeAsXmlMethod(object2, method);
                    string = string + (string3.length() == 0 ? object2.toString() : string3);
                } else if (clazz.isArray()) {
                    int n = Array.getLength(object2);
                    for (int i = 0; i < n; ++i) {
                        Object object3 = Array.get(object2, i);
                        if (object3 != null) {
                            if (LogUtilities.canObjectBeSerialized(object3)) {
                                string = string + "<pos at=\"" + i + "\">\n<![CDATA[" + object3 + "]]>\n</pos>\n";
                                continue;
                            }
                            string = string + LogUtilities.objectAsXML(object3);
                            continue;
                        }
                        string = string + "<![CDATA[NULL]]>\n";
                    }
                } else {
                    string = LogUtilities.canObjectBeSerialized(object2) ? string + "<![CDATA[" + object2 + "]]>\n" : string + LogUtilities.objectAsXML(object2);
                }
            } else {
                string = string + "null";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        string = string + "</" + string2 + ">\n";
        return string;
    }

    protected static boolean isWrapperType(Class<?> clazz) {
        return WRAPPER_TYPES.contains(clazz);
    }

    private static HashSet<Class<?>> getWrapperTypes() {
        HashSet hashSet = new HashSet();
        hashSet.add(Boolean.class);
        hashSet.add(Character.class);
        hashSet.add(Byte.class);
        hashSet.add(Short.class);
        hashSet.add(Integer.class);
        hashSet.add(Long.class);
        hashSet.add(Float.class);
        hashSet.add(Double.class);
        hashSet.add(Void.class);
        return hashSet;
    }

    private static Method getAsXmlMethod(Object object) {
        for (Method method : object.getClass().getMethods()) {
            Class<?> clazz;
            Class<?>[] classArray;
            if (!"asXML".equals(method.getName()) || (classArray = method.getParameterTypes()).length != 0 || !(clazz = method.getReturnType()).equals(String.class)) continue;
            return method;
        }
        return null;
    }

    private static boolean canObjectBeSerialized(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.isEnum()) {
            return true;
        }
        if (LogUtilities.isWrapperType(clazz)) {
            return true;
        }
        if (clazz.equals(String.class)) {
            return true;
        }
        return LogUtilities.implementsSerializable(object);
    }

    private static boolean implementsSerializable(Object object) {
        for (Class<?> clazz : object.getClass().getInterfaces()) {
            if (!clazz.equals(Serializable.class)) continue;
            return true;
        }
        return false;
    }

    private static String invokeAsXmlMethod(Object object, Method method) {
        try {
            return (String)method.invoke(object, new Object[0]);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return "";
    }

    private static String removeInvalidChars(String string) {
        int n = string.indexOf("[");
        if (n >= 0) {
            string = "array___" + string.substring(n + 1);
        }
        if ((n = string.indexOf("$")) >= 0) {
            string = string.replace("$", "_innerCls_");
        }
        return string;
    }

    private static String arrayAsString(Object object) {
        String string = object instanceof int[] ? Arrays.toString((int[])object) : (object instanceof boolean[] ? Arrays.toString((boolean[])object) : (object instanceof byte[] ? Arrays.toString((byte[])object) : (object instanceof long[] ? Arrays.toString((long[])object) : (object instanceof float[] ? Arrays.toString((float[])object) : (object instanceof double[] ? Arrays.toString((double[])object) : (object instanceof char[] ? Arrays.toString((char[])object) : (object instanceof short[] ? Arrays.toString((short[])object) : Arrays.toString((Object[])object))))))));
        return string;
    }
}

