/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.utility;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Conversation;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.util.NameValuePair;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public final class Utilities {
    private static final String SCRIPT_TAG_END = "</script>";
    private static final String CDATA_END = "]]>";
    private static final String CDATA_START = "<![CDATA[";
    private static final String NULL_TOKEN = "<NULL>";
    private static final String MAX_TOKEN = "<MAX>";
    private static final String MIN_TOKEN = "<MIN>";
    private static final String NONE_TOKEN = "<NONE>";
    private static final String NUMERIC_FALSE = "0";
    private static final String FALSE = "false";
    private static final String NUMERIC_TRUE = "1";
    private static final String TRUE = "true";
    private static final Pattern storeIdPattern = Pattern.compile("^i[a-fA-F0-9]{32}$");
    private static final Pattern storeIdPathPattern = Pattern.compile("^storeID\\(\"([\\w\\W]*)\"\\)$");
    private static final Pattern urlPattern = Pattern.compile("https?://([-\\w\\.]+)+(:\\d+)*");
    private static final Pattern maliciousXPathPatern = Pattern.compile("([^\\w]|^)(document|evaluate)[\\s]*\\(");
    private static final Pattern cssFilePathPattern = Pattern.compile("^.*\\.css$");
    public static final String COPYRIGHT_NOTICE = "Licensed Materials - Property of IBM\n\nBI and PM: CCS\n\n(C) Copyright IBM Corp. 2005, 2009\n\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String SEARCHPATH_SUFFIX_CHILDREN = "/*";
    public static final String SEARCHPATH_PREFIX_STOREID = "storeID(";
    public static final String SEARCHPATH_SUFFIX_STOREID = ")";

    public static boolean isNullOrEmpty(String string) {
        if (string == null) {
            return true;
        }
        return string.length() <= 0;
    }

    public static boolean isNullOrBlank(String string) {
        boolean bl = Utilities.isNullOrEmpty(string);
        if (!bl) {
            bl = string.trim().length() == 0;
        }
        return bl;
    }

    public static boolean parseXMLBoolean(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equalsIgnoreCase(TRUE)) {
            return true;
        }
        if (string.equals(NUMERIC_TRUE)) {
            return true;
        }
        if (string.equalsIgnoreCase(FALSE)) {
            return false;
        }
        if (string.equals(NUMERIC_FALSE)) {
            return false;
        }
        throw new IllegalArgumentException();
    }

    public static boolean parseOptionalXMLBoolean(String string, boolean bl) {
        if (Utilities.isNullOrEmpty(string)) {
            return bl;
        }
        return Utilities.parseXMLBoolean(string);
    }

    public static boolean parseOptionalObjectBoolean(Object object, boolean bl) {
        if (object == null) {
            return bl;
        }
        if (object instanceof String) {
            return Utilities.parseOptionalXMLBoolean((String)object, bl);
        }
        return (Boolean)object;
    }

    public static String booleanToXMLBoolean(boolean bl) {
        if (bl) {
            return TRUE;
        }
        return FALSE;
    }

    public static String IRIEncode(String string, boolean bl) {
        return Utilities.IRIEncode(string, bl, true);
    }

    public static String IRIEncode(String string, boolean bl, boolean bl2) {
        return Utilities.IRIEncode(string, bl, bl2, false);
    }

    public static String IRIEncode(String string, boolean bl, boolean bl2, boolean bl3) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (bl && c == '/') {
                    stringBuffer.append(c);
                    continue;
                }
                if (c == ' ') {
                    stringBuffer.append("%20");
                    continue;
                }
                if (c == ';' || bl2 && c > '\u00ff' || bl3 && c == '_') {
                    Utilities.encodeChar(stringBuffer, c);
                    continue;
                }
                stringBuffer.append(URLEncoder.encode(new String(new char[]{c}), "utf-8"));
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String escapeXML(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (stringBuffer.toString().indexOf(38, n) != -1) {
            n = stringBuffer.toString().indexOf(38, n);
            stringBuffer.deleteCharAt(n);
            stringBuffer.insert(n, "&amp;");
            ++n;
        }
        n = 0;
        while (stringBuffer.toString().indexOf(60, n) != -1) {
            n = stringBuffer.toString().indexOf(60, n);
            stringBuffer.deleteCharAt(n);
            stringBuffer.insert(n, "&lt;");
            ++n;
        }
        n = 0;
        while (stringBuffer.toString().indexOf(62, n) != -1) {
            n = stringBuffer.toString().indexOf(62, n);
            stringBuffer.deleteCharAt(n);
            stringBuffer.insert(n, "&gt;");
            ++n;
        }
        n = 0;
        while (stringBuffer.toString().indexOf(39, n) != -1) {
            n = stringBuffer.toString().indexOf(39, n);
            stringBuffer.deleteCharAt(n);
            stringBuffer.insert(n, "&apos;");
            ++n;
        }
        n = 0;
        while (stringBuffer.toString().indexOf(34, n) != -1) {
            n = stringBuffer.toString().indexOf(34, n);
            stringBuffer.deleteCharAt(n);
            stringBuffer.insert(n, "&quot;");
            ++n;
        }
        n = 0;
        while (stringBuffer.toString().indexOf(123, n) != -1) {
            n = stringBuffer.toString().indexOf(123, n);
            stringBuffer.deleteCharAt(n);
            stringBuffer.insert(n, "&#123;");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String unescapeXML(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            int n2;
            if (string.charAt(n) == '&' && (n2 = string.indexOf(59, n)) > -1) {
                String string2 = string.substring(n + 1, n2);
                if (string2.equals("amp")) {
                    stringBuffer.append('&');
                } else if (string2.equals("lt")) {
                    stringBuffer.append('<');
                } else if (string2.equals("gt")) {
                    stringBuffer.append('>');
                } else if (string2.equals("apos")) {
                    stringBuffer.append('\'');
                } else if (string2.equals("quot")) {
                    stringBuffer.append('\"');
                } else {
                    stringBuffer.append(string.charAt(n));
                    ++n;
                    continue;
                }
                n = n2 + 1;
                continue;
            }
            stringBuffer.append(string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String string) throws UnsupportedEncodingException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(ConfigMgr.getInstance().getFileStream(string), "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuffer.append(string2);
                string2 = bufferedReader.readLine();
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuffer.toString();
    }

    public static void processSimplifiedRESTParameters(BIBusEnvelope bIBusEnvelope, Element element) throws CCSGeneralException {
        List list = bIBusEnvelope.getFormFieldValues();
        for (NameValuePair nameValuePair : list) {
            String string = nameValuePair.getName();
            if (!string.startsWith("p_")) continue;
            if (Utilities.isXPathStringSafe(string = string.substring(2))) {
                String string2 = nameValuePair.getValue();
                Element element2 = (Element)element.selectSingleNode("promptValues[name/text()='" + string + "']/values");
                if (element2 == null) {
                    Element element3 = element.addElement("promptValues");
                    Element element4 = element3.addElement("name");
                    element4.setText(string);
                    element2 = element3.addElement("values");
                }
                Utilities.parseValueString(element2, string2);
                continue;
            }
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
    }

    public static void addValueElement(Element element, QName qName, String string) {
        Element element2 = element.addElement(qName);
        element2.setText(string);
    }

    private static void parseValueString(Element element, String string) throws CCSGeneralException {
        String string2;
        if (Utilities.noValue(string)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        if (string.startsWith(CDATA_START)) {
            int n2 = string.indexOf(CDATA_END);
            n = string.indexOf(58, n2);
        } else {
            n = string.indexOf(58);
        }
        if (n != -1) {
            String string3 = string.substring(0, n);
            string2 = string.substring(n + 1, string.length());
            arrayList.add(Utilities.removeCDATA(string3));
            arrayList.add(Utilities.removeCDATA(string2));
        } else {
            arrayList.add(Utilities.removeCDATA(string));
        }
        if (arrayList.size() > 1) {
            Element element2;
            Element element3 = element.addElement("item");
            string2 = element3.addElement("RangePValue");
            Element element4 = string2.addElement("inclusive");
            element4.setText(NUMERIC_TRUE);
            if (Utilities.hasStart((String)arrayList.get(0))) {
                element2 = string2.addElement("start");
                Utilities.addSimplePValue((String)arrayList.get(0), element2);
            }
            if (Utilities.hasEnd((String)arrayList.get(1))) {
                element2 = string2.addElement("end");
                Utilities.addSimplePValue((String)arrayList.get(1), element2);
            }
        } else {
            Element element5 = element.addElement("item");
            string2 = element5.addElement("SimplePValue");
            Utilities.addSimplePValue((String)arrayList.get(0), (Element)string2);
        }
    }

    private static String removeCDATA(String string) {
        if (string.startsWith(CDATA_START)) {
            string = string.replace(CDATA_START, "");
            string = string.replace(CDATA_END, "");
            return Utilities.escapeXML(string);
        }
        return string;
    }

    private static boolean hasStart(String string) {
        return !MIN_TOKEN.equals(string);
    }

    private static boolean hasEnd(String string) {
        return !MAX_TOKEN.equals(string);
    }

    private static boolean noValue(String string) {
        return NONE_TOKEN.equals(string);
    }

    private static boolean isNullToken(String string) {
        return NULL_TOKEN.equals(string);
    }

    public static void addSimplePValue(String string, Element element) {
        Element element2 = element.addElement("inclusive");
        element2.setText(NUMERIC_TRUE);
        Element element3 = element.addElement("useValue");
        if (Utilities.isNullToken(string)) {
            element3.addAttribute(new QName("nil"), TRUE);
        } else {
            element3.setText(Utilities.unescapeXML(string));
        }
        Element element4 = element.addElement("displayValue");
        if (Utilities.isNullToken(string)) {
            element4.addAttribute(new QName("nil"), TRUE);
        } else {
            element4.setText(Utilities.unescapeXML(string));
        }
    }

    public static void addCookiesToMethod(HttpMethodBase httpMethodBase, Cookie[] cookieArray) {
        String string = Utilities.getCookiesString(cookieArray);
        httpMethodBase.addRequestHeader("Cookie", string);
    }

    public static String getCookiesString(Cookie[] cookieArray) {
        String string = "";
        for (int i = 0; i < cookieArray.length; ++i) {
            string = string + cookieArray[i].getName() + "=" + cookieArray[i].getValue() + "; ";
        }
        return string;
    }

    public static Document parseText(String string) throws DocumentException {
        try {
            SAXReader sAXReader = new SAXReader(false);
            sAXReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            sAXReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sAXReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            return sAXReader.read((Reader)new StringReader(string));
        }
        catch (Exception exception) {
            throw new DocumentException((Throwable)exception);
        }
    }

    public static SAXReader getSAXReader() {
        try {
            SAXReader sAXReader = new SAXReader(false);
            sAXReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            sAXReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sAXReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            return sAXReader;
        }
        catch (Exception exception) {
            return new SAXReader(false);
        }
    }

    public static void encodeChar(StringBuffer stringBuffer, char c) {
        stringBuffer.append("_x");
        String string = Integer.toHexString(c);
        for (int i = 4 - string.length(); i > 0; --i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
    }

    public static boolean isStoreIdValid(String string) {
        return storeIdPattern.matcher(string).find();
    }

    public static boolean isStoreIdPathValid(String string) {
        Matcher matcher = storeIdPathPattern.matcher(string);
        if (matcher.find()) {
            return Utilities.isStoreIdValid(matcher.group(1));
        }
        return true;
    }

    public static boolean isCSSFilePath(String string) {
        return cssFilePathPattern.matcher(string).find();
    }

    public static String getSearchUrl(Conversation conversation, String string) {
        return "/rds/" + Utilities.getReportTypeString(conversation) + "/searchPath" + Utilities.IRIEncode(string, true);
    }

    public static String getReportTypeString(Conversation conversation) {
        String string;
        Object object = conversation != null ? conversation.getProperty("pathInfo") : null;
        String string2 = string = object != null ? object.toString() : "";
        if (string.startsWith("/rds/reportData/")) {
            return "reportData";
        }
        if (string.startsWith("/rds/pagedReportData/")) {
            return "pagedReportData";
        }
        return "output";
    }

    public static Object resizeArray(Object object, int n) {
        int n2 = Array.getLength(object);
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        Class<?> clazz2 = clazz.getComponentType();
        Object object2 = Array.newInstance(clazz2, n);
        int n3 = Math.min(n2, n);
        if (n3 > 0) {
            System.arraycopy(object, 0, object2, 0, n3);
        }
        return object2;
    }

    public static HttpClient createClientConnection(URI uRI) throws CCSGeneralException {
        try {
            HttpClient httpClient = new HttpClient();
            if (uRI.isAbsolute()) {
                try {
                    URL uRL = uRI.toURL();
                    String string = uRL.getProtocol();
                    if (string.equalsIgnoreCase("https")) {
                        CAMFactory cAMFactory = new CAMFactory();
                        cAMFactory.initialize("<initializeDocument><serviceID>reportDataService</serviceID></initializeDocument>".getBytes());
                        httpClient = cAMFactory.createHttpClient(uRL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            } else {
                String string;
                HostConfiguration hostConfiguration = httpClient.getHostConfiguration();
                if (null == hostConfiguration) {
                    hostConfiguration = new HostConfiguration();
                }
                if (null == (string = hostConfiguration.getHost())) {
                    String string2 = ConfigMgr.getInstance().getCognosGateway();
                    URL uRL = new URL(string2);
                    if (null == string) {
                        string = uRL.getHost();
                        hostConfiguration.setHost(string);
                        httpClient.setHostConfiguration(hostConfiguration);
                    }
                }
            }
            return httpClient;
        }
        catch (Exception exception) {
            throw new CCSGeneralException("UNKNOWN", 500);
        }
    }

    public static String escapeRegExp(String string) {
        String string2 = string.replaceAll("\\\\", "\\\\\\\\");
        return string2.replaceAll("\\$", "\\\\\\$");
    }

    public static String removeHostnameFromURL(String string) {
        Matcher matcher = urlPattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String removeNamespaceFormSpec(String string) {
        if (string != null && string.length() > 0) {
            int n = string.indexOf("<report");
            int n2 = string.indexOf(">", n);
            if (n2 < 0) {
                n2 = 0;
            }
            return "<report>" + string.substring(n2 + 1);
        }
        return "";
    }

    public static String addReportNameToSpec(String string, String string2) {
        if (!string.contains("<reportName>")) {
            string = string.replaceFirst("<modelPath>", "<reportName>" + string2 + "</reportName><modelPath>");
        }
        return string;
    }

    public static boolean isXPathStringSafe(String string) {
        if (string == null || "".equals(string)) {
            return true;
        }
        Matcher matcher = maliciousXPathPatern.matcher(string);
        return matcher == null || !matcher.find();
    }

    public static Cookie[] httpRequestCookies(Conversation conversation) {
        Cookie[] cookieArray = null;
        if (null != conversation && null == (cookieArray = (Cookie[])conversation.getProperty("cookies"))) {
            try {
                Cookie cookie = new Cookie();
                cookie.setName("cam_passport");
                BiBusHeader biBusHeader = conversation.getHeader();
                CAM cAM = biBusHeader.getCAM();
                CAMPassport cAMPassport = cAM.getCAMPassport();
                String string = cAMPassport.getId();
                cookie.setValue(string);
                ConfigMgr configMgr = ConfigMgr.getInstance();
                cookie.setPath(configMgr.getCookiePath());
                cookie.setSecure(configMgr.getCookieSecure());
                HdrSession hdrSession = biBusHeader.getHdrSession();
                EnvironmentVar[] environmentVarArray = hdrSession.getEnvironmentVars();
                if (null != environmentVarArray) {
                    String string2 = null;
                    for (int i = 0; null == string2 && i < environmentVarArray.length; ++i) {
                        EnvironmentVar environmentVar = environmentVarArray[i];
                        String string3 = environmentVar.getName();
                        if (!"HTTP_HOST".equals(string3)) continue;
                        string2 = environmentVar.getValue();
                    }
                    if (null != string2) {
                        cookie.setDomain(string2);
                    }
                }
                cookieArray = new Cookie[]{cookie};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cookieArray;
    }

    public static String browserDefaultLocale(String string) {
        String string2 = null;
        if (!Utilities.isNullOrBlank(string)) {
            int n = -1;
            int n2 = string.indexOf(",");
            int n3 = string.indexOf(";");
            n = n2 > n ? (n3 == -1 ? n2 : (n2 < n3 ? n2 : n3)) : (n3 > n ? n3 : string.length());
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static boolean useRelativeUrl(Conversation conversation) {
        Object object;
        boolean bl = false;
        if (null != conversation && (object = conversation.getProperty("GENERATE_RELATIVE_URL")) != null) {
            bl = Boolean.parseBoolean(object.toString());
        }
        return bl;
    }

    public static boolean useGatewayURI(Conversation conversation) {
        Object object;
        boolean bl = false;
        if (null != conversation && (object = conversation.getProperty("useGatewayURI")) != null) {
            bl = Boolean.parseBoolean(object.toString());
        }
        return bl;
    }

    public static void updateObj(BaseClass baseClass, String string) {
        Utilities.updateObj(baseClass, string, string);
    }

    public static void updateObj(BaseClass baseClass, String string, String string2) {
        GuidProp guidProp = new GuidProp();
        Guid guid = new Guid();
        guid.set_value(string);
        guidProp.setValue(guid);
        baseClass.setStoreID(guidProp);
        TokenProp tokenProp = new TokenProp();
        StringProp stringProp = new StringProp();
        if (!Utilities.isNullOrBlank(string2)) {
            tokenProp.setValue(string2);
            stringProp.setValue(string2);
        } else {
            tokenProp.setValue(string);
            stringProp.setValue("storeID(\"" + string + "\")");
        }
        baseClass.setSearchPath(stringProp);
        baseClass.setDefaultName(tokenProp);
    }

    public static String searchPathStripStoreID(String string) {
        boolean bl = string.endsWith(SEARCHPATH_SUFFIX_CHILDREN);
        if (string.startsWith(SEARCHPATH_PREFIX_STOREID)) {
            if (!bl) {
                string = string.substring(SEARCHPATH_PREFIX_STOREID.length() + 1, string.length() - 2);
            } else {
                string = string.substring(SEARCHPATH_PREFIX_STOREID.length() + 1, string.length() - 4);
                string = string + SEARCHPATH_SUFFIX_CHILDREN;
            }
        }
        return string;
    }

    public static String htmlRemoveJavascriptTags(String string) {
        String string2 = null;
        if (null != string) {
            string2 = string;
            int n = string2.indexOf("<script");
            while (-1 != n) {
                int n2 = string2.indexOf(SCRIPT_TAG_END, n);
                if (n2 > n && n2 < string2.length()) {
                    string2 = string2.substring(0, n) + string2.substring(n2 + SCRIPT_TAG_END.length());
                }
                n = string2.indexOf("<script", n);
            }
        }
        return string2;
    }

    public static void copyStreamToOutput(OutputStream outputStream, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4096];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        boolean bl = false;
        int n = 0;
        while (!bl) {
            n = bufferedInputStream.read(byArray, 0, 4096);
            if (n == -1) {
                bl = true;
                break;
            }
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.flush();
    }

    public static HashSet<String> getCapabilityValues(BIBusEnvelope bIBusEnvelope) {
        HashSet<String> hashSet = new HashSet<String>();
        Element element = bIBusEnvelope.getUserCapabilitiesCache().element("userCapabilities");
        if (element != null) {
            int n = element.elements("item").size();
            Iterator iterator = element.elements("item").iterator();
            if (n == 0) {
                n = bIBusEnvelope.getUserCapabilitiesCache().elements("userCapabilities").size();
                iterator = bIBusEnvelope.getUserCapabilitiesCache().elementIterator("userCapabilities");
            }
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                hashSet.add(element2.getText());
            }
        }
        return hashSet;
    }

    public static UserCapabilityEnum getEnumForValue(String string) throws CCSGeneralException {
        try {
            Class<UserCapabilityEnum> clazz = UserCapabilityEnum.class;
            Field field = clazz.getField(string);
            return (UserCapabilityEnum)field.get(UserCapabilityEnum.canReceiveDetailedErrors);
        }
        catch (Exception exception) {
            throw new CCSGeneralException("REQUEST_ERROR", 500);
        }
    }

    public static boolean isCAMSystemRecoverableFault(CCSException cCSException) {
        return cCSException instanceof CCSAuthenticationException && ((CCSAuthenticationException)cCSException).isCAMSystemRecoverableFault();
    }

    public static BIBusEnvelope getCAMSystemRecoverableFaultEnvelope(CCSException cCSException) {
        BIBusEnvelope bIBusEnvelope;
        if (Utilities.isCAMSystemRecoverableFault(cCSException) && (bIBusEnvelope = ((CCSAuthenticationException)cCSException).getBIBusEnvelope()) != null) {
            return bIBusEnvelope;
        }
        return null;
    }

    public static class Quadruplet<C1, C2, C3, C4> {
        public C1 child1;
        public C2 child2;
        public C3 child3;
        public C4 child4;

        public Quadruplet(C1 C1, C2 C2, C3 C3, C4 C4) {
            this.child1 = C1;
            this.child2 = C2;
            this.child3 = C3;
            this.child4 = C4;
        }
    }
}

