/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.wsdl;

import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.raas.NameGenerator;
import com.cognos.ccs.wsdl.SpecTransformer;
import com.cognos.ccs.wsdl.WSDLTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class CrossTabTransformer
extends SpecTransformer {
    public CrossTabTransformer(WSDLTransform wSDLTransform) {
        super(wSDLTransform);
    }

    private void importLDXTypes() {
        this.m_wsdl.addLDXType("style");
        this.m_wsdl.addLDXType("TextFrame");
        this.m_wsdl.addLDXType("DimensionRowOrColumn");
        this.m_wsdl.addLDXType("Cell");
        this.m_wsdl.addLDXType("Row");
        this.m_wsdl.addLDXType("IntegerValue");
    }

    @Override
    public Element transform(Element element) {
        this.importLDXTypes();
        String string = CrossTabTransformer.getId(element);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element2 = DocumentHelper.createElement((QName)new QName("element", WSDLTransform.XS_NAMESPACE));
        element2.addAttribute("ref", "style");
        element2.addAttribute("minOccurs", "0");
        element2.addAttribute("maxOccurs", "unbounded");
        arrayList.add(element2);
        arrayList.add(this.processCorner(element));
        arrayList.addAll(this.processRowsAndColumns(element, string));
        arrayList.add(this.createTableElement(string));
        Element element3 = this.createComplexType(string + "_CrossTabType", arrayList);
        this.m_wsdl.addType(element3);
        Element element4 = this.createSequenceElement(string, "" + string + "_CrossTabType");
        this.addPortOperation(string, "raas:" + string + "_CrossTabType");
        return element4;
    }

    private Element processCorner(Element element) {
        Element element2 = this.createSequenceElement("corner", "TextFrame");
        element2.addAttribute("minOccurs", "0");
        return element2;
    }

    private List processRowsAndColumns(Element element, String string) {
        ArrayList arrayList = new ArrayList();
        List list = CrossTabTransformer.selectNodesWithXPath("*/rds:crosstabNode", element);
        for (Element element2 : list) {
            arrayList.addAll(this.processNode(element2, string));
        }
        return arrayList;
    }

    private List processNode(Element element, String string) {
        Object object2;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        ArrayList arrayList2 = new ArrayList();
        List list = CrossTabTransformer.selectNodesWithXPath("rds:nestedNodes/rds:crosstabNode", element);
        for (Object object2 : list) {
            arrayList2.addAll(this.processNode((Element)object2, string));
        }
        object2 = CrossTabTransformer.selectNodesWithXPath("rds:members/rds:member", element);
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.processMember((Element)iterator.next(), arrayList2, string));
        }
        List list2 = CrossTabTransformer.selectNodesWithXPath("rds:members/rds:spacer", element);
        NameGenerator nameGenerator = new NameGenerator();
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.processSpacer((Element)iterator.next(), arrayList2, string, nameGenerator));
        }
        return arrayList;
    }

    private Element processMember(Element element, List list, String string) {
        Element element2 = (Element)CrossTabTransformer.selectNodesWithXPath("rds:title", element).get(0);
        String string2 = CCSFormatter.encodeNameForTag(element2.getText());
        Element element3 = this.createDimensionElement(list, string2, string + "_" + string2 + "_DimensionType");
        element3.addAttribute("minOccurs", "0");
        element3.addAttribute("maxOccurs", "unbounded");
        return element3;
    }

    private Element processSpacer(Element element, List list, String string, NameGenerator nameGenerator) {
        Element element2 = (Element)CrossTabTransformer.selectNodesWithXPath("rds:contents/rds:item/*[3]", element).get(0);
        String string2 = element2.getName().substring(1);
        String string3 = nameGenerator.getNextName(string2);
        Element element3 = this.createDimensionElement(list, string3, string + "_" + string3 + "_DimensionType");
        element3.addAttribute("minOccurs", "0");
        element3.addAttribute("maxOccurs", "unbounded");
        return element3;
    }

    private Element createDimensionElement(List list, String string, String string2) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(this.createSequenceElement("name", "Cell"));
        arrayList.add(this.createSequenceElement("start", "IntegerValue"));
        arrayList.add(this.createSequenceElement("size", "IntegerValue"));
        arrayList.addAll(list);
        Element element = this.createComplexType(string2, arrayList);
        this.m_wsdl.addType(element);
        return this.createSequenceElement(string, string2);
    }

    public Element createTableElement(String string) {
        Element element = DocumentHelper.createElement((QName)new QName("element", WSDLTransform.XS_NAMESPACE));
        element.addAttribute("name", "table");
        element.addAttribute("minOccurs", "0");
        Element element2 = element.addElement(new QName("complexType", WSDLTransform.XS_NAMESPACE));
        Element element3 = element2.addElement(new QName("sequence", WSDLTransform.XS_NAMESPACE));
        Element element4 = element3.addElement(new QName("element", WSDLTransform.XS_NAMESPACE));
        element4.addAttribute("name", "row");
        element4.addAttribute("type", "Row");
        element4.addAttribute("minOccurs", "0");
        element4.addAttribute("maxOccurs", "unbounded");
        return element;
    }
}

