/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.wsdl;

import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.wsdl.ListColumn;
import com.cognos.ccs.wsdl.ListGroupTransformer;
import com.cognos.ccs.wsdl.SpecTransformer;
import com.cognos.ccs.wsdl.WSDLTransform;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ListTransformer
extends SpecTransformer {
    public static final int HEADER_TYPE = 0;
    public static final int FOOTER_TYPE = 1;
    List<ListColumn> columns;
    Hashtable<String, Integer> nameHash = new Hashtable();

    public ListTransformer(WSDLTransform wSDLTransform) {
        super(wSDLTransform);
    }

    @Override
    public Element transform(Element element) {
        String string = ListTransformer.getId(element);
        this.columns = this.getColumnsFromSpec(element, string);
        Element element2 = this.createRow(this.columns, string);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        this.m_wsdl.addLDXType("Cell");
        Element element3 = this.createSequenceElement("columnTitle", "Cell");
        element3.addAttribute("minOccurs", "0");
        element3.addAttribute("maxOccurs", "unbounded");
        this.m_wsdl.addLDXType("style");
        Element element4 = DocumentHelper.createElement((QName)new QName("element", WSDLTransform.XS_NAMESPACE));
        element4.addAttribute("ref", "style");
        element4.addAttribute("minOccurs", "0");
        element4.addAttribute("maxOccurs", "unbounded");
        Element element5 = this.transformListSection(element, string, "", 0);
        Element element6 = this.transformListSection(element, string, "", 1);
        if (element5 != null) {
            arrayList.add(element5);
        }
        arrayList.add(element4);
        arrayList.add(element3);
        boolean bl = this.addListGroups(arrayList, element, element2, string);
        if (!bl) {
            arrayList.add(element2);
        }
        if (element6 != null) {
            arrayList.add(element6);
        }
        Element element7 = this.createComplexType(string + "_top_ListGroup", arrayList);
        this.m_wsdl.addLDXType("style");
        this.m_wsdl.addType(element7);
        Element element8 = this.createSequenceElement(string, "" + string + "_top_ListGroup");
        this.addPortOperation(string, "raas:" + string + "_top_ListGroup");
        return element8;
    }

    private boolean addListGroups(List<Element> list, Element element, Element element2, String string) {
        List list2 = ListTransformer.selectNodesWithXPath("rds:listGroup", element);
        ListGroupTransformer listGroupTransformer = new ListGroupTransformer(this.m_wsdl, this);
        if (list2.size() > 0) {
            Element element3 = (Element)list2.remove(0);
            Element element4 = listGroupTransformer.transform(element3, element2, string, list2, 0);
            element4.addAttribute("minOccurs", "0");
            element4.addAttribute("maxOccurs", "unbounded");
            list.add(element4);
            return true;
        }
        return false;
    }

    private Element createRow(List<ListColumn> list, String string) {
        ListColumn listColumn2;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (ListColumn listColumn2 : list) {
            if (listColumn2.item == null) continue;
            listColumn2.item.addAttribute("minOccurs", "0");
            arrayList.add(listColumn2.item);
        }
        listColumn2 = this.createComplexType(string + "_row", arrayList);
        this.m_wsdl.addType((Element)listColumn2);
        Element element = this.createSequenceElement("row", "" + string + "_row");
        element.addAttribute("minOccurs", "0");
        element.addAttribute("maxOccurs", "unbounded");
        return element;
    }

    public List<ListColumn> getColumnsFromSpec(Element element, String string) {
        ArrayList<ListColumn> arrayList = new ArrayList<ListColumn>();
        List list = ListTransformer.selectNodesWithXPath("rds:columns/rds:column", element);
        for (Element element2 : list) {
            Element element3 = (Element)ListTransformer.selectNodesWithXPath("rds:title", element2).get(0);
            String string2 = element3.getText();
            string2 = CCSFormatter.encodeNameForTag(string2);
            List<Element> list2 = this.transformChildrenWithXPath("rds:contents/rds:item/*", element2, true);
            Element element4 = this.processContents(string, string2, list2);
            ListColumn listColumn = new ListColumn(string2, element4);
            arrayList.add(listColumn);
        }
        return arrayList;
    }

    private Element processContents(String string, String string2, List<Element> list) {
        Element element;
        if (list.size() == 1) {
            element = list.get(0);
            element.addAttribute("name", string2);
        } else {
            Element element22;
            if (list.size() == 0) {
                return null;
            }
            for (Element element22 : list) {
                String string3 = this.getNextName(element22.attributeValue("type"));
                element22.addAttribute("name", string3);
            }
            element22 = this.createComplexType(string + "_" + string2 + "_" + "Type", list);
            this.m_wsdl.addType(element22);
            element = this.createSequenceElement(string2, string + "_" + string2 + "_" + "Type");
            this.nameHash.clear();
        }
        return element;
    }

    public Element transformListSection(Element element, String string, String string2, int n) {
        Element element2;
        List<Element> list;
        List list2;
        String string3 = "";
        if (n == 0) {
            string3 = "header";
            list2 = ListTransformer.selectNodesWithXPath("rds:listHeader", element);
        } else {
            string3 = "footer";
            list2 = ListTransformer.selectNodesWithXPath("rds:listFooter", element);
        }
        if (list2.size() == 1 && (list = this.transformSectionRows(element2 = (Element)list2.get(0), string, string2, string3)).size() > 0) {
            Element element3 = this.createComplexType(string + "_" + string2 + "_" + string3, list);
            this.m_wsdl.addType(element3);
            Element element4 = this.createSequenceElement(string3, string + "_" + string2 + "_" + string3);
            element4.addAttribute("minOccurs", "0");
            this.m_wsdl.addLDXType("TextFrame");
            return element4;
        }
        return null;
    }

    public List<Element> transformSectionRows(Element element, String string, String string2, String string3) {
        List list = ListTransformer.selectNodesWithXPath("rds:listRow", element);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = 1;
        for (Element element2 : list) {
            List<Element> list2 = this.transformRowCells(element2, string, string2);
            String string4 = string + "_" + string2 + "_" + string3 + "Row" + n + "Type";
            Element element3 = this.createComplexType(string4, list2);
            this.m_wsdl.addType(element3);
            Element element4 = this.createSequenceElement("row" + n, "" + string4);
            ++n;
            element4.addAttribute("minOccurs", "0");
            arrayList.add(element4);
        }
        return arrayList;
    }

    public List<Element> transformRowCells(Element element, String string, String string2) {
        List list = ListTransformer.selectNodesWithXPath("rds:rowCell", element);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = 0;
        int n2 = 0;
        int n3 = this.findColOffset(string2);
        for (Element element2 : list) {
            Element element3;
            Object object;
            String string3 = "";
            if (n < this.columns.size()) {
                string3 = this.columns.get((int)(n + n3)).name;
                object = element2.attributeValue("colSpan");
                int n4 = Integer.parseInt((String)object);
                n += n4;
            } else {
                string3 = "Column" + ++n2;
            }
            if ((element3 = this.processContents(string, string3, (List<Element>)(object = this.transformChildrenWithXPath("rds:item/*", element2, true)))) == null) continue;
            arrayList.add(element3);
        }
        return arrayList;
    }

    protected int findColOffset(String string) {
        if (string != null && string.length() > 0) {
            String string2 = CCSFormatter.encodeNameForTag(string);
            for (int i = 0; i < this.columns.size(); ++i) {
                ListColumn listColumn = this.columns.get(i);
                if (!listColumn.name.equals(string2)) continue;
                return i;
            }
        }
        return 0;
    }

    protected String getNextName(String string) {
        Integer n = this.nameHash.get(string);
        int n2 = 1;
        if (n != null) {
            n2 = n;
        }
        this.nameHash.put(string, new Integer(n2 + 1));
        return string + Integer.toString(n2);
    }

    public ListColumn getColumn(int n) {
        return this.columns.get(n);
    }
}

