/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.wsdl;

import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.wsdl.PageSectionTransformer;
import com.cognos.ccs.wsdl.WSDLTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.XPath;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class SpecTransformer {
    WSDLTransform m_wsdl;
    public static final Namespace RDSCM_NAMESPACE = new Namespace("rdsCM", "http://developer.cognos.com/schemas/rds/contentmodel/1");

    public SpecTransformer(WSDLTransform wSDLTransform) {
        this.m_wsdl = wSDLTransform;
    }

    public Element transform(Element element) {
        this.addReportResponseType();
        List<Element> list = this.transformChildrenWithXPath("/rds:document/*", element, false);
        Element element2 = this.createSequenceElement("styleGroup", "StyleGroup");
        element2.addAttribute("minOccurs", "0");
        element2.addAttribute("maxOccurs", "unbounded");
        list.add(element2);
        this.m_wsdl.addLDXType("StyleGroup");
        this.m_wsdl.addLDXType("BiDirectionEnum");
        Element element3 = this.createComplexType("ReportType", list);
        this.m_wsdl.addType(element3);
        Element element4 = this.createSequenceElement("report", "ReportType");
        this.createPromptAnswerType(element);
        return element4;
    }

    protected void createPromptAnswerType(Element element) {
        Element element2;
        List list = SpecTransformer.selectNodesWithXPath("/rds:document/rds:parameters/*", element);
        Iterator iterator = list.iterator();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            arrayList.add(this.generateParameterList(element2));
        }
        element2 = this.createSequenceElement("advanced", "PromptValue");
        element2.addAttribute("minOccurs", "0");
        element2.addAttribute("maxOccurs", "unbounded");
        Element element3 = this.createSequenceElement("extension", "xs:anyType");
        element3.addAttribute("minOccurs", "0");
        arrayList.add(element2);
        arrayList.add(element3);
        Element element4 = this.createComplexType("PromptAnswersType", arrayList);
        this.m_wsdl.addType(element4);
    }

    public static List selectNodesWithXPath(String string, Element element) {
        SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
        simpleNamespaceContext.addNamespace("rds", "http://developer.cognos.com/schemas/rds/types/2");
        XPath xPath = element.createXPath(string);
        xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
        List list = xPath.selectNodes((Object)element);
        return list;
    }

    protected List<Element> transformChildrenWithXPath(String string, Element element, boolean bl) {
        List list = SpecTransformer.selectNodesWithXPath(string, element);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Object e : list) {
            Element element2;
            if (!(e instanceof Element)) continue;
            Element element3 = (Element)e;
            String string2 = element3.getName();
            SpecTransformer specTransformer = this.m_wsdl.getTransformationTable().getTransformer(string2);
            if (specTransformer == null) continue;
            String string3 = SpecTransformer.getId(element3);
            if (!bl && string3 == null && !(specTransformer instanceof PageSectionTransformer) || (element2 = specTransformer.transform(element3)) == null) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    protected Element createSequenceElement(String string, String string2) {
        Element element = DocumentHelper.createElement((QName)new QName("element", WSDLTransform.XS_NAMESPACE));
        element.addAttribute("name", string);
        element.addAttribute("type", string2);
        return element;
    }

    protected Element createComplexType(String string, List list) {
        Element element = DocumentHelper.createElement((QName)new QName("complexType", WSDLTransform.XS_NAMESPACE));
        element.addAttribute("name", string);
        Element element2 = element.addElement(new QName("sequence", WSDLTransform.XS_NAMESPACE));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            element2.add((Element)iterator.next());
        }
        return element;
    }

    protected void addPortOperation(String string, String string2) {
        if (string == null) {
            return;
        }
        this.m_wsdl.addPort("get_" + string, "Get_" + string);
        this.m_wsdl.addBindingOperation("get_" + string, "get_" + string);
        this.m_wsdl.addMessages("Get_" + string);
        this.m_wsdl.addPort("getFormatted_" + string, "GetFormatted_" + string);
        this.m_wsdl.addBindingOperation("getFormatted_" + string, "GetFormatted_" + string);
        this.m_wsdl.addMessages("GetFormatted_" + string);
        this.m_wsdl.addPort("drill_" + string, "Drill_" + string);
        this.m_wsdl.addBindingOperation("drill_" + string, "Drill_" + string);
        this.m_wsdl.addMessages("Drill_" + string);
        Element element = this.createSequenceElement("Get_" + string + "Request", "Get_" + string + "RequestType");
        Element element2 = this.createRequestType(string);
        this.m_wsdl.addType(element);
        this.m_wsdl.addType(element2);
        Element element3 = this.createSequenceElement("Get_" + string + "Response", "Get_" + string + "ResponseType");
        Element element4 = this.createResponseType(string);
        this.m_wsdl.addType(element3);
        this.m_wsdl.addType(element4);
        Element element5 = this.createResultsType(string, string2);
        this.m_wsdl.addType(element5);
        Element element6 = this.createSequenceElement("GetFormatted_" + string + "Request", "GetFormatted_" + string + "RequestType");
        Element element7 = this.createFormattedRequestType(string);
        this.m_wsdl.addType(element6);
        this.m_wsdl.addType(element7);
        Element element8 = this.createSequenceElement("GetFormatted_" + string + "Response", "GetFormattedReportResponseType");
        this.m_wsdl.addType(element8);
        Element element9 = this.createSequenceElement("Drill_" + string + "Request", "DrillRequestType");
        Element element10 = this.createSequenceElement("Drill_" + string + "Response", "Get_" + string + "ResponseType");
        this.m_wsdl.addType(element9);
        this.m_wsdl.addType(element10);
    }

    protected Element createRequestType(String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this.createSequenceElement("versionType", "VersionSelection");
        element.addAttribute("minOccurs", "0");
        Element element2 = this.createSequenceElement("session", "SessionType");
        element2.addAttribute("minOccurs", "0");
        Element element3 = this.createSequenceElement("promptAnswers", "PromptAnswersType");
        element3.addAttribute("minOccurs", "0");
        arrayList.add(element);
        arrayList.add(element2);
        arrayList.add(element3);
        Element element4 = this.createComplexType("Get_" + string + "RequestType", arrayList);
        return element4;
    }

    protected Element createResponseType(String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(this.createSequenceElement("session", "SessionType"));
        arrayList.add(this.createSequenceElement("results", "Get_" + string + "ResultsType"));
        Element element = this.createComplexType("Get_" + string + "ResponseType", arrayList);
        return element;
    }

    protected Element createResultsType(String string, String string2) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(this.createSequenceElement(string, string2));
        Element element = this.createSequenceElement("styleGroup", "StyleGroup");
        element.addAttribute("minOccurs", "0");
        element.addAttribute("maxOccurs", "unbounded");
        arrayList.add(element);
        Element element2 = this.createComplexType("Get_" + string + "ResultsType", arrayList);
        return element2;
    }

    protected Element createFormattedRequestType(String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this.createSequenceElement("versionType", "VersionSelection");
        element.addAttribute("minOccurs", "0");
        Element element2 = this.createSequenceElement("session", "SessionType");
        element2.addAttribute("minOccurs", "0");
        Element element3 = this.createSequenceElement("promptAnswers", "PromptAnswersType");
        element3.addAttribute("minOccurs", "0");
        arrayList.add(element);
        arrayList.add(element2);
        arrayList.add(this.createSequenceElement("format", "xs:string"));
        arrayList.add(element3);
        Element element4 = this.createComplexType("GetFormatted_" + string + "RequestType", arrayList);
        return element4;
    }

    public static String getId(Element element) {
        String string = element.elementText(new QName("id", RDSCM_NAMESPACE));
        if (string == null || string.equals("")) {
            return null;
        }
        return CCSFormatter.encodeNameForTag(string);
    }

    public Element generateParameterList(Element element) {
        String string = CCSFormatter.encodeNameForTag(element.getText());
        Element element2 = this.createSequenceElement(string, "xs:string");
        element2.addAttribute("minOccurs", "0");
        return element2;
    }

    protected void addReportResponseType() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this.createSequenceElement("session", "SessionType");
        element.addAttribute("minOccurs", "0");
        Element element2 = this.createSequenceElement("report", "ReportType");
        element2.addAttribute("minOccurs", "0");
        Element element3 = this.createSequenceElement("extension", "xs:anyType");
        element3.addAttribute("minOccurs", "0");
        arrayList.add(element);
        arrayList.add(element2);
        arrayList.add(element3);
        Element element4 = this.createComplexType("GetReportResponseType", arrayList);
        this.m_wsdl.addType(element4);
    }
}

