/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.wsdl;

import com.cognos.ccs.exceptions.CCSGeneralException;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public class SpecValidator {
    private boolean m_isValid = false;

    public boolean isValid() {
        return this.m_isValid;
    }

    public void validateSpec(String string) throws CCSGeneralException {
        try {
            Document document = DocumentHelper.parseText((String)string);
            if (SpecValidator.validateSpec(document.getRootElement())) {
                this.m_isValid = true;
            }
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("METADATA_ERROR", 500);
        }
    }

    public static boolean validateSpec(Element element) {
        if (!element.selectNodes("/report/layouts/layout//list[ancestor::list]").isEmpty()) {
            return false;
        }
        if (!element.selectNodes("/report/layouts/layout//crosstab[ancestor::list]").isEmpty()) {
            return false;
        }
        if (!element.selectNodes("/report/layouts/layout//repeater[ancestor::list]").isEmpty()) {
            return false;
        }
        if (!element.selectNodes("/report/layouts/layout//repeaterTable[ancestor::list]").isEmpty()) {
            return false;
        }
        if (!SpecValidator.validateCrosstabs(element.selectNodes("/report/layouts/layout//crosstab"))) {
            return false;
        }
        return SpecValidator.validatePageSets(element.selectNodes("/report/layouts/layout/reportPages/pageSet"));
    }

    public static boolean validateCrosstabs(List<Element> list) {
        for (int i = 0; i < list.size(); ++i) {
            Element element = list.get(i);
            if (!SpecValidator.validateCrosstabDimensions((Element)element.selectSingleNode("crosstabColumns"))) {
                return false;
            }
            if (SpecValidator.validateCrosstabDimensions((Element)element.selectSingleNode("crosstabRows"))) continue;
            return false;
        }
        return true;
    }

    public static boolean validateCrosstabDimensions(Element element) {
        if (null == element) {
            return true;
        }
        List list = element.selectNodes(".//crosstabNodeMember");
        HashSet<String> hashSet = new HashSet<String>();
        for (Element element2 : list) {
            String string = element2.attributeValue("refDataItem");
            Node node = element2.selectSingleNode("contents/textItem/dataSource/staticValue");
            if (node != null) {
                string = node.getText();
            }
            if (hashSet.contains(string)) {
                return false;
            }
            hashSet.add(string);
        }
        return true;
    }

    public static boolean validatePageSets(List<Element> list) {
        if (list != null && list.size() > 0) {
            for (Element element : list) {
                XPath xPath = element.createXPath("count(.//pageGroup)");
                Number number = xPath.numberValueOf((Object)element);
                if (number.shortValue() <= 1) continue;
                return false;
            }
        }
        return true;
    }
}

