/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.wsdl;

import com.cognos.ccs.wsdl.CrossTabTransformer;
import com.cognos.ccs.wsdl.ListTransformer;
import com.cognos.ccs.wsdl.PageGroupTransformer;
import com.cognos.ccs.wsdl.PageSectionTransformer;
import com.cognos.ccs.wsdl.PageTransformer;
import com.cognos.ccs.wsdl.RepeaterTableTransformer;
import com.cognos.ccs.wsdl.SimpleTypeTransformer;
import com.cognos.ccs.wsdl.SpecTransformer;
import com.cognos.ccs.wsdl.WSDLTransform;
import java.util.Hashtable;

public class TransformationTable {
    private Hashtable m_table;
    private WSDLTransform m_wsdl;

    public TransformationTable(WSDLTransform wSDLTransform) {
        this.m_wsdl = wSDLTransform;
        this.setupTable();
    }

    private void setupTable() {
        this.m_table = new Hashtable();
        this.m_table.put("page", new PageTransformer(this.m_wsdl));
        this.m_table.put("pageGroup", new PageGroupTransformer(this.m_wsdl));
        this.m_table.put("body", new PageSectionTransformer(this.m_wsdl, "Body"));
        this.m_table.put("header", new PageSectionTransformer(this.m_wsdl, "Header"));
        this.m_table.put("footer", new PageSectionTransformer(this.m_wsdl, "Footer"));
        this.m_table.put("MRepeaterTable", new RepeaterTableTransformer(this.m_wsdl));
        this.m_table.put("MListFrame", new ListTransformer(this.m_wsdl));
        this.m_table.put("MCrossTab", new CrossTabTransformer(this.m_wsdl));
    }

    public SpecTransformer getTransformer(String string) {
        SpecTransformer specTransformer = (SpecTransformer)this.m_table.get(string);
        if (specTransformer != null) {
            return specTransformer;
        }
        if (string.charAt(0) == 'M') {
            specTransformer = this.getSimpleTransformer(string);
            return specTransformer;
        }
        return null;
    }

    private SpecTransformer getSimpleTransformer(String string) {
        String string2 = string.substring(1);
        if (this.m_wsdl.addLDXType(string2)) {
            SimpleTypeTransformer simpleTypeTransformer = new SimpleTypeTransformer(this.m_wsdl, string2);
            this.m_table.put(string, simpleTypeTransformer);
            return simpleTypeTransformer;
        }
        return null;
    }
}

