/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.wsdl;

import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.wsdl.TransformationTable;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class WSDLTransform {
    Document m_result;
    TransformationTable m_transformationTable;
    Element m_ldxRoot;
    HashSet m_addedTypes;
    HashSet m_addedRefs;
    String raasNamespaceTarget;
    public static final Namespace WSDL_NAMESPACE = new Namespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
    public static final Namespace PLNK_NAMESPACE = new Namespace("plnk", "http://schemas.xmlsoap.org/ws/2003/05/partner-link/");
    public static final Namespace XS_NAMESPACE = new Namespace("xs", "http://www.w3.org/2001/XMLSchema");
    public static final Namespace SOAP_NAMESPACE = new Namespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");

    public WSDLTransform(Document document, String string) {
        this(document, string, ConfigMgr.getInstance().getFileStream("/xslt/raas/wsdltemplate.xml"), null);
    }

    public WSDLTransform(Document document, String string, String string2) {
        this(document, string, ConfigMgr.getInstance().getFileStream("/xslt/raas/wsdltemplate.xml"), string2);
    }

    public WSDLTransform(Document document, String string, InputStream inputStream, String string2) {
        this(document, string, inputStream, ConfigMgr.getInstance().getFileStream("/wsdl/layoutDataXML.xsd"), string2);
    }

    public WSDLTransform(Document document, String string, InputStream inputStream, InputStream inputStream2, String string2) {
        this.raasNamespaceTarget = string2 == null ? "http://developer.cognos.com/schemas/raas/1" : "http://developer.cognos.com/schemas/raas/" + string2;
        this.m_result = WSDLTransform.createResultRoot(string, inputStream, string2);
        this.addRaasNamespaces();
        this.m_transformationTable = new TransformationTable(this);
        this.importLDX(inputStream2);
        this.m_addedTypes = new HashSet();
        this.addLDXType("BooleanValue");
    }

    public static Document createResultRoot(String string, InputStream inputStream, String string2) {
        Document document = WSDLTransform.loadWSDLTemplate(inputStream);
        WSDLTransform.addService(document.getRootElement(), string, string2);
        return document;
    }

    private void addRaasNamespaces() {
        Object object2;
        Element element = this.m_result.getRootElement();
        Namespace namespace = element.getNamespaceForPrefix("raas");
        Namespace namespace2 = element.getNamespaceForPrefix("y");
        element.remove(namespace);
        element.remove(namespace2);
        element.add(new Namespace("raas", this.raasNamespaceTarget));
        element.add(new Namespace("y", this.raasNamespaceTarget));
        element.attribute("targetNamespace").setValue(this.raasNamespaceTarget);
        Element element2 = (Element)element.selectSingleNode("/wsdl:definitions/wsdl:types/xs:schema[2]");
        namespace = element2.getNamespaceForPrefix("");
        element2.remove(namespace);
        element2.add(new Namespace("", this.raasNamespaceTarget));
        List list = this.m_result.getRootElement().selectNodes("//*[@namespace]");
        for (Object object2 : list) {
            if (!object2.attributeValue("namespace").equals("http://developer.cognos.com/schemas/raas/1")) continue;
            object2.attribute("namespace").setValue(this.raasNamespaceTarget);
        }
        object2 = this.m_result.getRootElement().selectNodes("//*[@targetNamespace]");
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            if (!element3.attributeValue("targetNamespace").equals("http://developer.cognos.com/schemas/raas/1")) continue;
            element3.attribute("targetNamespace").setValue(this.raasNamespaceTarget);
        }
    }

    private static Document loadWSDLTemplate(InputStream inputStream) {
        try {
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read(inputStream);
            return document;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void addService(Element element, String string, String string2) {
        if (string2 == null) {
            string2 = "CognosReportService";
        }
        Element element2 = element.addElement(new QName("service", WSDL_NAMESPACE));
        element2.addAttribute("name", string2 + "_Service");
        Element element3 = element2.addElement(new QName("port", WSDL_NAMESPACE));
        element3.addAttribute("binding", "y:CognosReportServiceBinding");
        element3.addAttribute("name", string2 + "_Service");
        Element element4 = element3.addElement(new QName("address", SOAP_NAMESPACE));
        element4.addAttribute("location", string);
        WSDLTransform.updatePartnerLink(element, string2);
        WSDLTransform.updatePortType(element, string2);
        WSDLTransform.updateReportServiceBinding(element, string2);
    }

    private static void updatePartnerLink(Element element, String string) {
        Element element2 = element.element(new QName("partnerLinkType", PLNK_NAMESPACE));
        Element element3 = element2.element(new QName("role", PLNK_NAMESPACE));
        Element element4 = element3.element(new QName("portType", PLNK_NAMESPACE));
        element4.attribute("name").setValue("y:" + string);
    }

    private static void updatePortType(Element element, String string) {
        Element element2 = element.element(new QName("portType", WSDL_NAMESPACE));
        element2.attribute("name").setValue(string);
    }

    private static void updateReportServiceBinding(Element element, String string) {
        Element element2 = element.element(new QName("binding", WSDL_NAMESPACE));
        element2.attribute("type").setValue("y:" + string);
    }

    public Document getResult() {
        return this.m_result;
    }

    public TransformationTable getTransformationTable() {
        return this.m_transformationTable;
    }

    public void addType(Element element) {
        Element element2 = (Element)this.m_result.selectSingleNode("/wsdl:definitions/wsdl:types/xs:schema[2]");
        element2.add(element);
    }

    public void addPort(String string, String string2) {
        Element element = (Element)this.m_result.selectSingleNode("/wsdl:definitions/wsdl:portType");
        Element element2 = element.addElement(new QName("operation", WSDL_NAMESPACE));
        element2.addAttribute("name", string);
        Element element3 = element2.addElement(new QName("input", WSDL_NAMESPACE));
        element3.addAttribute("message", "y:" + string2 + "In");
        Element element4 = element2.addElement(new QName("output", WSDL_NAMESPACE));
        element4.addAttribute("message", "y:" + string2 + "Out");
        this.addPortFault(element2, "CCSGeneralFault");
        this.addPortFault(element2, "CCSPromptFault");
        this.addPortFault(element2, "CCSAuthenticationFault");
    }

    private void addPortFault(Element element, String string) {
        Element element2 = element.addElement(new QName("fault", WSDL_NAMESPACE));
        element2.addAttribute("name", string);
        element2.addAttribute("message", "y:" + string + "Out");
    }

    public void addBindingOperation(String string, String string2) {
        Element element = (Element)this.m_result.selectSingleNode("/wsdl:definitions/wsdl:binding");
        Element element2 = element.addElement(new QName("operation", WSDL_NAMESPACE));
        element2.addAttribute("name", string);
        Element element3 = element2.addElement(new QName("operation", SOAP_NAMESPACE));
        element3.addAttribute("soapAction", "http://developer.cognos.com/schemas/rds/2");
        Element element4 = element2.addElement(new QName("input", WSDL_NAMESPACE));
        Element element5 = element4.addElement(new QName("header", SOAP_NAMESPACE));
        element5.addAttribute("message", "y:BiBusHeader");
        element5.addAttribute("part", "bibus");
        element5.addAttribute("use", "literal");
        Element element6 = element4.addElement(new QName("body", SOAP_NAMESPACE));
        element6.addAttribute("use", "literal");
        Element element7 = element2.addElement(new QName("output", WSDL_NAMESPACE));
        Element element8 = element7.addElement(new QName("header", SOAP_NAMESPACE));
        element8.addAttribute("message", "y:BiBusHeader");
        element8.addAttribute("part", "bibus");
        element8.addAttribute("use", "literal");
        Element element9 = element7.addElement(new QName("body", SOAP_NAMESPACE));
        element9.addAttribute("use", "literal");
        this.addFault(element2, "CCSGeneralFault");
        this.addFault(element2, "CCSPromptFault");
        this.addFault(element2, "CCSAuthenticationFault");
    }

    private void addFault(Element element, String string) {
        Element element2 = element.addElement(new QName("fault", WSDL_NAMESPACE));
        element2.addAttribute("name", string);
        Element element3 = element2.addElement(new QName("fault", SOAP_NAMESPACE));
        element3.addAttribute("name", string);
    }

    public void addMessages(String string) {
        Element element = this.m_result.getRootElement().addElement(new QName("message", WSDL_NAMESPACE));
        element.addAttribute("name", string + "In");
        Element element2 = element.addElement(new QName("part", WSDL_NAMESPACE));
        element2.addAttribute("name", "request");
        element2.addAttribute("element", "raas:" + string + "Request");
        Element element3 = this.m_result.getRootElement().addElement(new QName("message", WSDL_NAMESPACE));
        element3.addAttribute("name", string + "Out");
        Element element4 = element3.addElement(new QName("part", WSDL_NAMESPACE));
        element4.addAttribute("name", "response");
        element4.addAttribute("element", "raas:" + string + "Response");
    }

    private void importLDX(InputStream inputStream) {
        try {
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read(inputStream);
            this.m_ldxRoot = document.getRootElement();
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }

    public boolean addLDXType(String string) {
        if (string.length() > 4 && string.substring(0, 5).equals("raas:")) {
            string = string.substring(5);
        }
        if (this.m_addedTypes.contains(string)) {
            return true;
        }
        String string2 = "/xs:schema/*[@name = '" + string + "']";
        Element element = (Element)this.m_ldxRoot.selectSingleNode(string2);
        if (element == null) {
            return false;
        }
        this.addType(element.createCopy());
        this.m_addedTypes.add(string);
        this.processChildren(element);
        return true;
    }

    private void processChildren(Element element) {
        String string;
        Object object2;
        String string2 = element.attributeValue("type");
        if (string2 != null) {
            this.addLDXType(string2);
        }
        List list = element.selectNodes(".//xs:element[@type]");
        for (Object object2 : list) {
            string = object2.attributeValue("type");
            if (string == null) continue;
            this.addLDXType(string);
        }
        object2 = element.selectNodes(".//xs:element[@ref]");
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            string = (Element)iterator.next();
            String string3 = string.attributeValue("ref");
            if (string3 == null) continue;
            this.addLDXType(string3);
        }
    }
}

