/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.ccs.internal.cache;

import com.cognos.ccl4j.util.CCLWeb64;
import com.cognos.ccs.cache.ConversationCache;
import com.cognos.ccs.cache.PromptAnswersCache;
import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AnyTypeProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BoundRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RunTimeState;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedEndRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedStartRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.ibm.cognos.tds.TDS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class CMSCache
implements ConversationCache,
PromptAnswersCache {
    private static final String CONVERSATION_MAP = "cmsConversations";
    private static final String PROMPTANSWERS_MAP = "cmsPromptAnswers";
    private static final String TRUE = "true";
    private String m_passport;
    private TDS m_tds;
    public static final String COMPONENTID_PS = "PS";
    private static final Namespace NS_XSI = Namespace.get((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final QName QN_XSI_TYPE = DocumentHelper.createQName((String)"type", (Namespace)NS_XSI);
    private static final QName QN_XSI_NIL = DocumentHelper.createQName((String)"nil", (Namespace)NS_XSI);
    private static final Namespace NS_SOAPENC = Namespace.get((String)"SOAP-ENC", (String)"http://schemas.xmlsoap.org/soap/encoding/");
    private static final QName QN_ARRAYTYPE = new QName("arrayType", NS_SOAPENC);
    public static final String OUTPUT = "output";
    private final Cognos8Connector m_connector;

    public CMSCache(String string, Cognos8Connector cognos8Connector, TDS tDS) {
        this.m_passport = string;
        this.m_connector = cognos8Connector;
        this.m_tds = tDS;
    }

    public TDS tds() {
        return this.m_tds;
    }

    public String passport() {
        return this.m_passport;
    }

    @Override
    public String addConversation(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        String string = this.serialize(conversation);
        String string2 = this.add(CONVERSATION_MAP, string);
        return string2;
    }

    @Override
    public Conversation getConversation(String string) throws CCSGeneralException, CCSAuthenticationException {
        Conversation conversation = null;
        String string2 = this.get(CONVERSATION_MAP, string);
        if (null != string2) {
            try {
                byte[] byArray = CCLWeb64.decode((String)string2);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                conversation = (Conversation)objectInputStream.readObject();
            }
            catch (Exception exception) {
                CCSGeneralException cCSGeneralException = new CCSGeneralException("CMSCache::getConversation", exception, 500);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "", null, null, cCSGeneralException.getSourceTrace());
                throw cCSGeneralException;
            }
        }
        return conversation;
    }

    @Override
    public void updateConversation(String string, Conversation conversation) {
        String string2 = this.serialize(conversation);
        this.update(CONVERSATION_MAP, string, string2);
    }

    @Override
    public void deleteConversation(String string) {
        this.delete(CONVERSATION_MAP, string);
    }

    @Override
    public String newPrompt() throws CCSGeneralException, CCSAuthenticationException {
        String string = this.add(PROMPTANSWERS_MAP, "");
        return string;
    }

    @Override
    public String addPromptAnswers(PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        String string = CMSCache.promptValuesToString(promptValueArray);
        int n = string.indexOf("<parameterValues");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(n);
        }
        String string3 = this.add(PROMPTANSWERS_MAP, string2);
        return string3;
    }

    @Override
    public PromptValue[] promptAnswers(String string) throws CCSGeneralException, CCSAuthenticationException {
        PromptValue[] promptValueArray = null;
        Document document = null;
        String string2 = this.get(PROMPTANSWERS_MAP, string);
        try {
            document = Utilities.parseText(string2);
        }
        catch (Exception exception) {
            CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("GETPROMPT_ERROR", ConfigMgr.getInstance().getServerLocale()), "", null, null, null);
        }
        if (document != null) {
            Element element = document.getRootElement();
            List list = element.elements("item");
            promptValueArray = new PromptValue[element.elements("item").size()];
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                ParameterValue parameterValue = new ParameterValue();
                parameterValue.setName(element2.elementText("name"));
                Element element3 = element2.element("value");
                List list2 = element3.elements("item");
                ParmValueItem[] parmValueItemArray = new ParmValueItem[list2.size()];
                for (int j = 0; j < list2.size(); ++j) {
                    Element element4;
                    Element element5;
                    SimpleParmValueItem simpleParmValueItem;
                    Element element6 = (Element)list2.get(j);
                    String string3 = element6.attributeValue("type");
                    if (string3.indexOf("simpleParmValueItem") > -1) {
                        simpleParmValueItem = new SimpleParmValueItem();
                        simpleParmValueItem.setInclusive(this.getInclusive(element6.element("inclusive")));
                        element5 = element6.element("use");
                        element4 = element6.element("display");
                        if (element4 != null && element4.element("credential") != null) {
                            simpleParmValueItem.setUse(element5.element("credential").asXML());
                            simpleParmValueItem.setDisplay(element4.element("credential").asXML());
                        } else {
                            simpleParmValueItem.setUse(this.getValue(element5));
                            simpleParmValueItem.setDisplay(this.getValue(element4));
                        }
                        parmValueItemArray[j] = simpleParmValueItem;
                        continue;
                    }
                    if (string3.indexOf("unboundedStartRangeParmValueItem") > -1) {
                        simpleParmValueItem = new UnboundedStartRangeParmValueItem();
                        simpleParmValueItem.setInclusive(this.getInclusive(element6.element("inclusive")));
                        element5 = element6.element("end");
                        if (element5 != null) {
                            element4 = new SimpleParmValueItem();
                            element4.setInclusive(this.getInclusive(element5.element("inclusive")));
                            element4.setDisplay(this.getValue(element5.element("display")));
                            element4.setUse(this.getValue(element5.element("use")));
                            simpleParmValueItem.setEnd((SimpleParmValueItem)element4);
                        }
                        parmValueItemArray[j] = simpleParmValueItem;
                        continue;
                    }
                    if (string3.indexOf("unboundedEndRangeParmValueItem") > -1) {
                        simpleParmValueItem = new UnboundedEndRangeParmValueItem();
                        simpleParmValueItem.setInclusive(this.getInclusive(element6.element("inclusive")));
                        element5 = element6.element("start");
                        if (element5 != null) {
                            element4 = new SimpleParmValueItem();
                            element4.setInclusive(this.getInclusive(element5.element("inclusive")));
                            element4.setDisplay(this.getValue(element5.element("display")));
                            element4.setUse(this.getValue(element5.element("use")));
                            simpleParmValueItem.setStart((SimpleParmValueItem)element4);
                        }
                        parmValueItemArray[j] = simpleParmValueItem;
                        continue;
                    }
                    if (string3.indexOf("boundRangeParmValueItem") <= -1) continue;
                    simpleParmValueItem = new BoundRangeParmValueItem();
                    simpleParmValueItem.setInclusive(this.getInclusive(element6.element("inclusive")));
                    element5 = element6.element("start");
                    if (element5 != null) {
                        element4 = new SimpleParmValueItem();
                        element4.setInclusive(this.getInclusive(element5.element("inclusive")));
                        element4.setDisplay(this.getValue(element5.element("display")));
                        element4.setUse(this.getValue(element5.element("use")));
                        simpleParmValueItem.setStart((SimpleParmValueItem)element4);
                    }
                    if ((element4 = element6.element("end")) != null) {
                        SimpleParmValueItem simpleParmValueItem2 = new SimpleParmValueItem();
                        simpleParmValueItem2.setInclusive(this.getInclusive(element4.element("inclusive")));
                        simpleParmValueItem2.setDisplay(this.getValue(element4.element("display")));
                        simpleParmValueItem2.setUse(this.getValue(element4.element("use")));
                        simpleParmValueItem.setEnd(simpleParmValueItem2);
                    }
                    parmValueItemArray[j] = simpleParmValueItem;
                }
                parameterValue.setValue(parmValueItemArray);
                promptValueArray[i] = new PromptValue(parameterValue);
            }
        }
        return promptValueArray;
    }

    private boolean getInclusive(Element element) {
        boolean bl = false;
        if (element != null) {
            String string = element.getText();
            bl = "1".equals(string) || TRUE.equals(string);
        }
        return bl;
    }

    private String getValue(Element element) {
        if (element != null && TRUE.equals(element.attributeValue("nil"))) {
            element = null;
        }
        return element != null ? element.getText() : null;
    }

    private String add(String string, String string2) throws CCSGeneralException, CCSAuthenticationException {
        String string3 = null;
        if (null != string2) {
            AddOptions addOptions = new AddOptions();
            addOptions.setUpdateAction(UpdateActionEnum.fail);
            RunTimeState runTimeState = new RunTimeState();
            runTimeState.setState(new AnyTypeProp());
            runTimeState.getState().setValue(string2);
            BaseClass[] baseClassArray = new BaseClass[]{runTimeState};
            BaseClass[] baseClassArray2 = this.m_connector.addToCM("~~", baseClassArray, addOptions);
            RunTimeState runTimeState2 = (RunTimeState)baseClassArray2[0];
            GuidProp guidProp = runTimeState2.getStoreID();
            Guid guid = guidProp.getValue();
            string3 = guid.get_value();
            this.m_tds.putMappedValue(string, this.m_passport, string3, string2);
        }
        return string3;
    }

    private String get(String string, String string2) throws CCSGeneralException, CCSAuthenticationException {
        BaseClass[] baseClassArray;
        CCSGeneralException cCSGeneralException;
        String string3 = null;
        try {
            string3 = this.m_tds.getMappedValue(string, this.m_passport, string2);
        }
        catch (Exception exception) {
            cCSGeneralException = new CCSGeneralException("CMSCache::get", exception, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "", null, null, cCSGeneralException.getSourceTrace());
        }
        if ((null == string3 || string3.trim().length() == 0) && null != (baseClassArray = this.m_connector.queryCM("storeID(\"" + string2 + "\")", new PropEnum[]{PropEnum.storeID, PropEnum.state})) && baseClassArray.length > 0) {
            cCSGeneralException = (RunTimeState)baseClassArray[0];
            AnyTypeProp anyTypeProp = cCSGeneralException.getState();
            string3 = anyTypeProp.getValue();
        }
        return string3;
    }

    private void update(String string, String string2, String string3) {
        PropEnum[] propEnumArray = new PropEnum[]{PropEnum.state, PropEnum.storeID, PropEnum.searchPath};
        try {
            BaseClass[] baseClassArray = this.m_connector.queryCM("storeID(\"" + string2 + "\")", propEnumArray);
            if (baseClassArray == null || baseClassArray.length == 0 || !(baseClassArray[0] instanceof RunTimeState)) {
                throw new CCSGeneralException("CMSCache::update", 404);
            }
            AnyTypeProp anyTypeProp = new AnyTypeProp();
            anyTypeProp.setValue(string3);
            ((RunTimeState)baseClassArray[0]).setState(anyTypeProp);
            this.m_connector.updateCM(baseClassArray, new UpdateOptions());
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("CMSCache::update", exception, 404);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "", null, null, cCSGeneralException.getSourceTrace());
        }
        this.m_tds.putMappedValue(string, this.m_passport, string2, string3);
    }

    private void delete(String string, String string2) {
        PropEnum[] propEnumArray = new PropEnum[]{PropEnum.state};
        try {
            BaseClass[] baseClassArray = this.m_connector.queryCM("storeID(\"" + string2 + "\")", propEnumArray);
            if (baseClassArray == null) {
                throw new CCSGeneralException("DELETE_STATEINFO", 404);
            }
            if (!(baseClassArray[0] instanceof RunTimeState)) {
                throw new CCSGeneralException("DELETE_STATEINFO", 404);
            }
            this.m_connector.deleteFromCM(baseClassArray, new DeleteOptions());
        }
        catch (Exception exception) {
            CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("DELETE_STATEINFO", ConfigMgr.getInstance().getServerLocale()), "", null, null, null);
        }
        this.m_tds.removeMappedValue(string, this.m_passport, string2);
    }

    private String serialize(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            String string = CCLWeb64.encode((byte[])byteArrayOutputStream.toByteArray());
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String promptValuesToString(PromptValue[] promptValueArray) {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("parameterValues");
        element.addAttribute(QN_XSI_TYPE, "SOAP-ENC:Array");
        element.addAttribute(QN_ARRAYTYPE, "bus:parameterValue[]");
        for (int i = 0; i < promptValueArray.length; ++i) {
            ParameterValue parameterValue = promptValueArray[i].toPValue();
            Element element2 = element.addElement("item");
            element2.addAttribute(QN_XSI_TYPE, "bus:parameterValue");
            Element element3 = element2.addElement("name").addCDATA(parameterValue.getName());
            element3.addAttribute(QN_XSI_TYPE, "xsd:string");
            Element element4 = element2.addElement("value");
            element4.addAttribute(QN_XSI_TYPE, "SOAP-ENC:Array");
            element4.addAttribute(QN_ARRAYTYPE, "bus:parmValueItem[]");
            for (int j = 0; j < parameterValue.getValue().length; ++j) {
                Element element5;
                Element element6;
                boolean bl;
                BoundRangeParmValueItem boundRangeParmValueItem;
                ParmValueItem parmValueItem = parameterValue.getValue()[j];
                Element element7 = element4.addElement("item");
                if (parmValueItem instanceof BoundRangeParmValueItem) {
                    boundRangeParmValueItem = (BoundRangeParmValueItem)parmValueItem;
                    bl = boundRangeParmValueItem.isInclusive();
                    element7.addAttribute(QN_XSI_TYPE, "bus:boundRangeParmValueItem");
                    element6 = element7.addElement("inclusive");
                    element6.addText(new Boolean(bl).toString());
                    element6.addAttribute(QN_XSI_TYPE, "xsd:boolean");
                    element5 = element7.addElement("start");
                    CMSCache.createSimpleParmValueItem(boundRangeParmValueItem.getStart(), element5);
                    Element element8 = element7.addElement("end");
                    CMSCache.createSimpleParmValueItem(boundRangeParmValueItem.getEnd(), element8);
                    continue;
                }
                if (parmValueItem instanceof UnboundedStartRangeParmValueItem) {
                    boundRangeParmValueItem = (UnboundedStartRangeParmValueItem)parmValueItem;
                    bl = boundRangeParmValueItem.isInclusive();
                    element7.addAttribute(QN_XSI_TYPE, "bus:unboundedStartRangeParmValueItem");
                    element6 = element7.addElement("inclusive");
                    element6.addText(new Boolean(bl).toString());
                    element6.addAttribute(QN_XSI_TYPE, "xsd:boolean");
                    element5 = element7.addElement("end");
                    CMSCache.createSimpleParmValueItem(boundRangeParmValueItem.getEnd(), element5);
                    continue;
                }
                if (parmValueItem instanceof UnboundedEndRangeParmValueItem) {
                    boundRangeParmValueItem = (UnboundedEndRangeParmValueItem)parmValueItem;
                    bl = boundRangeParmValueItem.isInclusive();
                    element7.addAttribute(QN_XSI_TYPE, "bus:unboundedEndRangeParmValueItem");
                    element6 = element7.addElement("inclusive");
                    element6.addText(new Boolean(bl).toString());
                    element6.addAttribute(QN_XSI_TYPE, "xsd:boolean");
                    element5 = element7.addElement("start");
                    CMSCache.createSimpleParmValueItem(boundRangeParmValueItem.getStart(), element5);
                    continue;
                }
                if (!(parmValueItem instanceof SimpleParmValueItem)) continue;
                CMSCache.createSimpleParmValueItem((SimpleParmValueItem)parmValueItem, element7);
            }
        }
        return document.asXML();
    }

    private static void createSimpleParmValueItem(SimpleParmValueItem simpleParmValueItem, Element element) {
        element.addAttribute(QN_XSI_TYPE, "bus:simpleParmValueItem");
        Element element2 = element.addElement("inclusive");
        element2.addText(new Boolean(simpleParmValueItem.isInclusive()).toString());
        element2.addAttribute(QN_XSI_TYPE, "xsd:boolean");
        element2 = element.addElement("use");
        CMSCache.setValue(element2, simpleParmValueItem.getUse());
        element2 = element.addElement("display");
        CMSCache.setValue(element2, simpleParmValueItem.getDisplay());
    }

    private static void setValue(Element element, String string) {
        if (string != null) {
            element.addCDATA(string);
            element.addAttribute(QN_XSI_TYPE, "xsd:string");
        } else {
            element.addAttribute(QN_XSI_NIL, TRUE);
        }
    }
}

