/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.ccs.internal.thumbnailservice;

import com.cognos.p2pd.httptools.MimeHeaderUtil;
import com.cognos.pogo.impl.PogoResponder;
import com.cognos.pogo.impl.PogoSOAPAttachmentResponder;
import com.cognos.pogo.impl.PogoSOAPMessageResponder;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import javax.mail.internet.InternetHeaders;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ThumbnailResponder
extends PogoResponder {
    private static final InternetHeaders nullInternetHeaders = new InternetHeaders();
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PogoSOAPMessageResponder.class.getName());
    private Logger perf_cat = Hierarchy.getDefaultHierarchy().getLoggerFor("perf." + PogoSOAPAttachmentResponder.class.getName());
    private InputStream src = null;
    private boolean failed = false;

    public void setStream(InputStream inputStream) {
        this.src = inputStream;
    }

    public void setFailed(boolean bl) {
        this.failed = bl;
    }

    protected boolean respondImpl(HttpServletResponse httpServletResponse, MessageContext messageContext, String string) throws IOException {
        int n = messageContext.getIntProperty(string + ".status_code", 500);
        SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)messageContext.getProperty(string + ".envelope");
        if (n != 304 && sOAPEnvelope == null) {
            cat.error("No response was generated.");
            if (null == messageContext.getFault()) {
                messageContext.setFault(new Fault("NO_RESPONSE"));
            }
            return false;
        }
        InternetHeaders internetHeaders = (InternetHeaders)messageContext.getProperty(string + ".headers");
        if (internetHeaders == null) {
            internetHeaders = nullInternetHeaders;
        }
        Iterator iterator = (Iterator)messageContext.getProperty(string + ".attachments");
        int n2 = messageContext.getIntProperty("byteRanges", 0);
        if (n2 > 0 && iterator != null) {
            sOAPEnvelope = null;
        }
        if (iterator == null) {
            iterator = Collections.EMPTY_LIST.iterator();
        }
        String string2 = messageContext.getStrProperty(string + ".boundary");
        httpServletResponse.setStatus(n);
        internetHeaders.removeHeader("Content-Length");
        internetHeaders.removeHeader("Transfer-Encoding");
        internetHeaders.removeHeader("Server");
        internetHeaders.removeHeader("Set-Cookie");
        MimeHeaderUtil.copyHeaders((InternetHeaders)internetHeaders, (HttpServletResponse)httpServletResponse);
        this.addCacheDirectives(httpServletResponse);
        String[] stringArray = internetHeaders.getHeader("ETag");
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            if (cat.isDebugEnabled()) {
                cat.debug("Using Etag value: " + stringArray[0]);
            }
            httpServletResponse.setHeader("ETag", this.quoteETagValue(stringArray[0]));
        }
        if (n == 304) {
            httpServletResponse.setContentLength(0);
            httpServletResponse.getOutputStream().flush();
            return true;
        }
        byte[] byArray = new byte[4096];
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        int n3 = 0;
        do {
            if ((n3 = this.src.read(byArray)) == -1) continue;
            servletOutputStream.write(byArray);
        } while (n3 != -1);
        servletOutputStream.flush();
        return false;
    }

    private void addCacheDirectives(HttpServletResponse httpServletResponse) {
        if (this.failed) {
            httpServletResponse.setHeader("Cache-Control", "no-cache");
        } else {
            long l = 86400L;
            String string = "";
            string = string + "max-age=" + String.valueOf(l);
            httpServletResponse.setHeader("Cache-Control", string);
            Date date = new Date(Calendar.getInstance().getTimeInMillis() + l * 1000L);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
            String string2 = simpleDateFormat.format(date);
            httpServletResponse.setHeader("Expires", string2);
        }
    }
}

