/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.ccs.internal.thumbnailservice;

import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.content.DashboardContentProvider;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.CCSSession;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.CommandSession;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.transports.XMLTransport;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.ccs.internal.thumbnailservice.ThumbnailOptions;
import com.ibm.cognos.ccs.internal.thumbnailservice.ThumbnailResponder;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.dom4j.Namespace;

public class ThumbnailService {
    volatile boolean cancelRequest = false;
    volatile long waitThreshold = 5000L;
    volatile boolean done = false;
    String lastPath = null;
    String dispatcherurl = ConfigMgr.getInstance().getCognosDispatcher();
    ThumbnailResponder responder = null;
    InputStream thesource = null;
    private BIBusEnvelope m_request;
    private String m_resource;
    CCSSession session;

    public synchronized InputStream getSource() {
        return this.thesource;
    }

    public synchronized void setSource(InputStream inputStream) {
        this.thesource = inputStream;
    }

    public void processRequest(BIBusEnvelope bIBusEnvelope, MessageContext messageContext, CCSSession cCSSession) {
        this.m_request = bIBusEnvelope;
        this.session = cCSSession;
        try {
            boolean bl;
            XMLTransport xMLTransport = new XMLTransport();
            xMLTransport.setContentType("image/png");
            this.responder = new ThumbnailResponder();
            messageContext.setProperty("pogo.responder", (Object)this.responder);
            xMLTransport.prepareResponse(this.m_request, messageContext, new Namespace[0]);
            String string = (String)messageContext.getProperty("path_info");
            this.m_resource = string.substring(string.indexOf("thumbnail/") + 10);
            String string2 = this.m_request.getFormValue("selection");
            String string3 = this.m_request.getFormValue("height");
            String string4 = this.m_request.getFormValue("width");
            String string5 = this.m_request.getFormValue("deficon");
            String string6 = this.m_request.getFormValue("waitThreshold");
            Cookie[] cookieArray = CCSSession.populateCookies(this.m_request, messageContext);
            if (!Utilities.isNullOrEmpty(string6)) {
                this.waitThreshold = Integer.parseInt(string6);
            }
            ThumbnailOptions thumbnailOptions = new ThumbnailOptions(string2, string4, string3, "LOND", string5);
            if (0L == this.waitThreshold && (bl = this.isDashboard())) {
                thumbnailOptions.setVersion("STATIC");
            }
            this.generateThumbnail(this.m_resource, string, thumbnailOptions, cookieArray);
        }
        catch (Exception exception) {
            messageContext.setFault(new Fault("FAIL", exception));
            this.done = true;
        }
    }

    private boolean isDashboard() {
        ContentProvider contentProvider = null;
        Cognos8Connector cognos8Connector = new Cognos8Connector();
        try {
            cognos8Connector.connectToReportServer();
        }
        catch (CCSGeneralException cCSGeneralException) {
            cCSGeneralException.printStackTrace();
        }
        cognos8Connector.populateSDKBiBus(this.m_request);
        CommandSession commandSession = new CommandSession();
        commandSession.setConnect(cognos8Connector);
        try {
            String[] stringArray = this.m_resource.split("/");
            if (stringArray.length == 2) {
                String string = "storeID(\"" + stringArray[1] + "\")";
                contentProvider = commandSession.getProviderFromID(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return contentProvider instanceof DashboardContentProvider;
    }

    public void generateThumbnail(String string, String string2, ThumbnailOptions thumbnailOptions, Cookie[] cookieArray) throws Exception {
        Thread thread = new Thread(new ServerThread(string, string2, thumbnailOptions, cookieArray));
        Thread thread2 = new Thread(new TimerThread());
        thread2.setPriority(10);
        thread.start();
        thread2.start();
        while (thread.isAlive()) {
            Thread.sleep(100L);
        }
        this.done = true;
    }

    private void getThumbnailFromServer(String string, String string2, ThumbnailOptions thumbnailOptions, Cookie[] cookieArray) throws IOException, HttpException, URISyntaxException {
        HttpMethod httpMethod = this.thumbnailServiceRedirect(string, thumbnailOptions, cookieArray);
        InputStream inputStream = null;
        int n = httpMethod.getStatusCode();
        if (this.cancelRequest || n != 200) {
            if (n == 400) {
                inputStream = ConfigMgr.getInstance().getFileStream("/../icd/images/" + thumbnailOptions.getDefaultIcon());
                this.responder.setFailed(true);
            } else {
                String string3 = thumbnailOptions.getVersion();
                if ("STATIC".equals(string3)) {
                    inputStream = httpMethod.getResponseBodyAsStream();
                } else {
                    boolean bl = this.isDashboard();
                    if (bl) {
                        thumbnailOptions.setVersion("STATIC");
                        httpMethod = this.thumbnailServiceRedirect(string, thumbnailOptions, cookieArray);
                        inputStream = httpMethod.getResponseBodyAsStream();
                    } else {
                        inputStream = ConfigMgr.getInstance().getFileStream("/../icd/images/" + thumbnailOptions.getDefaultIcon());
                        this.responder.setFailed(true);
                    }
                }
            }
        } else {
            inputStream = httpMethod.getResponseBodyAsStream();
        }
        this.responder.setStream(inputStream);
    }

    private HttpMethod thumbnailServiceRedirect(String string, ThumbnailOptions thumbnailOptions, Cookie[] cookieArray) throws MalformedURLException, IOException, HttpException, URISyntaxException {
        ConfigMgr configMgr = ConfigMgr.getInstance();
        String string2 = configMgr.getCognosDispatcher();
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append("/rds");
        stringBuffer.append("/pagedReportData/");
        String string3 = Utilities.IRIEncode(string, true);
        stringBuffer.append(string3);
        String string4 = thumbnailOptions.toString();
        stringBuffer.append(string4);
        if (this.session.getRequestVersion() == Constants.RequestVersion.V3) {
            stringBuffer.append("&v=3");
        }
        String string5 = stringBuffer.toString();
        URL uRL = new URL(string5);
        HttpClient httpClient = this.getClient(uRL.toURI());
        HttpClientParams httpClientParams = httpClient.getParams();
        httpClientParams.setParameter("http.protocol.allow-circular-redirects", (Object)Boolean.TRUE);
        String string6 = uRL.toString();
        String string7 = uRL.getProtocol();
        if (string7.equalsIgnoreCase("https")) {
            string6 = uRL.getFile();
        }
        GetMethod getMethod = new GetMethod(string6);
        getMethod.setFollowRedirects(false);
        Utilities.addCookiesToMethod((HttpMethodBase)getMethod, cookieArray);
        httpClient.executeMethod((HttpMethod)getMethod);
        HttpMethod httpMethod = this.followRedirect((HttpMethod)getMethod, httpClient, thumbnailOptions, cookieArray);
        return httpMethod;
    }

    private HttpClient getClient(URI uRI) throws IOException {
        HttpClient httpClient;
        try {
            httpClient = Utilities.createClientConnection(uRI);
        }
        catch (CCSGeneralException cCSGeneralException) {
            throw new IOException();
        }
        return httpClient;
    }

    private HttpMethod followRedirect(HttpMethod httpMethod, HttpClient httpClient, ThumbnailOptions thumbnailOptions, Cookie[] cookieArray) throws IOException, HttpException {
        Header header = httpMethod.getResponseHeader("location");
        String string = thumbnailOptions.getVersion();
        boolean bl = "STATIC".equals(string);
        if (header != null && (!this.cancelRequest || bl)) {
            String string2 = header.getValue().replaceAll("/\\.\\.", "");
            this.lastPath = string2 = string2.replaceAll("\\.\\.", "");
            URL uRL = new URL(ConfigMgr.getInstance().getCognosDispatcher() + string2);
            GetMethod getMethod = uRL.getProtocol().equalsIgnoreCase("https") ? new GetMethod(uRL.getFile()) : new GetMethod(uRL.toString());
            Utilities.addCookiesToMethod((HttpMethodBase)getMethod, cookieArray);
            httpClient.executeMethod((HttpMethod)getMethod);
            httpMethod = this.followRedirect((HttpMethod)getMethod, httpClient, thumbnailOptions, cookieArray);
        }
        return httpMethod;
    }

    class TimerThread
    implements Runnable {
        int time = 0;

        TimerThread() {
        }

        @Override
        public void run() {
            try {
                while (!ThumbnailService.this.done && !ThumbnailService.this.cancelRequest) {
                    if ((long)this.time > ThumbnailService.this.waitThreshold) {
                        ThumbnailService.this.cancelRequest = true;
                        continue;
                    }
                    this.time += 100;
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    class ServerThread
    implements Runnable {
        String st_resource;
        ThumbnailOptions st_options;
        OutputStream st_target;
        Cookie[] st_cookies;
        private final String m_searchPath;

        public ServerThread(String string, String string2, ThumbnailOptions thumbnailOptions, Cookie[] cookieArray) {
            this.st_resource = string;
            this.m_searchPath = string2;
            this.st_options = thumbnailOptions;
            this.st_cookies = cookieArray;
        }

        @Override
        public void run() {
            try {
                ThumbnailService.this.getThumbnailFromServer(this.st_resource, this.m_searchPath, this.st_options, this.st_cookies);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

