/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import com.cognos.pogo.util.base64;
import com.ibm.cgsBus.CGSServerImpl;
import com.ibm.cgsBus.CGSVisOutputRequestHelper;
import com.ibm.cgsBus.FrameWork.CGSCanvas;
import com.ibm.cgsBus.Logging.CGSLogging;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class CGSServerRequest
extends Thread {
    private boolean m_done = false;
    private String m_primaryRequestId = null;
    private Socket m_socket = null;
    private CGSServerImpl m_server = null;
    private String m_command = "";
    private String m_exeCommand = "";
    private Header[] m_headers = null;
    private BIBusEnvelope m_request = null;
    private BIBusEnvelope m_response = null;
    private String m_attachmentEncoding = "base64";
    private static final long MAX_WAIT_DURATION = 10000L;
    private static final String COMPRESSED_TAG = "<cgsCompressed>";
    private static final String COMPRESSED_ENDTAG = "</cgsCompressed>";
    private static final String ATTACH_ID = "cgsImageData.Id@cognos.ibm.com";
    private static final String ATTACH_ENCODE_BASE64 = "base64";
    private static final String ATTACH_ENCODE_MIME = "MIME";
    private static final String ATTACH_ENCODE_MIME_COMPRESSED = "MIMECompressed";
    private static final QName DATA_SIZE = DocumentHelper.createQName((String)"dataSize");
    private static final QName DATA_TYPE = DocumentHelper.createQName((String)"dataType");
    private static final QName DATA = DocumentHelper.createQName((String)"data");
    private static final QName ITEM = DocumentHelper.createQName((String)"item");
    private static final QName RESULT = DocumentHelper.createQName((String)"result");
    private static final QName DETAILS = DocumentHelper.createQName((String)"details");
    private static final QName BUS_ASYNC_REPLY = DocumentHelper.createQName((String)"asynchReply", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName BUS_ASYNC_DETAIL = DocumentHelper.createQName((String)"asynchDetail", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName BUS_ASYNC_DETAIL_MIMEATTACH = DocumentHelper.createQName((String)"asynchDetailMIMEAttachment", (Namespace)BIBusEnvelope.NS_BUS);
    private static final String MIME_BOUNDARY_DASH = "--";

    public CGSServerRequest(CGSServerImpl cGSServerImpl, Socket socket) {
        this.m_server = cGSServerImpl;
        this.m_socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        BufferedInputStream bufferedInputStream = null;
        OutputStream outputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.m_socket.getInputStream(), 65536);
            outputStream = this.m_socket.getOutputStream();
            while (!this.m_done) {
                this.handleRequest(bufferedInputStream, outputStream);
                if (this.m_primaryRequestId == null) continue;
                CGSLogging.logInfo("Waiting for 10000 ms.");
                CGSServerRequest cGSServerRequest = this;
                synchronized (cGSServerRequest) {
                    this.wait(10000L);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            CGSLogging.logError("InterruptedException: " + interruptedException.getMessage());
            return;
        }
        catch (IOException iOException) {
            CGSLogging.logError("IOException (run): " + iOException.getMessage());
            return;
        }
        finally {
            try {
                if (this.m_primaryRequestId != null) {
                    CGSLogging.logInfo("Removing thread reference (finally): " + this.m_primaryRequestId);
                    this.m_server.removePrimaryRequestThreadReference(this.m_primaryRequestId);
                    this.m_primaryRequestId = null;
                }
                CGSLogging.logInfo("Finally.");
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                CGSLogging.logError("IOException: (finally)" + exception.getMessage());
            }
        }
    }

    private void handleRequest(InputStream inputStream, OutputStream outputStream) throws IOException {
        Object object;
        String string = null;
        string = HttpParser.readLine((InputStream)inputStream, (String)"UTF-8");
        CGSLogging.logInfo("HTTP Header line: " + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        this.m_command = stringTokenizer.nextToken().substring(1);
        CGSLogging.logEnter("CGSServerRequest::handleRequest threadId=" + this.getId());
        CGSLogging.logInfo("cmd = " + this.m_command);
        this.m_headers = HttpParser.parseHeaders((InputStream)inputStream, (String)"UTF-8");
        boolean bl = false;
        for (int i = 0; i < this.m_headers.length; ++i) {
            object = this.m_headers[i];
            if (object.getName().compareTo("Transfer-Encoding") == 0) {
                if (object.getValue().compareTo("chunked") != 0) continue;
                bl = true;
                continue;
            }
            if (object.getName().compareTo("Connection") != 0 || object.getValue().compareTo("close") != 0) continue;
            this.m_done = true;
            CGSLogging.logInfo("Found Connection=close, m_done = true");
        }
        ChunkedInputStream chunkedInputStream = null;
        try {
            chunkedInputStream = new ChunkedInputStream(inputStream);
            if (this.m_command.compareTo("config") == 0) {
                this.processConfigRequest(chunkedInputStream, outputStream);
            } else if (this.m_command.compareTo("cclconfiguration") == 0) {
                this.processConfigRequest(chunkedInputStream, outputStream);
            } else if (this.m_command.compareTo("cgs") == 0) {
                this.processExecuteRequest(chunkedInputStream, outputStream);
            } else if (this.m_command.compareTo("stop") == 0) {
                this.processStopRequest(chunkedInputStream, outputStream);
            } else {
                CGSLogging.logWarning("Unknown command: " + this.m_command);
                try {
                    object = "HTTP/1.1 500 Internal Server Error\r\n";
                    outputStream.write(((String)object).getBytes());
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            this.returnError(outputStream, iOException);
        }
        CGSLogging.logExit("CGSServerRequest::handleRequest threadId=" + this.getId());
    }

    private void processConfigRequest(ChunkedInputStream chunkedInputStream, OutputStream outputStream) {
        try {
            int n;
            byte[] byArray = new byte[1024];
            while ((n = chunkedInputStream.read(byArray)) > 0) {
            }
            chunkedInputStream.close();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("HTTP/1.1 200 OK\n");
            stringBuilder.append("Content-Type: text/plain; charset=UTF-8\n");
            stringBuilder.append("Content-Length: 8\n");
            stringBuilder.append("\n");
            stringBuilder.append("Received");
            outputStream.write(stringBuilder.toString().getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processStopRequest(ChunkedInputStream chunkedInputStream, OutputStream outputStream) {
        try {
            int n;
            CGSServerImpl.stopListening();
            byte[] byArray = new byte[1024];
            while ((n = chunkedInputStream.read(byArray)) > 0) {
            }
            chunkedInputStream.close();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("HTTP/1.1 200 OK\n");
            stringBuilder.append("Content-Type: text/plain; charset=UTF-8\n");
            stringBuilder.append("Content-Length: 8\n");
            stringBuilder.append("\n");
            stringBuilder.append("Received");
            outputStream.write(stringBuilder.toString().getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processExecuteRequest(ChunkedInputStream chunkedInputStream, OutputStream outputStream) {
        try {
            this.m_request = new BIBusEnvelope((InputStream)chunkedInputStream);
            Element element = this.m_request.getBody();
            this.m_exeCommand = ((Element)element.elements().get(0)).getQName().getName();
            CGSLogging.logInfo("exeCmd = " + this.m_exeCommand);
            if (this.m_exeCommand.compareTo("runSpecification") == 0) {
                if (CGSVisOutputRequestHelper.isVisOutputServiceRequest(element, "runSpecification")) {
                    this.processVisOutputRunSpecRequest(outputStream);
                    return;
                } else {
                    this.processRunSpecificationRequest(outputStream);
                }
                return;
            }
            if (this.m_exeCommand.compareTo("run") == 0) {
                this.processRunRequest(outputStream);
                return;
            }
            if (this.m_exeCommand.compareTo("release") == 0) {
                this.processReleaseRequest(outputStream);
                return;
            }
            if (this.m_exeCommand.compareTo("cancel") != 0) return;
        }
        catch (SOAPException sOAPException) {
            this.returnError(outputStream, sOAPException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReleaseRequest(OutputStream outputStream) {
        this.prepareResponse(outputStream, null);
        String string = this.m_request.getConversationContextID();
        Thread thread = this.m_server.getPrimaryRequestThreadReference(string);
        if (thread != null) {
            Thread thread2 = thread;
            synchronized (thread2) {
                thread.notify();
            }
            this.m_server.removePrimaryRequestThreadReference(string);
            CGSLogging.logInfo("Removing thread reference (release): " + string);
        } else {
            CGSLogging.logWarning("Unable to find thread reference " + string + ", will not be able to wake up.");
            this.m_server.outputPrimaryRequestThreadReferencesMap();
        }
    }

    private void processRunRequest(OutputStream outputStream) {
        this.processSpecificationRequest(outputStream);
    }

    private void processRunSpecificationRequest(OutputStream outputStream) {
        this.processSpecificationRequest(outputStream);
    }

    private void processSpecificationRequest(OutputStream outputStream) {
        byte[] byArray = null;
        try {
            this.m_primaryRequestId = this.m_request.getConversationContextID();
            this.m_server.addPrimaryRequestThreadReference(this.m_primaryRequestId, this);
            CGSLogging.logInfo("Adding thread reference: " + this.m_primaryRequestId);
            this.processAttachmentEncoding();
            String string = this.getSpecificationFromRequest();
            if (string != null) {
                String string2 = this.decompressSpecification(string);
                CGSLogging.logInfo("Specification = " + string2);
                byArray = this.generateBytesFromSpecification(string2);
            }
        }
        catch (Exception exception) {
            this.returnError(outputStream, exception);
            return;
        }
        this.prepareResponse(outputStream, byArray);
    }

    private void processVisOutputRunSpecRequest(OutputStream outputStream) {
        Map<String, byte[]> map;
        try {
            this.m_primaryRequestId = this.m_request.getConversationContextID();
            this.m_server.addPrimaryRequestThreadReference(this.m_primaryRequestId, this);
            CGSLogging.logInfo("Adding thread reference: " + this.m_primaryRequestId);
            this.processAttachmentEncoding();
            map = CGSVisOutputRequestHelper.generateChartOutput(this.m_request, this.m_server.getInternalDispatcherURL(), this.m_server.getRootFolder(), "runSpecification");
        }
        catch (Exception exception) {
            this.returnError(outputStream, exception);
            return;
        }
        this.prepareVisOutputResponse(outputStream, map);
    }

    private void processAttachmentEncoding() throws DocumentException {
        this.m_attachmentEncoding = this.getAttachmentEncodingFromRequest();
        CGSLogging.logInfo("Attachment Encoding = " + this.m_attachmentEncoding);
    }

    private String getAttachmentEncodingFromRequest() throws DocumentException {
        Element element = this.m_request.getBody();
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            if (element.getName().compareToIgnoreCase("runSpecification") != 0) continue;
            Iterator iterator2 = element.elementIterator();
            while (iterator2.hasNext()) {
                element = (Element)iterator2.next();
                if (element.getName().compareToIgnoreCase("options") != 0) continue;
                Iterator iterator3 = element.elementIterator();
                while (iterator3.hasNext()) {
                    element = (Element)iterator3.next();
                    if (element.getName().compareToIgnoreCase("item") != 0) continue;
                    Iterator iterator4 = element.elementIterator();
                    while (iterator4.hasNext()) {
                        element = (Element)iterator4.next();
                        if (element.getName().compareToIgnoreCase("name") != 0 || element.getTextTrim().compareToIgnoreCase("attachmentEncoding") != 0 || !iterator4.hasNext()) continue;
                        element = (Element)iterator4.next();
                        return element.getTextTrim();
                    }
                }
            }
        }
        return "";
    }

    private String getSpecificationFromRequest() {
        Element element = this.m_request.getBody();
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            if (element.getName().compareToIgnoreCase("runSpecification") == 0) {
                Iterator iterator2 = element.elementIterator();
                while (iterator2.hasNext()) {
                    element = (Element)iterator2.next();
                    if (element.getName().compareToIgnoreCase("specification") != 0) continue;
                    Iterator iterator3 = element.elementIterator();
                    while (iterator3.hasNext()) {
                        element = (Element)iterator3.next();
                        if (element.getName().compareToIgnoreCase("value") != 0) continue;
                        return element.getTextTrim();
                    }
                }
                continue;
            }
            if (element.getName().compareToIgnoreCase("runRequest") != 0) continue;
        }
        return null;
    }

    private String decompressSpecification(String string) throws IOException {
        int n;
        if (!this.isSpecificationCompressed(string)) {
            CGSLogging.logInfo("Specification is not compressed.");
            return string;
        }
        String string2 = "";
        byte[] byArray = this.getCompressedSpecification(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = null;
        gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        byte[] byArray2 = new byte[1024];
        while ((n = gZIPInputStream.read(byArray2)) > 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        gZIPInputStream.close();
        string2 = byteArrayOutputStream.toString("UTF-8");
        CGSLogging.logInfo("Compressed spec length = " + string.length());
        CGSLogging.logInfo("Uncompressed spec length = " + string2.length());
        return string2;
    }

    private boolean isSpecificationCompressed(String string) {
        int n = string.indexOf(COMPRESSED_TAG);
        int n2 = string.indexOf(COMPRESSED_ENDTAG);
        return n != -1 && n2 != -1;
    }

    private byte[] getCompressedSpecification(String string) {
        int n = string.indexOf(COMPRESSED_TAG);
        int n2 = string.indexOf(COMPRESSED_ENDTAG);
        int n3 = n + COMPRESSED_TAG.length();
        int n4 = n2;
        String string2 = string.substring(n3, n4);
        byte[] byArray = base64.decode((int)0, (String)string2);
        return byArray;
    }

    private byte[] generateBytesFromSpecification(String string) throws InterruptedException {
        CGSCanvas cGSCanvas = new CGSCanvas("en-us");
        byte[] byArray = cGSCanvas.drawAsBytes(string);
        char[] cArray = new char[]{(char)byArray[0], (char)byArray[1], (char)byArray[2]};
        CGSLogging.logInfo("Drawing code [" + cArray[0] + cArray[1] + cArray[2] + "] :: Byte count = " + byArray.length);
        return byArray;
    }

    private void returnError(OutputStream outputStream, Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Error: " + throwable.getMessage() + " : " + throwable.getCause() + "\n");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuilder.append("at " + stackTraceElementArray[i].getClassName() + "(" + stackTraceElementArray[i].getFileName() + ":" + stackTraceElementArray[i].getLineNumber() + ")\n");
        }
        byte[] byArray = stringBuilder.toString().getBytes();
        CGSLogging.logError("Exception: " + stringBuilder.toString());
        this.prepareResponse(outputStream, byArray);
    }

    private void prepareResponse(OutputStream outputStream, byte[] byArray) {
        Element element = this.initializeResponse();
        this.returnResponse(outputStream, element, byArray);
    }

    private void prepareVisOutputResponse(OutputStream outputStream, Map<String, byte[]> map) {
        Element element = this.initializeResponse();
        this.returnVisOutputResponse(outputStream, element, map);
    }

    private Element initializeResponse() {
        this.m_response = new BIBusEnvelope();
        if (this.m_request != null) {
            this.m_request.getHeader();
            this.m_request.moveHeaderTo((SOAPEnvelope)this.m_response);
        }
        Element element = this.m_response.getBody();
        Element element2 = element.addElement(this.m_exeCommand + "Response");
        element2.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REPLY.getQualifiedName());
        return element2;
    }

    private void returnResponse(OutputStream outputStream, Element element, byte[] byArray) {
        if (this.m_attachmentEncoding.equalsIgnoreCase(ATTACH_ENCODE_BASE64)) {
            this.returnBase64EncodedResponse(outputStream, element, byArray);
        } else if (this.m_attachmentEncoding.equalsIgnoreCase(ATTACH_ENCODE_MIME)) {
            this.returnMIMEAttachmentResponse(outputStream, element, byArray);
        } else if (this.m_attachmentEncoding.equalsIgnoreCase(ATTACH_ENCODE_MIME_COMPRESSED)) {
            this.returnMIMECompressedAttachmentResponse(outputStream, element, byArray);
        }
    }

    private void returnVisOutputResponse(OutputStream outputStream, Element element, Map<String, byte[]> map) {
        if (this.m_attachmentEncoding.equalsIgnoreCase(ATTACH_ENCODE_BASE64)) {
            this.returnBase64EncodedResponse(outputStream, element, map);
        } else if (this.m_attachmentEncoding.equalsIgnoreCase(ATTACH_ENCODE_MIME)) {
            this.returnMIMEAttachmentResponse(outputStream, element, map);
        } else if (this.m_attachmentEncoding.equalsIgnoreCase(ATTACH_ENCODE_MIME_COMPRESSED)) {
            this.returnMIMECompressedAttachmentResponse(outputStream, element, map);
        }
    }

    private void returnBase64EncodedResponse(OutputStream outputStream, Element element, byte[] byArray) {
        try {
            String string = "";
            if (byArray != null) {
                string = base64.encode((int)0, (byte[])byArray);
                this.addResult(element, string, string.length());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.m_response.writeAsXML((OutputStream)byteArrayOutputStream);
            this.returnSinglePartResponse(outputStream, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            CGSLogging.logError("IOException: " + iOException.toString());
            this.returnError(outputStream, iOException);
        }
    }

    private void returnBase64EncodedResponse(OutputStream outputStream, Element element, Map<String, byte[]> map) {
        try {
            this.addResult(element, map);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.m_response.writeAsXML((OutputStream)byteArrayOutputStream);
            this.returnSinglePartResponse(outputStream, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            CGSLogging.logError("IOException: " + iOException.toString());
            this.returnError(outputStream, iOException);
        }
    }

    private void returnMIMEAttachmentResponse(OutputStream outputStream, Element element, byte[] byArray) {
        try {
            this.addResult(element, null, byArray.length);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.m_response.writeAsXML((OutputStream)byteArrayOutputStream);
            this.returnMultiPartResponse(outputStream, byteArrayOutputStream, byArray, false);
        }
        catch (IOException iOException) {
            CGSLogging.logError("IOException: " + iOException.toString());
            this.returnError(outputStream, iOException);
        }
    }

    private void returnMIMEAttachmentResponse(OutputStream outputStream, Element element, Map<String, byte[]> map) {
        try {
            this.addResult(element, map);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.m_response.writeAsXML((OutputStream)byteArrayOutputStream);
            this.returnMultiPartResponse(outputStream, byteArrayOutputStream, map, false);
        }
        catch (IOException iOException) {
            CGSLogging.logError("IOException: " + iOException.toString());
            this.returnError(outputStream, iOException);
        }
    }

    private void returnMIMECompressedAttachmentResponse(OutputStream outputStream, Element element, byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = CGSServerRequest.compressDataByGZIP(byArray);
            this.addResult(element, null, byteArrayOutputStream.size());
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            this.m_response.writeAsXML((OutputStream)byteArrayOutputStream2);
            this.returnMultiPartResponse(outputStream, byteArrayOutputStream2, byteArrayOutputStream.toByteArray(), true);
        }
        catch (IOException iOException) {
            CGSLogging.logError("IOException: " + iOException.toString());
            this.returnError(outputStream, iOException);
        }
    }

    private void returnMIMECompressedAttachmentResponse(OutputStream outputStream, Element element, Map<String, byte[]> map) {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        try {
            for (String string : map.keySet()) {
                ByteArrayOutputStream byteArrayOutputStream = CGSServerRequest.compressDataByGZIP(map.get(string));
                hashMap.put(string, byteArrayOutputStream.toByteArray());
            }
            this.addResult(element, hashMap);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.m_response.writeAsXML((OutputStream)byteArrayOutputStream);
            this.returnMultiPartResponse(outputStream, byteArrayOutputStream, hashMap, true);
        }
        catch (IOException iOException) {
            CGSLogging.logError("IOException: " + iOException.toString());
            this.returnError(outputStream, iOException);
        }
    }

    static ByteArrayOutputStream compressDataByGZIP(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.finish();
        gZIPOutputStream.close();
        return byteArrayOutputStream;
    }

    private void addResult(Element element, String string, int n) {
        Element element2 = this.m_response.getEnvelope();
        element2.addAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        Element element3 = element.addElement(RESULT);
        element3.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REPLY.getQualifiedName());
        Element element4 = element3.addElement(DETAILS);
        element4.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        element4.addAttribute(BIBusEnvelope.SOAP_ENC_ARRAYTYPE, BUS_ASYNC_DETAIL.getQualifiedName() + "[1]");
        Element element5 = element4.addElement(ITEM);
        element5.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_DETAIL_MIMEATTACH.getQualifiedName());
        Element element6 = element5.addElement(DATA);
        element6.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.XSD_BASE64BINARY);
        if (this.m_attachmentEncoding.equalsIgnoreCase(ATTACH_ENCODE_BASE64)) {
            element6.setText(string);
        } else if (this.m_attachmentEncoding.equalsIgnoreCase(ATTACH_ENCODE_MIME)) {
            element6.addAttribute("href", "cid:cgsImageData.Id@cognos.ibm.com");
        } else if (this.m_attachmentEncoding.equalsIgnoreCase(ATTACH_ENCODE_MIME_COMPRESSED)) {
            element6.addAttribute("href", "cid:cgsImageData.Id@cognos.ibm.com");
        }
        Element element7 = element5.addElement(DATA_SIZE);
        element7.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INT);
        element7.setText(Integer.toString(n));
        Element element8 = element5.addElement(DATA_TYPE);
        element8.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        element8.setText("");
    }

    private void addResult(Element element, Map<String, byte[]> map) {
        Element element2 = this.m_response.getEnvelope();
        element2.addAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        Element element3 = element.addElement(RESULT);
        element3.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_REPLY.getQualifiedName());
        Element element4 = element3.addElement(DETAILS);
        element4.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        element4.addAttribute(BIBusEnvelope.SOAP_ENC_ARRAYTYPE, BUS_ASYNC_DETAIL.getQualifiedName() + "[1]");
        for (String string : map.keySet()) {
            String string2;
            Element element5 = element4.addElement(ITEM);
            element5.addAttribute(BIBusEnvelope.XSI_TYPE, BUS_ASYNC_DETAIL_MIMEATTACH.getQualifiedName());
            Element element6 = element5.addElement(DATA);
            element6.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.XSD_BASE64BINARY);
            byte[] byArray = map.get(string);
            int n = byArray.length;
            if (this.m_attachmentEncoding.equalsIgnoreCase(ATTACH_ENCODE_BASE64)) {
                string2 = new String();
                if (byArray != null) {
                    string2 = base64.encode((int)0, (byte[])byArray);
                }
                n = string2.length();
                element6.setText(string2);
            } else if (this.m_attachmentEncoding.equalsIgnoreCase(ATTACH_ENCODE_MIME) || this.m_attachmentEncoding.equalsIgnoreCase(ATTACH_ENCODE_MIME_COMPRESSED)) {
                element6.addAttribute("href", "cid:cgsImageData.Id@cognos.ibm.com");
            }
            string2 = element5.addElement(DATA_SIZE);
            string2.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.XSD_INT);
            string2.setText(Integer.toString(n));
            Element element7 = element5.addElement(DATA_TYPE);
            element7.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
            element7.setText("");
        }
    }

    private void returnMultiPartResponse(OutputStream outputStream, ByteArrayOutputStream byteArrayOutputStream, byte[] byArray, boolean bl) {
        boolean bl2 = true;
        String string = "\r\n";
        String string2 = MIME_BOUNDARY_DASH;
        String string3 = "cgsResponseBoundary";
        String string4 = ATTACH_ID;
        try {
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            byteArrayOutputStream2.write(string.getBytes());
            byteArrayOutputStream2.write(string2.getBytes());
            byteArrayOutputStream2.write(string3.getBytes());
            byteArrayOutputStream2.write(string.getBytes());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Content-ID: envelope" + string);
            stringBuilder.append("Content-Length: " + byteArrayOutputStream.size() + string);
            stringBuilder.append("Content-Transfer-Encoding: Binary" + string);
            stringBuilder.append("Content-Type: text/xml; charset=UTF-8" + string);
            byteArrayOutputStream2.write(stringBuilder.toString().getBytes());
            byteArrayOutputStream2.write(string.getBytes());
            byteArrayOutputStream2.write(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream2.write(string.getBytes());
            ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
            byteArrayOutputStream3.write(string.getBytes());
            byteArrayOutputStream3.write(string2.getBytes());
            byteArrayOutputStream3.write(string3.getBytes());
            byteArrayOutputStream3.write(string.getBytes());
            stringBuilder = new StringBuilder("Content-ID: " + string4 + string);
            stringBuilder.append("Content-Transfer-Encoding: Binary" + string);
            stringBuilder.append("Content-Type: text/plain; charset=utf-8" + string);
            if (!bl2) {
                stringBuilder.append("Content-Length: " + byArray.length + string);
            }
            if (bl) {
                stringBuilder.append("Content-Encoding: gzip" + string);
            }
            byteArrayOutputStream3.write(stringBuilder.toString().getBytes());
            byteArrayOutputStream3.write(string.getBytes());
            byteArrayOutputStream3.write(byArray);
            byteArrayOutputStream3.write(string.getBytes());
            byteArrayOutputStream3.write(string.getBytes());
            ByteArrayOutputStream byteArrayOutputStream4 = new ByteArrayOutputStream();
            byteArrayOutputStream4.write(string.getBytes());
            byteArrayOutputStream4.write(string2.getBytes());
            byteArrayOutputStream4.write(string3.getBytes());
            byteArrayOutputStream4.write(string2.getBytes());
            byteArrayOutputStream4.write(string.getBytes());
            int n = byteArrayOutputStream2.size() + byteArrayOutputStream3.size();
            stringBuilder = new StringBuilder("HTTP/1.1 200 OK" + string);
            stringBuilder.append("Content-Type: multipart/related; boundary=" + string3 + string);
            if (bl2) {
                stringBuilder.append("Transfer-Encoding: chunked" + string);
            } else {
                stringBuilder.append("Content-Length: " + n + string);
            }
            ByteArrayOutputStream byteArrayOutputStream5 = new ByteArrayOutputStream();
            byteArrayOutputStream5.write(stringBuilder.toString().getBytes());
            this.writeInChunks(byteArrayOutputStream5, byteArrayOutputStream2.toByteArray(), bl2);
            this.writeInChunks(byteArrayOutputStream5, byteArrayOutputStream3.toByteArray(), bl2);
            this.writeInChunks(byteArrayOutputStream5, byteArrayOutputStream4.toByteArray(), bl2);
            byteArrayOutputStream5.write(string.getBytes());
            if (bl2) {
                byteArrayOutputStream5.write(Integer.toString(0).getBytes());
            }
            byteArrayOutputStream5.write(string.getBytes());
            byteArrayOutputStream5.write(string.getBytes());
            outputStream.write(byteArrayOutputStream5.toByteArray());
            outputStream.flush();
        }
        catch (IOException iOException) {
            CGSLogging.logError("IOException: " + iOException.toString());
        }
    }

    private void returnMultiPartResponse(OutputStream outputStream, ByteArrayOutputStream byteArrayOutputStream, Map<String, byte[]> map, boolean bl) {
        boolean bl2 = true;
        String string = new String(MIME_BOUNDARY_DASH);
        String string2 = new String("cgsResponseBoundary");
        try {
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            byteArrayOutputStream2.write("\r\n".getBytes());
            byteArrayOutputStream2.write(string.getBytes());
            byteArrayOutputStream2.write(string2.getBytes());
            byteArrayOutputStream2.write("\r\n".getBytes());
            String string3 = new String();
            string3 = "Content-ID: envelope\r\n";
            string3 = string3 + "Content-Length: " + byteArrayOutputStream.size() + "\r\n";
            string3 = string3 + "Content-Transfer-Encoding: Binary\r\n";
            string3 = string3 + "Content-Type: text/xml; charset=UTF-8\r\n";
            byteArrayOutputStream2.write(string3.getBytes());
            byteArrayOutputStream2.write("\r\n".getBytes());
            byteArrayOutputStream2.write(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream2.write("\r\n".getBytes());
            ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                this.addAttachment(byteArrayOutputStream3, entry, bl, bl2, string2);
            }
            ByteArrayOutputStream byteArrayOutputStream4 = new ByteArrayOutputStream();
            byteArrayOutputStream4.write("\r\n".getBytes());
            byteArrayOutputStream4.write(string.getBytes());
            byteArrayOutputStream4.write(string2.getBytes());
            byteArrayOutputStream4.write(string.getBytes());
            byteArrayOutputStream4.write("\r\n".getBytes());
            int n = byteArrayOutputStream2.size() + byteArrayOutputStream3.size();
            string3 = "HTTP/1.1 200 OK\r\n";
            string3 = string3 + "Content-Type: multipart/related; boundary=" + string2 + "\r\n";
            string3 = bl2 ? string3 + "Transfer-Encoding: chunked\r\n" : string3 + "Content-Length: " + n + "\r\n";
            ByteArrayOutputStream byteArrayOutputStream5 = new ByteArrayOutputStream();
            byteArrayOutputStream5.write(string3.getBytes());
            this.writeInChunks(byteArrayOutputStream5, byteArrayOutputStream2.toByteArray(), bl2);
            this.writeInChunks(byteArrayOutputStream5, byteArrayOutputStream3.toByteArray(), bl2);
            this.writeInChunks(byteArrayOutputStream5, byteArrayOutputStream4.toByteArray(), bl2);
            byteArrayOutputStream5.write("\r\n".getBytes());
            if (bl2) {
                byteArrayOutputStream5.write(Integer.toString(0).getBytes());
            }
            byteArrayOutputStream5.write("\r\n".getBytes());
            byteArrayOutputStream5.write("\r\n".getBytes());
            outputStream.write(byteArrayOutputStream5.toByteArray());
            outputStream.flush();
        }
        catch (IOException iOException) {
            CGSLogging.logError("IOException: " + iOException.toString());
        }
    }

    private void addAttachment(ByteArrayOutputStream byteArrayOutputStream, Map.Entry<String, byte[]> entry, boolean bl, boolean bl2, String string) throws IOException {
        byteArrayOutputStream.write("\r\n".getBytes());
        byteArrayOutputStream.write(MIME_BOUNDARY_DASH.getBytes());
        byteArrayOutputStream.write(string.getBytes());
        byteArrayOutputStream.write("\r\n".getBytes());
        String string2 = "Content-ID: cgsImageData.Id@cognos.ibm.com\r\n";
        string2 = string2 + "Content-Transfer-Encoding: Binary\r\n";
        string2 = entry.getKey().endsWith(".xml") ? string2 + "Content-Type: text/xml; charset=UTF-8\r\n" : string2 + "Content-Type: image/png\r\n";
        byte[] byArray = entry.getValue();
        if (!bl2) {
            string2 = string2 + "Content-Length: " + byArray.length + "\r\n";
        }
        if (bl) {
            string2 = string2 + "Content-Encoding: gzip\r\n";
        }
        byteArrayOutputStream.write(string2.getBytes());
        byteArrayOutputStream.write("\r\n".getBytes());
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write("\r\n".getBytes());
        byteArrayOutputStream.write("\r\n".getBytes());
    }

    private void returnSinglePartResponse(OutputStream outputStream, ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = new String();
            string = "HTTP/1.1 200 OK\n";
            string = string + "Content-Type: text/xml; charset=UTF-8\n";
            string = string + "Content-Length: " + byteArrayOutputStream.size() + "\n";
            string = string + "\n";
            outputStream.write(string.getBytes());
            this.writeInChunks(outputStream, byteArrayOutputStream.toByteArray(), false);
            outputStream.flush();
        }
        catch (IOException iOException) {
            CGSLogging.logError("IOException: " + iOException.toString());
        }
    }

    private void writeInChunks(OutputStream outputStream, byte[] byArray, boolean bl) {
        String string = "\r\n";
        try {
            int n = 0;
            int n2 = 4000;
            int n3 = byArray.length;
            int n4 = 0;
            while (n3 > 0) {
                if (n3 < n2) {
                    n2 = n3;
                }
                if (bl) {
                    outputStream.write(string.getBytes());
                    outputStream.write(Integer.toHexString(n2).getBytes());
                    outputStream.write(string.getBytes());
                }
                outputStream.write(byArray, n4, n2);
                n4 += n2;
                n3 -= n2;
                ++n;
            }
        }
        catch (IOException iOException) {
            CGSLogging.logError("IOException: " + iOException.toString());
        }
    }
}

