/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Common;

import com.ibm.icu.lang.UCharacter;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class CMHelper {
    public static void CGS_ASSERT(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException(string);
        }
    }

    public static boolean getBooleanValue(Element element, String string, boolean bl) {
        Element element2;
        Element element3 = element2 = string == null ? element : element.element(string);
        if (element2 != null && element2.getStringValue().length() != 0) {
            return element2.getStringValue().compareTo("false") != 0;
        }
        return bl;
    }

    public static int getIntValue(Element element, String string, int n) {
        Element element2 = string == null ? element : element.element(string);
        return element2 != null && element2.getStringValue().length() != 0 ? Integer.parseInt(element2.getStringValue()) : n;
    }

    public static double getDoubleValue(Element element, String string, double d) {
        Element element2 = string == null ? element : element.element(string);
        return element2 != null && element2.getStringValue().length() != 0 ? Double.parseDouble(element2.getStringValue()) : d;
    }

    public static String getStringValue(Element element, String string, String string2) {
        Element element2 = string == null ? element : element.element(string);
        return element2 != null ? element2.getStringValue() : string2;
    }

    public static Color getColorValue(Element element, String string, Color color) {
        Element element2;
        Element element3 = element2 = string == null ? element : element.element(string);
        if (element2 != null) {
            int n = CMHelper.getIntValue(element2, "alpha", 255);
            int n2 = CMHelper.getIntValue(element2, "red", 0);
            int n3 = CMHelper.getIntValue(element2, "green", 0);
            int n4 = CMHelper.getIntValue(element2, "blue", 0);
            return new Color(n2, n3, n4, n);
        }
        return color;
    }

    public static String prettyPrint(Element element) {
        if (element != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                OutputFormat outputFormat = OutputFormat.createPrettyPrint();
                XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter, outputFormat);
                xMLWriter.write(element);
                xMLWriter.flush();
                return stringWriter.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getIdealTickCount(double d, boolean bl) {
        int n = 6;
        if (d < 100.0 && bl) {
            n = 4;
        } else if (d > 500.0) {
            n = 10;
        }
        return n;
    }

    public static double[] getAxisScale(double d, double d2, int n) {
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            d2 = 0.0;
            d = 0.0;
        } else if (Double.isNaN(d)) {
            d = d2;
        } else if (Double.isNaN(d2)) {
            d2 = d;
        }
        if (Math.abs(d2 - d) < 1.0E-4 && (Math.abs(d2) > 1.0 || d2 == 0.0)) {
            d -= 1.0;
            d2 += 1.0;
        } else if (d2 == d) {
            d -= Math.abs(d2) / 2.0;
            d2 += Math.abs(d2) / 2.0;
        }
        double d3 = Math.abs(d2 - d);
        d3 /= (double)n;
        d3 = Math.pow(10.0, Math.floor(Math.log10(d3)));
        int n2 = Math.abs(n - CMHelper.countIntervals(d, d2, d3));
        int n3 = Math.abs(n - CMHelper.countIntervals(d, d2, 2.0 * d3));
        int n4 = Math.abs(n - CMHelper.countIntervals(d, d2, 5.0 * d3));
        int n5 = Math.abs(n - CMHelper.countIntervals(d, d2, 10.0 * d3));
        int n6 = Math.min(Math.min(n2, n3), Math.min(n4, n5));
        double d4 = 0.0;
        d4 = n6 == n2 ? d3 : (n6 == n3 ? 2.0 * d3 : (n6 == n4 ? 5.0 * d3 : 10.0 * d3));
        return CMHelper.getAxisScale(d, d2, d4);
    }

    public static double[] getAxisScale(double d, double d2, double d3) {
        double d4;
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            d2 = 0.0;
            d = 0.0;
        } else if (Double.isNaN(d)) {
            d = d2;
        } else if (Double.isNaN(d2)) {
            d2 = d;
        }
        if (Math.abs(d2 - d) < 1.0E-4 && (Math.abs(d2) > 1.0 || d2 == 0.0)) {
            d -= 1.0;
            d2 += 1.0;
        } else if (d2 == d) {
            d -= Math.abs(d2) / 2.0;
            d2 += Math.abs(d2) / 2.0;
        }
        double d5 = CMHelper.roundTickUp(d2, d3);
        if (d3 != 0.0) {
            for (d4 = CMHelper.roundTickDown(d, d3); d4 > d; d4 -= d3) {
            }
            while (d5 < d2) {
                d5 += d3;
            }
        } else {
            d4 = d;
            d5 = d2;
        }
        double[] dArray = new double[]{d4, d5, d3};
        return dArray;
    }

    private static double roundTickUp(double d, double d2) {
        return d2 == 0.0 ? 0.0 : d2 * Math.ceil(d / d2 - 0.001);
    }

    private static double roundTickDown(double d, double d2) {
        return d2 == 0.0 ? 0.0 : d2 * Math.floor(0.001 + d / d2);
    }

    private static int countIntervals(double d, double d2, double d3) {
        double d4 = CMHelper.roundTickDown(d, d3);
        double d5 = CMHelper.roundTickUp(d2, d3);
        int n = (int)Math.floor(1.5 + (d5 - d4) / d3);
        return n;
    }

    public static void reverseArrayInt(int[] nArray) {
        int n = 0;
        for (int i = nArray.length - 1; n < i; ++n, --i) {
            int n2 = nArray[n];
            nArray[n] = nArray[i];
            nArray[i] = n2;
        }
    }

    public static void reverseArrayDouble(double[] dArray) {
        int n = 0;
        for (int i = dArray.length - 1; n < i; ++n, --i) {
            double d = dArray[n];
            dArray[n] = dArray[i];
            dArray[i] = d;
        }
    }

    public static void reverseArrayObject(Object[] objectArray) {
        int n = 0;
        for (int i = objectArray.length - 1; n < i; ++n, --i) {
            Object object = objectArray[n];
            objectArray[n] = objectArray[i];
            objectArray[i] = object;
        }
    }

    public static void writeNullableString(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string != null) {
            dataOutputStream.writeInt(string.length());
            dataOutputStream.writeUTF(string);
        } else {
            dataOutputStream.writeInt(-1);
        }
    }

    public static String readNullableString(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.readInt() == -1) {
            return null;
        }
        return dataInputStream.readUTF().intern();
    }

    public static boolean isRtlTextDirection(String string) {
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            n = UCharacter.getDirection((int)string.charAt(i));
            if (n == 0) {
                return false;
            }
            if (n != 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isComposite(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (UCharacter.getType((int)string.charAt(i)) != 6) continue;
            return true;
        }
        return false;
    }
}

