/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Common;

public class CMIntToShortHashMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public CMIntToShortHashMap() {
        this(20, 0.75f);
    }

    public CMIntToShortHashMap(int n) {
        this(n, 0.75f);
    }

    public CMIntToShortHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        int n2 = n;
        if (n2 == 0) {
            n2 = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n2];
        this.threshold = (int)((float)n2 * f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsKey(int n) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.key == n2) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public short get(int n) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.key == n2) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -1;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.key & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public short put(int n, short s) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.key == n2) {
                short s2 = entry.value;
                entry.value = s;
                return s2;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n3] = entry = new Entry(n, s, entryArray[n3]);
        ++this.count;
        return -1;
    }

    public short remove(int n) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.key == n2) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n3] = entry.next;
                }
                --this.count;
                short s = entry.value;
                entry.value = (short)-1;
                return s;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return -1;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    private static class Entry {
        int key;
        short value;
        private Entry next;

        protected Entry(int n, short s, Entry entry) {
            this.key = n;
            this.value = s;
            this.next = entry;
        }
    }
}

