/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Common;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.Common.CMMath;
import java.util.Arrays;

public class CMWaterlinesUtil {
    public static double calculateStatisticalValueStatMax(double[] dArray, double d) {
        double d2 = CMWaterlinesUtil.calculateStatisticalValuePercentile(dArray, 25.0);
        if (Double.isNaN(d2)) {
            return d;
        }
        double d3 = CMWaterlinesUtil.calculateStatisticalValuePercentile(dArray, 75.0);
        if (Double.isNaN(d3)) {
            return d;
        }
        return d3 + 1.5 * (d3 - d2);
    }

    public static double calculateStatisticalValueStatMin(double[] dArray, double d) {
        double d2 = CMWaterlinesUtil.calculateStatisticalValuePercentile(dArray, 25.0);
        if (Double.isNaN(d2)) {
            return d;
        }
        double d3 = CMWaterlinesUtil.calculateStatisticalValuePercentile(dArray, 75.0);
        if (Double.isNaN(d3)) {
            return d;
        }
        return d2 - 1.5 * (d3 - d2);
    }

    public static double calculateStatisticalValuePercentile(double[] dArray, double d) {
        double d2;
        if (dArray.length == 0) {
            return Double.NaN;
        }
        Arrays.sort(dArray);
        int n = dArray.length;
        int n2 = 0;
        double d3 = 0.0;
        double d4 = d /= 100.0;
        if (d4 <= 0.0) {
            n2 = 0;
        } else if (d4 >= 1.0) {
            n2 = n - 1;
        } else {
            d2 = d4 * (double)(n - 1);
            n2 = (int)Math.floor(d2);
            d3 = d2 - (double)n2;
        }
        CMHelper.CGS_ASSERT(n2 < n, "Percentile calculation error.");
        CMHelper.CGS_ASSERT(d3 >= 0.0 && d3 < 1.0, "Percentile calculation error.");
        d2 = dArray[n2];
        if (n2 < n - 1 && d3 > 1.0E-5) {
            d2 += d3 * (dArray[n2 + 1] - dArray[n2]);
        }
        return d2;
    }

    public static double calculateStatisticalValueMeanStdDev(double[] dArray, double d, boolean bl) {
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = dArray.length;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i];
            d3 += dArray[i] * dArray[i];
        }
        double d5 = d2 / d4;
        if (d == 0.0) {
            return d5;
        }
        if (bl) {
            double d6 = d4;
            double d7 = (d6 * d3 - d2 * d2) / (d6 * d6);
            double d8 = Math.sqrt(d7);
            return d5 + d * d8;
        }
        if (d4 == 1.0) {
            return Double.NaN;
        }
        double d9 = d4;
        double d10 = (d9 * d3 - d2 * d2) / (d9 * (d9 - 1.0));
        double d11 = Math.sqrt(d10);
        return d5 + d * d11;
    }

    public static double calculateStatisticalValuePercent(double d, float[] fArray, boolean bl) {
        d = CMMath.restrict(d, 0.0, 100.0);
        d = (double)(fArray[1] - fArray[0]) * (d / 100.0) + (double)fArray[0];
        return d;
    }

    public static double calculateStatisticalValueGeneral(double d, boolean bl) {
        if (bl) {
            d -= 1.0;
        }
        return d;
    }
}

