/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Common.Regression;

import com.ibm.cgsBus.Common.CMPointFloat2;
import com.ibm.cgsBus.Common.Regression.CMRegressionEquation;
import java.util.ArrayList;

public class CMLinearEquation
extends CMRegressionEquation {
    protected double[] calculateYList(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.calculateY(dArray[i]);
        }
        return dArray2;
    }

    @Override
    protected double calculateY(double d) {
        return this.m_a * d + this.m_b;
    }

    @Override
    protected double calculateX(double d) {
        return (d - this.m_b) / this.m_a;
    }

    @Override
    public String getEquationToString() {
        if (Double.isNaN(this.m_a)) {
            return "";
        }
        String string = "y = " + this.formatValue(this.m_a) + "x";
        if (!Double.isNaN(this.m_b)) {
            string = string + (this.m_b < 0.0 ? " - " + this.formatValue(-this.m_b) : " + " + this.formatValue(this.m_b));
        }
        return string;
    }

    @Override
    public void calculateEquation(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        int n = arrayList.size();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            d6 = arrayList.get(i);
            d7 = arrayList2.get(i);
            d += d6;
            d2 += d7;
            d3 += d6 * d7;
            d4 += Math.pow(d6, 2.0);
            d5 += Math.pow(d7, 2.0);
        }
        this.m_a = ((double)n * d3 - d * d2) / ((double)n * d4 - Math.pow(d, 2.0));
        this.m_b = (d2 - this.m_a * d) / (double)n;
        this.m_rSquared = this.calculateLinearRSquared(n, d, d2, d3, d4, d5);
    }

    @Override
    public CMPointFloat2[] calculateLine(float[] fArray, float[] fArray2) {
        return this.calculateLinearLine(fArray, fArray2);
    }
}

