/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Common.Regression;

import com.ibm.cgsBus.Common.CMPointFloat2;
import com.ibm.cgsBus.Common.Regression.CMILineEquation;
import com.ibm.cgsBus.Common.Regression.CMNumberMatrix;
import com.ibm.cgsBus.Common.Regression.CMRegressionEquation;
import java.util.ArrayList;

public class CMPolynomialFitEquation
extends CMRegressionEquation
implements CMILineEquation {
    private int m_polynomialFactor = 0;
    private ArrayList<Double> m_parameters;

    public void setPolynomialFactor(int n) {
        this.m_polynomialFactor = n;
    }

    @Override
    public double calculateY(double d) {
        double d2 = this.m_parameters.get(0);
        for (int i = 1; i < this.m_parameters.size(); ++i) {
            d2 += this.m_parameters.get(i) * Math.pow(d, i);
        }
        return d2;
    }

    protected ArrayList<Double> calculateYList(ArrayList<Double> arrayList) {
        int n = arrayList.size();
        ArrayList<Double> arrayList2 = new ArrayList<Double>(n);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d = this.calculateY(arrayList.get(i));
            arrayList2.add(new Double(d));
        }
        return arrayList2;
    }

    @Override
    public String getEquationToString() {
        String string = "y = ";
        double d = 0.0;
        boolean bl = true;
        for (int i = this.m_parameters.size() - 1; i >= 0; --i) {
            d = this.m_parameters.get(i);
            if (Double.isNaN(d)) continue;
            if (!bl) {
                string = string + (d < 0.0 ? " - " + this.formatValue(-d) : " + " + this.formatValue(d));
            } else {
                string = string + this.formatValue(d);
                bl = false;
            }
            if (i > 0) {
                string = string + "x";
            }
            if (i <= 1) continue;
            string = string + "^" + i;
        }
        return string;
    }

    @Override
    public void calculateEquation(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        ArrayList<double[]> arrayList3 = this.createEquationMatrix(arrayList, arrayList2);
        CMNumberMatrix cMNumberMatrix = new CMNumberMatrix(arrayList3);
        this.m_parameters = cMNumberMatrix.solve();
        int n = arrayList.size();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        ArrayList<Double> arrayList4 = this.calculateYList(arrayList);
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            d4 = arrayList2.get(i);
            d5 = arrayList4.get(i);
            d += d4;
            d2 += Math.pow(d4, 2.0);
            d3 += Math.pow(d4 - d5, 2.0);
        }
        this.m_rSquared = this.calculateRSquared(n, d, d2, d3);
    }

    protected ArrayList<double[]> createEquationMatrix(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        int n;
        int n2;
        double d = 0.0;
        int n3 = 2 * this.m_polynomialFactor;
        double[] dArray = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = 0.0;
        }
        double[] dArray2 = new double[this.m_polynomialFactor];
        for (n2 = 0; n2 < this.m_polynomialFactor; ++n2) {
            dArray2[n2] = 0.0;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = arrayList.size();
        for (n2 = 0; n2 < n4; ++n2) {
            d2 = arrayList.get(n2);
            d3 = arrayList2.get(n2);
            d += d3;
            for (n = 0; n < n3; ++n) {
                double d4 = Math.pow(d2, n + 1);
                int n5 = n;
                dArray[n5] = dArray[n5] + d4;
                if (n >= this.m_polynomialFactor) continue;
                int n6 = n;
                dArray2[n6] = dArray2[n6] + d3 * d4;
            }
        }
        int n7 = this.m_polynomialFactor + 1;
        ArrayList<double[]> arrayList3 = new ArrayList<double[]>(n7);
        double[] dArray3 = new double[n7 + 1];
        dArray3[0] = n4;
        n = 0;
        int n8 = 1;
        while (n < this.m_polynomialFactor) {
            dArray3[n8] = dArray[n];
            ++n;
            ++n8;
        }
        dArray3[n8] = d;
        arrayList3.add(0, dArray3);
        for (n2 = 1; n2 < n7; ++n2) {
            dArray3 = new double[n7 + 1];
            int n9 = n2 - 1;
            int n10 = n9 + this.m_polynomialFactor + 1;
            n = n9;
            n8 = 0;
            while (n < n10) {
                dArray3[n8] = dArray[n];
                ++n;
                ++n8;
            }
            dArray3[n8] = dArray2[n9];
            arrayList3.add(n2, dArray3);
        }
        return arrayList3;
    }

    protected double calculateRSquared(int n, double d, double d2, double d3) {
        double d4 = 1.0 - d3 / (d2 - Math.pow(d, 2.0) / (double)n);
        return d4;
    }

    @Override
    public CMPointFloat2[] calculateLine(float[] fArray, float[] fArray2) {
        return this.calculateNonLinearLine(fArray, fArray2);
    }
}

