/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.fw.PointFloat3;
import com.avs.openviz3.fw.base.GradientDirectionEnum;
import com.avs.openviz3.fw.base.GroupSceneNode;
import com.avs.openviz3.fw.base.IAttributeSceneNode;
import com.avs.openviz3.fw.base.IDataMapSource;
import com.avs.openviz3.fw.base.IFieldSource;
import com.avs.openviz3.fw.base.IGradientAttributes;
import com.avs.openviz3.fw.base.ILineAttributes;
import com.avs.openviz3.fw.base.IMaterialAttributes;
import com.avs.openviz3.fw.base.ISoftwareRendererLineAttributes;
import com.avs.openviz3.fw.base.ISurfaceAttributes;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributeSceneNode;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributes;
import com.avs.openviz3.fw.base.LineAttributesPropertyEnum;
import com.avs.openviz3.fw.base.MaterialAttributesPropertyEnum;
import com.avs.openviz3.fw.base.SurfaceTypeEnum;
import com.avs.openviz3.fw.base.UnitsEnum;
import com.avs.openviz3.fw.field.CellTypeEnum;
import com.avs.openviz3.glyphs.IGlyph;
import com.avs.openviz3.io.UnstructuredFieldBuilder;
import com.avs.openviz3.viewer.GenerateNormalsEnum;
import com.ibm.cgsBus.DrawContext.DCDrawContextOV;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.Properties.CGSPropChart;
import com.ibm.cgsBus.Properties.CGSPropMarker;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import java.awt.Color;
import java.awt.image.BufferedImage;

public abstract class OVDevice {
    protected int m_width = 0;
    protected int m_height = 0;
    protected boolean m_sceneTreeMeasured = false;
    protected GroupSceneNode m_rootNode = null;

    public void destroy() {
        this.m_width = 0;
        this.m_height = 0;
    }

    public abstract void reset();

    public abstract boolean isRaster();

    public abstract boolean isSVG();

    public abstract void setSize(int var1, int var2);

    public abstract void addChild(GroupSceneNode var1);

    public abstract void measureSceneTree();

    public abstract String getImageMap();

    public void disableBackfaceCull() {
    }

    protected double getLineWidth(double d) {
        return d;
    }

    public void vectorTransparencyNotSupported() {
    }

    public double getOpacity(double d) {
        return d;
    }

    protected void applyLineAttributes(ILineAttributes iLineAttributes, Color color, double d, CGSEnums.LineStyleB lineStyleB) {
        ISoftwareRendererLineAttributes iSoftwareRendererLineAttributes = (ISoftwareRendererLineAttributes)iLineAttributes;
        iSoftwareRendererLineAttributes.setPreciseSuperSampledLines(true);
        if (color != null) {
            iSoftwareRendererLineAttributes.setLineColor(color);
        }
        iSoftwareRendererLineAttributes.setLineWidth(this.getLineWidth(d));
        iSoftwareRendererLineAttributes.setLinePatternIndex(OVHelper.getLineStyle(lineStyleB));
    }

    protected void applySolidEffect(CGSTypeFillEffect cGSTypeFillEffect, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode) {
        ISurfaceFaceAttributes iSurfaceFaceAttributes = iSurfaceFaceAttributeSceneNode.getSurfaceFaceAttributes();
        iSurfaceFaceAttributes.setSurfaceType(SurfaceTypeEnum.SOLID);
        Color color = cGSTypeFillEffect.getDefaultColor();
        iSurfaceFaceAttributes.getSolidAttributes().setSurfaceColor(color);
        ISurfaceAttributes iSurfaceAttributes = iSurfaceFaceAttributeSceneNode.getSurfaceAttributes();
        iSurfaceAttributes.setSurfaceOpacity(this.getOpacity(OVHelper.getOpacity(color)));
    }

    protected void applyPatternEffect(CGSTypeFillEffect cGSTypeFillEffect, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode) {
        ISurfaceFaceAttributes iSurfaceFaceAttributes = iSurfaceFaceAttributeSceneNode.getSurfaceFaceAttributes();
        ISurfaceAttributes iSurfaceAttributes = iSurfaceFaceAttributeSceneNode.getSurfaceAttributes();
        if (cGSTypeFillEffect.getPatternType() == CGSEnums.PatternType.ePatternNone || cGSTypeFillEffect.getPatternType() == CGSEnums.PatternType.ePatternSolid) {
            iSurfaceFaceAttributes.setSurfaceType(SurfaceTypeEnum.SOLID);
            Color color = cGSTypeFillEffect.getPatternForeColor();
            iSurfaceFaceAttributes.getSolidAttributes().setSurfaceColor(color);
            iSurfaceAttributes.setSurfaceOpacity(this.getOpacity(OVHelper.getOpacity(color)));
        } else {
            boolean bl = cGSTypeFillEffect.getPatternTransparent();
            iSurfaceAttributes.setShowStippleBackground(!bl);
            if (bl) {
                iSurfaceAttributes.setStippleColor(cGSTypeFillEffect.getPatternForeColor());
                iSurfaceAttributes.setSurfaceColor(cGSTypeFillEffect.getPatternForeColor());
            } else {
                iSurfaceAttributes.setStippleColor(cGSTypeFillEffect.getPatternForeColor());
                iSurfaceAttributes.setSurfaceColor(cGSTypeFillEffect.getPatternBackColor());
            }
            iSurfaceAttributes.setSurfaceStippleIndex(OVHelper.getStippleIndex(cGSTypeFillEffect));
        }
    }

    protected void applyRadialLinearGradient(IGradientAttributes iGradientAttributes, Color color, Color color2) {
    }

    protected void applyRadialRectGradient(IGradientAttributes iGradientAttributes, Color color, Color color2) {
        iGradientAttributes.setGradientDirection(GradientDirectionEnum.RECTANGULAR);
        iGradientAttributes.setStartColor(color);
        iGradientAttributes.setEndColor(color2);
    }

    protected void applyLinearGradient(CGSEnums.GradientDirection gradientDirection, double d, IGradientAttributes iGradientAttributes, Color color, Color color2) {
        iGradientAttributes.setStartColor(color);
        iGradientAttributes.setEndColor(color2);
        d = (int)d;
        if (d != 0.0) {
            iGradientAttributes.setGradientDirection(GradientDirectionEnum.LINEAR_GRADIENT);
            iGradientAttributes.setLinearGradientAngle(d % 90.0);
        } else {
            switch (gradientDirection) {
                case eGradientUp: {
                    iGradientAttributes.setGradientDirection(GradientDirectionEnum.VERTICAL);
                    break;
                }
                case eGradientDown: {
                    iGradientAttributes.setGradientDirection(GradientDirectionEnum.VERTICAL);
                    break;
                }
                case eGradientRight: {
                    iGradientAttributes.setGradientDirection(GradientDirectionEnum.HORIZONTAL);
                    break;
                }
                case eGradientLeft: {
                    iGradientAttributes.setGradientDirection(GradientDirectionEnum.HORIZONTAL);
                    break;
                }
                default: {
                    iGradientAttributes.setGradientDirection(GradientDirectionEnum.HORIZONTAL);
                }
            }
        }
    }

    protected void applyGradientEffect(CGSTypeFillEffect cGSTypeFillEffect, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode) {
        ISurfaceFaceAttributes iSurfaceFaceAttributes = iSurfaceFaceAttributeSceneNode.getSurfaceFaceAttributes();
        iSurfaceFaceAttributes.setSurfaceType(SurfaceTypeEnum.GRADIENT);
        IGradientAttributes iGradientAttributes = iSurfaceFaceAttributes.getGradientAttributes();
        switch (cGSTypeFillEffect.getGradientType()) {
            case eGradientRadialRect: {
                this.applyRadialRectGradient(iGradientAttributes, cGSTypeFillEffect.getGradientFromColor(), cGSTypeFillEffect.getGradientToColor());
                break;
            }
            case eGradientLinear: {
                this.applyLinearGradient(cGSTypeFillEffect.getGradientDirection(), cGSTypeFillEffect.getGradientAngle(), iGradientAttributes, cGSTypeFillEffect.getGradientFromColor(), cGSTypeFillEffect.getGradientToColor());
                break;
            }
            case eGradientRadialLine: {
                this.applyRadialLinearGradient(iGradientAttributes, cGSTypeFillEffect.getGradientFromColor(), cGSTypeFillEffect.getGradientToColor());
                break;
            }
        }
    }

    public void applyFillEffect(CGSTypeFillEffect cGSTypeFillEffect, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, IAttributeSceneNode iAttributeSceneNode, Float f) {
        if (cGSTypeFillEffect.isSimple(this.isRaster() || this.isSVG())) {
            ISurfaceFaceAttributes iSurfaceFaceAttributes = iSurfaceFaceAttributeSceneNode.getSurfaceFaceAttributes();
            block0 : switch (cGSTypeFillEffect.getType()) {
                case eFillGradient: {
                    iSurfaceFaceAttributes.setSurfaceType(SurfaceTypeEnum.GRADIENT);
                    IGradientAttributes iGradientAttributes = iSurfaceFaceAttributes.getGradientAttributes();
                    Color color = cGSTypeFillEffect.getGradientToColor();
                    Color color2 = cGSTypeFillEffect.getGradientFromColor();
                    if (color.getAlpha() == 0 && color2.getAlpha() == 0) {
                        ISurfaceAttributes iSurfaceAttributes = iSurfaceFaceAttributeSceneNode.getSurfaceAttributes();
                        iSurfaceAttributes.setSurfaceOpacity(0.0);
                        break;
                    }
                    switch (cGSTypeFillEffect.getGradientDirection()) {
                        case eGradientUp: {
                            iGradientAttributes.setGradientDirection(GradientDirectionEnum.VERTICAL);
                            iGradientAttributes.setStartColor(color2);
                            iGradientAttributes.setEndColor(color);
                            break block0;
                        }
                        case eGradientDown: {
                            iGradientAttributes.setGradientDirection(GradientDirectionEnum.VERTICAL);
                            iGradientAttributes.setStartColor(color);
                            iGradientAttributes.setEndColor(color2);
                            break block0;
                        }
                        case eGradientRight: {
                            iGradientAttributes.setGradientDirection(GradientDirectionEnum.HORIZONTAL);
                            iGradientAttributes.setStartColor(color2);
                            iGradientAttributes.setEndColor(color);
                            break block0;
                        }
                    }
                    iGradientAttributes.setGradientDirection(GradientDirectionEnum.HORIZONTAL);
                    iGradientAttributes.setStartColor(color);
                    iGradientAttributes.setEndColor(color2);
                    break;
                }
                case eFillPattern: {
                    ISurfaceAttributes iSurfaceAttributes = iSurfaceFaceAttributeSceneNode.getSurfaceAttributes();
                    if (cGSTypeFillEffect.getPatternType() == CGSEnums.PatternType.ePatternNone || cGSTypeFillEffect.getPatternType() == CGSEnums.PatternType.ePatternSolid) {
                        iSurfaceFaceAttributes.setSurfaceType(SurfaceTypeEnum.SOLID);
                        Color color = cGSTypeFillEffect.getPatternForeColor();
                        iSurfaceFaceAttributes.getSolidAttributes().setSurfaceColor(color);
                        iSurfaceAttributes.setSurfaceOpacity(this.getOpacity(OVHelper.getOpacity(color)));
                        break;
                    }
                    boolean bl = cGSTypeFillEffect.getPatternTransparent();
                    iSurfaceAttributes.setShowStippleBackground(!bl);
                    if (bl) {
                        iSurfaceAttributes.setStippleColor(cGSTypeFillEffect.getPatternForeColor());
                        iSurfaceAttributes.setSurfaceColor(cGSTypeFillEffect.getPatternForeColor());
                    } else {
                        iSurfaceAttributes.setStippleColor(cGSTypeFillEffect.getPatternForeColor());
                        iSurfaceAttributes.setSurfaceColor(cGSTypeFillEffect.getPatternBackColor());
                    }
                    iSurfaceAttributes.setSurfaceStippleIndex(OVHelper.getStippleIndex(cGSTypeFillEffect));
                    break;
                }
            }
        } else {
            ISurfaceFaceAttributes iSurfaceFaceAttributes = iSurfaceFaceAttributeSceneNode.getSurfaceFaceAttributes();
            iSurfaceFaceAttributes.setSurfaceType(SurfaceTypeEnum.SOLID);
            Color color = cGSTypeFillEffect.getDefaultColor();
            iSurfaceFaceAttributes.getSolidAttributes().setSurfaceColor(color);
            ISurfaceAttributes iSurfaceAttributes = iSurfaceFaceAttributeSceneNode.getSurfaceAttributes();
            iSurfaceAttributes.setSurfaceOpacity(this.getOpacity(OVHelper.getOpacity(color)));
        }
    }

    public void applyFillEffectToUSFB(CGSTypeFillEffect cGSTypeFillEffect, UnstructuredFieldBuilder unstructuredFieldBuilder, Float f) {
        ISurfaceAttributes iSurfaceAttributes = unstructuredFieldBuilder.getSurfaceAttributes();
        if (cGSTypeFillEffect.getType() == CGSEnums.FillType.eFillPattern) {
            if (cGSTypeFillEffect.getPatternType() == CGSEnums.PatternType.ePatternSolid) {
                Color color = cGSTypeFillEffect.getPatternForeColor();
                iSurfaceAttributes.setSurfaceColor(color);
                iSurfaceAttributes.setSurfaceOpacity(this.getOpacity(this.getOpacity(OVHelper.getOpacity(color))));
            } else {
                boolean bl = cGSTypeFillEffect.getPatternTransparent();
                iSurfaceAttributes.setShowStippleBackground(!bl);
                if (bl) {
                    iSurfaceAttributes.setStippleColor(cGSTypeFillEffect.getPatternForeColor());
                    iSurfaceAttributes.setSurfaceColor(cGSTypeFillEffect.getPatternForeColor());
                } else {
                    iSurfaceAttributes.setStippleColor(cGSTypeFillEffect.getPatternForeColor());
                    iSurfaceAttributes.setSurfaceColor(cGSTypeFillEffect.getPatternBackColor());
                }
                iSurfaceAttributes.setSurfaceStippleIndex(OVHelper.getStippleIndex(cGSTypeFillEffect));
            }
        } else {
            Color color = cGSTypeFillEffect.getDefaultColor();
            iSurfaceAttributes.setSurfaceColor(color);
            iSurfaceAttributes.setSurfaceOpacity(OVHelper.getOpacity(color));
        }
    }

    protected BufferedImage createFillEffectImage(CGSTypeFillEffect cGSTypeFillEffect, DCDrawContextOV dCDrawContextOV, float f, float f2) {
        boolean bl = false;
        if (dCDrawContextOV.getWidget().isChartMirroringEnabled() && cGSTypeFillEffect.getType() == CGSEnums.FillType.eFillImage) {
            bl = true;
        }
        return cGSTypeFillEffect.createImage(null, (int)Math.ceil(f), (int)Math.ceil(f2), false, bl);
    }

    public void applyFillEffectToLineSegment(CGSTypeFillEffect cGSTypeFillEffect, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, IDataMapSource iDataMapSource) {
        ILineAttributes iLineAttributes = iSurfaceFaceAttributeSceneNode.getLineAttributes();
        IMaterialAttributes iMaterialAttributes = iSurfaceFaceAttributeSceneNode.getMaterialAttributes();
        switch (cGSTypeFillEffect.getType()) {
            case eFillGradient: {
                iLineAttributes.resetProperty(LineAttributesPropertyEnum.LINE_COLOR);
                iMaterialAttributes.setColorMap(iDataMapSource);
                break;
            }
            case eFillPattern: {
                iMaterialAttributes.resetProperty(MaterialAttributesPropertyEnum.COLOR_MAP);
                if (cGSTypeFillEffect.getPatternType() == CGSEnums.PatternType.ePatternSolid) {
                    iLineAttributes.setLineColor(cGSTypeFillEffect.getSolidColor());
                    break;
                }
                iLineAttributes.setLineColor(cGSTypeFillEffect.getDefaultColor());
                break;
            }
            default: {
                iMaterialAttributes.resetProperty(MaterialAttributesPropertyEnum.COLOR_MAP);
                iLineAttributes.setLineColor(cGSTypeFillEffect.getDefaultColor());
            }
        }
    }

    public IGlyph getMarkerGlyph(CGSPropMarker cGSPropMarker, boolean bl) {
        return this.generateGlyph(cGSPropMarker.getMarkerShapeB(), null, bl);
    }

    public UnstructuredFieldBuilder getMarkerUSFB(IGlyph iGlyph, CGSPropMarker cGSPropMarker, PointFloat3 pointFloat3) {
        UnstructuredFieldBuilder unstructuredFieldBuilder = this.generateUSFBFromGlyph(iGlyph, cGSPropMarker.getMarkerShapeB(), Float.valueOf((float)cGSPropMarker.getMarkerSize()), pointFloat3, false);
        OVHelper.applyMaterialEffect((IAttributeSceneNode)unstructuredFieldBuilder, CGSPropChart.MaterialEffect.eMaterialNone);
        return unstructuredFieldBuilder;
    }

    protected UnstructuredFieldBuilder getGlyph(CGSEnums.MarkerShapeB markerShapeB, Float f, PointFloat3 pointFloat3, CGSTypeFillEffect cGSTypeFillEffect, Color color, boolean bl, CGSPropChart.MaterialEffect materialEffect, boolean bl2) {
        UnstructuredFieldBuilder unstructuredFieldBuilder = null;
        IGlyph iGlyph = this.generateGlyph(markerShapeB, color, bl2);
        if (iGlyph != null) {
            this.applyFillEffect(cGSTypeFillEffect, (ISurfaceFaceAttributeSceneNode)iGlyph, null, f);
            unstructuredFieldBuilder = this.generateUSFBFromGlyph(iGlyph, markerShapeB, f, pointFloat3, bl);
            OVHelper.applyMaterialEffect((IAttributeSceneNode)unstructuredFieldBuilder, materialEffect);
        }
        return unstructuredFieldBuilder;
    }

    protected IGlyph generateGlyph(CGSEnums.MarkerShapeB markerShapeB, Color color, boolean bl) {
        IGlyph iGlyph = null;
        if (markerShapeB != null) {
            iGlyph = OVHelper.getGlyph(markerShapeB);
            if (bl) {
                OVHelper.rotateGlyph(iGlyph);
            }
            if (color != null && color.getAlpha() > 0) {
                iGlyph.setShowBorder(true);
                this.applyLineAttributes(iGlyph.getLineAttributes(), color, 0.0, CGSEnums.LineStyleB.eLineSolidB);
            }
        }
        return iGlyph;
    }

    protected UnstructuredFieldBuilder generateUSFBFromGlyph(IGlyph iGlyph, CGSEnums.MarkerShapeB markerShapeB, Float f, PointFloat3 pointFloat3, boolean bl) {
        if (iGlyph == null) {
            return null;
        }
        UnstructuredFieldBuilder unstructuredFieldBuilder = null;
        double[] dArray = new double[]{pointFloat3.getX(), pointFloat3.getY(), pointFloat3.getZ()};
        unstructuredFieldBuilder = new UnstructuredFieldBuilder("OVHelper::generateUSFBFromGlyph");
        unstructuredFieldBuilder.appendVerts((Object)dArray);
        unstructuredFieldBuilder.addCellSet(1, 0, CellTypeEnum.POINT);
        IFieldSource iFieldSource = iGlyph.getOutputField();
        unstructuredFieldBuilder.getGlyphAttributes().setGlyph(iFieldSource);
        if (OVHelper.isGlyph3D(markerShapeB)) {
            unstructuredFieldBuilder.getSurfaceAttributes().setGenerateNormals(GenerateNormalsEnum.CELL);
        }
        if (bl) {
            unstructuredFieldBuilder.getGlyphAttributes().setGlyphSizeUnits(UnitsEnum.PIXEL);
        } else {
            unstructuredFieldBuilder.getGlyphAttributes().setGlyphSizeUnits(UnitsEnum.POINT);
        }
        if (f.floatValue() < 0.0f) {
            f = Float.valueOf(0.0f);
        }
        unstructuredFieldBuilder.getGlyphAttributes().setGlyphSize(new PointFloat3(f.floatValue(), f.floatValue(), f.floatValue()));
        return unstructuredFieldBuilder;
    }
}

