/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.filter.ColumnDataToBins;
import com.avs.openviz3.filter.DataMath;
import com.avs.openviz3.filter.NodeDataSetupEnum;
import com.avs.openviz3.filter.SortDataArray;
import com.avs.openviz3.filter.SortOrderEnum;
import com.avs.openviz3.fw.OrderStyleEnum;
import com.avs.openviz3.fw.base.ComponentExceptionEvent;
import com.avs.openviz3.fw.base.ComponentExceptionListener;
import com.avs.openviz3.fw.base.IFieldSource;
import com.avs.openviz3.io.FieldInfo;
import com.avs.openviz3.layout.DiscreteAxisMap;
import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.Properties.CGSPropOthersGroupB;
import com.ibm.cgsBus.Types.CGSTypeEnum;

public class OVGroupRemainingItems
implements ComponentExceptionListener {
    protected static final int OFFSET_INDEX = 0;
    protected static final int OFFSET_SERIES_SUM = 1;
    protected static final int OFFSET_THRESHOLD_INDEX = 2;
    protected static final int OFFSET_MAXITEM_INDEX = 3;
    protected int m_maxItems;
    protected double m_minThresholdValue;
    protected int[] m_series;
    protected int m_labelColumnIndex;
    protected String m_aggregatedItemLabel = "Other";
    protected CGSTypeEnum<CGSPropOthersGroupB.ThresholdMode> m_thresholdMode = new CGSTypeEnum<CGSPropOthersGroupB.ThresholdMode>(CGSPropOthersGroupB.ThresholdMode.eThresholdModePercentage);
    protected CGSTypeEnum<CGSPropOthersGroupB.AggregateMode> m_aggregationOperation = new CGSTypeEnum<CGSPropOthersGroupB.AggregateMode>(CGSPropOthersGroupB.AggregateMode.eAggregateAverage);
    protected IFieldSource m_outputField;
    protected int[] m_indicesNotToAggregate;
    protected FieldInfo m_inputFieldInfo = new FieldInfo();
    protected DataMath m_addSeriesSumColumn;
    protected DataMath m_removeNullsColumn;
    protected SortDataArray m_sortSeriesSumField;
    protected SortDataArray m_sortByIndex;
    protected DataMath m_addThresholdColumn;
    protected DataMath m_addMaxItemsColumn;
    protected DiscreteAxisMap m_filterAxisMap;
    protected ColumnDataToBins m_binGroupedField;

    public OVGroupRemainingItems() {
        this.m_inputFieldInfo.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_removeNullsColumn = new DataMath();
        this.m_removeNullsColumn.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_addSeriesSumColumn = new DataMath();
        this.m_addSeriesSumColumn.connectInputField(this.m_removeNullsColumn.getOutputField());
        this.m_addSeriesSumColumn.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_sortSeriesSumField = new SortDataArray();
        this.m_sortSeriesSumField.connectInputField(this.m_addSeriesSumColumn.getOutputField());
        this.m_sortSeriesSumField.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_addThresholdColumn = new DataMath();
        this.m_addThresholdColumn.connectInputField(this.m_sortSeriesSumField.getOutputField());
        this.m_addThresholdColumn.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_addMaxItemsColumn = new DataMath();
        this.m_addMaxItemsColumn.connectInputField(this.m_addThresholdColumn.getOutputField());
        this.m_addMaxItemsColumn.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_sortByIndex = new SortDataArray();
        this.m_sortByIndex.connectInputField(this.m_addMaxItemsColumn.getOutputField());
        this.m_sortByIndex.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_filterAxisMap = new DiscreteAxisMap();
        this.m_filterAxisMap.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_filterAxisMap.connectInputField(this.m_sortByIndex.getOutputField());
        this.m_filterAxisMap.setUnique(true);
        this.m_filterAxisMap.setOrderStyle(OrderStyleEnum.ENCOUNTERED);
        this.m_binGroupedField = new ColumnDataToBins();
        this.m_binGroupedField.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_binGroupedField.connectInputField(this.m_addMaxItemsColumn.getOutputField());
        this.m_binGroupedField.setXAxisMap(this.m_filterAxisMap.getOutputAxisMap());
        this.m_outputField = this.m_binGroupedField.getOutputField();
    }

    protected void debug() {
        System.out.println("***DEBUG****");
        System.out.println("m_removeNullsColumn...");
        System.out.println(this.m_removeNullsColumn.getExpression());
        OVGroupRemainingItems.checkOutputFieldValues(this.m_removeNullsColumn.getOutputField());
        System.out.println("m_addSeriesSumColumn...");
        System.out.println(this.m_addSeriesSumColumn.getExpression());
        OVGroupRemainingItems.checkOutputFieldValues(this.m_addSeriesSumColumn.getOutputField());
        System.out.println("m_sortSeriesSumField...");
        OVGroupRemainingItems.checkOutputFieldValues(this.m_sortSeriesSumField.getOutputField());
        System.out.println("m_addThresholdColumn...");
        System.out.println(this.m_addThresholdColumn.getExpression());
        OVGroupRemainingItems.checkOutputFieldValues(this.m_addThresholdColumn.getOutputField());
        System.out.println("m_addMaxItemsColumn...");
        System.out.println(this.m_addMaxItemsColumn.getExpression());
        OVGroupRemainingItems.checkOutputFieldValues(this.m_addMaxItemsColumn.getOutputField());
        System.out.println("m_sortByIndex...");
        OVGroupRemainingItems.checkOutputFieldValues(this.m_sortByIndex.getOutputField());
        System.out.println("m_binGroupedField...");
        System.out.println("m_indicesNotToAggregate.length: " + this.m_indicesNotToAggregate.length);
        OVGroupRemainingItems.checkOutputFieldValues(this.m_binGroupedField.getOutputField());
    }

    public void update() {
        this.updateRemoveNullsExpression(this.m_series);
        this.updateSeriesSumExpression(this.m_series);
        double d = this.getAbsoluteThresholdValue();
        this.updateThresholdExpression(d);
        this.updateMaxItemsExpression();
        int n = this.m_inputFieldInfo.getNumberNodeData();
        int n2 = n + 0;
        int n3 = n + 1;
        int n4 = n + 3;
        this.m_sortSeriesSumField.addSort(n3, SortOrderEnum.DESCENDING);
        this.m_filterAxisMap.setValueArrayIndex(n4);
        this.m_binGroupedField.setXNodeDataIndex(n4);
        this.m_sortByIndex.addSort(n2, SortOrderEnum.ASCENDING);
        this.aggregateBinData(n);
    }

    protected double getAbsoluteThresholdValue() {
        double d = 0.0;
        if (this.m_thresholdMode.getValue() == CGSPropOthersGroupB.ThresholdMode.eThresholdModeAbsolute) {
            d = this.m_minThresholdValue;
        } else if (this.m_thresholdMode.getValue() == CGSPropOthersGroupB.ThresholdMode.eThresholdModePercentage) {
            if (this.m_minThresholdValue > 0.0) {
                d = this.calculateTotalForChart() * this.m_minThresholdValue / 100.0;
            }
        } else {
            CMHelper.CGS_ASSERT(false, "invalid threshold mode");
        }
        return d;
    }

    protected void aggregateBinData(int n) {
        NodeDataSetupEnum nodeDataSetupEnum = NodeDataSetupEnum.SUM;
        if (this.m_aggregationOperation.getValue() == CGSPropOthersGroupB.AggregateMode.eAggregateAverage) {
            nodeDataSetupEnum = NodeDataSetupEnum.MEAN;
        }
        for (int i = 0; i < n; ++i) {
            boolean bl = true;
            Class clazz = this.m_inputFieldInfo.getNodeDataClass(i);
            if (clazz == String.class) {
                bl = false;
            }
            for (int j = 0; j < this.m_indicesNotToAggregate.length; ++j) {
                if (i != this.m_indicesNotToAggregate[j]) continue;
                bl = false;
            }
            if (bl) {
                this.m_binGroupedField.addNodeDataSpec(i, nodeDataSetupEnum);
                continue;
            }
            this.m_binGroupedField.addNodeDataSpec(i, NodeDataSetupEnum.FIRST);
        }
    }

    protected void updateRemoveNullsExpression(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder("output=input;");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append("output[" + nArray[i] + "]=input[" + nArray[i] + "]==null?0:input[" + nArray[i] + "];");
        }
        this.m_removeNullsColumn.setExpression(stringBuilder.toString());
    }

    protected void updateSeriesSumExpression(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder("output=input;output[numInputs]=index;");
        for (int i = 0; i < nArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append("output[numInputs+1]=");
                if (this.m_aggregationOperation.getValue() == CGSPropOthersGroupB.AggregateMode.eAggregateAverage) {
                    stringBuilder.append("(");
                }
            } else {
                stringBuilder.append("+");
            }
            stringBuilder.append("input[" + nArray[i] + "]");
        }
        if (this.m_aggregationOperation.getValue() == CGSPropOthersGroupB.AggregateMode.eAggregateAverage) {
            stringBuilder.append(")/" + nArray.length);
        }
        stringBuilder.append(";");
        this.m_addSeriesSumColumn.setExpression(stringBuilder.toString());
    }

    protected void updateThresholdExpression(double d) {
        int n = this.m_inputFieldInfo.getNumberNodeData();
        int n2 = n + 0;
        String string = "output=input;";
        if (this.m_minThresholdValue > 0.0) {
            string = string + "output[" + n2 + "]=input[numInputs-1]>=" + d + "?input[" + n2 + "]:numValues;";
            string = string + this.getThresholdStringToSetGroupedColumnLabel(this.m_labelColumnIndex, d);
            string = string + this.getThresholdStringToSetGroupedColumnLabel(this.m_labelColumnIndex + 1, d);
            string = string + "output[numInputs]=input[numInputs-1]>=" + d + "?index:numValues;";
        } else {
            string = string + "output[numInputs]=index;";
        }
        this.m_addThresholdColumn.setExpression(string);
    }

    protected String getThresholdStringToSetGroupedColumnLabel(int n, double d) {
        String string = "output[" + n + "]=input[numInputs-1]>=" + d + "?input[" + n + "]:\"" + this.m_aggregatedItemLabel + "\";";
        return string;
    }

    protected void updateMaxItemsExpression() {
        int n = this.m_inputFieldInfo.getNumberNodeData();
        int n2 = n + 0;
        String string = "output=input;";
        if (this.m_maxItems > 0) {
            string = string + "output[" + n2 + "]=index<" + (this.m_maxItems - 1) + "?input[" + n2 + "]:numValues;";
            string = string + this.getMaxItemsStringToSetGroupedColumnLabel(this.m_labelColumnIndex);
            string = string + this.getMaxItemsStringToSetGroupedColumnLabel(this.m_labelColumnIndex + 1);
            string = string + "output[numInputs]=index<" + (this.m_maxItems - 1) + "?input[numInputs-1]:numValues;";
        } else {
            string = string + "output[numInputs]=input[numInputs-1];";
        }
        this.m_addMaxItemsColumn.setExpression(string);
    }

    protected String getMaxItemsStringToSetGroupedColumnLabel(int n) {
        String string = "output[" + n + "]=(index<" + (this.m_maxItems - 1) + "||numValues==" + this.m_maxItems + ")?input[" + n + "]:\"" + this.m_aggregatedItemLabel + "\";";
        return string;
    }

    protected double calculateTotalForChart() {
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.addComponentExceptionListener((ComponentExceptionListener)this);
        fieldInfo.connectInputField(this.m_addSeriesSumColumn.getOutputField());
        int n = fieldInfo.getNumberNodeData();
        int n2 = fieldInfo.getNumCoordinates();
        double d = 0.0;
        double[] dArray = fieldInfo.getNodeDataSubarrayAsNumber(n - 1, 0, n2);
        for (int i = 0; i < n2; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public void connectInputField(IFieldSource iFieldSource) {
        this.m_inputFieldInfo.connectInputField(iFieldSource);
        this.m_removeNullsColumn.connectInputField(iFieldSource);
    }

    public IFieldSource getOutputField() {
        return this.m_outputField;
    }

    public String getAggregatedItemLabel() {
        return this.m_aggregatedItemLabel;
    }

    public void setAggregatedItemLabel(String string) {
        this.m_aggregatedItemLabel = string;
    }

    public CGSPropOthersGroupB.AggregateMode getAggregationOperation() {
        return this.m_aggregationOperation.getValue();
    }

    public void setAggregationOperation(CGSPropOthersGroupB.AggregateMode aggregateMode) {
        this.m_aggregationOperation.setValue(aggregateMode);
    }

    public int getMaxItems() {
        return this.m_maxItems;
    }

    public void setMaxItems(int n) {
        this.m_maxItems = n;
    }

    public CGSPropOthersGroupB.ThresholdMode getThresholdMode() {
        return this.m_thresholdMode.getValue();
    }

    public double getMinThresholdValue() {
        return this.m_minThresholdValue;
    }

    public void setMinThresholdValue(double d, CGSPropOthersGroupB.ThresholdMode thresholdMode) {
        this.m_minThresholdValue = d;
        this.m_thresholdMode.setValue(thresholdMode);
    }

    public void setLabelAndSeriesIndices(int n, int[] nArray) {
        this.m_labelColumnIndex = n;
        this.m_series = nArray;
    }

    public void exceptionOccurred(ComponentExceptionEvent componentExceptionEvent) {
        OVHelper.outputAVSException(componentExceptionEvent);
    }

    public void setIndicesNotToAggregate(int[] nArray) {
        this.m_indicesNotToAggregate = nArray;
    }

    public static void checkOutputFieldValues(IFieldSource iFieldSource) {
        String string = "----------------------------------------";
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.connectInputField(iFieldSource);
        int n = fieldInfo.getNumberNodeData();
        int n2 = fieldInfo.getNumCoordinates();
        System.out.println(string);
        System.out.println("Contents of outputField are:");
        for (int i = 0; i < n; ++i) {
            int n3;
            String[] stringArray = null;
            double[] dArray = null;
            Class clazz = fieldInfo.getNodeDataClass(i);
            if (clazz == String.class) {
                stringArray = fieldInfo.getNodeDataSubarrayAsString(i, 0, n2);
            } else if (clazz == Double.TYPE || clazz == Integer.TYPE) {
                dArray = fieldInfo.getNodeDataSubarrayAsNumber(i, 0, n2);
            }
            System.out.print(i + " : [");
            if (stringArray != null) {
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    System.out.print(stringArray[n3]);
                    if (n3 >= stringArray.length - 1) continue;
                    System.out.print(", ");
                }
            } else if (dArray != null) {
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    System.out.print(dArray[n3]);
                    if (n3 >= dArray.length - 1) continue;
                    System.out.print(", ");
                }
            }
            System.out.println("]");
        }
        System.out.println(string);
    }
}

