/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.chart.AnchorPointHeightPositionEnum;
import com.avs.openviz3.chart.BarChartStyleEnum;
import com.avs.openviz3.fw.BevelStyleEnum;
import com.avs.openviz3.fw.Matrix4x4;
import com.avs.openviz3.fw.PointFloat3;
import com.avs.openviz3.fw.base.ComponentExceptionEvent;
import com.avs.openviz3.fw.base.ExceptionTypeEnum;
import com.avs.openviz3.fw.base.IAttributeSceneNode;
import com.avs.openviz3.fw.base.IComponent;
import com.avs.openviz3.fw.base.IMaterialAttributes;
import com.avs.openviz3.glyphs.BoxGlyph;
import com.avs.openviz3.glyphs.ChaletGlyph;
import com.avs.openviz3.glyphs.CircleGlyph;
import com.avs.openviz3.glyphs.ConeGlyph;
import com.avs.openviz3.glyphs.Cross2DGlyph;
import com.avs.openviz3.glyphs.Cross3DGlyph;
import com.avs.openviz3.glyphs.Diamond3DGlyph;
import com.avs.openviz3.glyphs.DiamondGlyph;
import com.avs.openviz3.glyphs.DodecahedronGlyph;
import com.avs.openviz3.glyphs.DownTriangle3DGlyph;
import com.avs.openviz3.glyphs.DownTriangleGlyph;
import com.avs.openviz3.glyphs.FivePointStarGlyph;
import com.avs.openviz3.glyphs.GunSight3DGlyph;
import com.avs.openviz3.glyphs.GunSightGlyph;
import com.avs.openviz3.glyphs.HexagonGlyph;
import com.avs.openviz3.glyphs.HorizontalBar3DGlyph;
import com.avs.openviz3.glyphs.HorizontalBarGlyph;
import com.avs.openviz3.glyphs.HouseGlyph;
import com.avs.openviz3.glyphs.IGlyph;
import com.avs.openviz3.glyphs.IcosahedronGlyph;
import com.avs.openviz3.glyphs.LeftTriangle3DGlyph;
import com.avs.openviz3.glyphs.LeftTriangleGlyph;
import com.avs.openviz3.glyphs.LowerLeftTriangle3DGlyph;
import com.avs.openviz3.glyphs.LowerLeftTriangleGlyph;
import com.avs.openviz3.glyphs.LowerRightTriangle3DGlyph;
import com.avs.openviz3.glyphs.LowerRightTriangleGlyph;
import com.avs.openviz3.glyphs.MapleLeafGlyph;
import com.avs.openviz3.glyphs.NinjaStarGlyph;
import com.avs.openviz3.glyphs.NotchedSquareGlyph;
import com.avs.openviz3.glyphs.NotchedXGlyph;
import com.avs.openviz3.glyphs.RightTriangle3DGlyph;
import com.avs.openviz3.glyphs.RightTriangleGlyph;
import com.avs.openviz3.glyphs.Sphere32Glyph;
import com.avs.openviz3.glyphs.SquareGlyph;
import com.avs.openviz3.glyphs.StarGlyph;
import com.avs.openviz3.glyphs.TaperedCrossGlyph;
import com.avs.openviz3.glyphs.TaperedXGlyph;
import com.avs.openviz3.glyphs.ThickCrossGlyph;
import com.avs.openviz3.glyphs.ThickXGlyph;
import com.avs.openviz3.glyphs.ThinX3DGlyph;
import com.avs.openviz3.glyphs.ThinXGlyph;
import com.avs.openviz3.glyphs.UpTriangle3DGlyph;
import com.avs.openviz3.glyphs.UpTriangleGlyph;
import com.avs.openviz3.glyphs.UpperLeftTriangle3DGlyph;
import com.avs.openviz3.glyphs.UpperLeftTriangleGlyph;
import com.avs.openviz3.glyphs.UpperRightTriangle3DGlyph;
import com.avs.openviz3.glyphs.UpperRightTriangleGlyph;
import com.avs.openviz3.glyphs.VerticalBar3DGlyph;
import com.avs.openviz3.glyphs.VerticalBarGlyph;
import com.avs.openviz3.glyphs.XGlyph;
import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.Logging.CGSLogging;
import com.ibm.cgsBus.Properties.CGSPropChart;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import java.awt.Color;
import java.io.File;

public final class OVHelper {
    protected static final CGSEnums.MarkerShapeB[] s_glyphs = new CGSEnums.MarkerShapeB[]{CGSEnums.MarkerShapeB.eMarkerSquareB, CGSEnums.MarkerShapeB.eMarkerDiamondB, CGSEnums.MarkerShapeB.eMarkerCircleB, CGSEnums.MarkerShapeB.eMarkerPlusB, CGSEnums.MarkerShapeB.eMarkerUpTriangleB, CGSEnums.MarkerShapeB.eMarkerStar90B, CGSEnums.MarkerShapeB.eMarkerFatPlusB, CGSEnums.MarkerShapeB.eMarkerDownTriangleB, CGSEnums.MarkerShapeB.eMarkerPlainXB, CGSEnums.MarkerShapeB.eMarkerRightTriangleB, CGSEnums.MarkerShapeB.eMarkerFatXB, CGSEnums.MarkerShapeB.eMarkerLeftTriangleB, CGSEnums.MarkerShapeB.eMarkerCastleB, CGSEnums.MarkerShapeB.eMarkerSkewLeftTriangleB, CGSEnums.MarkerShapeB.eMarkerSkewedStarB, CGSEnums.MarkerShapeB.eMarkerSkewRightTriangleB, CGSEnums.MarkerShapeB.eMarkerSoftXB, CGSEnums.MarkerShapeB.eMarkerDownSkewLeftTriangleB, CGSEnums.MarkerShapeB.eMarkerSpikedXB, CGSEnums.MarkerShapeB.eMarkerDownSkewRightTriangleB, CGSEnums.MarkerShapeB.eMarkerStarB, CGSEnums.MarkerShapeB.eMarkerHexagonB, CGSEnums.MarkerShapeB.eMarkerChaletB, CGSEnums.MarkerShapeB.eMarkerHouseB, CGSEnums.MarkerShapeB.eMarkerFivePointStarB, CGSEnums.MarkerShapeB.eMarkerVerticalLineB, CGSEnums.MarkerShapeB.eMarkerHorizontalLineB, CGSEnums.MarkerShapeB.eMarkerMapleLeafB, CGSEnums.MarkerShapeB.eMarkerAsteriskB, CGSEnums.MarkerShapeB.eMarkerGunsightB, CGSEnums.MarkerShapeB.eMarkerVerticalBar3DGlyphB, CGSEnums.MarkerShapeB.eMarkerGunSight3DGlyphB, CGSEnums.MarkerShapeB.eMarkerDiamond3DGlyphB, CGSEnums.MarkerShapeB.eMarkerUpperLeftTriangle3DGlyphB, CGSEnums.MarkerShapeB.eMarkerUpperRightTriangle3DGlyphB, CGSEnums.MarkerShapeB.eMarkerDownTriangle3DGlyphB, CGSEnums.MarkerShapeB.eMarkerLeftTriangle3DGlyphB, CGSEnums.MarkerShapeB.eMarkerThinX3DGlyphB, CGSEnums.MarkerShapeB.eMarkerCross3DGlyphB, CGSEnums.MarkerShapeB.eMarkerRightTriangle3DGlyphB, CGSEnums.MarkerShapeB.eMarkerLowerLeftTriangle3DGlyphB, CGSEnums.MarkerShapeB.eMarkerLowerRightTriangle3DGlyphB, CGSEnums.MarkerShapeB.eMarkerBoxGlyphB, CGSEnums.MarkerShapeB.eMarkerUpTriangle3DGlyphB, CGSEnums.MarkerShapeB.eMarkerHorizontalBar3DGlyphB, CGSEnums.MarkerShapeB.eMarkerConeGlyphB, CGSEnums.MarkerShapeB.eMarkerDodecahedronGlyphB, CGSEnums.MarkerShapeB.eMarkerIcosahedronGlyphB, CGSEnums.MarkerShapeB.eMarkerSphere32GlyphB};
    protected static final CGSEnums.MarkerShapeB[] s_shapeByCategory = new CGSEnums.MarkerShapeB[]{CGSEnums.MarkerShapeB.eMarkerCircleB, CGSEnums.MarkerShapeB.eMarkerDiamondB, CGSEnums.MarkerShapeB.eMarkerStarB, CGSEnums.MarkerShapeB.eMarkerSquareB, CGSEnums.MarkerShapeB.eMarkerDownSkewLeftTriangleB, CGSEnums.MarkerShapeB.eMarkerHexagonB, CGSEnums.MarkerShapeB.eMarkerHorizontalLineB, CGSEnums.MarkerShapeB.eMarkerDownSkewRightTriangleB, CGSEnums.MarkerShapeB.eMarkerHouseB, CGSEnums.MarkerShapeB.eMarkerAsteriskB, CGSEnums.MarkerShapeB.eMarkerPlainXB, CGSEnums.MarkerShapeB.eMarkerUpTriangleB, CGSEnums.MarkerShapeB.eMarkerVerticalLineB, CGSEnums.MarkerShapeB.eMarkerChaletB, CGSEnums.MarkerShapeB.eMarkerSoftXB, CGSEnums.MarkerShapeB.eMarkerDownTriangleB, CGSEnums.MarkerShapeB.eMarkerFatPlusB, CGSEnums.MarkerShapeB.eMarkerFivePointStarB, CGSEnums.MarkerShapeB.eMarkerFatXB, CGSEnums.MarkerShapeB.eMarkerCastleB, CGSEnums.MarkerShapeB.eMarkerGunsightB, CGSEnums.MarkerShapeB.eMarkerLeftTriangleB, CGSEnums.MarkerShapeB.eMarkerRightTriangleB, CGSEnums.MarkerShapeB.eMarkerSkewedStarB, CGSEnums.MarkerShapeB.eMarkerSkewLeftTriangleB, CGSEnums.MarkerShapeB.eMarkerSkewRightTriangleB, CGSEnums.MarkerShapeB.eMarkerSpikedXB, CGSEnums.MarkerShapeB.eMarkerStar90B, CGSEnums.MarkerShapeB.eMarkerUpTriangleB, CGSEnums.MarkerShapeB.eMarkerPlusB};

    public static boolean supersampleFileOverride() {
        File file = new File("cgsSupersampleOff.ini");
        if (file.exists()) {
            CGSLogging.logInfo("Found cgsSupersampleOff.ini: turning off supersampling");
            return true;
        }
        return false;
    }

    public static int getLineStyle(CGSEnums.LineStyleB lineStyleB) {
        switch (lineStyleB) {
            case eLineSolidB: {
                return 0;
            }
            case eLineDashB: {
                return 1;
            }
            case eLineDotB: {
                return 2;
            }
            case eLineDashDotB: {
                return 3;
            }
        }
        CMHelper.CGS_ASSERT(false, "Invalid line style specified");
        return 0;
    }

    public static CGSEnums.MarkerShapeB getGlyphShape(CGSEnums.MarkerShapeB markerShapeB, int n) {
        int n2 = 0;
        int n3 = s_glyphs.length;
        for (n2 = 0; n2 < n3 && s_glyphs[n2] != markerShapeB; ++n2) {
        }
        CMHelper.CGS_ASSERT(n2 < n3, "Specified marker shape not found");
        return s_glyphs[(n2 + n) % n3];
    }

    public static IGlyph getGlyph(CGSEnums.MarkerShapeB markerShapeB) {
        CircleGlyph circleGlyph = new CircleGlyph();
        circleGlyph.setRenderQuality(5);
        CircleGlyph circleGlyph2 = null;
        switch (markerShapeB) {
            case eMarkerSquareB: {
                circleGlyph2 = new SquareGlyph();
                break;
            }
            case eMarkerDiamondB: {
                circleGlyph2 = new DiamondGlyph();
                break;
            }
            case eMarkerCircleB: {
                circleGlyph2 = circleGlyph;
                break;
            }
            case eMarkerPlusB: {
                circleGlyph2 = new Cross2DGlyph();
                break;
            }
            case eMarkerUpTriangleB: {
                circleGlyph2 = new UpTriangleGlyph();
                break;
            }
            case eMarkerStar90B: {
                circleGlyph2 = new TaperedCrossGlyph();
                break;
            }
            case eMarkerFatPlusB: {
                circleGlyph2 = new ThickCrossGlyph();
                break;
            }
            case eMarkerDownTriangleB: {
                circleGlyph2 = new DownTriangleGlyph();
                break;
            }
            case eMarkerPlainXB: {
                circleGlyph2 = new ThinXGlyph();
                break;
            }
            case eMarkerRightTriangleB: {
                circleGlyph2 = new RightTriangleGlyph();
                break;
            }
            case eMarkerFatXB: {
                circleGlyph2 = new ThickXGlyph();
                break;
            }
            case eMarkerLeftTriangleB: {
                circleGlyph2 = new LeftTriangleGlyph();
                break;
            }
            case eMarkerCastleB: {
                circleGlyph2 = new NotchedSquareGlyph();
                break;
            }
            case eMarkerSkewLeftTriangleB: {
                circleGlyph2 = new LowerLeftTriangleGlyph();
                break;
            }
            case eMarkerSkewedStarB: {
                circleGlyph2 = new NinjaStarGlyph();
                break;
            }
            case eMarkerSkewRightTriangleB: {
                circleGlyph2 = new LowerRightTriangleGlyph();
                break;
            }
            case eMarkerSoftXB: {
                circleGlyph2 = new XGlyph();
                break;
            }
            case eMarkerDownSkewLeftTriangleB: {
                circleGlyph2 = new UpperLeftTriangleGlyph();
                break;
            }
            case eMarkerSpikedXB: {
                circleGlyph2 = new NotchedXGlyph();
                break;
            }
            case eMarkerDownSkewRightTriangleB: {
                circleGlyph2 = new UpperRightTriangleGlyph();
                break;
            }
            case eMarkerStarB: {
                circleGlyph2 = new TaperedXGlyph();
                break;
            }
            case eMarkerHexagonB: {
                circleGlyph2 = new HexagonGlyph();
                break;
            }
            case eMarkerChaletB: {
                circleGlyph2 = new ChaletGlyph();
                break;
            }
            case eMarkerHouseB: {
                circleGlyph2 = new HouseGlyph();
                break;
            }
            case eMarkerFivePointStarB: {
                circleGlyph2 = new FivePointStarGlyph();
                break;
            }
            case eMarkerVerticalLineB: {
                circleGlyph2 = new VerticalBarGlyph();
                break;
            }
            case eMarkerHorizontalLineB: {
                circleGlyph2 = new HorizontalBarGlyph();
                break;
            }
            case eMarkerMapleLeafB: {
                circleGlyph2 = new MapleLeafGlyph();
                break;
            }
            case eMarkerAsteriskB: {
                circleGlyph2 = new StarGlyph();
                break;
            }
            case eMarkerGunsightB: {
                circleGlyph2 = new GunSightGlyph();
                break;
            }
            case eMarkerVerticalBar3DGlyphB: {
                circleGlyph2 = new VerticalBar3DGlyph();
                break;
            }
            case eMarkerGunSight3DGlyphB: {
                circleGlyph2 = new GunSight3DGlyph();
                break;
            }
            case eMarkerDiamond3DGlyphB: {
                circleGlyph2 = new Diamond3DGlyph();
                break;
            }
            case eMarkerUpperLeftTriangle3DGlyphB: {
                circleGlyph2 = new UpperLeftTriangle3DGlyph();
                break;
            }
            case eMarkerUpperRightTriangle3DGlyphB: {
                circleGlyph2 = new UpperRightTriangle3DGlyph();
                break;
            }
            case eMarkerDownTriangle3DGlyphB: {
                circleGlyph2 = new DownTriangle3DGlyph();
                break;
            }
            case eMarkerLeftTriangle3DGlyphB: {
                circleGlyph2 = new LeftTriangle3DGlyph();
                break;
            }
            case eMarkerThinX3DGlyphB: {
                circleGlyph2 = new ThinX3DGlyph();
                break;
            }
            case eMarkerCross3DGlyphB: {
                circleGlyph2 = new Cross3DGlyph();
                break;
            }
            case eMarkerRightTriangle3DGlyphB: {
                circleGlyph2 = new RightTriangle3DGlyph();
                break;
            }
            case eMarkerLowerLeftTriangle3DGlyphB: {
                circleGlyph2 = new LowerLeftTriangle3DGlyph();
                break;
            }
            case eMarkerLowerRightTriangle3DGlyphB: {
                circleGlyph2 = new LowerRightTriangle3DGlyph();
                break;
            }
            case eMarkerBoxGlyphB: {
                circleGlyph2 = new BoxGlyph();
                break;
            }
            case eMarkerUpTriangle3DGlyphB: {
                circleGlyph2 = new UpTriangle3DGlyph();
                break;
            }
            case eMarkerHorizontalBar3DGlyphB: {
                circleGlyph2 = new HorizontalBar3DGlyph();
                break;
            }
            case eMarkerConeGlyphB: {
                circleGlyph2 = new ConeGlyph();
                break;
            }
            case eMarkerDodecahedronGlyphB: {
                circleGlyph2 = new DodecahedronGlyph();
                break;
            }
            case eMarkerIcosahedronGlyphB: {
                circleGlyph2 = new IcosahedronGlyph();
                break;
            }
            case eMarkerSphere32GlyphB: {
                circleGlyph2 = new Sphere32Glyph();
                ((Sphere32Glyph)circleGlyph2).setRenderQuality(5);
                break;
            }
            default: {
                circleGlyph2 = circleGlyph;
            }
        }
        return circleGlyph2;
    }

    public static boolean isGlyph3D(CGSEnums.MarkerShapeB markerShapeB) {
        if (markerShapeB == null) {
            return false;
        }
        switch (markerShapeB) {
            case eMarkerSquareB: 
            case eMarkerDiamondB: 
            case eMarkerCircleB: 
            case eMarkerPlusB: 
            case eMarkerUpTriangleB: 
            case eMarkerStar90B: 
            case eMarkerFatPlusB: 
            case eMarkerDownTriangleB: 
            case eMarkerPlainXB: 
            case eMarkerRightTriangleB: 
            case eMarkerFatXB: 
            case eMarkerLeftTriangleB: 
            case eMarkerCastleB: 
            case eMarkerSkewLeftTriangleB: 
            case eMarkerSkewedStarB: 
            case eMarkerSkewRightTriangleB: 
            case eMarkerSoftXB: 
            case eMarkerDownSkewLeftTriangleB: 
            case eMarkerSpikedXB: 
            case eMarkerDownSkewRightTriangleB: 
            case eMarkerStarB: 
            case eMarkerHexagonB: 
            case eMarkerChaletB: 
            case eMarkerHouseB: 
            case eMarkerFivePointStarB: 
            case eMarkerVerticalLineB: 
            case eMarkerHorizontalLineB: 
            case eMarkerMapleLeafB: 
            case eMarkerAsteriskB: 
            case eMarkerGunsightB: {
                return false;
            }
            case eMarkerVerticalBar3DGlyphB: 
            case eMarkerGunSight3DGlyphB: 
            case eMarkerDiamond3DGlyphB: 
            case eMarkerUpperLeftTriangle3DGlyphB: 
            case eMarkerUpperRightTriangle3DGlyphB: 
            case eMarkerDownTriangle3DGlyphB: 
            case eMarkerLeftTriangle3DGlyphB: 
            case eMarkerThinX3DGlyphB: 
            case eMarkerCross3DGlyphB: 
            case eMarkerRightTriangle3DGlyphB: 
            case eMarkerLowerLeftTriangle3DGlyphB: 
            case eMarkerLowerRightTriangle3DGlyphB: 
            case eMarkerBoxGlyphB: 
            case eMarkerUpTriangle3DGlyphB: 
            case eMarkerHorizontalBar3DGlyphB: 
            case eMarkerConeGlyphB: 
            case eMarkerDodecahedronGlyphB: 
            case eMarkerIcosahedronGlyphB: 
            case eMarkerSphere32GlyphB: {
                return true;
            }
        }
        return false;
    }

    public static int getStippleIndex(CGSTypeFillEffect cGSTypeFillEffect) {
        switch (cGSTypeFillEffect.getPatternType()) {
            case ePatternSolid: {
                return 0;
            }
            case ePatternBackwardDiagonal: {
                return 4;
            }
            case ePatternCross: {
                return 2;
            }
            case ePatternDiagonalCross: {
                return 3;
            }
            case ePatternForwardDiagonal: {
                return 1;
            }
            case ePatternHorizontal: {
                return 5;
            }
            case ePatternVertical: {
                return 6;
            }
        }
        return 0;
    }

    public static double getOpacity(Color color) {
        return (double)color.getAlpha() / 255.0;
    }

    public static BarChartStyleEnum getBarStyle(CGSEnums.BarStyle barStyle) {
        BarChartStyleEnum barChartStyleEnum = BarChartStyleEnum.BOX;
        switch (barStyle) {
            case eBarStyleRectangle: {
                barChartStyleEnum = BarChartStyleEnum.RECTANGLE;
                break;
            }
            case eBarStyleTriangle: {
                barChartStyleEnum = BarChartStyleEnum.TRIANGLE;
                break;
            }
            case eBarStyleBox: {
                barChartStyleEnum = BarChartStyleEnum.BOX;
                break;
            }
            case eBarStylePyramid: {
                barChartStyleEnum = BarChartStyleEnum.PYRAMID;
                break;
            }
            case eBarStyleCone: {
                barChartStyleEnum = BarChartStyleEnum.CONE;
                break;
            }
            case eBarStyleCylinder: {
                barChartStyleEnum = BarChartStyleEnum.CYLINDER;
                break;
            }
            default: {
                barChartStyleEnum = BarChartStyleEnum.BOX;
            }
        }
        return barChartStyleEnum;
    }

    public static boolean isBarStyle3D(CGSEnums.BarStyle barStyle) {
        switch (barStyle) {
            case eBarStyleRectangle: 
            case eBarStyleTriangle: {
                return false;
            }
            case eBarStyleBox: 
            case eBarStylePyramid: 
            case eBarStyleCone: 
            case eBarStyleCylinder: {
                return true;
            }
        }
        return false;
    }

    public static BevelStyleEnum getBevelStyle(CGSEnums.BevelType bevelType) {
        BevelStyleEnum bevelStyleEnum = BevelStyleEnum.NONE;
        switch (bevelType) {
            case eBevelFlat: {
                bevelStyleEnum = BevelStyleEnum.FLAT;
                break;
            }
            case eBevelRound: {
                bevelStyleEnum = BevelStyleEnum.ROUND;
                break;
            }
            case eBevelNone: {
                bevelStyleEnum = BevelStyleEnum.NONE;
            }
        }
        return bevelStyleEnum;
    }

    public static void applyMaterialEffect(IAttributeSceneNode iAttributeSceneNode, CGSPropChart.MaterialEffect materialEffect) {
        if (materialEffect == CGSPropChart.MaterialEffect.eMaterialNone) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        switch (materialEffect) {
            case eMaterialMatte: {
                d = 0.3;
                d2 = 0.6;
                d3 = 0.3;
                d4 = 0.1;
                d5 = 1.0;
                break;
            }
            case eMaterialMetal: {
                d = 0.28;
                d2 = 0.25;
                d3 = 1.0;
                d4 = 0.17;
                d5 = 1.0;
                break;
            }
            case eMaterialPlastic: {
                d = 0.3;
                d2 = 0.6;
                d3 = 0.9;
                d4 = 0.3;
                d5 = 0.9;
                break;
            }
            case eMaterialSemigloss: {
                d = 0.3;
                d2 = 0.6;
                d3 = 0.65;
                d4 = 0.23;
                d5 = 1.0;
                break;
            }
            default: {
                CMHelper.CGS_ASSERT(false, "Unknown material effect");
            }
        }
        IMaterialAttributes iMaterialAttributes = iAttributeSceneNode.getMaterialAttributes();
        iMaterialAttributes.setMaterialAmbient(d);
        iMaterialAttributes.setMaterialDiffuse(d2);
        iMaterialAttributes.setMaterialSpecular(d3);
        iMaterialAttributes.setMaterialRoughness(d4);
        iAttributeSceneNode.getSurfaceAttributes().setSurfaceOpacity(d5);
    }

    public static CGSEnums.MarkerShapeB getFirstShapeByCategory() {
        return s_shapeByCategory[0];
    }

    public static CGSEnums.MarkerShapeB getShapeByCategory(int n) {
        return s_shapeByCategory[n % s_shapeByCategory.length];
    }

    public static void rotateGlyph(IGlyph iGlyph) {
        PointFloat3 pointFloat3 = new PointFloat3();
        pointFloat3.setValues(-0.5f, 1.0f, 0.0f);
        Matrix4x4 matrix4x4 = Matrix4x4.createRotation((double)-0.3490658503988659, (PointFloat3)pointFloat3);
        iGlyph.getSceneNodeAttributes().getMatrix().setMatrix(matrix4x4);
    }

    public static void outputAVSException(ComponentExceptionEvent componentExceptionEvent) {
        ExceptionTypeEnum exceptionTypeEnum = componentExceptionEvent.getType();
        int n = componentExceptionEvent.getCode();
        String string = componentExceptionEvent.getMessage();
        IComponent iComponent = componentExceptionEvent.getComponent();
        String string2 = iComponent.getName();
        String string3 = null;
        if (exceptionTypeEnum == ExceptionTypeEnum.INFORMATION) {
            string3 = "AVS Information Exception: " + string + " (" + string2 + ":" + n + ")";
            CGSLogging.logInfo(string3);
        } else if (exceptionTypeEnum == ExceptionTypeEnum.WARNING) {
            string3 = "AVS Warning Exception: " + string + " (" + string2 + ":" + n + ")";
            CGSLogging.logWarning(string3);
        } else if (exceptionTypeEnum == ExceptionTypeEnum.INTERNAL) {
            string3 = "AVS Internal Exception: " + string + " (" + string2 + ":" + n + ")";
            CGSLogging.logError(string3);
        } else if (exceptionTypeEnum == ExceptionTypeEnum.COMPONENT) {
            string3 = "AVS Component Exception: " + string + " (" + string2 + ":" + n + ")";
            CGSLogging.logError(string3);
        } else {
            string3 = "AVS Unknown Exception: " + string + " (" + string2 + ":" + n + ")";
            CGSLogging.logError(string3);
        }
    }

    public static AnchorPointHeightPositionEnum getLabelAnchorPosition(CGSEnums.DataTextLocation dataTextLocation) {
        switch (dataTextLocation) {
            case eDataTextCentered: {
                return AnchorPointHeightPositionEnum.CENTERED;
            }
            case eDataTextOutsideTop: {
                return AnchorPointHeightPositionEnum.OUTSIDE_TOP;
            }
            case eDataTextInsideTop: {
                return AnchorPointHeightPositionEnum.INSIDE_TOP;
            }
            case eDataTextOutsideBottom: {
                return AnchorPointHeightPositionEnum.OUTSIDE_BOTTOM;
            }
            case eDataTextInsideBottom: {
                return AnchorPointHeightPositionEnum.INSIDE_BOTTOM;
            }
        }
        return AnchorPointHeightPositionEnum.CENTERED;
    }
}

