/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.chart.PieChartBase;
import com.avs.openviz3.chart.PieChartBevelStyleEnum;
import com.avs.openviz3.chart.PieChartBevelTypeEnum;
import com.avs.openviz3.chart.PieChartLabelTypeEnum;
import com.avs.openviz3.chart.PieLabelFilteringEnum;
import com.avs.openviz3.chart.PieLabelFittingEnum;
import com.avs.openviz3.chart.RadialLabeledPieChart;
import com.avs.openviz3.chart.SideLabeledPieChart;
import com.avs.openviz3.fw.base.ComponentExceptionListener;
import com.avs.openviz3.fw.base.IAttributeSceneNode;
import com.avs.openviz3.fw.base.IAxisMapSource;
import com.avs.openviz3.fw.base.IFieldSource;
import com.avs.openviz3.fw.base.IManageableComponentSceneNode;
import com.avs.openviz3.fw.base.ISceneNode;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributeSceneNode;
import com.avs.openviz3.layout.Domain;
import com.avs.openviz3.layout.UniformAxesEnum;
import com.avs.openviz3.layout.UniformAxisModeEnum;
import com.ibm.cgsBus.DrawContext.DCDrawContextOV;
import com.ibm.cgsBus.DrawContext.OVChart;
import com.ibm.cgsBus.DrawContext.OVGroupRemainingItems;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.FrameWork.CGSDataItem;
import com.ibm.cgsBus.FrameWork.CGSDataRow;
import com.ibm.cgsBus.FrameWork.CGSFormatter;
import com.ibm.cgsBus.FrameWork.CGSWidget;
import com.ibm.cgsBus.Graphics.GRLegend;
import com.ibm.cgsBus.Graphics.GRLegendItemIcon;
import com.ibm.cgsBus.Properties.CGSPropChartPie;
import com.ibm.cgsBus.Properties.CGSPropFormatNumeric;
import com.ibm.cgsBus.Properties.CGSPropFormatNumericBase;
import com.ibm.cgsBus.Properties.CGSPropLegend;
import com.ibm.cgsBus.Properties.CGSPropLegendItem;
import com.ibm.cgsBus.Properties.CGSPropOthersGroupB;
import com.ibm.cgsBus.Properties.CGSPropWidgetChart;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeString;
import java.awt.Color;

public class OVPieChart
extends OVChart
implements ComponentExceptionListener {
    private CGSPropChartPie m_propChartPie;
    private CGSPropOthersGroupB m_propOthersGroupB;
    private PieChartBase m_ovPieChart;
    private Domain m_domain;
    private OVGroupRemainingItems m_groupRemainingItems;
    private int m_dataRowIndex = -1;
    private int m_dataSeriesIndex = -1;
    private int m_dataLabelIndex = -1;
    private int m_piePercentIndex = -1;
    private int m_valueLabelIndex = -1;

    public OVPieChart(DCDrawContextOV dCDrawContextOV) {
        super(dCDrawContextOV);
        this.init(dCDrawContextOV);
    }

    @Override
    protected void init(DCDrawContextOV dCDrawContextOV) {
        super.init(dCDrawContextOV);
        this.getChartProperties();
        if (this.useGrouping()) {
            this.m_groupRemainingItems = new OVGroupRemainingItems();
        }
        if (this.hasDepth()) {
            dCDrawContextOV.getOutputDevice().vectorTransparencyNotSupported();
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_propChartPie = null;
        this.m_propOthersGroupB = null;
        this.m_ovPieChart = null;
        this.m_domain = null;
        this.m_groupRemainingItems = null;
        this.m_dataRowIndex = -1;
        this.m_dataSeriesIndex = -1;
        this.m_dataLabelIndex = -1;
        this.m_piePercentIndex = -1;
        this.m_valueLabelIndex = -1;
    }

    private boolean useGrouping() {
        int n = this.m_propOthersGroupB.getCountMaxItems();
        double d = this.m_propOthersGroupB.getThresholdValue();
        return n > 0 || d > 0.0;
    }

    @Override
    protected void prepareData() {
        int n;
        int n2;
        Object object;
        Object[] objectArray;
        this.setItemIndices();
        if (this.useGrouping() && this.m_pData.getNumGroupedRows() == 0 && this.m_dataLabelIndex >= 0) {
            super.prepareData();
            objectArray = this.m_pData.getGridColumns();
            int n3 = ((double[])objectArray[this.m_dataSeriesIndex]).length;
            int n4 = this.m_propOthersGroupB.getCountMaxItems();
            if (this.m_propOthersGroupB.getThresholdValue() == 0.0 && n4 < n3 || this.m_propOthersGroupB.getThresholdValue() > 0.0) {
                object = this.getGroupRemainingItemsField();
                objectArray = this.getFieldColumns((IFieldSource)object);
                int n5 = ((double[])objectArray[this.m_dataSeriesIndex]).length;
                n2 = n3 - n5;
                this.m_pData.setNumGroupedRows(n2);
            }
        } else {
            objectArray = this.m_pData.getGridColumns();
        }
        String[] stringArray = (String[])objectArray[this.m_valueLabelIndex];
        String[] stringArray2 = (String[])objectArray[this.m_piePercentIndex];
        object = (int[])objectArray[this.m_dataRowIndex];
        double[] dArray = (double[])objectArray[this.m_dataSeriesIndex];
        n2 = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            d += Math.abs(dArray[i]);
        }
        CGSPropFormatNumeric cGSPropFormatNumeric = (CGSPropFormatNumeric)((CGSPropChartPie)this.getChart()).getProp(CGSEnums.PropType.ePropFormatNumeric);
        cGSPropFormatNumeric.setFormatType(CGSPropFormatNumericBase.FormatType.eFormatPercentage);
        for (n = 0; n < dArray.length; ++n) {
            Object object2;
            double d2 = dArray[n];
            if (Double.isNaN(d2)) continue;
            CGSTypeString cGSTypeString = new CGSTypeString();
            if (this.m_pData.getNumGroupedRows() > 0 && n == n2 - 1) {
                object2 = (CGSPropFormatNumeric)this.m_propOthersGroupB.getProp(CGSEnums.PropType.ePropFormatNumeric);
                CGSFormatter cGSFormatter = this.m_pWidget.getFormatter((CGSPropFormatNumericBase)object2);
                cGSTypeString.setValue(cGSFormatter.applyFormat(d2));
                cGSPropFormatNumeric.setLocale(((CGSPropFormatNumericBase)object2).getLocale());
                cGSPropFormatNumeric.setDigitShapeType(((CGSPropFormatNumericBase)object2).getDigitShapeType());
            } else {
                this.m_pWidget.getDataValueAsString(this.m_pData, object[n], this.m_dataSeriesIndex, d2, cGSTypeString);
                int n6 = this.m_pData.getTableRowIndex(object[n], this.m_dataSeriesIndex);
                int n7 = this.m_pData.getTableColumnIndex(object[n], this.m_dataSeriesIndex);
                if (n6 != -1 && n7 != -1) {
                    CGSDataRow cGSDataRow = this.m_pData.getRow(n6);
                    CGSDataItem cGSDataItem = cGSDataRow.getAt(n7);
                    CGSPropWidgetChart cGSPropWidgetChart = (CGSPropWidgetChart)this.m_pWidget.getBaseProp();
                    if (cGSDataItem.m_index >= 0 && cGSDataItem.m_index < cGSPropWidgetChart.getFormatNumericCount()) {
                        CGSPropFormatNumeric cGSPropFormatNumeric2 = cGSPropWidgetChart.getFormatNumeric(cGSDataItem.m_index);
                        cGSPropFormatNumeric.setLocale(cGSPropFormatNumeric2.getLocale());
                        cGSPropFormatNumeric.setDigitShapeType(cGSPropFormatNumeric2.getDigitShapeType());
                    }
                }
            }
            stringArray[n] = cGSTypeString.getValue();
            object2 = this.m_pWidget.getFormatter(cGSPropFormatNumeric);
            ((CGSFormatter)object2).setAttributes(cGSPropFormatNumeric);
            stringArray2[n] = ((CGSFormatter)object2).applyFormat(Math.abs(d2) / d);
        }
        for (n = 0; n < objectArray.length; ++n) {
            this.m_pData.getGridColumns()[n] = objectArray[n];
        }
        if (!this.m_pDrawContext.isDrawingLegend()) {
            double[] dArray2 = (double[])this.m_pData.getGridColumns()[this.m_dataSeriesIndex];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = Math.abs(dArray2[i]);
            }
        }
        this.addFormattedValuesToCellInfo(stringArray, stringArray2);
        this.fixGridColumnAmpersandEncoding();
        super.prepareData();
    }

    private void fixGridColumnAmpersandEncoding() {
        if (!this.m_pDrawContext.isDrawingLegend()) {
            this.m_pData.fixGridColumnAmpersandEncoding(this.m_valueLabelIndex);
            this.m_pData.fixGridColumnAmpersandEncoding(this.m_piePercentIndex);
        }
    }

    private void addFormattedValuesToCellInfo(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = ((int[])this.m_pData.getGridColumns()[this.m_dataRowIndex])[i];
            if (this.showRawDA()) {
                this.m_pData.addFormattedValueToCell(n2, this.m_dataSeriesIndex, stringArray[i]);
            }
            if (this.showPercentDA()) {
                this.m_pData.addFormattedValueToCell(n2, this.m_dataSeriesIndex, CGSEnums.FormattedStringIndex.eFormattedStringPercentage.getValue(), stringArray2[i]);
            }
            if (this.m_pData.getNumGroupedRows() <= 0 || i != n - 1) continue;
            this.m_pData.setIsGroupedData(n2, this.m_dataSeriesIndex, true);
            String string = this.m_propOthersGroupB.getLabel();
            this.m_pData.addFormattedValueToCell(n2, this.m_dataSeriesIndex, CGSEnums.FormattedStringIndex.eFormattedStringOthersLabel.getValue(), string);
        }
    }

    private boolean showRawDA() {
        CGSPropChartPie.PieValueMode pieValueMode = this.m_propChartPie.getShowValuesB();
        CGSPropChartPie.PieValueModeDA pieValueModeDA = this.m_propChartPie.getDataValuesModeDA();
        return pieValueModeDA == CGSPropChartPie.PieValueModeDA.ePieValueRawDA || pieValueModeDA == CGSPropChartPie.PieValueModeDA.ePieValueBothDA || pieValueModeDA == CGSPropChartPie.PieValueModeDA.ePieValueDisplayDA && (pieValueMode == CGSPropChartPie.PieValueMode.ePieValueRaw || pieValueMode == CGSPropChartPie.PieValueMode.ePieValueBoth || pieValueMode == CGSPropChartPie.PieValueMode.ePieValueHidden);
    }

    private boolean showPercentDA() {
        CGSPropChartPie.PieValueMode pieValueMode = this.m_propChartPie.getShowValuesB();
        CGSPropChartPie.PieValueModeDA pieValueModeDA = this.m_propChartPie.getDataValuesModeDA();
        return pieValueModeDA == CGSPropChartPie.PieValueModeDA.ePieValuePercentDA || pieValueModeDA == CGSPropChartPie.PieValueModeDA.ePieValueBothDA || pieValueModeDA == CGSPropChartPie.PieValueModeDA.ePieValueDisplayDA && (pieValueMode == CGSPropChartPie.PieValueMode.ePieValuePercent || pieValueMode == CGSPropChartPie.PieValueMode.ePieValueBoth);
    }

    private void setItemIndices() {
        if (this.m_pData.getGridColumnCount() > 1) {
            for (int i = 0; i < this.m_pData.getGridColumnCount(); ++i) {
                if (this.m_pData.getGridColumnType(i) == 4 && this.m_dataSeriesIndex == -1) {
                    this.m_dataSeriesIndex = i;
                    continue;
                }
                if (this.m_pData.getGridColumnType(i) == 5) {
                    this.m_dataRowIndex = i;
                    continue;
                }
                if (this.m_pData.getGridColumnType(i) == 0) {
                    this.m_dataLabelIndex = i;
                    continue;
                }
                if (this.m_pData.getGridColumnType(i) == 7 && this.m_valueLabelIndex == -1) {
                    this.m_valueLabelIndex = i;
                    continue;
                }
                if (this.m_pData.getGridColumnType(i) != 9 || this.m_piePercentIndex != -1) continue;
                this.m_piePercentIndex = i;
            }
        }
    }

    @Override
    public void applyProperties() {
        super.applyProperties();
        this.createChart();
        this.populateLegend();
        this.addChartData();
        if (this.m_pDrawContext.isDrawingLegend()) {
            return;
        }
        this.setLabelTemplate(0, this.m_dataLabelIndex);
        this.setImageMapTemplate();
        this.applyChartProperties();
    }

    protected void createChart() {
        this.m_ovPieChart = this.m_propChartPie.getRadialLabelStyle() ? new com.avs.openviz3.cognos.RadialLabeledPieChart() : new SideLabeledPieChart();
        this.m_ovPieChart.addComponentExceptionListener((ComponentExceptionListener)this);
        OVHelper.applyMaterialEffect((IAttributeSceneNode)this.m_ovPieChart, this.m_propChartPie.getMaterialEffect());
    }

    private void addChartData() {
        this.m_ovPieChart.connectInputField(this.getInputField());
        Object object = this.m_propChartPie.getRadialLabelStyle() ? ((com.avs.openviz3.cognos.RadialLabeledPieChart)this.m_ovPieChart).newSeries(this.m_dataSeriesIndex) : ((SideLabeledPieChart)this.m_ovPieChart).newSeries(this.m_dataSeriesIndex);
        int n = this.getColorByValueIndex(this.m_dataSeriesIndex);
        if (n != -1) {
            object.setColorIndex(Integer.valueOf(n));
        }
    }

    private void setLabelTemplate(int n, int n2) {
        String string = "";
        if (this.m_propChartPie.getShowLabelsB() && n2 >= 0) {
            string = string + "<Array" + n2 + "><br/>";
        }
        if (this.m_propChartPie.getShowValuesB() == CGSPropChartPie.PieValueMode.ePieValueRaw || this.m_propChartPie.getShowValuesB() == CGSPropChartPie.PieValueMode.ePieValueBoth) {
            string = string + "<Array" + this.m_valueLabelIndex + "><br/>";
        }
        if (this.m_propChartPie.getShowValuesB() == CGSPropChartPie.PieValueMode.ePieValuePercent || this.m_propChartPie.getShowValuesB() == CGSPropChartPie.PieValueMode.ePieValueBoth) {
            string = string + "<Array" + this.m_piePercentIndex + ">";
        }
        this.getPieSeries(n).setLabelTemplate(string);
    }

    private void setImageMapTemplate() {
        if (this.m_pWidget.isDetectionAreaRequired(CGSEnums.DetArea.eDetChartElement, 0)) {
            this.m_ovPieChart.setImageMapTemplate("[" + CGSEnums.DetArea.eDetChartElement.getValue() + " " + CGSWidget.DataType.eCategory.getValue() + " <SeriesIndex> <Array" + this.m_dataRowIndex + "> 0]");
        }
    }

    private void getChartProperties() {
        this.m_propChartPie = (CGSPropChartPie)this.getChart();
        this.m_propOthersGroupB = (CGSPropOthersGroupB)this.m_propChartPie.getProp(CGSEnums.PropType.ePropOthersGroupB);
    }

    private IFieldSource getGroupRemainingItemsField() {
        String string = this.m_propOthersGroupB.getLabel();
        if (!this.m_pDrawContext.isDrawingLegend()) {
            string = string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        int n = this.m_propOthersGroupB.getCountMaxItems();
        CGSPropOthersGroupB.AggregateMode aggregateMode = this.m_propOthersGroupB.getAggregateMode();
        CGSPropOthersGroupB.ThresholdMode thresholdMode = this.m_propOthersGroupB.getThresholdMode();
        double d = this.m_propOthersGroupB.getThresholdValue();
        this.m_groupRemainingItems.setAggregatedItemLabel(string);
        this.m_groupRemainingItems.setMaxItems(n);
        this.m_groupRemainingItems.setAggregationOperation(aggregateMode);
        this.m_groupRemainingItems.setMinThresholdValue(d, thresholdMode);
        int[] nArray = new int[]{this.m_dataSeriesIndex};
        int[] nArray2 = new int[]{this.m_dataRowIndex};
        IFieldSource iFieldSource = this.m_pTableMapper.getOutputField();
        this.m_groupRemainingItems.connectInputField(iFieldSource);
        this.m_groupRemainingItems.setLabelAndSeriesIndices(this.m_dataLabelIndex, nArray);
        this.m_groupRemainingItems.setIndicesNotToAggregate(nArray2);
        this.m_groupRemainingItems.update();
        return this.m_groupRemainingItems.getOutputField();
    }

    public void applyChartProperties() {
        this.m_ovPieChart.setRenderQuality(10);
        this.m_ovPieChart.setInnerRadius((double)this.m_propChartPie.getHoleSize() / 100.0);
        this.m_ovPieChart.setStartAngle(this.m_propChartPie.getWedgeStartAngle());
        this.m_ovPieChart.setHeight(this.hasDepth() ? (double)this.getDepth() / 100.0 : 0.0);
        if (this.m_propChartPie.getShowOutline()) {
            this.m_ovPieChart.setShowBorders(true);
            this.applyOutline(this.m_ovPieChart.getLineAttributes(), this.m_propChartPie.getOutlineColor());
            if (this.m_pDrawContext.getOutputDevice().isRaster() || this.m_pDrawContext.getOutputDevice().isSVG()) {
                this.m_ovPieChart.getLineAttributes().setExcludeLinesFromImageMap(true);
            }
            if (!this.hasDepth()) {
                this.m_ovPieChart.setHeight(0.01);
            }
        } else {
            this.m_ovPieChart.setShowBorders(false);
        }
        switch (this.m_propChartPie.getBevelType()) {
            case eBevelFlat: {
                this.m_ovPieChart.setBevelStyle(PieChartBevelStyleEnum.FLAT);
                this.m_ovPieChart.setBevelType(PieChartBevelTypeEnum.BOTH);
                this.m_ovPieChart.setBevelWidth(0.2);
                break;
            }
            case eBevelRound: {
                this.m_ovPieChart.setBevelStyle(PieChartBevelStyleEnum.ROUND);
                this.m_ovPieChart.setBevelType(PieChartBevelTypeEnum.BOTH);
                this.m_ovPieChart.setBevelWidth(1.0);
                break;
            }
            default: {
                this.m_ovPieChart.setBevelStyle(PieChartBevelStyleEnum.FLAT);
                this.m_ovPieChart.setBevelType(PieChartBevelTypeEnum.NONE);
                this.m_ovPieChart.setBevelWidth(0.0);
            }
        }
        this.setLabelProperties();
        this.applyFontProperties(this.m_propChartPie, this.m_ovPieChart.getTextAttributes());
        this.applyExplodeFactorToSectors();
        this.populateDomain();
    }

    private void setLabelProperties() {
        this.m_ovPieChart.setLabelType(PieChartLabelTypeEnum.INDEX);
        if (this.m_propChartPie.getShowFeelers()) {
            this.m_ovPieChart.setShowLabelLeaders(true);
            this.applyOutline(this.m_ovPieChart.getLineAttributes(), this.m_propChartPie.getOutlineColor());
        } else {
            this.m_ovPieChart.setShowLabelLeaders(false);
        }
        if (this.m_propChartPie.getRadialLabelStyle()) {
            ((RadialLabeledPieChart)this.m_ovPieChart).setMaxNumLevels(1);
        }
        if (!this.m_propChartPie.getShowLabelsB() && this.m_propChartPie.getShowValuesB() == CGSPropChartPie.PieValueMode.ePieValueHidden) {
            this.m_ovPieChart.setLabelType(PieChartLabelTypeEnum.NONE);
        } else {
            this.m_ovPieChart.setLabelType(PieChartLabelTypeEnum.NODE_DATA);
        }
        if (this.m_propChartPie.getRadialLabelStyle()) {
            if (this.m_propChartPie.getLabelCollisionMode() == CGSPropChartPie.PieLabelCollisionMode.ePieLabelCollisionNormal) {
                ((com.avs.openviz3.cognos.RadialLabeledPieChart)this.m_ovPieChart).setLabelFitting(PieLabelFittingEnum.NORMAL);
            } else if (this.m_propChartPie.getLabelCollisionMode() == CGSPropChartPie.PieLabelCollisionMode.ePieLabelCollisionStaggerCoarse) {
                ((com.avs.openviz3.cognos.RadialLabeledPieChart)this.m_ovPieChart).setLabelFitting(PieLabelFittingEnum.COARSELY_STAGGERED);
            } else if (this.m_propChartPie.getLabelCollisionMode() == CGSPropChartPie.PieLabelCollisionMode.ePieLabelCollisionStaggerFine) {
                ((com.avs.openviz3.cognos.RadialLabeledPieChart)this.m_ovPieChart).setLabelFitting(PieLabelFittingEnum.FINELY_STAGGERED);
            } else {
                ((com.avs.openviz3.cognos.RadialLabeledPieChart)this.m_ovPieChart).setLabelFitting(PieLabelFittingEnum.NONE);
            }
            ((com.avs.openviz3.cognos.RadialLabeledPieChart)this.m_ovPieChart).setLabelFiltering(PieLabelFilteringEnum.ALL);
            ((com.avs.openviz3.cognos.RadialLabeledPieChart)this.m_ovPieChart).setAutoLayout(true);
        }
    }

    protected void applyPaletteToSectors() {
        PieChartBase.PieSeriesBase pieSeriesBase = this.getPieSeries(0);
        if (pieSeriesBase.getNumSectors() == 0) {
            return;
        }
        this.m_ovPieChart.getMaterialAttributes().setColorMap(this.getContinuousColorMap(0));
        double[] dArray = (double[])this.m_pData.getGridColumns()[this.m_dataSeriesIndex];
        int n = 0;
        boolean bl = this.m_propChartPie.getShowClockwise();
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            PieChartBase.PieSectorBase pieSectorBase = null;
            if (Double.isNaN(dArray[i]) || !this.m_pDrawContext.isDrawingLegend() && !((pieSectorBase = this.getPieSector(pieSeriesBase, n)) instanceof ISurfaceFaceAttributeSceneNode)) continue;
            int n3 = bl ? n2 - 1 - i : i;
            this.applyPalette(n3, 0, 0, (ISurfaceFaceAttributeSceneNode)pieSectorBase);
            ++n;
        }
    }

    private void applyExplodeFactorToSectors() {
        if (!this.m_pData.hasPieExplodeColumn()) {
            return;
        }
        PieChartBase.PieSeriesBase pieSeriesBase = this.getPieSeries(0);
        if (pieSeriesBase.getNumSectors() == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = this.m_ovPieChart.getOuterRadius();
        int[] nArray = (int[])this.m_pData.getGridColumns()[this.m_dataRowIndex];
        double[] dArray = (double[])this.m_pData.getGridColumns()[this.m_dataSeriesIndex];
        double d3 = this.m_pData.getNumGroupedRows() > 0 ? (double)(nArray.length - 1) : (double)nArray.length;
        int n3 = 0;
        int n4 = 0;
        while ((double)n4 < d3) {
            n2 = this.m_pData.getTableRowIndex(nArray[n4], this.m_dataSeriesIndex);
            n = this.m_pData.getPieExplodeValue(n2);
            d = d2 * ((double)n / 100.0);
            PieChartBase.PieSectorBase pieSectorBase = this.getPieSector(pieSeriesBase, n4 - n3);
            if (pieSectorBase != null) {
                pieSectorBase.setExplodeScale(d);
            }
            if (Double.isNaN(dArray[n4])) {
                ++n3;
            }
            ++n4;
        }
    }

    @Override
    protected int getPaletteIndex(int n, int n2, int n3) {
        return n2;
    }

    protected void populateLegend() {
        if (this.useContinuousPalette()) {
            return;
        }
        GRLegend gRLegend = this.m_pDrawContext.getLegend();
        if (gRLegend == null) {
            return;
        }
        CGSPropLegend cGSPropLegend = (CGSPropLegend)this.m_pWidget.getBaseProp().getProp(CGSEnums.PropType.ePropLegend);
        CGSPropLegendItem cGSPropLegendItem = (CGSPropLegendItem)cGSPropLegend.getProp(CGSEnums.PropType.ePropLegendItem);
        String string = cGSPropLegendItem.getSeparator();
        Object[] objectArray = this.m_pData.getGridColumns();
        double[] dArray = (double[])objectArray[this.m_dataSeriesIndex];
        boolean bl = this.m_propChartPie.getShowClockwise();
        int n = bl ? dArray.length - 1 : 0;
        int n2 = bl ? -1 : 1;
        int n3 = dArray.length;
        for (int i = n; i >= 0 && i <= dArray.length - 1; i += n2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < objectArray.length; ++j) {
                if (this.m_pData.getGridColumnType(j) != 1) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                Object[] objectArray2 = (Object[])objectArray[j];
                stringBuilder.append(objectArray2[i]);
            }
            GRLegendItemIcon gRLegendItemIcon = new GRLegendItemIcon();
            gRLegendItemIcon.dataPointShapeB = CGSEnums.MarkerShapeB.eMarkerSquareB;
            int n4 = bl ? dArray.length - 1 - i : i;
            gRLegendItemIcon.dataPointShapeFill = this.getFillEffect(n4, CGSEnums.PropType.ePropPaletteDiscreteB, true);
            gRLegendItemIcon.dataPointShapeOutlineColor = this.getOutlineColor(0);
            gRLegendItemIcon.materialEffect = this.m_propChartPie.getMaterialEffect();
            int[] nArray = (int[])objectArray[this.m_dataRowIndex];
            int n5 = this.m_pData.getNumGroupedRows() > 0 && i == n3 - 1 ? -1 : this.m_pData.getTableRowIndex(nArray[i], this.m_dataSeriesIndex);
            boolean bl2 = this.m_pWidget.isDetectionAreaRequired(CGSEnums.DetArea.eDetLegendLabel, 0);
            if (this.m_pData.getCategoryCount(0) == 0 && this.m_pData.getSeriesCount(0) == 1) {
                String string2 = this.m_pData.getAxisTitle(1);
                gRLegend.addChartItem(string2, gRLegendItemIcon, n5, bl2);
                break;
            }
            gRLegend.addChartItem(stringBuilder.toString(), gRLegendItemIcon, n5, bl2);
        }
    }

    @Override
    protected void populateWorkbox() {
        if (this.m_domain != null) {
            this.m_pWorkbox.addChild((ISceneNode)this.m_domain);
        }
    }

    protected void populateDomain() {
        this.m_domain = new Domain();
        this.m_domain.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_domain.connectXAxisMap((IAxisMapSource)this.m_ovPieChart.getOutputXAxisMap());
        this.m_domain.connectYAxisMap((IAxisMapSource)this.m_ovPieChart.getOutputYAxisMap());
        this.m_domain.addChild((ISceneNode)this.m_ovPieChart);
        this.m_domain.setUniformAxes(UniformAxesEnum.XY_AXES);
        this.m_domain.setUniformAxisMode(UniformAxisModeEnum.COORDINATE_UNIFORM);
    }

    @Override
    protected void populateViewport() {
        this.createViewport();
        this.m_ovViewport.setMaintainAspectRatio(true);
        this.m_ovViewport.addChild((ISceneNode)this.m_pWorkbox);
        this.m_pDrawContext.getContainer().setCenter((IManageableComponentSceneNode)this.m_ovViewport);
    }

    @Override
    protected void postSceneTreeBuild() {
        super.postSceneTreeBuild();
        this.applyPaletteToSectors();
    }

    private PieChartBase.PieSeriesBase getPieSeries(int n) {
        Object object = this.m_propChartPie.getRadialLabelStyle() ? ((com.avs.openviz3.cognos.RadialLabeledPieChart)this.m_ovPieChart).getSeries(n) : ((SideLabeledPieChart)this.m_ovPieChart).getSeries(n);
        return object;
    }

    private PieChartBase.PieSectorBase getPieSector(PieChartBase.PieSeriesBase pieSeriesBase, int n) {
        Object object = null;
        if (n <= pieSeriesBase.getMaxChildIndex()) {
            object = this.m_propChartPie.getRadialLabelStyle() ? ((RadialLabeledPieChart.RadialLabeledPieSeries)pieSeriesBase).getSector(n) : ((SideLabeledPieChart.SideLabeledPieSeries)pieSeriesBase).getSector(n);
        }
        return object;
    }

    @Override
    protected Color getOutlineColor(int n) {
        return this.m_propChartPie.getShowOutline() ? this.m_propChartPie.getOutlineColor() : null;
    }

    @Override
    protected float getDepth() {
        return this.m_propChartPie.getDepth();
    }

    @Override
    protected boolean is3DViewportRequired() {
        return this.hasDepth();
    }
}

