/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.chart.AnchorPointDepthPositionEnum;
import com.avs.openviz3.chart.ScatterChart;
import com.avs.openviz3.fw.PointFloat3;
import com.avs.openviz3.fw.base.IAttributeSceneNode;
import com.avs.openviz3.fw.base.IAxisMapSource;
import com.avs.openviz3.fw.base.UnitsEnum;
import com.avs.openviz3.glyphs.IGlyph;
import com.ibm.cgsBus.DrawContext.DCDrawContextOV;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.DrawContext.OVScatterBase;
import com.ibm.cgsBus.FrameWork.CGSDataMultimeasure;
import com.ibm.cgsBus.Properties.CGSPropChart;
import com.ibm.cgsBus.Properties.CGSPropChartScatter;
import com.ibm.cgsBus.Properties.CGSPropDataLabelsB;
import com.ibm.cgsBus.Properties.CGSPropRegressionLinesB;
import com.ibm.cgsBus.Types.CGSEnums;
import java.awt.Color;

public class OVScatterChart
extends OVScatterBase {
    protected CGSPropChartScatter m_propChartScatter = null;
    protected Float m_glyphSize = null;

    public OVScatterChart(DCDrawContextOV dCDrawContextOV) {
        super(dCDrawContextOV);
    }

    @Override
    protected void init(DCDrawContextOV dCDrawContextOV) {
        super.init(dCDrawContextOV);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_propChartScatter = null;
        this.m_glyphSize = null;
    }

    @Override
    public void applyProperties() {
        super.applyProperties();
        OVHelper.applyMaterialEffect((IAttributeSceneNode)this.m_ovScatterChart, this.m_propChartScatter.getMaterialEffect());
        this.populateLegend(this.m_propChartScatter.getDataPointMode(), this.m_propChartScatter.getDataPointShapeB());
        this.createMarkers(this.m_propChartScatter.getMarkerList());
        this.createRegressionLines();
    }

    @Override
    protected void getProperties() {
        this.m_propChartScatter = (CGSPropChartScatter)this.getChart();
        this.m_propDataLabels = (CGSPropDataLabelsB)this.m_propChartScatter.getProp(CGSEnums.PropType.ePropDataLabelsB);
    }

    @Override
    protected void addChartData() {
        int n = this.m_pData.getGridColumnCount();
        int n2 = ((CGSDataMultimeasure)this.m_pData).getPointCount();
        int n3 = 0;
        this.m_glyphs = new IGlyph[n2];
        Object[] objectArray = this.m_pData.getGridNulls();
        for (int i = 0; i < n - 1; ++i) {
            int n4 = this.m_pData.getGridColumnType(i);
            int n5 = this.m_pData.getGridColumnType(i + 1);
            if (n4 != 4 || n5 != 4) continue;
            if (objectArray[i] != null && objectArray[i + 1] != null) {
                int n6;
                ScatterChart.ScatterSeries scatterSeries = this.m_ovScatterChart.newSeries(i, i + 1, -1);
                scatterSeries.setGlyphIndex(Integer.valueOf(this.m_dataRowIndex));
                int n7 = this.getColorByValueIndex(i);
                if (n7 != -1) {
                    scatterSeries.setColorIndex(Integer.valueOf(n7));
                }
                for (n6 = 0; n6 < n2; ++n6) {
                    this.addGlyph(n6, n3, this.m_propChartScatter.getDataPointShapeB(), this.m_propChartScatter.getDataPointMode(), false, this.m_propChartScatter.getShowOutline(), this.m_propChartScatter.getOutlineColor(), this.getGlyphSize());
                }
                n6 = this.m_pData.getShowDataValueColumn(i);
                this.setLabelTemplate(n3, n6, n6 + 1);
                this.addSeriesImageTemplate();
                scatterSeries.getLabelProperties().setAnchorPointDepthPosition(AnchorPointDepthPositionEnum.FRONT);
                scatterSeries.getLabelProperties().setAnchorPointHeightPosition(OVHelper.getLabelAnchorPosition(this.m_propChartScatter.getDataTextLocation()));
                OVScatterChart.setLabelCollisionMode(scatterSeries, this.m_propDataLabels, this.m_ovScatterChart.getLabelProperties());
                ++n3;
            }
            ++i;
        }
    }

    private void setLabelTemplate(int n, int n2, int n3) {
        String string = "";
        CGSDataMultimeasure cGSDataMultimeasure = (CGSDataMultimeasure)this.m_pData;
        string = this.getCategoryLabelTemplate(cGSDataMultimeasure, this.m_propChartScatter.getShowCategoryData());
        string = string + this.getSeriesLabelTemplate(cGSDataMultimeasure, this.m_propChartScatter.getShowSeriesData());
        String string2 = cGSDataMultimeasure.getAxisTitle(0);
        string = string + this.getMeasurelLabelTemplate(string2, n2, this.m_propChartScatter.getShowMeasureData());
        String string3 = cGSDataMultimeasure.getAxisTitle(1);
        string = string + this.getMeasurelLabelTemplate(string3, n3, this.m_propChartScatter.getShowMeasureData());
        this.m_ovScatterChart.getSeries(n).setLabelTemplate(string);
    }

    @Override
    protected void applyChartProperties() {
        OVScatterChart.setChartLevelLabelProperties(this.m_propDataLabels, this.m_ovScatterChart.getLabelProperties());
        this.applyFontProperties(this.m_propChartScatter, this.m_ovScatterChart.getTextAttributes());
        this.setSeriesGlyphMap();
        this.setDataPointSize();
        this.m_ovScatterChart.getMaterialAttributes().setColorMap(this.getContinuousColorMap(0));
    }

    protected void setDataPointSize() {
        float f = this.getGlyphSize();
        this.m_ovScatterChart.getGlyphAttributes().setGlyphSizeUnits(UnitsEnum.POINT);
        this.m_ovScatterChart.getGlyphAttributes().setGlyphSize(new PointFloat3(f, f, f));
    }

    @Override
    protected void calculateBubbleSizeScale() {
    }

    protected float getGlyphSize() {
        return (float)this.m_propChartScatter.getDataPointSize();
    }

    @Override
    protected final void createAxis() {
        this.m_pAxisMapX = this.m_ovScatterChart.getOutputXAxisMap();
        this.addOutputValueAxisMap((IAxisMapSource)this.m_ovScatterChart.getOutputYAxisMap(), 1);
        this.setOutputSeriesAxisMap((IAxisMapSource)this.m_ovScatterChart.getOutputSeriesAxisMap());
        this.createAxesXY(CGSEnums.PropType.ePropNumericAxisX, CGSEnums.PropType.ePropNumericAxisY);
        if (this.m_pDrawContext.isDrawingLegend()) {
            return;
        }
        this.m_ovScatterChart.connectInputXAxisMap(this.m_pAxisMapX);
        this.m_ovScatterChart.connectInputYAxisMap(this.m_pAxisMapTopLeft);
    }

    @Override
    protected CGSPropRegressionLinesB getRegressionLines() {
        return (CGSPropRegressionLinesB)this.m_propChartScatter.getProp(CGSEnums.PropType.ePropRegressionLinesB);
    }

    @Override
    protected CGSPropChart.MaterialEffect getMaterialEffect() {
        return this.m_propChartScatter.getMaterialEffect();
    }

    @Override
    protected Color getOutlineColor(int n) {
        return this.m_propChartScatter.getShowOutline() ? this.m_propChartScatter.getOutlineColor() : null;
    }
}

