/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.EntryPoint;

import com.ibm.cgsBus.EntryPoint.EPRequest;
import com.ibm.cgsBus.EntryPoint.EPStream;
import com.ibm.cgsBus.FrameWork.CGSMain;
import com.ibm.cgsBus.Graphics.GRHelper;
import com.ibm.cgsBus.Logging.CGSConsoleLogger;
import com.ibm.cgsBus.Logging.CGSLogging;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class EPPort {
    private static boolean s_isEmbedded = false;
    private boolean m_running = true;
    private InetAddress m_addr = null;
    private int m_port = 0;
    private int m_readyPort = 0;
    private ServerSocket m_pServerSocket = null;

    public static void main(String[] stringArray) {
        boolean bl;
        if (stringArray.length != 1 && stringArray.length != 2 && stringArray.length != 3) {
            System.out.println("This program should not be executable directly .. it forms part of the Cognos 8 package.");
            return;
        }
        int n = Integer.parseInt(stringArray[0]);
        if (n <= 0) {
            CGSLogging.set(new CGSConsoleLogger());
            CGSLogging.setOutputEnabled(true);
            CGSLogging.setLevel(1);
            n = -n;
        } else {
            CGSLogging.setOutputEnabled(false);
        }
        if (stringArray.length > 1) {
            bl = Boolean.parseBoolean(stringArray[1]);
            CGSMain.setForceAndale(bl);
            CGSLogging.logInfo("Force Andale = " + bl);
        }
        if (stringArray.length > 2) {
            bl = Boolean.parseBoolean(stringArray[2]);
            CGSMain.setGetImageMap(bl);
            CGSLogging.logInfo("Get Image Map = " + bl);
        }
        System.setProperty("java.awt.headless", "true");
        EPPort ePPort = new EPPort(n);
        ePPort.run();
        ePPort.destroy();
        System.exit(0);
    }

    public static String getExceptionText(Exception exception) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Error: " + exception.getMessage() + " : " + exception.getCause() + "\n");
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuilder.append("at " + stackTraceElementArray[i].getClassName() + "(" + stackTraceElementArray[i].getFileName() + ":" + stackTraceElementArray[i].getLineNumber() + ")\n");
        }
        return stringBuilder.toString();
    }

    public EPPort(int n) {
        this.m_readyPort = n;
    }

    public void destroy() {
        this.m_addr = null;
        this.m_pServerSocket = null;
    }

    public void run() {
        try {
            this.m_addr = InetAddress.getByName(null);
            String string = this.m_addr.getHostName();
            if (s_isEmbedded) {
                CGSLogging.logInfo("  Loopback CGS Java service started.");
            } else {
                CGSLogging.logInfo("CGS Java service started.");
            }
            CGSLogging.logInfo("  Machine: " + string);
            CGSLogging.logInfo("  JRE: " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")" + " (" + System.getProperty("java.home") + ")");
            CGSLogging.logInfo("  JRE Class Path: " + System.getProperty("java.class.path"));
            GRHelper.setJavaFontNames();
            if (!this.createSocket()) {
                return;
            }
            CGSLogging.logInfo("  Ready Port: " + this.m_readyPort);
            this.sendReadyMessage();
            CGSLogging.logInfo("... waiting for requests ");
            this.processRequests();
            this.destroySocket();
            CGSLogging.logInfo("CGS Java service stopped.");
        }
        catch (Exception exception) {
            CGSLogging.logError("Unexpected exception occured in charting service java component.\n" + EPPort.getExceptionText(exception));
        }
    }

    public static int startPortThread() {
        class PortThread
        extends Thread {
            public EPPort m_portObject = null;

            PortThread() {
            }

            public void create() {
                this.setDaemon(true);
                this.start();
            }

            @Override
            public void run() {
                s_isEmbedded = true;
                this.m_portObject = new EPPort(0);
                this.m_portObject.run();
                this.m_portObject.destroy();
            }
        }
        PortThread portThread = new PortThread();
        portThread.create();
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!portThread.isAlive() || portThread.m_portObject == null || portThread.m_portObject.m_port <= 0);
        return portThread.m_portObject.m_port;
    }

    private boolean createSocket() {
        try {
            this.m_pServerSocket = new ServerSocket(0);
            this.m_port = this.m_pServerSocket.getLocalPort();
            CGSLogging.logInfo("  Port: " + this.m_port);
            if (this.m_readyPort != 0) {
                CGSLogging.logInfo("  Socket timeout: 10 min");
                this.m_pServerSocket.setSoTimeout(600000);
            }
        }
        catch (SocketException socketException) {
            CGSLogging.logError("Unable to set socket timeout.");
            return false;
        }
        catch (IOException iOException) {
            CGSLogging.logError("Unable to open port for charting service java component.");
            return false;
        }
        return true;
    }

    private boolean destroySocket() {
        try {
            this.m_pServerSocket.close();
        }
        catch (IOException iOException) {
            CGSLogging.logError("Unable to close port " + this.m_port + " used by charting service java component.");
            return false;
        }
        return true;
    }

    private void sendReadyMessage() {
        if (this.m_readyPort != 0) {
            Socket socket = null;
            try {
                socket = new Socket(this.m_addr, this.m_readyPort);
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(this.m_port & 0xFF);
                outputStream.write((this.m_port & 0xFF00) >> 8);
                outputStream.write((this.m_port & 0xFF0000) >> 16);
                outputStream.write((this.m_port & 0xFF000000) >> 24);
            }
            catch (IOException iOException) {
                CGSLogging.logError("Unable to send ready message using port " + this.m_readyPort + " from charting service java component.");
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        CGSLogging.logError("Unable to close Socket " + this.m_readyPort + " from charting service java component.");
                    }
                }
            }
        }
    }

    private void processRequests() {
        while (this.m_running) {
            try {
                int n;
                int n2;
                Socket socket = this.m_pServerSocket.accept();
                InputStream inputStream = socket.getInputStream();
                int n3 = 8;
                byte[] byArray = new byte[n3];
                for (n = n3; n != 0; n -= n2) {
                    n2 = inputStream.read(byArray, n3 - n, n);
                    if (n2 != -1) continue;
                    CGSLogging.logError("Unexpected end of stream found when reading request in charting service java component.");
                    inputStream.close();
                    return;
                }
                EPStream ePStream = new EPStream(byArray);
                int n4 = ePStream.readInt32();
                int n5 = ePStream.readInt32();
                CGSLogging.logInfo("... reading request, output goes to port " + n4);
                if (n4 == 0) {
                    this.m_running = false;
                } else {
                    int n6;
                    byte[] byArray2 = new byte[n5];
                    for (n = n5; n != 0; n -= n6) {
                        n6 = inputStream.read(byArray2, n5 - n, n);
                        if (n6 != -1) continue;
                        CGSLogging.logError("Unexpected end of stream found when reading request in charting service java component.");
                        inputStream.close();
                        return;
                    }
                    EPRequest ePRequest = new EPRequest(n4, this.m_addr, byArray2);
                    ePRequest.start();
                }
                inputStream.close();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                CGSLogging.logError("Timeout waiting for request.  Shutting down...");
                this.m_running = false;
            }
            catch (IOException iOException) {
                CGSLogging.logError("Unable to read request in charting service java component.");
            }
        }
    }
}

