/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.EntryPoint;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.ibm.ba.vis.service.VisualizationService;
import com.ibm.ba.vis.service.VisualizationServiceFactory;
import com.ibm.ba.vis.service.gallery.FileGallery;
import com.ibm.ba.vis.service.gallery.Gallery;
import com.ibm.cgsBus.Common.CMByteBuffer;
import com.ibm.cgsBus.FrameWork.CGSCanvas;
import com.ibm.cgsBus.Logging.CGSLogging;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

public class EPRequest
extends Thread {
    private static final String MAP = "map";
    private static final String PNG = "png";
    private static final String IMAGEMAP_XML = "imagemap.xml";
    private static final String IMAGEMAP = "imagemap";
    private static final String IMAGE_PNG = "image.png";
    public static final int SUCCESS = 0;
    public static final int EXCEPTION = 1;
    private int m_retPort = 0;
    private InetAddress m_retIPAddr = null;
    private byte[] m_pRequest = null;

    public EPRequest(int n, InetAddress inetAddress, byte[] byArray) {
        this.m_retPort = n;
        this.m_retIPAddr = inetAddress;
        this.m_pRequest = (byte[])byArray.clone();
    }

    public void destroy() {
        this.m_retIPAddr = null;
        this.m_pRequest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket socket = null;
        try {
            socket = new Socket(this.m_retIPAddr, this.m_retPort);
            String string = null;
            try {
                string = new String(this.m_pRequest, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Unable to parse UTF-8 characters in string.");
            }
            if (string.startsWith("<cgsJava")) {
                this.doRenderInCGSCanvas(socket, string);
            } else {
                this.doRenderInCGSExtensibleCanvas(socket, string);
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                CGSLogging.logError("Unable to close return port (" + this.m_retPort + ") when handling a request in charting service java component.");
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException2) {
                        CGSLogging.logError("Unable to close Socket (" + this.m_retPort + ") when handling a request in charting service java component.");
                    }
                }
                this.destroy();
                return;
            }
        }
        catch (IOException iOException) {
            CGSLogging.logError("Unable to open return port (" + this.m_retPort + ") when handling a request in charting service java component.");
            return;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    CGSLogging.logError("Unable to close Socket (" + this.m_retPort + ") when handling a request in charting service java component.");
                }
            }
            this.destroy();
        }
    }

    private void doRenderInCGSExtensibleCanvas(Socket socket, String string) {
        CGSLogging.logInfo("... drawing extensible");
        String string2 = CCLConfigurationFactory.getInstance().resolveEffectivePath("../");
        FileGallery fileGallery = new FileGallery(string2);
        VisualizationService visualizationService = VisualizationServiceFactory.getService((Gallery)fileGallery, null);
        Map map = visualizationService.generate(string, IMAGEMAP);
        try {
            CGSLogging.logInfo("... sending output through port");
            OutputStream outputStream = socket.getOutputStream();
            CMByteBuffer cMByteBuffer = new CMByteBuffer();
            CMByteBuffer cMByteBuffer2 = new CMByteBuffer();
            cMByteBuffer.appendInt(0);
            cMByteBuffer.appendInt(map.size());
            for (String string3 : map.keySet()) {
                cMByteBuffer2.reset();
                if (string3.equalsIgnoreCase(IMAGE_PNG)) {
                    cMByteBuffer2.appendRawString(PNG);
                } else if (string3.equalsIgnoreCase(IMAGEMAP_XML)) {
                    cMByteBuffer2.appendRawString(MAP);
                }
                byte[] byArray = (byte[])map.get(string3);
                cMByteBuffer2.appendBytes(byArray);
                cMByteBuffer.appendInt(cMByteBuffer2.pcount());
                cMByteBuffer.appendBytes(cMByteBuffer2.str());
                byArray = null;
            }
            outputStream.write(cMByteBuffer.str());
        }
        catch (Exception exception) {
            CGSLogging.logError("Unable to write to return port (" + this.m_retPort + ") when handling a request in charting service java component.");
            return;
        }
    }

    private void doRenderInCGSCanvas(Socket socket, String string) {
        Object object;
        byte[] byArray = null;
        try {
            CGSLogging.logInfo("... drawing");
            object = new CGSCanvas("en-us");
            byArray = ((CGSCanvas)object).drawAsBytes(string);
        }
        catch (InterruptedException interruptedException) {
            CGSLogging.logError("Unable to generate image in charting service java component.");
            return;
        }
        try {
            CGSLogging.logInfo("... sending output through port");
            object = socket.getOutputStream();
            ByteBuffer byteBuffer = ByteBuffer.allocate(12);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(0);
            byteBuffer.putInt(1);
            byteBuffer.putInt(byArray.length);
            ((OutputStream)object).write(byteBuffer.array());
            ((OutputStream)object).write(byArray);
            CGSLogging.logInfo("... output sent through port (" + byArray.length + " bytes)");
            byArray = null;
        }
        catch (Exception exception) {
            CGSLogging.logError("Unable to write to return port (" + this.m_retPort + ") when handling a request in charting service java component.");
            return;
        }
    }
}

