/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.FrameWork;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.FrameWork.CGSWidget;
import com.ibm.cgsBus.FrameWork.CGSWidgetRef;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeEnum;
import java.awt.Point;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class CGSDetectArea
implements Comparator<CGSDetectArea> {
    private CGSEnums.DetArea m_type;
    private CGSWidget.DataType m_dataType;
    private int m_id;
    private int m_row;
    private int m_col;
    private CGSWidget.DataTableId m_dataTableId;
    private int m_widgetIndex;
    private Point[] m_points;
    private ArrayList<Integer> m_formattedValueColumns;
    private ArrayList<String> m_formattedValues;
    private CGSWidgetRef m_widget;
    private Vector<CGSEnums.DetArea> m_detOrder;
    private int m_firstSortIndex;
    private int m_secondIndex;

    public CGSDetectArea(CGSEnums.DetArea detArea, CGSWidget.DataType dataType, int n, Point[] pointArray, int n2, int n3, CGSWidget.DataTableId dataTableId, int n4, CGSWidgetRef cGSWidgetRef) {
        this.m_type = detArea;
        this.m_dataType = dataType;
        this.m_id = n;
        this.setPoints(pointArray);
        this.m_row = n2;
        this.m_col = n3;
        this.m_dataTableId = dataTableId;
        this.m_widgetIndex = n4;
        this.m_formattedValueColumns = new ArrayList(0);
        this.m_formattedValues = new ArrayList(0);
        this.m_widget = cGSWidgetRef;
        this.createDetectionOrderVector();
    }

    private void createDetectionOrderVector() {
        this.m_detOrder = new Vector(7);
        this.m_detOrder.add(CGSEnums.DetArea.eDetChartElement);
        this.m_detOrder.add(CGSEnums.DetArea.eDetDiscreteAxisLabel);
        this.m_detOrder.add(CGSEnums.DetArea.eDetDiscreteAxisTitle);
        this.m_detOrder.add(CGSEnums.DetArea.eDetNumericAxisTitle);
        this.m_detOrder.add(CGSEnums.DetArea.eDetLegendLabel);
        this.m_detOrder.add(CGSEnums.DetArea.eDetLegendTitle);
        this.m_detOrder.add(CGSEnums.DetArea.eDetTitle);
    }

    public CGSEnums.DetArea getType() {
        return this.m_type;
    }

    public CGSWidget.DataType getDataType() {
        return this.m_dataType;
    }

    public int getWidgetIndex() {
        return this.m_widgetIndex;
    }

    public int getId() {
        return this.m_id;
    }

    public int getDataRowIndex() {
        return this.m_row;
    }

    public int getDataColumnIndex() {
        return this.m_col;
    }

    public CGSWidget.DataTableId getDataTableId() {
        return this.m_dataTableId;
    }

    public Point[] getPoints() {
        return this.m_points;
    }

    public void setPoints(Point[] pointArray) {
        this.m_points = pointArray;
        if (this.m_points == null) {
            this.m_points = new Point[0];
        }
    }

    public CGSWidgetRef getWidget() {
        return this.m_widget;
    }

    public void setWidget(CGSWidgetRef cGSWidgetRef) {
        this.m_widget = cGSWidgetRef;
    }

    public void setWidgetIndex(int n) {
        this.m_widgetIndex = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("************************ DectectArea ************************\n");
        stringBuilder.append("type: " + CGSDetectArea.getDetAreaString(this.m_type) + ", ");
        stringBuilder.append("dataType: " + (Object)((Object)this.m_dataType) + ", ");
        stringBuilder.append("id: " + this.m_id + ", ");
        stringBuilder.append("row: " + this.m_row + ", ");
        stringBuilder.append("col: " + this.m_col + ", ");
        stringBuilder.append("dataTableId: " + (Object)((Object)this.m_dataTableId) + ", ");
        stringBuilder.append("widgetIndex: " + this.m_widgetIndex + "\n");
        stringBuilder.append("points: ");
        stringBuilder.append("[");
        for (int i = 0; i < this.m_points.length; ++i) {
            stringBuilder.append("[");
            stringBuilder.append(this.m_points[i].x);
            stringBuilder.append(" ");
            stringBuilder.append(this.m_points[i].y);
            stringBuilder.append("]");
        }
        stringBuilder.append("]\n");
        Iterator<Integer> iterator = this.m_formattedValueColumns.iterator();
        Iterator<String> iterator2 = this.m_formattedValues.iterator();
        while (iterator2.hasNext()) {
            stringBuilder.append("formattedValues[");
            stringBuilder.append(iterator.next());
            stringBuilder.append("]: ");
            stringBuilder.append(iterator2.next());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String formattedValuesToString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Integer> iterator = this.m_formattedValueColumns.iterator();
        Iterator<String> iterator2 = this.m_formattedValues.iterator();
        while (iterator2.hasNext()) {
            stringBuilder.append("[");
            stringBuilder.append(iterator.next());
            stringBuilder.append(" ");
            stringBuilder.append(iterator2.next());
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public static String getDetAreaString(CGSEnums.DetArea detArea) {
        switch (detArea) {
            case eDetNone: {
                return "eDetNone";
            }
            case eDetChartElement: {
                return "eDetChartElement";
            }
            case eDetDiscreteAxisTitle: {
                return "eDetDiscreteAxisTitle";
            }
            case eDetDiscreteAxisLabel: {
                return "eDetDiscreteAxisLabel";
            }
            case eDetLegendTitle: {
                return "eDetLegendTitle";
            }
            case eDetLegendLabel: {
                return "eDetLegendLabel";
            }
            case eDetNumericAxisTitle: {
                return "eDetNumericAxisTitle";
            }
        }
        throw new Error("invalid DetArea type");
    }

    public int hashCode() {
        CMHelper.CGS_ASSERT(false, "hashCode() not implemented for CGSDetectArea");
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        Point[] pointArray;
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CGSDetectArea)) {
            return false;
        }
        CGSDetectArea cGSDetectArea = (CGSDetectArea)object;
        boolean bl = true;
        if (this.m_type != cGSDetectArea.getType() || this.m_dataType != cGSDetectArea.getDataType() || this.m_id != cGSDetectArea.getId() || this.m_row != cGSDetectArea.getDataRowIndex() || this.m_col != cGSDetectArea.getDataColumnIndex() || this.m_dataTableId != cGSDetectArea.getDataTableId() || this.m_widgetIndex != cGSDetectArea.getWidgetIndex()) {
            bl = false;
        }
        if ((pointArray = cGSDetectArea.getPoints()).length == this.m_points.length) {
            for (int i = 0; i < this.m_points.length; ++i) {
                if (this.m_points[i].x == pointArray[i].x && this.m_points[i].y == pointArray[i].y) continue;
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!this.m_formattedValues.equals(cGSDetectArea.m_formattedValues) || !this.m_formattedValueColumns.equals(cGSDetectArea.m_formattedValueColumns)) {
            bl = false;
        }
        return bl;
    }

    public void test() {
        byte[] byArray = this.encode();
        CGSDetectArea cGSDetectArea = CGSDetectArea.decode(ByteBuffer.wrap(byArray));
        if (this.equals(cGSDetectArea)) {
            System.out.println("TEST PASSED ORIGINAL MATCHES ENCODED/DECODED VALUE");
        } else {
            System.out.println("TEST FAILED ORIGINAL DOES NOT MATCH ENCODED/DECODED VALUE");
        }
    }

    public static CGSDetectArea decode(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        CGSEnums.DetArea detArea = CGSTypeEnum.decode(CGSEnums.DetArea.class, byteBuffer.getInt());
        CGSWidget.DataType dataType = CGSTypeEnum.decode(CGSWidget.DataType.class, byteBuffer.getInt());
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        CGSWidget.DataTableId dataTableId = CGSTypeEnum.decode(CGSWidget.DataTableId.class, byteBuffer.getInt());
        int n4 = byteBuffer.getInt();
        int n5 = byteBuffer.getInt();
        Point[] pointArray = new Point[n5];
        for (int i = 0; i < pointArray.length; ++i) {
            pointArray[i] = new Point(byteBuffer.getInt(), byteBuffer.getInt());
        }
        CGSDetectArea cGSDetectArea = new CGSDetectArea(detArea, dataType, n, pointArray, n2, n3, dataTableId, n4, null);
        int n6 = byteBuffer.getInt();
        for (int i = 0; i < n6; ++i) {
            int n7 = byteBuffer.getInt();
            int n8 = byteBuffer.getInt();
            byte[] byArray = new byte[n8];
            byteBuffer.get(byArray, 0, n8);
            String string = new String(byArray);
            cGSDetectArea.addFormattedValue(n7, string);
        }
        return cGSDetectArea;
    }

    public byte[] encode() {
        int n = 4;
        int n2 = 9 + this.m_points.length * 2 + this.m_formattedValues.size() * 2;
        String string = "UTF8";
        int n3 = n2 * n;
        for (String string2 : this.m_formattedValues) {
            try {
                n3 += string2.getBytes(string).length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                n3 += string2.getBytes().length;
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(this.m_type.getValue());
        byteBuffer.putInt(this.m_dataType.getValue());
        byteBuffer.putInt(this.m_id);
        byteBuffer.putInt(this.m_row);
        byteBuffer.putInt(this.m_col);
        byteBuffer.putInt(this.m_dataTableId.getValue());
        byteBuffer.putInt(this.m_widgetIndex);
        byteBuffer.putInt(this.m_points.length);
        for (int i = 0; i < this.m_points.length; ++i) {
            byteBuffer.putInt(this.m_points[i].x);
            byteBuffer.putInt(this.m_points[i].y);
        }
        byteBuffer.putInt(this.m_formattedValues.size());
        int n4 = 0;
        Iterator<Integer> iterator = this.m_formattedValueColumns.iterator();
        Iterator<String> iterator2 = this.m_formattedValues.iterator();
        while (iterator2.hasNext()) {
            byte[] byArray;
            String string2;
            n4 = iterator.next();
            string2 = iterator2.next();
            try {
                byArray = string2.getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string2.getBytes();
            }
            byteBuffer.putInt(n4);
            byteBuffer.putInt(byArray.length);
            byteBuffer.put(byArray);
        }
        return byteBuffer.array();
    }

    private void addFormattedValue(int n, String string) {
        this.m_formattedValueColumns.add(n);
        this.m_formattedValues.add(string);
    }

    public void addFormattedValues(HashMap<Integer, String> hashMap) {
        if (hashMap != null) {
            Iterator<Map.Entry<Integer, String>> iterator = hashMap.entrySet().iterator();
            for (int i = 0; i < hashMap.size(); ++i) {
                Map.Entry<Integer, String> entry = iterator.next();
                int n = entry.getKey();
                String string = hashMap.get(entry.getKey());
                this.addFormattedValue(n, string);
            }
        }
    }

    public int getFormattedValuesCount() {
        return this.m_formattedValues.size();
    }

    public HashMap<Integer, String> getFormattedValues() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>(this.m_formattedValues.size());
        Iterator<Integer> iterator = this.m_formattedValueColumns.iterator();
        Iterator<String> iterator2 = this.m_formattedValues.iterator();
        while (iterator2.hasNext()) {
            hashMap.put(iterator.next(), iterator2.next());
        }
        return hashMap;
    }

    @Override
    public int compare(CGSDetectArea cGSDetectArea, CGSDetectArea cGSDetectArea2) {
        int n = 0;
        n = cGSDetectArea.getType() == cGSDetectArea2.getType() ? (cGSDetectArea.getType() == CGSEnums.DetArea.eDetChartElement && cGSDetectArea2.getType() == CGSEnums.DetArea.eDetChartElement ? (cGSDetectArea.m_secondIndex == cGSDetectArea2.m_secondIndex ? 0 : (cGSDetectArea.m_secondIndex < cGSDetectArea2.m_secondIndex ? -1 : 1)) : (cGSDetectArea.m_firstSortIndex == cGSDetectArea2.m_firstSortIndex ? (cGSDetectArea.m_secondIndex == cGSDetectArea2.m_secondIndex ? 0 : (cGSDetectArea.m_secondIndex < cGSDetectArea2.m_secondIndex ? -1 : 1)) : (cGSDetectArea.m_firstSortIndex < cGSDetectArea2.m_firstSortIndex ? -1 : 1))) : (this.m_detOrder.indexOf((Object)cGSDetectArea.getType()) > this.m_detOrder.indexOf((Object)cGSDetectArea2.getType()) ? -1 : 1);
        return n;
    }

    public void setFirstSortIndex(int n) {
        this.m_firstSortIndex = n;
    }

    public void setSecondSortIndex(int n) {
        this.m_secondIndex = n;
    }

    public String getFormattedStringByIndex(int n) {
        CMHelper.CGS_ASSERT(n < this.m_formattedValues.size(), "invalid index");
        return this.m_formattedValues.get(n);
    }

    public String getFormattedString(int n) {
        String string = null;
        int n2 = this.getIndexFromColumnIndex(n);
        if (n2 >= 0 && n2 < this.m_formattedValues.size()) {
            string = this.m_formattedValues.get(n2);
        }
        return string;
    }

    public int getIndexFromColumnIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.m_formattedValueColumns.size() && n2 == -1; ++i) {
            if (this.m_formattedValueColumns.get(i) != n) continue;
            n2 = i;
        }
        return n2;
    }
}

