/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.FrameWork;

import com.avs.openviz3.axis.INumberFormatter;
import com.cognos.i18n.NumericFormat;
import com.cognos.i18n.ToolkitResources;
import com.ibm.cgsBus.Properties.CGSPropFormatNumericBase;
import com.ibm.cognos.i18n.IntervalFormat;
import com.ibm.cognos.i18n.util.IntervalDHMSM;
import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class CGSFormatter
implements INumberFormatter {
    public static final String CGS_PERMILL_SYMBOL = "\u2030";
    private static final int CGS_MAXIMUM_DECIMAL_SIZE_DOUBLE = 8;
    private TreeMap<String, String> m_codeSymbolMap = null;
    private String m_pattern = "";
    private String m_negativePattern = "";
    private String m_PatternLocale = "";
    private String m_unitOfMeasure = "";
    private int m_scale = 0;
    private CGSPropFormatNumericBase.FormatType m_type = CGSPropFormatNumericBase.FormatType.eFormatRegular;
    private int m_minDigits = -1;
    private int m_maxDigits = -1;
    private String m_padChar = " ";
    private NumberFormat m_pNumberFormat = null;
    private IntervalFormat m_pIntervalFormat = null;
    private CGSTimeUnit m_timeUnit = CGSTimeUnit.eIntervalUnitDefault;
    private CGSPropFormatNumericBase.DigitShapeType m_digitShape = CGSPropFormatNumericBase.DigitShapeType.eDigitShapeDefault;
    private static Map<Locale, Character> m_defaultZeros = new HashMap<Locale, Character>();
    private static Map<String, Character> m_zeroDigitMap = new HashMap<String, Character>();

    public CGSFormatter(Locale locale, CGSPropFormatNumericBase.FormatType formatType) {
        CGSFormatter.fillZeroDigit();
        this.m_codeSymbolMap = new TreeMap();
        this.m_codeSymbolMap.put("USD", "$");
        this.m_codeSymbolMap.put("EUR", "\u20ac");
        this.m_codeSymbolMap.put("JPY", "\u00a5");
        this.m_codeSymbolMap.put("GBP", "\u20a4");
        this.m_codeSymbolMap.put("CAD", "$");
        this.m_codeSymbolMap.put("AUD", "$");
        this.m_codeSymbolMap.put("DKK", "kr");
        this.m_codeSymbolMap.put("IEP", "\u20a4");
        this.m_codeSymbolMap.put("CHF", "SFr.");
        this.m_codeSymbolMap.put("SGD", "S$");
        this.m_codeSymbolMap.put("HKD", "HK$");
        this.m_codeSymbolMap.put("KPW", "KPW");
        this.m_codeSymbolMap.put("INR", "Rs.");
        this.m_codeSymbolMap.put("MXN", "$");
        this.m_codeSymbolMap.put("BRL", "R$");
        this.m_codeSymbolMap.put("CZK", "K\u010d");
        this.m_codeSymbolMap.put("HUF", "Ft");
        this.m_codeSymbolMap.put("ROL", "lei");
        this.m_codeSymbolMap.put("RUB", "\u0440.");
        this.m_codeSymbolMap.put("SKK", "Sk");
        this.m_codeSymbolMap.put("TRL", "TL");
        this.m_codeSymbolMap.put("UAH", "\u0491\u0440\u041d.");
        this.m_codeSymbolMap.put("ZAR", "R");
        this.m_codeSymbolMap.put("RMB", "\u00a5");
        this.m_codeSymbolMap.put("NOK", "kr");
        this.m_codeSymbolMap.put("KLN", "z\u0142");
        this.m_codeSymbolMap.put("RON", "lei");
        this.m_codeSymbolMap.put("SEK", "kr");
        this.m_codeSymbolMap.put("TRY", "TL");
        this.m_type = formatType;
        switch (this.m_type) {
            case eFormatPercentage: {
                this.m_pNumberFormat = NumberFormat.getPercentInstance((Locale)locale);
                break;
            }
            case eFormatCurrency: {
                this.m_pNumberFormat = NumberFormat.getCurrencyInstance((Locale)locale);
                break;
            }
            case eFormatScientific: {
                this.m_pNumberFormat = NumberFormat.getScientificInstance((Locale)locale);
                break;
            }
            case eFormatInterval: {
                this.m_pNumberFormat = NumberFormat.getNumberInstance((Locale)locale);
                this.m_pIntervalFormat = new IntervalFormat();
                break;
            }
            default: {
                this.m_pNumberFormat = NumberFormat.getNumberInstance((Locale)locale);
            }
        }
        if (this.m_pNumberFormat instanceof com.ibm.icu.text.DecimalFormat) {
            com.ibm.icu.text.DecimalFormat decimalFormat = (com.ibm.icu.text.DecimalFormat)this.m_pNumberFormat;
            com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            if (m_defaultZeros.get(locale) == null) {
                m_defaultZeros.put(locale, Character.valueOf(decimalFormatSymbols.getZeroDigit()));
            }
        }
    }

    private static void fillZeroDigit() {
        m_zeroDigitMap.put("ar", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("ar_bh", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("ar_eg", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("ar_iq", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("ar_jo", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("ar_kw", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("ar_lb", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("ar_om", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("ar_qa", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("ar_sa", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("ar_sy", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("ar_ae", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("ar_ye", Character.valueOf('\u0660'));
        m_zeroDigitMap.put("th", Character.valueOf('\u0e50'));
        m_zeroDigitMap.put("th_th", Character.valueOf('\u0e50'));
    }

    private static CGSTimeUnit getFromIntervalUnit(CGSPropFormatNumericBase.IntervalUnit intervalUnit) {
        switch (intervalUnit) {
            case eIntervalYears: {
                return CGSTimeUnit.eIntervalUnitYears;
            }
            case eIntervalMonths: {
                return CGSTimeUnit.eIntervalUnitMonths;
            }
            case eIntervalDays: {
                return CGSTimeUnit.eIntervalUnitDays;
            }
            case eIntervalHours: {
                return CGSTimeUnit.eIntervalUnitHours;
            }
            case eIntervalMinutes: {
                return CGSTimeUnit.eIntervalUnitMinutes;
            }
            case eIntervalSeconds: {
                return CGSTimeUnit.eIntervalUnitSeconds;
            }
            case eIntervalMilliseconds: {
                return CGSTimeUnit.eIntervalUnitMilliseconds;
            }
        }
        return CGSTimeUnit.eIntervalUnitDefault;
    }

    public void setPatternLocale(String string) {
        this.m_PatternLocale = string;
    }

    public String getPatternLocale() {
        return this.m_PatternLocale;
    }

    private void setScale(int n) {
        this.m_scale = n;
    }

    private int getScale() {
        return this.m_scale;
    }

    private void setDigitShape(CGSPropFormatNumericBase.DigitShapeType digitShapeType) {
        this.m_digitShape = digitShapeType;
    }

    private CGSPropFormatNumericBase.DigitShapeType getDigitShape() {
        return this.m_digitShape;
    }

    public void setPattern(String string) {
        this.m_pattern = string;
        if (string.contains("-")) {
            this.m_negativePattern = string;
        }
    }

    public String getPattern() {
        return this.m_pattern;
    }

    public void setNegativePattern(String string) {
        this.m_negativePattern = string;
    }

    public String getNegativePattern() {
        return this.m_negativePattern;
    }

    public boolean getUseTrailingCurrencySymbol() {
        com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols;
        String string;
        if (this.m_pNumberFormat == null || !(this.m_pNumberFormat instanceof com.ibm.icu.text.DecimalFormat)) {
            return false;
        }
        com.ibm.icu.text.DecimalFormat decimalFormat = (com.ibm.icu.text.DecimalFormat)this.m_pNumberFormat;
        String string2 = decimalFormat.getPositiveSuffix();
        return string2.indexOf(string = (decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols()).getCurrencySymbol()) >= 0;
    }

    public String getCurrencySymbol() {
        if (this.m_pNumberFormat == null || !(this.m_pNumberFormat instanceof com.ibm.icu.text.DecimalFormat)) {
            return "";
        }
        com.ibm.icu.text.DecimalFormat decimalFormat = (com.ibm.icu.text.DecimalFormat)this.m_pNumberFormat;
        com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        return decimalFormatSymbols.getCurrencySymbol();
    }

    public String getDecimalSeparator() {
        if (this.m_pNumberFormat == null || !(this.m_pNumberFormat instanceof com.ibm.icu.text.DecimalFormat)) {
            return "";
        }
        com.ibm.icu.text.DecimalFormat decimalFormat = (com.ibm.icu.text.DecimalFormat)this.m_pNumberFormat;
        com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        return Character.toString(decimalFormatSymbols.getDecimalSeparator());
    }

    public String getGroupingSeparator() {
        if (this.m_pNumberFormat == null || !(this.m_pNumberFormat instanceof com.ibm.icu.text.DecimalFormat)) {
            return "";
        }
        com.ibm.icu.text.DecimalFormat decimalFormat = (com.ibm.icu.text.DecimalFormat)this.m_pNumberFormat;
        com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        return Character.toString(decimalFormatSymbols.getGroupingSeparator());
    }

    private Locale getLocale(CGSPropFormatNumericBase cGSPropFormatNumericBase) {
        String string = cGSPropFormatNumericBase.getLocale();
        String string2 = null;
        if (string.length() > 2) {
            string2 = string.substring(3);
            string = string.substring(0, 2);
        }
        Locale locale = null;
        locale = string2 != null ? new Locale(string, string2) : new Locale(string);
        return locale;
    }

    public static char getZeroDigit(String string) {
        Character c = m_zeroDigitMap.get(string);
        if (c != null) {
            return c.charValue();
        }
        return '0';
    }

    protected void setNumericAttributes(CGSPropFormatNumericBase cGSPropFormatNumericBase, com.ibm.icu.text.DecimalFormat decimalFormat) {
        this.setDigitShape(cGSPropFormatNumericBase.getDigitShapeType());
        this.setNumericBasicAttributes(cGSPropFormatNumericBase, decimalFormat);
        this.setNumericDigits(cGSPropFormatNumericBase, decimalFormat);
        this.setNumericGrouping(cGSPropFormatNumericBase, decimalFormat);
        this.setNumericPrefixSuffix(cGSPropFormatNumericBase, decimalFormat);
        this.setNumericPattern(cGSPropFormatNumericBase, decimalFormat);
        this.setNumericSeparator(cGSPropFormatNumericBase, decimalFormat);
    }

    protected void setNumericBasicAttributes(CGSPropFormatNumericBase cGSPropFormatNumericBase, com.ibm.icu.text.DecimalFormat decimalFormat) {
        String string;
        com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        this.setScale(cGSPropFormatNumericBase.getScale());
        String string2 = cGSPropFormatNumericBase.getPaddingCharacter();
        if (string2.length() > 0) {
            this.m_padChar = string2;
        }
        if ((string = cGSPropFormatNumericBase.getUnitOfMeasure()).length() > 0) {
            this.m_unitOfMeasure = string;
        }
        decimalFormat.setExponentSignAlwaysShown(true);
        String string3 = cGSPropFormatNumericBase.getExponentialSymbol();
        if (string3.length() > 0) {
            decimalFormatSymbols.setExponentSeparator(string3);
        }
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        if (!decimalFormat.isScientificNotation()) {
            decimalFormat.setRoundingMode(this.convertRSVPRoundingToICURounding(cGSPropFormatNumericBase.getRoundingMode()));
        }
    }

    protected void setNumericSeparator(CGSPropFormatNumericBase cGSPropFormatNumericBase, com.ibm.icu.text.DecimalFormat decimalFormat) {
        String string;
        com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        String string2 = cGSPropFormatNumericBase.getDecimalSeparator();
        if (string2.length() > 0) {
            decimalFormatSymbols.setDecimalSeparator(string2.charAt(0));
            decimalFormatSymbols.setMonetaryDecimalSeparator(string2.charAt(0));
        }
        if ((string = cGSPropFormatNumericBase.getGroupingSeparator()).length() > 0) {
            decimalFormatSymbols.setGroupingSeparator(string.charAt(0));
            decimalFormatSymbols.setMonetaryGroupingSeparator(string.charAt(0));
        }
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    protected void setNumericPattern(CGSPropFormatNumericBase cGSPropFormatNumericBase, com.ibm.icu.text.DecimalFormat decimalFormat) {
        String string;
        String string2;
        com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        String string3 = cGSPropFormatNumericBase.getPatternLocale();
        if (string3.length() > 0) {
            this.setPatternLocale(string3);
        }
        if ((string2 = cGSPropFormatNumericBase.getPattern()).length() > 0) {
            this.setPattern(string2);
        }
        if ((string = cGSPropFormatNumericBase.getNegativePattern()).length() > 0) {
            if (string.compareTo(decimalFormatSymbols.getMinusSign() + string2) == 0) {
                this.setNegativePattern(string2);
            } else {
                this.setNegativePattern(string);
            }
        }
    }

    protected void setNumericPrefixSuffix(CGSPropFormatNumericBase cGSPropFormatNumericBase, com.ibm.icu.text.DecimalFormat decimalFormat) {
        String string;
        com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        String string2 = cGSPropFormatNumericBase.getPositivePrefix();
        if (string2.length() > 0) {
            decimalFormat.setPositivePrefix(string2);
        }
        if ((string = cGSPropFormatNumericBase.getPositiveSuffix()).length() > 0) {
            decimalFormat.setPositiveSuffix(string);
        }
        String string3 = cGSPropFormatNumericBase.getNegativePrefix();
        String string4 = cGSPropFormatNumericBase.getNegativeSuffix();
        String string5 = cGSPropFormatNumericBase.getNegativeSign();
        boolean bl = cGSPropFormatNumericBase.getTrailingNegativeSign();
        if (string3.length() > 0 || string4.length() > 0) {
            if (string3.length() > 0) {
                if (string3.charAt(0) == decimalFormatSymbols.getMinusSign() || this.m_type == CGSPropFormatNumericBase.FormatType.eFormatRegular || this.m_type == CGSPropFormatNumericBase.FormatType.eFormatScientific) {
                    decimalFormat.setNegativePrefix(string3);
                } else {
                    decimalFormat.setNegativePrefix(decimalFormatSymbols.getMinusSign() + string3);
                }
                decimalFormat.setNegativeSuffix("");
            }
            if (string4.length() > 0) {
                decimalFormat.setNegativeSuffix(string4);
            }
        } else if (string5.length() > 0) {
            if (string5.compareTo("()") == 0) {
                String string6 = decimalFormat.getNegativePrefix();
                String string7 = decimalFormat.getNegativeSuffix();
                if (!string6.startsWith("(")) {
                    decimalFormat.setNegativePrefix("(");
                }
                if (!string7.endsWith(")")) {
                    decimalFormat.setNegativeSuffix(string7 + ")");
                }
            } else if (bl) {
                decimalFormat.setNegativePrefix("");
                String string8 = string5;
                boolean bl2 = Character.isWhitespace(string8.charAt(string8.length() - 1));
                while (bl2) {
                    string8 = "".concat(string8.substring(0, string8.length() - 1));
                    bl2 = Character.isWhitespace(string8.charAt(string8.length() - 1));
                }
                decimalFormat.setNegativeSuffix(string8);
            } else {
                decimalFormat.setNegativePrefix(string5);
                decimalFormat.setNegativeSuffix("");
            }
        } else if (bl) {
            decimalFormat.setNegativePrefix("");
            decimalFormat.setNegativeSuffix(Character.toString(decimalFormatSymbols.getMinusSign()));
        }
    }

    protected void setNumericGrouping(CGSPropFormatNumericBase cGSPropFormatNumericBase, com.ibm.icu.text.DecimalFormat decimalFormat) {
        int n;
        int n2 = cGSPropFormatNumericBase.getGroupingSize();
        if (n2 >= 0) {
            decimalFormat.setGroupingSize(n2);
        }
        if ((n = cGSPropFormatNumericBase.getSecondaryGroupingSize()) >= 0) {
            decimalFormat.setSecondaryGroupingSize(n);
        }
        decimalFormat.setGroupingUsed(cGSPropFormatNumericBase.getUseGrouping());
    }

    protected void setNumericDigits(CGSPropFormatNumericBase cGSPropFormatNumericBase, com.ibm.icu.text.DecimalFormat decimalFormat) {
        int n;
        int n2;
        int n3;
        com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        switch (this.getDigitShape()) {
            case eDigitShapeNone: 
            case eDigitShapeContextual: {
                decimalFormatSymbols.setZeroDigit('0');
                break;
            }
            case eDigitShapeNational: {
                try {
                    decimalFormatSymbols.setZeroDigit(ToolkitResources.getZeroDigit((String)cGSPropFormatNumericBase.getLocale()).charValue());
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    decimalFormatSymbols.setZeroDigit(CGSFormatter.getZeroDigit(cGSPropFormatNumericBase.getLocale()));
                }
                break;
            }
            case eDigitShapeDefault: {
                Character c = m_defaultZeros.get(this.getLocale(cGSPropFormatNumericBase));
                if (c == null) break;
                decimalFormatSymbols.setZeroDigit(m_defaultZeros.get(this.getLocale(cGSPropFormatNumericBase)).charValue());
            }
        }
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setSignificantDigitsUsed(false);
        int n4 = cGSPropFormatNumericBase.getMinimumDecimalPlaces();
        if (n4 > -1) {
            decimalFormat.setMinimumFractionDigits(n4);
        }
        if ((n3 = cGSPropFormatNumericBase.getMaximumDecimalPlaces()) > -1) {
            decimalFormat.setMaximumFractionDigits(n3);
        } else {
            decimalFormat.setMaximumFractionDigits(8);
        }
        int n5 = cGSPropFormatNumericBase.getDecimalPlaces();
        if (n5 > -1) {
            decimalFormat.setMinimumFractionDigits(n5);
            decimalFormat.setMaximumFractionDigits(n5);
        }
        if ((n2 = cGSPropFormatNumericBase.getMaximumDigits()) > -1) {
            this.m_maxDigits = n2;
        }
        if ((n = cGSPropFormatNumericBase.getMinimumDigits()) > -1) {
            this.m_minDigits = n;
        }
    }

    protected void setPercentageAttributes(CGSPropFormatNumericBase cGSPropFormatNumericBase, com.ibm.icu.text.DecimalFormat decimalFormat) {
        double d;
        int n = 100;
        String string = cGSPropFormatNumericBase.getPercentSymbol();
        if (string.compareTo(CGS_PERMILL_SYMBOL) == 0 || cGSPropFormatNumericBase.getUsePermill()) {
            n = 1000;
            if (string.length() == 1) {
                com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
                decimalFormatSymbols.setPercent(string.charAt(0));
                decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            } else if (string.length() > 1) {
                decimalFormat.setPositiveSuffix(string);
                decimalFormat.setNegativeSuffix(string);
            }
        }
        if ((n = (int)((double)n * (d = Math.pow(10.0, -cGSPropFormatNumericBase.getPercentScale())))) == 0) {
            n = 1;
        }
        decimalFormat.setMultiplier(n);
    }

    private boolean fuzzyCurrencyCompare(String string) {
        com.ibm.icu.text.DecimalFormat decimalFormat = (com.ibm.icu.text.DecimalFormat)this.m_pNumberFormat;
        Currency currency = decimalFormat.getCurrency();
        if (currency != null) {
            return currency.getCurrencyCode().equals(string);
        }
        com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        String string2 = decimalFormatSymbols.getCurrencySymbol();
        if (this.m_codeSymbolMap.containsKey(string)) {
            return string2.equals(string) || string2.equals(this.m_codeSymbolMap.get(string));
        }
        return true;
    }

    protected void setCurrencyAttributes(CGSPropFormatNumericBase cGSPropFormatNumericBase, com.ibm.icu.text.DecimalFormat decimalFormat) {
        int n;
        int n2;
        String string;
        com.ibm.icu.text.DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        String string2 = cGSPropFormatNumericBase.getCurrencyCode();
        boolean bl = cGSPropFormatNumericBase.getUseInternationalCurrencySymbol();
        String string3 = cGSPropFormatNumericBase.getInternationalCurrencySymbol();
        String string4 = cGSPropFormatNumericBase.getCurrencySymbol();
        if (bl && string3.length() > 0) {
            decimalFormatSymbols.setCurrencySymbol(string3);
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        } else if (bl) {
            string = decimalFormat.getCurrency().getCurrencyCode();
            decimalFormatSymbols.setCurrencySymbol(string);
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        } else if (string4.length() > 0) {
            decimalFormatSymbols.setCurrencySymbol(string4);
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        } else if (string2.length() >= 0) {
            string = ToolkitResources.getSymbolForCurrencyCode((String)string2);
            if (string != null) {
                decimalFormatSymbols.setCurrencySymbol(string);
            } else {
                decimalFormatSymbols.setCurrencySymbol(string2);
            }
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
        if (this.fuzzyCurrencyCompare("CHF")) {
            decimalFormat.setRoundingIncrement(0.0);
        }
        if (!(this.fuzzyCurrencyCompare("USD") || this.fuzzyCurrencyCompare("JPY") || this.fuzzyCurrencyCompare("TRL"))) {
            decimalFormat.setMaximumFractionDigits(2);
        }
        if ((n2 = cGSPropFormatNumericBase.getMinimumDecimalPlaces()) > -1) {
            decimalFormat.setMinimumFractionDigits(n2);
        }
        if ((n = cGSPropFormatNumericBase.getMaximumDecimalPlaces()) > -1) {
            decimalFormat.setMaximumFractionDigits(n);
        }
        String string5 = decimalFormat.getNegativePrefix();
        String string6 = decimalFormat.getNegativeSuffix();
        String string7 = decimalFormat.getPositivePrefix();
        String string8 = decimalFormat.getPositiveSuffix();
        String string9 = decimalFormatSymbols.getCurrencySymbol();
        int n3 = string5.indexOf(string9);
        int n4 = string7.indexOf(string9);
        int n5 = string6.indexOf(string9);
        int n6 = string8.indexOf(string9);
        if (cGSPropFormatNumericBase.getUseTrailingCurrencySymbol() || n6 != -1) {
            if (n6 == -1) {
                string8 = string8 + string9;
            }
            if (n4 != -1) {
                string7 = string7.replace(string9, "");
            }
            if (n5 == -1) {
                string6 = string6.endsWith(")") ? string6.replace(")", string9 + ")") : string6 + string9;
            }
            if (n3 != -1) {
                string5 = string5.replace(string9, "");
            }
        } else {
            if (n6 != -1) {
                string8 = string8.replace(string9, "");
            }
            if (n4 == -1) {
                string7 = string9 + string7;
            }
            if (n5 != -1) {
                string6 = string6.replace(string9, "");
            }
            if (n3 == -1) {
                if (string5.startsWith("(")) {
                    string5 = string5.replace("(", "(" + string9);
                } else if (cGSPropFormatNumericBase.getTrailingNegativeSign()) {
                    string5 = string9 + string5;
                } else {
                    String string10 = cGSPropFormatNumericBase.getNegativeSign();
                    string5 = string5.replace(string10, string10 + string9);
                }
            }
        }
        decimalFormat.setNegativePrefix(string5);
        decimalFormat.setNegativeSuffix(string6);
        decimalFormat.setPositivePrefix(string7);
        decimalFormat.setPositiveSuffix(string8);
    }

    protected void setIntervalAttributes(CGSPropFormatNumericBase cGSPropFormatNumericBase, com.ibm.icu.text.DecimalFormat decimalFormat) {
        if (this.m_pIntervalFormat == null) {
            return;
        }
        NumericFormat numericFormat = new NumericFormat(decimalFormat.getLocale(ULocale.VALID_LOCALE).toLocale());
        numericFormat.setGroupingSize(cGSPropFormatNumericBase.getGroupingSize());
        numericFormat.setMinusSign(cGSPropFormatNumericBase.getNegativeSign());
        switch (this.getDigitShape()) {
            case eDigitShapeNone: 
            case eDigitShapeContextual: {
                numericFormat.setZeroDigit('0');
                break;
            }
            case eDigitShapeNational: {
                try {
                    numericFormat.setZeroDigit(ToolkitResources.getZeroDigit((String)cGSPropFormatNumericBase.getLocale()).charValue());
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    numericFormat.setZeroDigit(CGSFormatter.getZeroDigit(cGSPropFormatNumericBase.getLocale()));
                }
                break;
            }
            case eDigitShapeDefault: {
                Character c = m_defaultZeros.get(this.getLocale(cGSPropFormatNumericBase));
                if (c == null) break;
                numericFormat.setZeroDigit(m_defaultZeros.get(this.getLocale(cGSPropFormatNumericBase)).charValue());
            }
        }
        this.m_pIntervalFormat.setNumericFormat(numericFormat);
        int n = 0;
        switch (cGSPropFormatNumericBase.getDaysDigitsShown()) {
            case eIntervalDigitsShow: {
                n = 1;
                break;
            }
            case eIntervalDigitsHide: {
                n = 0;
                break;
            }
            case eIntervalDigitsOne: {
                n = 2;
                break;
            }
            case eIntervalDigitsTwo: {
                n = 3;
                break;
            }
            case eIntervalDigitsThree: {
                n = 7;
                break;
            }
        }
        this.m_pIntervalFormat.showDays(n);
        switch (cGSPropFormatNumericBase.getHoursDigitsShown()) {
            case eIntervalDigitsShow: {
                n = 1;
                break;
            }
            case eIntervalDigitsHide: {
                n = 0;
                break;
            }
            case eIntervalDigitsOne: {
                n = 2;
                break;
            }
            case eIntervalDigitsTwo: {
                n = 3;
                break;
            }
        }
        this.m_pIntervalFormat.showHours(n);
        switch (cGSPropFormatNumericBase.getMinutesDigitsShown()) {
            case eIntervalDigitsShow: {
                n = 1;
                break;
            }
            case eIntervalDigitsHide: {
                n = 0;
                break;
            }
            case eIntervalDigitsOne: {
                n = 2;
                break;
            }
            case eIntervalDigitsTwo: {
                n = 3;
                break;
            }
        }
        this.m_pIntervalFormat.showMinutes(n);
        switch (cGSPropFormatNumericBase.getSecondsDigitsShown()) {
            case eIntervalDigitsShow: {
                n = 1;
                break;
            }
            case eIntervalDigitsHide: {
                n = 0;
                break;
            }
            case eIntervalDigitsOne: {
                n = 2;
                break;
            }
            case eIntervalDigitsTwo: {
                n = 3;
                break;
            }
        }
        this.m_pIntervalFormat.showSeconds(n);
        switch (cGSPropFormatNumericBase.getMillisecondsDigitsShown()) {
            case eIntervalDigitsShow: {
                n = 1;
                break;
            }
            case eIntervalDigitsHide: {
                n = 0;
                break;
            }
            case eIntervalDigitsOne: {
                n = 2;
                break;
            }
            case eIntervalDigitsTwo: {
                n = 3;
                break;
            }
            case eIntervalDigitsThree: {
                n = 7;
                break;
            }
        }
        if (cGSPropFormatNumericBase.getSecondsDigitsShown() == CGSPropFormatNumericBase.IntervalDigitsShown.eIntervalDigitsHide) {
            n = 0;
        }
        this.m_pIntervalFormat.showMilliseconds(n);
        this.m_timeUnit = CGSFormatter.getFromIntervalUnit(cGSPropFormatNumericBase.getIntervalMeasureUnit());
        String string = cGSPropFormatNumericBase.getTimeSeparator();
        if (string.length() > 0) {
            this.m_pIntervalFormat.setTimeSeparatorSymbol(string);
        }
        if (cGSPropFormatNumericBase.getIntervalLongFormat()) {
            this.m_pIntervalFormat.setStyle(IntervalFormat.IntervalFormatStyle.LONG_INTERVAL);
        } else {
            this.m_pIntervalFormat.setStyle(IntervalFormat.IntervalFormatStyle.SHORT_INTERVAL);
        }
    }

    protected void setScientificAttributes(CGSPropFormatNumericBase cGSPropFormatNumericBase, com.ibm.icu.text.DecimalFormat decimalFormat) {
        int n = cGSPropFormatNumericBase.getExponentDigits();
        int n2 = cGSPropFormatNumericBase.getMaximumDecimalPlaces();
        if (n > 0) {
            String string = decimalFormat.toPattern();
            String string2 = "E+";
            for (int i = 0; i < n; ++i) {
                string2 = string2.concat("0");
            }
            string = string.replaceFirst("(E\\+0)", string2);
            decimalFormat.applyPattern(string);
        } else if (n2 > -1) {
            decimalFormat.setMaximumFractionDigits(n2 + 1);
        } else {
            decimalFormat.setMaximumFractionDigits(9);
        }
    }

    public void setAttributes(CGSPropFormatNumericBase cGSPropFormatNumericBase) {
        if (this.m_pNumberFormat == null || !(this.m_pNumberFormat instanceof com.ibm.icu.text.DecimalFormat)) {
            return;
        }
        com.ibm.icu.text.DecimalFormat decimalFormat = (com.ibm.icu.text.DecimalFormat)this.m_pNumberFormat;
        String string = cGSPropFormatNumericBase.getCurrencyCode();
        if (string.length() <= 0) {
            String string2 = ToolkitResources.getLCIDForLocale((String)cGSPropFormatNumericBase.getLocale());
            string = ToolkitResources.getISOCurrencyCodeForLCID((String)string2);
        }
        if (string.length() > 0) {
            try {
                cGSPropFormatNumericBase.setCurrencyCode(string);
                decimalFormat.setCurrency(Currency.getInstance((String)string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.setNumericAttributes(cGSPropFormatNumericBase, decimalFormat);
        if (this.m_type == CGSPropFormatNumericBase.FormatType.eFormatInterval) {
            if (cGSPropFormatNumericBase.getGroupingSize() == -1) {
                this.m_pNumberFormat.setGroupingUsed(false);
            }
            if (this.m_pNumberFormat instanceof com.ibm.icu.text.DecimalFormat) {
                this.setIntervalAttributes(cGSPropFormatNumericBase, decimalFormat);
            }
        } else if (this.m_type == CGSPropFormatNumericBase.FormatType.eFormatCurrency) {
            this.setCurrencyAttributes(cGSPropFormatNumericBase, decimalFormat);
        } else if (this.m_type == CGSPropFormatNumericBase.FormatType.eFormatPercentage) {
            if (cGSPropFormatNumericBase.getMaximumDecimalPlaces() == -1 && cGSPropFormatNumericBase.getMinimumDecimalPlaces() == -1) {
                this.m_pNumberFormat.setMaximumFractionDigits(0);
            }
            this.setPercentageAttributes(cGSPropFormatNumericBase, decimalFormat);
        } else if (this.m_type == CGSPropFormatNumericBase.FormatType.eFormatScientific) {
            this.setScientificAttributes(cGSPropFormatNumericBase, decimalFormat);
        }
    }

    public String applyIntervalFormat(double d) {
        boolean bl = false;
        long l = (long)d;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        IntervalFormat.IntervalFormatDTType intervalFormatDTType = IntervalFormat.IntervalFormatDTType.FORMAT_DTTYPE_DEFAULT;
        if (this.m_pIntervalFormat.getStyle() != IntervalFormat.IntervalFormatStyle.SHORT_INTERVAL) {
            switch (this.m_timeUnit) {
                case eIntervalUnitDays: {
                    intervalFormatDTType = IntervalFormat.IntervalFormatDTType.FORMAT_AS_DAYS;
                    break;
                }
                case eIntervalUnitHours: {
                    intervalFormatDTType = IntervalFormat.IntervalFormatDTType.FORMAT_AS_HOURS;
                    break;
                }
                case eIntervalUnitMinutes: {
                    intervalFormatDTType = IntervalFormat.IntervalFormatDTType.FORMAT_AS_MINUTES;
                    break;
                }
                case eIntervalUnitSeconds: {
                    intervalFormatDTType = IntervalFormat.IntervalFormatDTType.FORMAT_AS_SECONDS;
                    break;
                }
                case eIntervalUnitMilliseconds: {
                    intervalFormatDTType = IntervalFormat.IntervalFormatDTType.FORMAT_AS_MILLISECONDS;
                    break;
                }
            }
        }
        IntervalDHMSM intervalDHMSM = new IntervalDHMSM(bl, 0L, 0L, 0L, 0L, l);
        return this.m_pIntervalFormat.format(intervalDHMSM, intervalFormatDTType);
    }

    public String applyFormat(double d) {
        int n;
        String string;
        String string2;
        if (this.m_type == CGSPropFormatNumericBase.FormatType.eFormatInterval) {
            return this.applyIntervalFormat(d);
        }
        double d2 = Math.pow(10.0, this.getScale());
        double d3 = d * d2;
        if (!(this.m_pNumberFormat instanceof com.ibm.icu.text.DecimalFormat)) {
            return "";
        }
        com.ibm.icu.text.DecimalFormat decimalFormat = (com.ibm.icu.text.DecimalFormat)this.m_pNumberFormat;
        try {
            if (this.getPattern().length() > 0 && d3 >= 0.0) {
                decimalFormat.applyLocalizedPattern(this.getPattern());
            } else if (this.getPattern().length() > 0 && this.getNegativePattern().length() > 0 && d3 < 0.0) {
                decimalFormat.applyLocalizedPattern(this.getPattern() + ";" + this.getNegativePattern());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String string3 = null;
        String string4 = null;
        Boolean bl = null;
        if (decimalFormat.isScientificNotation()) {
            string4 = this.m_pNumberFormat.format(d3);
        } else {
            string4 = this.convertICUDecimalFormatToJavaDecimalFormat(decimalFormat, d3);
            if (d3 < 0.0 && !decimalFormat.getNegativeSuffix().matches("") && string4.endsWith(decimalFormat.getNegativeSuffix())) {
                bl = new Boolean(true);
            }
        }
        char c = decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
        boolean bl2 = false;
        double d4 = 0.0;
        if (this.m_type == CGSPropFormatNumericBase.FormatType.eFormatRegular || this.m_type == CGSPropFormatNumericBase.FormatType.eFormatScientific) {
            bl2 = true;
            com.ibm.icu.text.DecimalFormat decimalFormat2 = new com.ibm.icu.text.DecimalFormat();
            ParsePosition parsePosition = new ParsePosition(0);
            Number number = decimalFormat2.parse(string4, parsePosition);
            if (number != null) {
                d4 = number.doubleValue();
            } else {
                bl2 = false;
            }
        }
        boolean bl3 = false;
        if (bl2) {
            if (d4 < 0.0) {
                bl3 = true;
            }
        } else if (d3 < 0.0 && bl != null && bl.booleanValue()) {
            bl3 = true;
        }
        if (bl3) {
            string2 = decimalFormat.getNegativePrefix();
            string = decimalFormat.getNegativeSuffix();
        } else {
            string2 = decimalFormat.getPositivePrefix();
            string = decimalFormat.getPositiveSuffix();
        }
        string3 = string4.substring(string2.length(), string4.length() - string.length());
        int n2 = 0;
        int n3 = string3.length();
        for (n = 0; n < n3 && string3.charAt(n) != c; ++n) {
            if (string3.charAt(n) <= '/' || string3.charAt(n) > '9') continue;
            ++n2;
        }
        if (n2 > this.m_maxDigits) {
            decimalFormat.setScientificNotation(true);
            String string5 = decimalFormat.toPattern();
            String string6 = "E+00";
            string5 = string5.replaceFirst("(E\\+0*)", string6);
            try {
                decimalFormat.applyPattern(string5);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            decimalFormat.setMinimumFractionDigits(n2 - 1);
            decimalFormat.setMaximumFractionDigits(n2 - 1 + decimalFormat.getMaximumFractionDigits());
            string4 = this.m_pNumberFormat.format(d3);
        } else if (this.m_minDigits > 0 && n2 < this.m_minDigits) {
            for (n = 0; n < this.m_minDigits - n2; ++n) {
                string3 = this.m_padChar.concat(string3);
            }
            string4 = string2.concat(string3).concat(string);
        }
        if (this.m_unitOfMeasure.length() > 0) {
            string4 = string4.concat(this.m_unitOfMeasure);
        }
        return string4;
    }

    private String convertICUDecimalFormatToJavaDecimalFormat(com.ibm.icu.text.DecimalFormat decimalFormat, double d) {
        String string;
        DecimalFormat decimalFormat2 = new DecimalFormat();
        decimalFormat2.setRoundingMode(this.convertICURoundingToJavaRounding(decimalFormat.getRoundingMode()));
        decimalFormat2.setMaximumFractionDigits(decimalFormat.getMaximumFractionDigits());
        decimalFormat2.setMinimumFractionDigits(decimalFormat.getMinimumFractionDigits());
        decimalFormat2.setMaximumIntegerDigits(decimalFormat.getMaximumIntegerDigits());
        decimalFormat2.setPositivePrefix(decimalFormat.getPositivePrefix());
        decimalFormat2.setPositiveSuffix(decimalFormat.getPositiveSuffix());
        decimalFormat2.setNegativePrefix(decimalFormat.getNegativePrefix());
        decimalFormat2.setNegativeSuffix(decimalFormat.getNegativeSuffix());
        decimalFormat2.setGroupingUsed(decimalFormat.isGroupingUsed());
        decimalFormat2.setGroupingSize(decimalFormat.getGroupingSize());
        decimalFormat2.setMultiplier(decimalFormat.getMultiplier());
        Currency currency = decimalFormat.getCurrency();
        java.util.Currency currency2 = null;
        if (currency != null && (string = currency.getCurrencyCode()) != null && (currency2 = java.util.Currency.getInstance(string)) != null) {
            decimalFormat2.setCurrency(currency2);
        }
        string = decimalFormat.getDecimalFormatSymbols();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(string.getLocale());
        if (currency2 != null) {
            decimalFormatSymbols.setCurrency(currency2);
        }
        decimalFormatSymbols.setDecimalSeparator(string.getDecimalSeparator());
        decimalFormatSymbols.setGroupingSeparator(string.getGroupingSeparator());
        decimalFormatSymbols.setExponentSeparator(string.getExponentSeparator());
        decimalFormatSymbols.setMinusSign(string.getMinusSign());
        decimalFormatSymbols.setInternationalCurrencySymbol(string.getInternationalCurrencySymbol());
        decimalFormatSymbols.setMonetaryDecimalSeparator(string.getMonetaryDecimalSeparator());
        decimalFormatSymbols.setPercent(string.getPercent());
        decimalFormatSymbols.setZeroDigit(string.getZeroDigit());
        decimalFormatSymbols.setPerMill(string.getPerMill());
        decimalFormatSymbols.setInfinity(string.getInfinity());
        decimalFormat2.setDecimalFormatSymbols(decimalFormatSymbols);
        if (!Double.isInfinite(d) && !Double.isNaN(d)) {
            BigDecimal bigDecimal = BigDecimal.valueOf((double)d);
            int n = decimalFormat2.getMultiplier() > 0 ? decimalFormat2.getMaximumFractionDigits() + (int)Math.log10(decimalFormat2.getMultiplier()) : decimalFormat2.getMaximumFractionDigits();
            bigDecimal = bigDecimal.setScale(n, decimalFormat.getRoundingMode());
            return decimalFormat2.format(bigDecimal);
        }
        return decimalFormat2.format(d);
    }

    private int convertRSVPRoundingToICURounding(CGSPropFormatNumericBase.RsvpRoundingMode rsvpRoundingMode) {
        switch (rsvpRoundingMode) {
            case eRoundCeiling: {
                return 2;
            }
            case eRoundDown: {
                return 1;
            }
            case eRoundFloor: {
                return 3;
            }
            case eRoundHalfDown: {
                return 5;
            }
            case eRoundHalfUp: {
                return 4;
            }
            case eRoundUp: {
                return 0;
            }
        }
        return 6;
    }

    private RoundingMode convertICURoundingToJavaRounding(int n) {
        switch (n) {
            case 2: {
                return RoundingMode.CEILING;
            }
            case 1: {
                return RoundingMode.DOWN;
            }
            case 3: {
                return RoundingMode.FLOOR;
            }
            case 5: {
                return RoundingMode.HALF_DOWN;
            }
            case 6: {
                return RoundingMode.HALF_EVEN;
            }
            case 4: {
                return RoundingMode.HALF_UP;
            }
            case 7: {
                return RoundingMode.UNNECESSARY;
            }
        }
        return RoundingMode.UP;
    }

    public static enum CGSTimeUnit {
        eIntervalUnitDays,
        eIntervalUnitHours,
        eIntervalUnitMinutes,
        eIntervalUnitSeconds,
        eIntervalUnitMilliseconds,
        eIntervalUnitMonths,
        eIntervalUnitYears,
        eIntervalUnitDefault;

    }
}

