/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.FrameWork;

import com.ibm.cgsBus.FrameWork.CGSDetectArea;
import com.ibm.cgsBus.Graphics.GRHelper;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.Vector;

public class CGSRaster {
    private String m_id = null;
    private BufferedImage m_pImage = null;
    private byte[] m_buffer = null;
    private Vector<CGSDetectArea> m_detectAreas;

    public CGSRaster(BufferedImage bufferedImage) {
        this.m_pImage = bufferedImage;
    }

    public void removeReference() {
    }

    public void setId(String string) {
        this.m_id = string;
    }

    public String getId() {
        return this.m_id;
    }

    public byte[] getBuffer() {
        this.initializeRawBuffer();
        return this.m_buffer;
    }

    public int getBufferSize() {
        this.initializeRawBuffer();
        return this.m_buffer.length;
    }

    public BufferedImage getImage() {
        return this.m_pImage;
    }

    protected void initializeRawBuffer() {
        if (this.m_buffer != null) {
            return;
        }
        WritableRaster writableRaster = this.m_pImage.getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int n = this.m_pImage.getWidth();
        int n2 = this.m_pImage.getHeight();
        int n3 = 3;
        int n4 = 4;
        int n5 = n3 + n4 + n4 + n4;
        this.m_buffer = new byte[n * n2 * 4 + n5];
        this.m_buffer[0] = 114;
        this.m_buffer[1] = 97;
        this.m_buffer[2] = 119;
        this.m_buffer[3] = 0;
        this.m_buffer[4] = 0;
        this.m_buffer[5] = 0;
        this.m_buffer[6] = 0;
        this.m_buffer[7] = (byte)(n & 0xFF);
        this.m_buffer[8] = (byte)((n & 0xFF00) >> 8);
        this.m_buffer[9] = (byte)((n & 0xFF0000) >> 16);
        this.m_buffer[10] = (byte)((n & 0xFF000000) >> 24);
        this.m_buffer[11] = (byte)(n2 & 0xFF);
        this.m_buffer[12] = (byte)((n2 & 0xFF00) >> 8);
        this.m_buffer[13] = (byte)((n2 & 0xFF0000) >> 16);
        this.m_buffer[14] = (byte)((n2 & 0xFF000000) >> 24);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n6 = nArray[i * n + j];
                int n7 = GRHelper.getAlpha(n6);
                int n8 = GRHelper.getRed(n6);
                int n9 = GRHelper.getGreen(n6);
                int n10 = GRHelper.getBlue(n6);
                this.m_buffer[n5 + (i * n + j) * 4 + 0] = (byte)n8;
                this.m_buffer[n5 + (i * n + j) * 4 + 1] = (byte)n9;
                this.m_buffer[n5 + (i * n + j) * 4 + 2] = (byte)n10;
                this.m_buffer[n5 + (i * n + j) * 4 + 3] = (byte)n7;
            }
        }
    }

    public Vector<CGSDetectArea> getDetectAreas() {
        return this.m_detectAreas;
    }

    public void setDetectAreas(Vector<CGSDetectArea> vector) {
        this.m_detectAreas = vector;
    }
}

