/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Graphics;

import com.ibm.cgsBus.FrameWork.CGSDetectArea;
import com.ibm.cgsBus.FrameWork.CGSWidgetRef;
import com.ibm.cgsBus.Graphics.GRAxisData;
import com.ibm.cgsBus.Graphics.GRText;
import com.ibm.cgsBus.Properties.CGSPropFont;
import java.awt.image.BufferedImage;
import java.util.Vector;

public abstract class GRAxis {
    public static final int GAP = 3;
    public static final int HORZ_LABEL_GAP = 10;
    public static final double MIN_FONT_SIZE = 4.0;
    public static final int eSingle = 0;
    public static final int eRotated = 1;
    public static final int eStagger = 2;
    protected CGSWidgetRef m_parent = null;
    protected GRAxisData m_def = null;
    protected CGSPropFont m_titleFont = new CGSPropFont();
    protected CGSPropFont m_tickFont = new CGSPropFont();
    protected boolean m_isHorizontal = false;
    protected int m_layoutMode = 0;
    protected boolean m_showTitle = false;
    protected boolean m_showTicks = false;
    protected int m_width = 0;
    protected int m_height = 0;
    protected int m_titleHeight = 0;
    protected int m_titleWidth = 0;
    protected int m_tickHeight = 0;
    protected int m_tickWidth = 0;
    protected int m_singleTickHeight = 0;
    protected int m_singleTickWidth = 0;
    protected int m_titlePad = 0;
    protected BufferedImage m_pImage = null;
    protected byte[] m_pVectorBlob = null;
    protected Vector<CGSDetectArea> m_pDetAreas = new Vector();

    protected GRAxis(CGSWidgetRef cGSWidgetRef, GRAxisData gRAxisData) {
        this.m_parent = cGSWidgetRef;
        this.m_def = gRAxisData;
        this.m_titleFont.copyAttributes(this.m_def.m_titleFont);
        this.m_tickFont.copyAttributes(this.m_def.m_tickFont);
    }

    protected GRAxis(CGSWidgetRef cGSWidgetRef, GRAxisData gRAxisData, GRAxis gRAxis) {
        this(cGSWidgetRef, gRAxisData);
        this.m_isHorizontal = gRAxis.m_isHorizontal;
        this.m_layoutMode = gRAxis.m_layoutMode;
        this.m_showTitle = gRAxis.m_showTitle;
        this.m_showTicks = gRAxis.m_showTicks;
        this.m_width = gRAxis.m_width;
        this.m_height = gRAxis.m_height;
        this.m_titleHeight = gRAxis.m_titleHeight;
        this.m_titleWidth = gRAxis.m_titleWidth;
        this.m_tickHeight = gRAxis.m_tickHeight;
        this.m_tickWidth = gRAxis.m_tickWidth;
        this.m_singleTickHeight = gRAxis.m_singleTickHeight;
        this.m_singleTickWidth = gRAxis.m_singleTickWidth;
        this.m_titlePad = gRAxis.m_titlePad;
    }

    public void setMaxSize(int n, int n2) {
        this.doLayout(n, n2);
    }

    public void resetMaxSize(int n, int n2) {
        if (n < this.m_width) {
            this.m_width = n;
        }
        if (n2 < this.m_height) {
            this.m_height = n2;
        }
    }

    protected void doLayout(int n, int n2) {
        boolean bl = this.m_isHorizontal = (this.m_def.m_location & 0x1000) != 0;
        if (this.m_isHorizontal) {
            this.determineHorizontalSizes(n, n2);
            int n3 = this.m_tickHeight + this.m_titleHeight;
            if (this.m_showTitle && this.m_showTicks) {
                n3 += 3;
            }
            this.m_width = n3 == 0 ? 0 : n;
            this.m_height = n3 > n2 ? n2 : n3;
        } else {
            this.determineVerticalSizes(n, n2);
            int n4 = this.m_titleWidth + this.m_tickWidth;
            if (this.m_showTitle && this.m_showTicks) {
                n4 += 3;
            }
            this.m_width = n4 > n ? n : n4;
            this.m_height = n4 == 0 ? 0 : n2;
        }
    }

    public BufferedImage getImage() {
        this.draw();
        return this.m_pImage;
    }

    public byte[] getVectorBlob() {
        this.draw();
        return this.m_pVectorBlob;
    }

    public Vector<CGSDetectArea> getDetectionAreas() {
        return this.m_pDetAreas;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    protected abstract boolean canTicksBeTruncated();

    protected abstract void doHorizontalLayout(int var1, int var2);

    protected void determineHorizontalSizes(int n, int n2) {
        double d;
        int n3;
        double d2;
        double d3;
        int n4;
        int n5;
        int n6;
        GRText gRText;
        String string;
        this.initializeSizeVariables();
        boolean bl = this.m_titleFont.getAutoSize();
        boolean bl2 = this.m_tickFont.getAutoSize();
        String string2 = string = this.m_def.m_tickTruncationText == null ? "" : this.m_def.m_tickTruncationText;
        if (this.m_def.m_titleVisible && this.m_def.m_title != null && this.m_def.m_title.length() != 0) {
            this.m_showTitle = true;
            gRText = new GRText(this.m_def.m_title, this.m_titleFont);
            this.m_titleWidth = gRText.getWidth();
            this.m_titleHeight = gRText.getHeight();
        }
        if (this.m_def.m_tickVisible && this.m_def.m_tickStrings.length != 0) {
            this.m_showTicks = true;
            this.doHorizontalLayout(n, n2);
        }
        if (!this.m_showTitle && !this.m_showTicks) {
            return;
        }
        if (this.m_showTitle && !bl) {
            if (this.m_titleHeight > n2) {
                bl = true;
            } else if (this.m_titleWidth > n) {
                gRText = new GRText(this.m_def.m_title, this.m_titleFont);
                gRText.resetSinglelineLabel(this.m_def.m_title, n, string);
                this.m_titleWidth = gRText.getWidth();
                if (this.m_titleWidth > n) {
                    bl = true;
                }
            }
        }
        if (this.m_showTicks && !bl2 && (!this.canTicksBeTruncated() && this.m_singleTickWidth > n || this.m_singleTickHeight > n2)) {
            bl2 = true;
        }
        double d4 = 1.0;
        double d5 = 1.0;
        if (bl && bl2) {
            n6 = this.m_titleHeight + this.m_tickHeight;
            n5 = Math.max(this.m_titleWidth, this.m_tickWidth);
            d3 = (double)n5 / (double)(n4 = n);
            d = Math.max(d3, d2 = (double)n6 / (double)(n3 = n2 - 3));
            if (d < 1.0) {
                d = 1.0;
            }
            this.m_titleWidth = (int)((double)this.m_titleWidth / d);
            this.m_titleHeight = (int)((double)this.m_titleHeight / d);
            this.m_tickWidth = (int)((double)this.m_tickWidth / d);
            this.m_tickHeight = (int)((double)this.m_tickHeight / d);
            d4 = d;
            d5 = d;
        } else if (bl) {
            n6 = this.m_titleWidth;
            n5 = this.m_titleHeight;
            n3 = n2;
            if (this.m_showTicks && !this.canTicksBeTruncated()) {
                n3 -= 3 + this.m_tickHeight;
            }
            if (n3 < 0) {
                n3 = n;
                this.m_showTicks = false;
            }
            if ((d = Math.max(d3 = (double)n6 / (double)(n4 = n), d2 = (double)n5 / (double)n3)) < 1.0) {
                d = 1.0;
            }
            this.m_titleWidth = (int)((double)this.m_titleWidth / d);
            this.m_titleHeight = (int)((double)this.m_titleHeight / d);
            d4 = d;
        } else if (bl2) {
            n6 = this.m_tickWidth;
            n5 = this.m_tickHeight;
            n3 = n2;
            if (this.m_showTitle) {
                n3 -= 3 + this.m_titleHeight;
            }
            if (n3 < 0) {
                n3 = n2;
                this.m_showTitle = false;
            }
            if ((d = Math.max(d3 = (double)n6 / (double)(n4 = n), d2 = (double)n5 / (double)n3)) < 1.0) {
                d = 1.0;
            }
            this.m_tickWidth = (int)((double)this.m_tickWidth / d);
            this.m_tickHeight = (int)((double)this.m_tickHeight / d);
            d5 = d;
        }
        double d6 = this.m_def.m_titleFont.getSize();
        if (d4 > 1.0 && (d6 = d6 / d4 - 0.5) < 4.0 && bl) {
            d6 = 4.0;
        }
        this.m_titleFont.setSize(d6);
        d6 = this.m_def.m_tickFont.getSize();
        if (d5 > 1.0 && (d6 = d6 / d5 - 0.5) < 4.0 && bl2) {
            d6 = 4.0;
        }
        this.m_tickFont.setSize(d6);
        if (this.m_showTitle && d4 != 1.0) {
            GRText gRText2 = new GRText(this.m_def.m_title, this.m_titleFont);
            this.m_titleHeight = gRText2.getHeight();
            this.m_titleWidth = gRText2.getWidth();
        }
        if (this.m_titleHeight > n2) {
            if (this.m_showTitle && !bl || this.m_showTicks && !bl2) {
                this.m_titleFont.setAutoSize(true);
                this.m_tickFont.setAutoSize(true);
                this.determineHorizontalSizes(n, n2);
                return;
            }
            this.m_showTitle = false;
            this.m_titleHeight = 0;
            this.m_titleWidth = 0;
        }
        if (this.m_showTicks && d5 != 1.0) {
            GRText gRText3 = new GRText("X", this.m_tickFont);
            n4 = gRText3.getHeight();
            int n7 = 0;
            int n8 = 0;
            for (int i = 0; i < this.m_def.m_tickStrings.length; ++i) {
                gRText3.resetSinglelineLabel(this.m_def.m_tickStrings[i], 0, null);
                int n9 = gRText3.getWidth();
                if (n9 > n7) {
                    n7 = n9;
                }
                n8 += n9;
            }
            if (this.m_layoutMode == 0) {
                this.m_tickWidth = n8;
                this.m_tickHeight = n4;
            } else {
                this.m_tickWidth = n7 * this.m_def.m_tickStrings.length;
                this.m_tickHeight = n4;
            }
        }
        if (this.m_tickHeight + this.m_titleHeight > n2) {
            if (this.m_showTitle && !bl || this.m_showTicks && !bl2) {
                this.m_titleFont.setAutoSize(true);
                this.m_tickFont.setAutoSize(true);
                this.determineHorizontalSizes(n, n2);
                return;
            }
            this.m_showTicks = false;
            this.m_tickWidth = 0;
            this.m_tickHeight = 0;
        }
        int n10 = this.m_titleHeight + this.m_tickHeight;
        if (this.m_showTicks) {
            n10 += 3;
        }
        this.m_titlePad = (n2 - n10) / 2;
        if (this.m_titlePad < 0) {
            this.m_titlePad = 0;
        }
    }

    protected void determineVerticalSizes(int n, int n2) {
        double d;
        double d2;
        int n3;
        int n4;
        double d3;
        int n5;
        int n6;
        GRText gRText;
        String string;
        this.initializeSizeVariables();
        boolean bl = this.m_titleFont.getAutoSize();
        boolean bl2 = this.m_tickFont.getAutoSize();
        String string2 = string = this.m_def.m_tickTruncationText == null ? "" : this.m_def.m_tickTruncationText;
        if (this.m_def.m_titleVisible && this.m_def.m_title != null && this.m_def.m_title.length() != 0) {
            this.m_showTitle = true;
            gRText = new GRText(this.m_def.m_title, this.m_titleFont);
            this.m_titleWidth = gRText.getHeight();
            this.m_titleHeight = gRText.getWidth();
        }
        if (this.m_def.m_tickVisible && this.m_def.m_tickStrings.length != 0) {
            this.m_showTicks = true;
            gRText = new GRText("X", this.m_tickFont);
            this.m_singleTickHeight = gRText.getHeight();
            for (int i = 0; i < this.m_def.m_tickStrings.length; ++i) {
                if (this.canTicksBeTruncated()) {
                    gRText.resetSinglelineLabel(this.m_def.m_tickStrings[i], n, string);
                } else {
                    gRText.resetSinglelineLabel(this.m_def.m_tickStrings[i], 0, null);
                }
                int n7 = gRText.getWidth();
                if (n7 > this.m_tickWidth) {
                    this.m_tickWidth = n7;
                }
                this.m_tickHeight += gRText.getHeight();
            }
            this.m_singleTickWidth = this.m_tickWidth;
        }
        if (!this.m_showTitle && !this.m_showTicks) {
            return;
        }
        if (this.m_showTitle && !bl) {
            if (this.m_titleWidth > n) {
                bl = true;
            } else if (this.m_titleHeight > n2) {
                gRText = new GRText(this.m_def.m_title, this.m_titleFont);
                gRText.resetSinglelineLabel(this.m_def.m_title, n2, string);
                this.m_titleHeight = gRText.getWidth();
                if (this.m_titleHeight > n2) {
                    bl = true;
                }
            }
        }
        if (this.m_showTicks && !bl2) {
            int n8 = n2;
            if (this.canTicksBeTruncated()) {
                n8 = n2 / this.m_def.m_tickStrings.length;
            }
            if (this.m_singleTickWidth > n || this.m_singleTickHeight > n8) {
                bl2 = true;
            }
        }
        double d4 = 1.0;
        double d5 = 1.0;
        if (bl && bl2) {
            n6 = this.m_titleWidth + this.m_tickWidth;
            n5 = n - 3;
            d3 = (double)n6 / (double)n5;
            n4 = Math.max(this.m_titleHeight, this.m_tickHeight);
            d2 = (double)n4 / (double)(n3 = n2);
            d = Math.max(d3, d2);
            if (d < 1.0) {
                d = 1.0;
            }
            this.m_titleWidth = (int)((double)this.m_titleWidth / d);
            this.m_titleHeight = (int)((double)this.m_titleHeight / d);
            this.m_tickWidth = (int)((double)this.m_tickWidth / d);
            this.m_tickHeight = (int)((double)this.m_tickHeight / d);
            d4 = d;
            d5 = d;
        } else if (bl) {
            n6 = this.m_titleWidth;
            n4 = this.m_titleHeight;
            n5 = n;
            if (this.m_showTicks && !this.canTicksBeTruncated()) {
                n5 -= 3 + this.m_tickWidth;
            }
            if (n5 < 0) {
                n5 = n;
                this.m_showTicks = false;
            }
            if ((d = Math.max(d3 = (double)n6 / (double)n5, d2 = (double)n4 / (double)(n3 = n2))) < 1.0) {
                d = 1.0;
            }
            this.m_titleWidth = (int)((double)this.m_titleWidth / d);
            this.m_titleHeight = (int)((double)this.m_titleHeight / d);
            d4 = d;
        } else if (bl2) {
            n6 = this.m_tickWidth;
            n4 = this.m_tickHeight;
            n5 = n;
            if (this.m_showTitle) {
                n5 -= 3 + this.m_titleWidth;
            }
            if (n5 < 0) {
                n5 = n;
                this.m_showTitle = false;
            }
            if ((d = Math.max(d3 = (double)n6 / (double)n5, d2 = (double)n4 / (double)(n3 = n2))) < 1.0) {
                d = 1.0;
            }
            this.m_tickWidth = (int)((double)this.m_tickWidth / d);
            this.m_tickHeight = (int)((double)this.m_tickHeight / d);
            d5 = d;
        }
        double d6 = this.m_def.m_titleFont.getSize();
        if (d4 > 1.0 && (d6 = d6 / d4 - 0.5) < 4.0 && bl) {
            d6 = 4.0;
        }
        this.m_titleFont.setSize(d6);
        d6 = this.m_def.m_tickFont.getSize();
        if (d5 > 1.0 && (d6 = d6 / d5 - 0.5) < 4.0 && bl2) {
            d6 = 4.0;
        }
        this.m_tickFont.setSize(d6);
        if (this.m_showTitle && d4 != 1.0) {
            GRText gRText2 = new GRText(this.m_def.m_title, this.m_titleFont);
            this.m_titleWidth = gRText2.getHeight();
            this.m_titleHeight = gRText2.getWidth();
        }
        if (this.m_titleWidth > n) {
            if (this.m_showTitle && !bl || this.m_showTicks && !bl2) {
                this.m_titleFont.setAutoSize(true);
                this.m_tickFont.setAutoSize(true);
                this.determineVerticalSizes(n, n2);
                return;
            }
            this.m_showTitle = false;
            this.m_titleWidth = 0;
            this.m_titleHeight = 0;
        }
        if (this.m_showTicks && d5 != 1.0) {
            GRText gRText3 = new GRText("X", this.m_tickFont);
            for (n3 = 0; n3 < this.m_def.m_tickStrings.length; ++n3) {
                gRText3.resetSinglelineLabel(this.m_def.m_tickStrings[n3], 0, null);
                int n9 = gRText3.getWidth();
                if (n9 > this.m_tickWidth) {
                    this.m_tickWidth = n9;
                }
                this.m_tickHeight += gRText3.getHeight();
            }
        }
        if (this.m_tickWidth + this.m_titleWidth > n && !this.canTicksBeTruncated()) {
            if (this.m_showTitle && !bl || this.m_showTicks && !bl2) {
                this.m_titleFont.setAutoSize(true);
                this.m_tickFont.setAutoSize(true);
                this.determineVerticalSizes(n, n2);
                return;
            }
            this.m_showTicks = false;
            this.m_tickWidth = 0;
            this.m_tickHeight = 0;
        }
        int n10 = this.m_titleWidth + this.m_tickWidth;
        if (this.m_showTicks) {
            n10 += 3;
        }
        this.m_titlePad = (n - n10) / 2;
        if (this.m_titlePad < 0) {
            this.m_titlePad = 0;
        }
    }

    protected abstract void draw();

    protected void initializeSizeVariables() {
        double d = this.m_def.m_titleFont.getSize();
        if (d < 4.0 && this.m_titleFont.getAutoSize()) {
            d = 4.0;
        }
        this.m_titleFont.setSize(d);
        d = this.m_def.m_tickFont.getSize();
        if (d < 4.0 && this.m_tickFont.getAutoSize()) {
            d = 4.0;
        }
        this.m_tickFont.setSize(d);
        this.m_titleHeight = 0;
        this.m_titleWidth = 0;
        this.m_tickHeight = 0;
        this.m_tickWidth = 0;
        this.m_singleTickHeight = 0;
        this.m_singleTickWidth = 0;
        this.m_titlePad = 0;
        this.m_showTitle = false;
        this.m_showTicks = false;
    }
}

