/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Graphics;

import com.ibm.cgsBus.Common.CMIntToShortHashMap;
import java.util.Arrays;

public final class GRDynamicColorDepthImageBuffer {
    private static int INITIAL_CONTAINERS_SIZE = 200;
    private static int MAX_COLOR_NUMBER_FOR_SHORT = 5000;
    private static int MIN_NUMBER_OF_PIXELS_FOR_INDEXED_MODE = 10000;
    private int m_width;
    private int m_height;
    private short[] m_shortStore;
    private int[] m_intStore;
    private CMIntToShortHashMap m_colorToIndex;
    private int[] m_colors;
    private short m_activeColorsCount = 0;

    private final int[] getDirectColor() {
        int[] nArray = new int[this.m_shortStore.length];
        for (int i = 0; i < this.m_shortStore.length; ++i) {
            nArray[i] = this.m_colors[this.m_shortStore[i]];
        }
        return nArray;
    }

    private final void handleNewColor(int n, int n2) {
        if (this.m_activeColorsCount == MAX_COLOR_NUMBER_FOR_SHORT) {
            this.m_intStore = this.getDirectColor();
            this.m_intStore[n] = n2;
            this.m_shortStore = null;
            this.m_colors = null;
            this.m_colorToIndex = null;
        } else {
            this.m_shortStore[n] = this.m_activeColorsCount;
            this.m_colors[this.m_activeColorsCount] = n2;
            this.m_colorToIndex.put(n2, this.m_activeColorsCount);
            this.m_activeColorsCount = (short)(this.m_activeColorsCount + 1);
        }
    }

    private final void handleNewColor(int n, int n2, int n3) {
        if (this.m_activeColorsCount == MAX_COLOR_NUMBER_FOR_SHORT) {
            this.m_intStore = this.getDirectColor();
            Arrays.fill(this.m_intStore, n, n2 + 1, n3);
            this.m_shortStore = null;
            this.m_colors = null;
            this.m_colorToIndex = null;
        } else {
            Arrays.fill(this.m_shortStore, n, n2 + 1, this.m_activeColorsCount);
            this.m_colors[this.m_activeColorsCount] = n3;
            this.m_colorToIndex.put(n3, this.m_activeColorsCount);
            this.m_activeColorsCount = (short)(this.m_activeColorsCount + 1);
        }
    }

    public final void finish() {
    }

    public final void setSize(int n, int n2) {
        this.m_height = n2;
        this.m_width = n;
        if (MIN_NUMBER_OF_PIXELS_FOR_INDEXED_MODE > this.m_height * this.m_width) {
            this.m_intStore = new int[this.m_width * this.m_height];
            this.m_shortStore = null;
            this.m_colors = null;
            this.m_colorToIndex = null;
        } else {
            this.m_shortStore = new short[this.m_width * this.m_height];
            this.m_colors = new int[MAX_COLOR_NUMBER_FOR_SHORT];
            this.m_colorToIndex = new CMIntToShortHashMap(INITIAL_CONTAINERS_SIZE);
            this.m_intStore = null;
            this.m_activeColorsCount = 0;
        }
    }

    public final void start() {
    }

    public final void putPixel(int n, int n2) {
        if (this.m_intStore != null) {
            this.m_intStore[n] = n2;
        } else {
            short s = this.m_colorToIndex.get(n2);
            if (s == -1) {
                this.handleNewColor(n, n2);
            } else {
                this.m_shortStore[n] = s;
            }
        }
    }

    public final void putPixels(int n, int n2, int n3) {
        if (this.m_intStore != null) {
            Arrays.fill(this.m_intStore, n, n + n2, n3);
        } else {
            short s = this.m_colorToIndex.get(n3);
            if (s == -1) {
                this.handleNewColor(n, n + n2 - 1, n3);
            } else {
                Arrays.fill(this.m_shortStore, n, n + n2, s);
            }
        }
    }

    public final int getPixel(int n) {
        if (this.m_intStore != null) {
            return this.m_intStore[n];
        }
        return this.m_colors[this.m_shortStore[n]];
    }

    public final int[] getUnCompressedPixels() {
        if (this.m_intStore != null) {
            return this.m_intStore;
        }
        return this.getDirectColor();
    }
}

