/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Graphics;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.Graphics.GRBufferedImage;
import com.ibm.cgsBus.Graphics.GRDeviceVector;
import com.ibm.cgsBus.Graphics.GRHelper;
import com.ibm.cgsBus.Properties.CGSPropFont;
import com.ibm.cgsBus.Types.CGSEnums;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class GRText {
    static final int TRANSPARENT = 0xFFFFFF;
    private String m_pLabel = null;
    private CGSPropFont m_pFontProp = null;
    private int m_width = 0;
    private int m_maxLineWidth = 0;
    private int m_height = 0;
    private int m_lineCount = 0;
    private GRBufferedImage m_pTextImage = null;
    private byte[] m_pTextVectorBlob = null;
    private CGSEnums.TextDirection m_textDirection = CGSEnums.TextDirection.eTextDirDefault;

    public GRText(String string, CGSPropFont cGSPropFont) {
        this.m_pLabel = string;
        this.m_pFontProp = cGSPropFont;
        this.resetWidth(0);
    }

    public GRText(String string, CGSPropFont cGSPropFont, int n, int n2) {
        this.m_pLabel = string;
        this.m_pFontProp = cGSPropFont;
        this.resetWidth(n);
        if (n2 != 0) {
            int n3 = this.m_pLabel.length();
            while (this.m_height > n2) {
                if (--n3 < 0) {
                    this.m_pLabel = "...";
                    break;
                }
                this.m_pLabel = string.substring(0, n3) + "...";
                this.resetWidth(n);
            }
        }
    }

    public void resetSinglelineLabel(String string, int n, String string2) {
        this.m_pLabel = string;
        int n2 = string.length();
        if (n == 0) {
            this.resetWidth(0);
        } else {
            while (this.resetWidth(0) > n) {
                if (--n2 < 0) {
                    this.m_pLabel = string2;
                    break;
                }
                this.m_pLabel = string.substring(0, n2) + string2;
            }
        }
    }

    public int resetWidth(int n) {
        this.m_width = 0;
        this.m_height = 0;
        this.m_maxLineWidth = 0;
        this.m_pTextImage = null;
        GRBufferedImage gRBufferedImage = new GRBufferedImage(1, 1);
        Graphics2D graphics2D = (Graphics2D)gRBufferedImage.getImage().getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        LineBreakMeasurer lineBreakMeasurer = this.setupLineBreaker(graphics2D, null);
        int n2 = n == 0 ? 999999999 : n;
        Point2D.Double double_ = this.drawWithLineBreaks(graphics2D, lineBreakMeasurer, n2);
        this.m_width = n == 0 ? this.m_maxLineWidth : n;
        this.m_height = GRHelper.GR_ROUND(double_.y);
        return this.m_width;
    }

    private void drawText(Graphics2D graphics2D, int n, boolean bl) {
        Boolean bl2 = bl ? TextAttribute.RUN_DIRECTION_RTL : TextAttribute.RUN_DIRECTION_LTR;
        LineBreakMeasurer lineBreakMeasurer = this.setupLineBreaker(graphics2D, bl2);
        this.drawWithLineBreaks(graphics2D, lineBreakMeasurer, n);
    }

    private LineBreakMeasurer setupLineBreaker(Graphics2D graphics2D, Boolean bl) {
        Font font = GRHelper.getFont(this.m_pFontProp, this.m_pLabel);
        graphics2D.setFont(font);
        graphics2D.setPaint(this.m_pFontProp.getColor());
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineBreakMeasurer lineBreakMeasurer = null;
        AttributedString attributedString = this.setupStyledLabel(font);
        if (attributedString != null) {
            if (bl != null) {
                attributedString.addAttribute(TextAttribute.RUN_DIRECTION, bl);
            }
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
        }
        return lineBreakMeasurer;
    }

    private AttributedString setupStyledLabel(Font font) {
        if (this.m_pLabel == null || this.m_pLabel.length() == 0) {
            return null;
        }
        AttributedString attributedString = new AttributedString(this.m_pLabel);
        attributedString.addAttribute(TextAttribute.FONT, font);
        boolean bl = false;
        boolean bl2 = false;
        switch (this.m_pFontProp.getEffect()) {
            case eEffectStrikeThrough: {
                bl2 = true;
                break;
            }
            case eEffectUnderlineStrikeThrough: {
                bl2 = true;
                bl = true;
                break;
            }
            case eEffectUnderline: {
                bl = true;
                break;
            }
        }
        if (bl) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (bl2) {
            attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return attributedString;
    }

    private void displayAndaleWTSequence(Graphics2D graphics2D, String string, int n, int n2) {
        char[] cArray = string.toCharArray();
        Shape shape = graphics2D.getClip();
        int n3 = 0;
        int n4 = 0;
        int n5 = graphics2D.getFontMetrics().getMaxAscent();
        for (int i = 0; i < cArray.length; ++i) {
            n4 = n3;
            n3 = graphics2D.getFontMetrics().charWidth(cArray[i]);
            if (Character.getType(cArray[i]) != 6) {
                graphics2D.drawChars(cArray, i, 1, n, n2);
            } else {
                graphics2D.setClip(n - n4, n2 - n5, n, n2 + n5);
                graphics2D.drawChars(cArray, i, 1, n - n4 - n3, n2);
                n -= n4;
            }
            n += n3;
        }
        if (shape != null) {
            graphics2D.setClip(shape);
        }
    }

    private Point2D.Double drawWithLineBreaks(Graphics2D graphics2D, LineBreakMeasurer lineBreakMeasurer, int n) {
        this.m_lineCount = 0;
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        if (lineBreakMeasurer != null) {
            TextLayout textLayout = null;
            while (lineBreakMeasurer.getPosition() < this.m_pLabel.length()) {
                int n2;
                int n3 = n2 = lineBreakMeasurer.nextOffset(n);
                int n4 = this.m_pLabel.indexOf("\n", lineBreakMeasurer.getPosition() + 1);
                if (n2 > n4 - lineBreakMeasurer.getPosition() && n4 != -1) {
                    n3 = n4 - lineBreakMeasurer.getPosition();
                }
                textLayout = lineBreakMeasurer.nextLayout(n, lineBreakMeasurer.getPosition() + n3, false);
                double_.y += (double)(textLayout.getLeading() + textLayout.getAscent());
                double_.x = this.calculateAlignmentOffset(textLayout.getVisibleAdvance(), n);
                if (graphics2D.getFont().getName().equals("Andale WT") && CMHelper.isComposite(this.m_pLabel)) {
                    this.displayAndaleWTSequence(graphics2D, this.m_pLabel, (int)double_.x, (int)double_.y);
                    double_.y += (double)graphics2D.getFontMetrics().getDescent();
                } else {
                    textLayout.draw(graphics2D, (float)double_.x, (float)double_.y);
                    double_.y += (double)textLayout.getDescent();
                }
                this.m_maxLineWidth = GRHelper.GR_ROUND(Math.max((float)this.m_maxLineWidth, textLayout.getVisibleAdvance()));
                ++this.m_lineCount;
            }
        }
        return double_;
    }

    private double calculateAlignmentOffset(float f, float f2) {
        double d = 0.0;
        switch (this.m_pFontProp.getHorAlignment()) {
            case eHorAlignLeft: {
                break;
            }
            case eHorAlignCenter: 
            case eHorAlignJustify: {
                d = (f2 - f) / 2.0f;
                break;
            }
            case eHorAlignRight: {
                d = f2 - f;
            }
        }
        return d;
    }

    public BufferedImage getTextImage(int n) {
        this.drawText(n);
        return this.m_pTextImage.getImage();
    }

    public byte[] getTextVectorBlob(int n) {
        this.drawText(n);
        return this.m_pTextVectorBlob;
    }

    private void drawText(int n) {
        int n2;
        if (this.m_pTextImage != null) {
            return;
        }
        int n3 = n2 = n == 0 ? this.m_width : n;
        if (n2 == 0 || this.m_height == 0) {
            this.m_pTextImage = new GRBufferedImage(1, 1);
            this.m_pTextVectorBlob = new byte[0];
            return;
        }
        this.m_pTextImage = new GRBufferedImage(n2, this.m_height);
        Graphics2D graphics2D = (Graphics2D)this.m_pTextImage.getImage().getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean bl = this.m_textDirection == CGSEnums.TextDirection.eTextDirAuto && CMHelper.isRtlTextDirection(this.m_pLabel) || this.m_textDirection == CGSEnums.TextDirection.eTextDirRtl;
        this.drawText(graphics2D, n2, bl);
        this.drawTextAsVector(n2, bl);
    }

    private void drawTextAsVector(int n, boolean bl) {
        GRDeviceVector gRDeviceVector = new GRDeviceVector();
        gRDeviceVector.setColor(this.m_pFontProp.getColor());
        gRDeviceVector.setFont(this.m_pFontProp);
        double d = this.calculateAlignmentOffset(this.m_maxLineWidth, n);
        if (this.m_lineCount > 1) {
            gRDeviceVector.drawString(gRDeviceVector.fromPixels(d), 0.0, gRDeviceVector.fromPixels(this.m_maxLineWidth), gRDeviceVector.fromPixels(this.m_height), this.m_pFontProp.getHorAlignment(), this.m_pLabel);
        } else {
            double d2 = 0.3 * this.m_pFontProp.getSize();
            gRDeviceVector.drawString(gRDeviceVector.fromPixels(d), -d2, 0.0, this.m_pLabel);
        }
        this.m_pTextVectorBlob = gRDeviceVector.getVectorBlob();
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    public String getLabel() {
        return this.m_pLabel;
    }

    public int getBitmapWidthUsed() {
        if (this.m_pTextImage == null) {
            this.drawText(0);
        }
        return this.m_maxLineWidth;
    }

    public void setTextDirection(CGSEnums.TextDirection textDirection) {
        this.m_textDirection = textDirection;
    }

    public CGSPropFont getFont() {
        return this.m_pFontProp;
    }
}

